package Map::Tube::Delhi::Line::Yellow;

$Map::Tube::Delhi::Line::Yellow::VERSION   = '0.30';
$Map::Tube::Delhi::Line::Yellow::AUTHORITY = 'cpan:MANWAR';

use 5.006;
use strict; use warnings;

=head1 NAME

Map::Tube::Delhi::Line::Yellow - Delhi Metro Yellow Line stations.

=head1 VERSION

Version 0.30

=head1 DESCRIPTION

Delhi Metro Yellow Line stations.

    +-----------------------+-----------------------------------+
    |                       |                                   |
    | Station Name          | Linked To                         |
    |                       |                                   |
    +-----------------------+-----------------------------------+
    | HUDA City Centre      | IFFCO Chowk                       |
    | IFFCO Chowk           | M G Road, HUDA City Centre        |
    | M G Road              | Sikanderpur, IIFCO Chowk          |
    | Sikanderpur           | Guru Dronacharya, M G Road        |
    | Guru Dronacharya      | Arjangarh, Sikanderpur            |
    | Arjangarh             | Ghitorni, Guru Dronacharya        |
    | Ghitorni              | Sultanpur, Arjangarh              |
    | Sultanpur             | Chhattarpur, Ghitorni             |
    | Chhattarpur           | Qutab Minar, Sultanpur            |
    | Qutab Minar           | Saket, Chhattarpur                |
    | Saket                 | Malviya Nagar, Qutab Minar        |
    | Malviya Nagar         | Hauz Khas, Saket                  |
    | Hauz Khas             | Green Park, Malviya Nagar         |
    | Green Park            | AIIMS, Hauz Khas                  |
    | AIIMS                 | INA, Green Park                   |
    | INA                   | Jor Bagh, AIIMS                   |
    | Jor Bagh              | Race Course, INA                  |
    | Race Course           | Udyog Bhavan, Jor Bagh            |
    | Udyog Bhavan          | Central Secretariate, Race Course |
    | Central Secretariate  | Patel Chowk, Udyog Bhavan         |
    | Patel Chowk           | Rajiv Chowk, Central Secretariate |
    | Rajiv Chowk           | New Delhi, Patel Chowk            |
    | New Delhi             | Chowri Bazar, Rajiv Chowk         |
    | Chowri Bazar          | Chandni Chowk, New Delhi          |
    | Chandni Chowk         | Kashmere Gate, Chowri Bazar       |
    | Kashmere Gate         | Civil Lines, Chandni Chowk        |
    | Civil Lines           | Vidhan Sabha, Kashmere Gate       |
    | Vidhan Sabha          | Vishwavidyalaya, Civil Lines      |
    | Vishwavidyalaya       | G. T. B. Nagar, Vidhan Sabha      |
    | G. T. B. Nagar        | Model Town, Vishwavidyalaya       |
    | Model Town            | Azadpur, G. T. B. Nagar           |
    | Azadpur               | Adarsh Nagar, Model Town          |
    | Adarsh Nagar          | Jahangir Puri, Azadpur            |
    | Jahangir Puri         | Adarsh Nagar                      |
    +-----------------------+-----------------------------------+

=head2 NOTE

=over 2

=item * The station "Central Secretariate" is also part of L<Violet Line|Map::Tube::Delhi::Line::Violet>.

=item * The station "Rajiv Chowk" is also part of L<Blue Line|Map::Tube::Delhi::Line::Blue>.

=item * The station "New Delhi" is also part of L<Orange Line|Map::Tube::Delhi::Line::Orange>.

=item * The station "Kashmere Gate" is also part of L<Red Line|Map::Tube::Delhi::Line::Red>.

=back

=head1 MAP

Delhi Metro Map: L<Yellow Line|https://raw.githubusercontent.com/Manwar/Map-Tube-Delhi/master/maps/Yellow.png>
map generated by plugin L<Map::Tube::Plugin::Graph>.

=begin html

<a href = "https://raw.githubusercontent.com/Manwar/Map-Tube-Delhi/master/maps/Yellow.png">
<img src    = "https://raw.githubusercontent.com/Manwar/Map-Tube-Delhi/master/maps/Yellow.png"
     alt    = "Delhi Metro Map: Yellow Line"
     width  = "350px"
     height = "500px"/>
</a>

=end html

=head1 AUTHOR

Mohammad S Anwar, C<< <mohammad.anwar at yahoo.com> >>

=head1 REPOSITORY

L<https://github.com/Manwar/Map-Tube-Delhi>

=head1 BUGS

Please  report any bugs/feature requests to C<bug-map-tube-delhi at rt.cpan.org>,
or through the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Map-Tube-Delhi>.
I will be notified, and then you'll automatically be notified of progress on your
bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Map::Tube::Delhi::Line::Yellow

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Map-Tube-Delhi>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Map-Tube-Delhi>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Map-Tube-Delhi>

=item * Search CPAN

L<http://search.cpan.org/dist/Map-Tube-Delhi/>

=back

=head1 LICENSE AND COPYRIGHT

Copyright (C) 2014 - 2015 Mohammad S Anwar.

This  program  is  free software; you can redistribute it and/or modify it under
the  terms  of the the Artistic License (2.0). You may obtain a copy of the full
license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any  use,  modification, and distribution of the Standard or Modified Versions is
governed by this Artistic License.By using, modifying or distributing the Package,
you accept this license. Do not use, modify, or distribute the Package, if you do
not accept this license.

If your Modified Version has been derived from a Modified Version made by someone
other than you,you are nevertheless required to ensure that your Modified Version
 complies with the requirements of this license.

This  license  does  not grant you the right to use any trademark,  service mark,
tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge patent license
to make,  have made, use,  offer to sell, sell, import and otherwise transfer the
Package with respect to any patent claims licensable by the Copyright Holder that
are  necessarily  infringed  by  the  Package. If you institute patent litigation
(including  a  cross-claim  or  counterclaim) against any party alleging that the
Package constitutes direct or contributory patent infringement,then this Artistic
License to you shall terminate on the date that such litigation is filed.

Disclaimer  of  Warranty:  THE  PACKAGE  IS  PROVIDED BY THE COPYRIGHT HOLDER AND
CONTRIBUTORS  "AS IS'  AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES. THE IMPLIED
WARRANTIES    OF   MERCHANTABILITY,   FITNESS   FOR   A   PARTICULAR  PURPOSE, OR
NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY YOUR LOCAL LAW. UNLESS
REQUIRED BY LAW, NO COPYRIGHT HOLDER OR CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL,  OR CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE
OF THE PACKAGE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=cut

1; # End of Map::Tube::Delhi::Line::Yellow
