/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieCriticalThread;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.processor.RequestProcessor;
import org.apache.bookkeeper.proto.BookieNettyServer;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.apache.bookkeeper.tls.SecurityProviderFactoryFactory;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieServer {
    final ServerConfiguration conf;
    BookieNettyServer nettyServer;
    private volatile boolean running = false;
    private final Bookie bookie;
    DeathWatcher deathWatcher;
    UncleanShutdownDetection uncleanShutdownDetection;
    private static final Logger LOG = LoggerFactory.getLogger(BookieServer.class);
    int exitCode = 0;
    private final RequestProcessor requestProcessor;
    private final StatsLogger statsLogger;
    private volatile Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;

    public BookieServer(ServerConfiguration conf, Bookie bookie, StatsLogger statsLogger, ByteBufAllocator allocator, UncleanShutdownDetection uncleanShutdownDetection) throws IOException, KeeperException, InterruptedException, BookieException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException, SecurityException {
        this.conf = conf;
        this.validateUser(conf);
        try {
            String configAsString = conf.asJson();
            LOG.info(configAsString);
        }
        catch (JsonUtil.ParseJsonException pe) {
            LOG.error("Got ParseJsonException while converting Config to JSONString", (Throwable)pe);
        }
        this.statsLogger = statsLogger;
        this.bookie = bookie;
        this.nettyServer = new BookieNettyServer(this.conf, null, allocator);
        this.uncleanShutdownDetection = uncleanShutdownDetection;
        SecurityHandlerFactory shFactory = SecurityProviderFactoryFactory.getSecurityProviderFactory(conf.getTLSProviderFactoryClass());
        this.requestProcessor = new BookieRequestProcessor(conf, bookie, statsLogger.scope("bookkeeper_server"), shFactory, allocator, this.nettyServer.allChannels);
        this.nettyServer.setRequestProcessor(this.requestProcessor);
    }

    @VisibleForTesting
    public static BookieServer newBookieServer(ServerConfiguration conf, Bookie bookie, StatsLogger statsLogger, ByteBufAllocator allocator, UncleanShutdownDetection uncleanShutdownDetection) throws ReplicationException.CompatibilityException, ReplicationException.UnavailableException, SecurityException, IOException, InterruptedException, KeeperException, BookieException {
        return new BookieServer(conf, bookie, statsLogger, allocator, uncleanShutdownDetection);
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.uncaughtExceptionHandler = exceptionHandler;
    }

    public void start() throws InterruptedException, IOException {
        this.bookie.start();
        if (!this.bookie.isRunning()) {
            this.exitCode = this.bookie.getExitCode();
            this.requestProcessor.close();
            return;
        }
        this.uncleanShutdownDetection.registerStartUp();
        this.nettyServer.start();
        this.running = true;
        this.deathWatcher = new DeathWatcher(this.conf);
        if (null != this.uncaughtExceptionHandler) {
            this.deathWatcher.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        this.deathWatcher.start();
        TimeUnit.MILLISECONDS.sleep(250L);
    }

    @VisibleForTesting
    public BookieSocketAddress getLocalAddress() throws UnknownHostException {
        return BookieImpl.getBookieAddress(this.conf);
    }

    @VisibleForTesting
    public BookieId getBookieId() throws UnknownHostException {
        return BookieImpl.getBookieId(this.conf);
    }

    @VisibleForTesting
    public Bookie getBookie() {
        return this.bookie;
    }

    @VisibleForTesting
    public BookieRequestProcessor getBookieRequestProcessor() {
        return (BookieRequestProcessor)this.requestProcessor;
    }

    @VisibleForTesting
    public void suspendProcessing() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Suspending bookie server, port is {}", (Object)this.conf.getBookiePort());
        }
        this.nettyServer.suspendProcessing();
    }

    @VisibleForTesting
    public void resumeProcessing() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resuming bookie server, port is {}", (Object)this.conf.getBookiePort());
        }
        this.nettyServer.resumeProcessing();
    }

    public synchronized void shutdown() {
        LOG.info("Shutting down BookieServer");
        this.nettyServer.shutdown();
        if (!this.running) {
            return;
        }
        this.requestProcessor.close();
        this.exitCode = this.bookie.shutdown();
        this.uncleanShutdownDetection.registerCleanShutdown();
        this.running = false;
    }

    private void validateUser(ServerConfiguration conf) throws BookieException {
        if (conf.containsKey("permittedStartupUsers")) {
            Object[] propertyValue;
            String currentUser = System.getProperty("user.name");
            for (String string : propertyValue = conf.getPermittedStartupUsers()) {
                if (!string.equals(currentUser)) continue;
                return;
            }
            String errorMsg = "System cannot start because current user isn't in permittedStartupUsers. Current user: " + currentUser + " permittedStartupUsers: " + Arrays.toString(propertyValue);
            LOG.error(errorMsg);
            throw new BookieException.BookieUnauthorizedAccessException(errorMsg);
        }
    }

    public boolean isRunning() {
        return this.bookie.isRunning() && this.nettyServer.isRunning() && this.running;
    }

    public boolean isBookieRunning() {
        return this.bookie.isRunning();
    }

    public void join() throws InterruptedException {
        this.bookie.join();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public static void main(String[] args) {
        Main.main(args);
    }

    public String toString() {
        String addr = "UNKNOWN";
        String id = "?";
        try {
            addr = BookieImpl.getBookieAddress(this.conf).toString();
            id = this.getBookieId().toString();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "Bookie Server listening on " + addr + " with id " + id;
    }

    private class DeathWatcher
    extends BookieCriticalThread {
        private final int watchInterval;

        DeathWatcher(ServerConfiguration conf) {
            super("BookieDeathWatcher-" + conf.getBookiePort());
            this.watchInterval = conf.getDeathWatchInterval();
            this.setUncaughtExceptionHandler((thread, cause) -> {
                LOG.info("BookieDeathWatcher exited loop due to uncaught exception from thread {}", (Object)thread.getName(), (Object)cause);
                BookieServer.this.shutdown();
            });
        }

        public void run() {
            do {
                try {
                    Thread.sleep(this.watchInterval);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            } while (BookieServer.this.isBookieRunning());
            LOG.info("BookieDeathWatcher noticed the bookie is not running any more, exiting the watch loop!");
            throw new RuntimeException("Bookie is not running any more");
        }
    }
}

