/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.logs;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.ResourceMarshaler;
import io.opentelemetry.exporter.internal.otlp.logs.InstrumentationScopeLogsStatelessMarshaler;
import io.opentelemetry.proto.logs.v1.internal.ResourceLogs;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ResourceLogsStatelessMarshaler
implements StatelessMarshaler2<Resource, Map<InstrumentationScopeInfo, List<LogRecordData>>> {
    static final ResourceLogsStatelessMarshaler INSTANCE = new ResourceLogsStatelessMarshaler();
    private static final MarshalerContext.Key SCOPE_LOG_WRITER_KEY = MarshalerContext.key();
    private static final MarshalerContext.Key SCOPE_LOG_SIZE_CALCULATOR_KEY = MarshalerContext.key();

    public void writeTo(Serializer output, Resource resource, Map<InstrumentationScopeInfo, List<LogRecordData>> scopeMap, MarshalerContext context) throws IOException {
        ResourceMarshaler resourceMarshaler = (ResourceMarshaler)((Object)context.getData(ResourceMarshaler.class));
        output.serializeMessage(ResourceLogs.RESOURCE, (Marshaler)resourceMarshaler);
        output.serializeRepeatedMessageWithContext(ResourceLogs.SCOPE_LOGS, scopeMap, (StatelessMarshaler2)InstrumentationScopeLogsStatelessMarshaler.INSTANCE, context, SCOPE_LOG_WRITER_KEY);
        output.serializeStringWithContext(ResourceLogs.SCHEMA_URL, resource.getSchemaUrl(), context);
    }

    public int getBinarySerializedSize(Resource resource, Map<InstrumentationScopeInfo, List<LogRecordData>> scopeMap, MarshalerContext context) {
        int size = 0;
        ResourceMarshaler resourceMarshaler = ResourceMarshaler.create(resource);
        context.addData((Object)resourceMarshaler);
        size += MarshalerUtil.sizeMessage((ProtoFieldInfo)ResourceLogs.RESOURCE, (Marshaler)resourceMarshaler);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)ResourceLogs.SCOPE_LOGS, scopeMap, (StatelessMarshaler2)InstrumentationScopeLogsStatelessMarshaler.INSTANCE, (MarshalerContext)context, (MarshalerContext.Key)SCOPE_LOG_SIZE_CALCULATOR_KEY);
        return size += StatelessMarshalerUtil.sizeStringWithContext((ProtoFieldInfo)ResourceLogs.SCHEMA_URL, (String)resource.getSchemaUrl(), (MarshalerContext)context);
    }
}

