/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksBuilderImpl;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusBuilderImpl;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanSuppressor;
import io.opentelemetry.instrumentation.api.instrumenter.UnsafeAttributes;
import io.opentelemetry.instrumentation.api.internal.HttpRouteState;
import io.opentelemetry.instrumentation.api.internal.InstrumenterAccess;
import io.opentelemetry.instrumentation.api.internal.InstrumenterContext;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.api.internal.SupportabilityMetrics;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class Instrumenter<REQUEST, RESPONSE> {
    private static final ContextKey<OperationListener[]> START_OPERATION_LISTENERS = ContextKey.named((String)"instrumenter-start-operation-listeners");
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final String instrumentationName;
    private final Tracer tracer;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final SpanKindExtractor<? super REQUEST> spanKindExtractor;
    private final SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor;
    private final SpanLinksExtractor<? super REQUEST>[] spanLinksExtractors;
    private final AttributesExtractor<? super REQUEST, ? super RESPONSE>[] attributesExtractors;
    private final ContextCustomizer<? super REQUEST>[] contextCustomizers;
    private final OperationListener[] operationListeners;
    private final AttributesExtractor<? super REQUEST, ? super RESPONSE>[] operationListenerAttributesExtractors;
    private final ErrorCauseExtractor errorCauseExtractor;
    private final boolean propagateOperationListenersToOnEnd;
    private final boolean enabled;
    private final SpanSuppressor spanSuppressor;

    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> builder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return new InstrumenterBuilder(openTelemetry, instrumentationName, spanNameExtractor);
    }

    Instrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder) {
        this.instrumentationName = builder.instrumentationName;
        this.tracer = builder.buildTracer();
        this.spanNameExtractor = builder.spanNameExtractor;
        this.spanKindExtractor = builder.spanKindExtractor;
        this.spanStatusExtractor = builder.spanStatusExtractor;
        this.spanLinksExtractors = builder.spanLinksExtractors.toArray(new SpanLinksExtractor[0]);
        this.attributesExtractors = builder.attributesExtractors.toArray(new AttributesExtractor[0]);
        this.contextCustomizers = builder.contextCustomizers.toArray(new ContextCustomizer[0]);
        this.operationListeners = builder.buildOperationListeners().toArray(new OperationListener[0]);
        this.operationListenerAttributesExtractors = builder.operationListenerAttributesExtractors.toArray(new AttributesExtractor[0]);
        this.errorCauseExtractor = builder.errorCauseExtractor;
        this.propagateOperationListenersToOnEnd = builder.propagateOperationListenersToOnEnd;
        this.enabled = builder.enabled;
        this.spanSuppressor = builder.buildSpanSuppressor();
    }

    public boolean shouldStart(Context parentContext, REQUEST request) {
        if (!this.enabled) {
            return false;
        }
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        boolean suppressed = this.spanSuppressor.shouldSuppress(parentContext, spanKind);
        if (suppressed) {
            supportability.recordSuppressedSpan(spanKind, this.instrumentationName);
        }
        return !suppressed;
    }

    public Context start(Context parentContext, REQUEST request) {
        return this.doStart(parentContext, request, null);
    }

    public void end(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        this.doEnd(context, request, response, error, null);
    }

    Context startAndEnd(Context parentContext, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error, Instant startTime, Instant endTime) {
        Context context = this.doStart(parentContext, request, startTime);
        this.doEnd(context, request, response, error, endTime);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context doStart(Context parentContext, REQUEST request, @Nullable Instant startTime) {
        try {
            Context context = this.doStartImpl(parentContext, request, startTime);
            return context;
        }
        finally {
            InstrumenterContext.reset();
        }
    }

    /*
     * WARNING - void declaration
     */
    private Context doStartImpl(Context parentContext, REQUEST request, @Nullable Instant startTime) {
        void var11_20;
        void var10_15;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.spanNameExtractor.extract(request)).setSpanKind(spanKind);
        if (startTime != null) {
            spanBuilder.setStartTimestamp(startTime);
        }
        SpanLinksBuilderImpl spanLinksBuilder = new SpanLinksBuilderImpl(spanBuilder);
        for (SpanLinksExtractor<REQUEST> spanLinksExtractor : this.spanLinksExtractors) {
            spanLinksExtractor.extract(spanLinksBuilder, parentContext, request);
        }
        UnsafeAttributes attributes = new UnsafeAttributes();
        AttributesExtractor<? super REQUEST, ? super RESPONSE>[] attributesExtractorArray = this.attributesExtractors;
        int n = attributesExtractorArray.length;
        boolean bl = false;
        while (var10_15 < n) {
            AttributesExtractor<REQUEST, RESPONSE> attributesExtractor = attributesExtractorArray[var10_15];
            attributesExtractor.onStart(attributes, parentContext, request);
            ++var10_15;
        }
        Context context = parentContext;
        ContextCustomizer<? super REQUEST>[] contextCustomizerArray = this.contextCustomizers;
        int n2 = contextCustomizerArray.length;
        boolean bl2 = false;
        while (var11_20 < n2) {
            ContextCustomizer<REQUEST> contextCustomizer = contextCustomizerArray[var11_20];
            context = contextCustomizer.onStart(context, request, attributes);
            ++var11_20;
        }
        boolean localRoot = LocalRootSpan.isLocalRoot(parentContext);
        boolean bl3 = LocalRootSpan.fromContextOrNull(context) != null;
        spanBuilder.setAllAttributes((Attributes)attributes);
        Span span = spanBuilder.setParent(context).startSpan();
        context = context.with((ImplicitContextKeyed)span);
        if (this.operationListeners.length != 0) {
            void var16_32;
            if (this.operationListenerAttributesExtractors.length != 0) {
                UnsafeAttributes unsafeAttributes = new UnsafeAttributes();
                unsafeAttributes.putAll(attributes.asMap());
                for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.operationListenerAttributesExtractors) {
                    attributesExtractor.onStart(unsafeAttributes, parentContext, request);
                }
                attributes = unsafeAttributes;
            }
            long l = Instrumenter.getNanos(startTime);
            OperationListener[] operationListenerArray = this.operationListeners;
            int n3 = operationListenerArray.length;
            boolean bl4 = false;
            while (var16_32 < n3) {
                OperationListener operationListener = operationListenerArray[var16_32];
                context = operationListener.onStart(context, attributes, l);
                ++var16_32;
            }
        }
        if (this.propagateOperationListenersToOnEnd || context.get(START_OPERATION_LISTENERS) != null) {
            context = context.with(START_OPERATION_LISTENERS, (Object)this.operationListeners);
        }
        if (localRoot) {
            context = LocalRootSpan.store(context, span);
        }
        if (!bl3 && spanKind == SpanKind.SERVER) {
            HttpRouteState.updateSpan(context, span);
        }
        return this.spanSuppressor.storeInContext(context, spanKind, span);
    }

    /*
     * WARNING - void declaration
     */
    private void doEnd(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error, @Nullable Instant endTime) {
        Span span = Span.fromContext((Context)context);
        if (error != null) {
            error = this.errorCauseExtractor.extract(error);
            span.recordException(error);
        }
        UnsafeAttributes attributes = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.attributesExtractors) {
            attributesExtractor.onEnd(attributes, context, request, response, error);
        }
        span.setAllAttributes((Attributes)attributes);
        OperationListener[] operationListeners = (OperationListener[])context.get(START_OPERATION_LISTENERS);
        if (operationListeners == null) {
            operationListeners = this.operationListeners;
        }
        if (operationListeners.length != 0) {
            void var11_18;
            if (this.operationListenerAttributesExtractors.length != 0) {
                UnsafeAttributes operationAttributes = new UnsafeAttributes();
                operationAttributes.putAll(attributes.asMap());
                for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.operationListenerAttributesExtractors) {
                    attributesExtractor.onEnd(operationAttributes, context, request, response, error);
                }
                attributes = operationAttributes;
            }
            long endNanos = Instrumenter.getNanos(endTime);
            int n = operationListeners.length - 1;
            while (var11_18 >= 0) {
                operationListeners[var11_18].onEnd(context, attributes, endNanos);
                --var11_18;
            }
        }
        SpanStatusBuilderImpl spanStatusBuilder = new SpanStatusBuilderImpl(span);
        this.spanStatusExtractor.extract(spanStatusBuilder, request, response, error);
        if (endTime != null) {
            span.end(endTime);
        } else {
            span.end();
        }
    }

    private static long getNanos(@Nullable Instant time) {
        if (time == null) {
            return System.nanoTime();
        }
        return TimeUnit.SECONDS.toNanos(time.getEpochSecond()) + (long)time.getNano();
    }

    static {
        InstrumenterUtil.setInstrumenterAccess(new InstrumenterAccess(){

            public <RQ, RS> Context startAndEnd(Instrumenter<RQ, RS> instrumenter, Context parentContext, RQ request, @Nullable RS response, @Nullable Throwable error, Instant startTime, Instant endTime) {
                return instrumenter.startAndEnd(parentContext, request, response, error, startTime, endTime);
            }

            @Override
            public <REQUEST, RESPONSE> Context suppressSpan(Instrumenter<REQUEST, RESPONSE> instrumenter, Context parentContext, REQUEST request) {
                SpanKind spanKind = ((Instrumenter)instrumenter).spanKindExtractor.extract(request);
                return ((Instrumenter)instrumenter).spanSuppressor.storeInContext(parentContext, spanKind, Span.getInvalid());
            }
        });
    }
}

