/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.management;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.streaming.StreamEvent;

public class SessionCompleteEventCompositeData {
    private static final String[] ITEM_NAMES = new String[]{"planId", "peer", "peer storage port", "success"};
    private static final String[] ITEM_DESCS = new String[]{"Plan ID", "Session peer", "Session peer storage port", "Indicates whether session was successful"};
    private static final OpenType<?>[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN};
    public static final CompositeType COMPOSITE_TYPE;

    public static CompositeData toCompositeData(StreamEvent.SessionCompleteEvent event) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put(ITEM_NAMES[0], event.planId.toString());
        valueMap.put(ITEM_NAMES[1], event.peer.getAddress().getHostAddress());
        valueMap.put(ITEM_NAMES[2], event.peer.getPort());
        valueMap.put(ITEM_NAMES[3], event.success);
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, valueMap);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            COMPOSITE_TYPE = new CompositeType(StreamEvent.SessionCompleteEvent.class.getName(), "SessionCompleteEvent", ITEM_NAMES, ITEM_DESCS, ITEM_TYPES);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

