/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel;

import net.openhft.chronicle.bytes.DistributedUniqueTimeProvider;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.NanoTimestampLongConverter;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;

public class SystemContext
extends SelfDescribingMarshallable {
    public static final SystemContext INSTANCE = SystemContext.getInstance();
    private int availableProcessors;
    private int hostId;
    private String hostName;
    @LongConversion(value=NanoTimestampLongConverter.class)
    private long upTime;
    private String userCountry;
    private String userName;
    private String javaVendor;
    private String javaVersion;

    private static SystemContext getInstance() {
        SystemContext sc = new SystemContext();
        Runtime runtime = Runtime.getRuntime();
        sc.availableProcessors = runtime.availableProcessors();
        sc.hostId = Integer.getInteger("hostId", 0);
        sc.hostName = OS.getHostName();
        SystemTimeProvider tp = sc.hostId == 0 ? SystemTimeProvider.INSTANCE : DistributedUniqueTimeProvider.instance();
        sc.upTime = tp.currentTimeNanos();
        sc.userCountry = System.getProperty("user.country");
        sc.userName = OS.getUserName();
        sc.javaVendor = System.getProperty("java.vendor");
        sc.javaVersion = System.getProperty("java.version");
        return sc;
    }

    public int availableProcessors() {
        return this.availableProcessors;
    }

    public int hostId() {
        return this.hostId;
    }

    public String hostName() {
        return this.hostName;
    }

    public String javaVendor() {
        return this.javaVendor;
    }

    public String javaVersion() {
        return this.javaVersion;
    }

    public long upTime() {
        return this.upTime;
    }

    public String userCountry() {
        return this.userCountry;
    }

    public String userName() {
        return this.userName;
    }
}

