/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.jexl3.ClassCreator;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ClassCreatorTest
extends JexlTestCase {
    static final Log logger = LogFactory.getLog(JexlTestCase.class);
    static final int LOOPS = 8;
    static final int MEGA = 0x100000;
    private File base;
    private JexlEngine jexl;

    public ClassCreatorTest() {
        super("ClassCreatorTest");
    }

    private void deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        dir.delete();
    }

    void functorTwo(Object nstest) throws Exception {
        HashMap<String, Object> ns = new HashMap<String, Object>();
        ns.put("test", nstest);
        JexlEngine jexl2 = new JexlBuilder().namespaces(ns).create();
        MapContext ctxt = new MapContext();
        ctxt.set("value", (Object)1000);
        ClassCreator cctor = new ClassCreator(this.jexl, this.base);
        cctor.setSeed(2);
        cctor.setCtorBody("value = (Integer) ctxt.get(\"value\") + 10;");
        Class<?> foo1 = cctor.createClass(true);
        Assertions.assertSame((Object)foo1.getClassLoader(), (Object)cctor.getClassLoader());
        Assertions.assertEquals((Object)"foo2", (Object)foo1.getSimpleName());
        Object result = cctor.newInstance(foo1, (JexlContext)ctxt);
        Assertions.assertEquals(foo1, result.getClass());
        jexl2.setClassLoader(cctor.getClassLoader());
        cctor.clear();
        JexlScript script = jexl2.createScript("test:getValue()");
        result = script.execute((JexlContext)ctxt, new Object[]{foo1.getName()});
        Assertions.assertEquals((Object)1010, (Object)result);
        cctor.setSeed(2);
        cctor.setCtorBody("value = (Integer) ctxt.get(\"value\") + 99;");
        Class<?> foo11 = cctor.createClass(true);
        Assertions.assertEquals((Object)"foo2", (Object)foo1.getSimpleName());
        Assertions.assertNotSame(foo11, foo1);
        foo1 = foo11;
        result = cctor.newInstance(foo1, (JexlContext)ctxt);
        Assertions.assertEquals(foo1, result.getClass());
        jexl2.setClassLoader(foo1.getClassLoader());
        result = script.execute((JexlContext)ctxt, new Object[]{foo1.getName()});
        Assertions.assertEquals((Object)1099, (Object)result);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.base = new File(SystemProperties.getJavaIoTmpdir(), "jexl" + System.currentTimeMillis());
        this.jexl = this.JEXL;
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.deleteDirectory(this.base);
    }

    @Test
    void testBasicCtor() {
        JexlScript s = this.jexl.createScript("(c, v)->{ var ct2 = new(c, v); ct2.value; }");
        Object r = s.execute(null, new Object[]{TwoCtors.class, 10});
        Assertions.assertEquals((Object)10, (Object)r);
        r = s.execute(null, new Object[]{TwoCtors.class, 10});
        Assertions.assertEquals((Object)10, (Object)r);
        r = s.execute(null, new Object[]{TwoCtors.class, 10.0});
        Assertions.assertEquals((Object)-10, (Object)r);
        r = s.execute(null, new Object[]{TwoCtors.class, Float.valueOf(100.0f)});
        Assertions.assertEquals((Object)-100, (Object)r);
    }

    @Test
    void testContextualCtor() {
        MapContext ctxt = new MapContext();
        ctxt.set("value", (Object)42);
        JexlScript s = this.jexl.createScript("(c)->{ new(c).value }");
        Object r = s.execute((JexlContext)ctxt, new Object[]{ContextualCtor.class});
        Assertions.assertEquals((Object)42, (Object)r);
        s = this.jexl.createScript("(c, v)->{ new(c, v).value }");
        r = s.execute((JexlContext)ctxt, new Object[]{ContextualCtor.class, 100});
        Assertions.assertEquals((Object)142, (Object)r);
    }

    @Test
    void testFunctor2Class() throws Exception {
        this.functorTwo(new NsTest("org.apache.commons.jexl3.generated.foo2"));
    }

    @Test
    void testFunctor2Name() throws Exception {
        this.functorTwo("org.apache.commons.jexl3.generated.foo2");
    }

    @Test
    void testFunctorOne() throws Exception {
        MapContext ctxt = new MapContext();
        ctxt.set("value", (Object)1000);
        ClassCreator cctor = new ClassCreator(this.jexl, this.base);
        cctor.setSeed(1);
        cctor.setCtorBody("value = (Integer) ctxt.get(\"value\") + 10;");
        Class<?> foo1 = cctor.createClass(true);
        Assertions.assertSame((Object)foo1.getClassLoader(), (Object)cctor.getClassLoader());
        Assertions.assertEquals((Object)"foo1", (Object)foo1.getSimpleName());
        Object result = cctor.newInstance(foo1, (JexlContext)ctxt);
        Assertions.assertEquals(foo1, result.getClass());
        this.jexl.setClassLoader(cctor.getClassLoader());
        cctor.clear();
        JexlScript script = this.jexl.createScript("(c)->{ new(c).value; }");
        result = script.execute((JexlContext)ctxt, new Object[]{foo1});
        Assertions.assertEquals((Object)1010, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{foo1.getName()});
        Assertions.assertEquals((Object)1010, (Object)result);
        cctor.setSeed(1);
        cctor.setCtorBody("value = (Integer) ctxt.get(\"value\") + 99;");
        Class<?> foo11 = cctor.createClass(true);
        Assertions.assertEquals((Object)"foo1", (Object)foo1.getSimpleName());
        Assertions.assertNotSame(foo11, foo1);
        foo1 = foo11;
        result = cctor.newInstance(foo1, (JexlContext)ctxt);
        Assertions.assertEquals(foo1, result.getClass());
        this.jexl.setClassLoader(foo1.getClassLoader());
        result = script.execute((JexlContext)ctxt, new Object[]{foo1.getName()});
        Assertions.assertEquals((Object)1099, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{foo1});
        Assertions.assertEquals((Object)1099, (Object)result);
    }

    @Test
    void testFunctorThree() throws Exception {
        MapContext ctxt = new MapContext();
        ctxt.set("value", (Object)1000);
        ClassCreator cctor = new ClassCreator(this.jexl, this.base);
        cctor.setSeed(2);
        cctor.setCtorBody("value = (Integer) ctxt.get(\"value\") + 10;");
        Class<?> foo1 = cctor.createClass(true);
        Assertions.assertSame((Object)foo1.getClassLoader(), (Object)cctor.getClassLoader());
        Assertions.assertEquals((Object)"foo2", (Object)foo1.getSimpleName());
        Object result = cctor.newInstance(foo1, (JexlContext)ctxt);
        Assertions.assertEquals(foo1, result.getClass());
        this.jexl.setClassLoader(cctor.getClassLoader());
        cctor.clear();
        HashMap ns = new HashMap();
        ns.put("test", foo1);
        JexlEngine jexl2 = new JexlBuilder().namespaces(ns).create();
        JexlScript script = jexl2.createScript("test:getValue()");
        result = script.execute((JexlContext)ctxt, new Object[]{foo1.getName()});
        Assertions.assertEquals((Object)1010, (Object)result);
        cctor.setSeed(2);
        cctor.setCtorBody("value = (Integer) ctxt.get(\"value\") + 99;");
        Class<?> foo11 = cctor.createClass(true);
        Assertions.assertEquals((Object)"foo2", (Object)foo1.getSimpleName());
        Assertions.assertNotSame(foo11, foo1);
        foo1 = foo11;
        result = cctor.newInstance(foo1, (JexlContext)ctxt);
        Assertions.assertEquals(foo1, result.getClass());
        jexl2.setClassLoader(foo1.getClassLoader());
        result = script.execute((JexlContext)ctxt, new Object[]{foo1.getName()});
        Assertions.assertEquals((Object)1099, (Object)result);
    }

    @Test
    void testMany() throws Exception {
        int pass = 0;
        int gced = -1;
        ReferenceQueue<Object> queue = new ReferenceQueue<Object>();
        ArrayList<Reference> stuff = new ArrayList<Reference>();
        JexlExpression expr = this.jexl.createExpression("foo.value");
        JexlExpression newx = this.jexl.createExpression("foo = new(clazz)");
        JexlEvalContext context = new JexlEvalContext();
        JexlOptions options = context.getEngineOptions();
        options.setStrict(false);
        options.setSilent(true);
        ClassCreator cctor = new ClassCreator(this.jexl, this.base);
        for (int i = 0; i < 8 && gced < 0; ++i) {
            Class<?> clazz;
            cctor.setSeed(i);
            if (pass == 0) {
                clazz = cctor.createClass();
            } else {
                clazz = cctor.getClassInstance();
                if (clazz == null) {
                    Assertions.assertEquals((int)i, (int)gced);
                    break;
                }
            }
            context.set("clazz", cctor.getClassName());
            context.set("foo", null);
            Object z = newx.evaluate((JexlContext)context);
            Assertions.assertNull((Object)z);
            context.set("clazz", clazz);
            z = newx.evaluate((JexlContext)context);
            Assertions.assertNotNull((Object)z, (String)(clazz + ": class " + i + " could not be instantiated on pass " + pass));
            Assertions.assertEquals((Object)i, (Object)expr.evaluate((JexlContext)context));
            this.jexl.setClassLoader(cctor.getClassLoader());
            z = newx.evaluate((JexlContext)context);
            Assertions.assertEquals(z.getClass(), clazz);
            Assertions.assertEquals((Object)i, (Object)expr.evaluate((JexlContext)context));
            cctor.clear();
            this.jexl.setClassLoader(null);
            if (pass != 0) continue;
            stuff.add(new ClassReference(clazz, queue));
            stuff.add(new InstanceReference(clazz.getConstructor(new Class[0]).newInstance(new Object[0]), queue));
            for (int b = 0; b < 1024 && Runtime.getRuntime().freeMemory() > 0x100000L; ++b) {
                BigObject big = new BigObject(b);
                stuff.add(new InstanceReference(big, queue));
            }
            System.gc();
            boolean qr = false;
            while (queue.poll() != null) {
                Reference<Object> ref = queue.remove(1L);
                if (!(ref instanceof ClassReference)) continue;
                gced = i;
                qr = true;
            }
            if (!qr) continue;
            pass = 1;
            i = 0;
        }
        if (gced < 0) {
            logger.warn((Object)"unable to force GC");
        }
    }

    @Test
    void testOne() throws Exception {
        ClassCreator cctor = new ClassCreator(this.jexl, this.base);
        cctor.setSeed(1);
        Class<?> foo1 = cctor.createClass();
        Assertions.assertEquals((Object)"foo1", (Object)foo1.getSimpleName());
        cctor.clear();
    }

    @Test
    void test432() throws Exception {
        ClassCreator cctor = new ClassCreator(this.jexl, this.base);
        cctor.setSeed(2);
        cctor.setCtorBody("value = (Integer) ctxt.get(\"value\") + 10;");
        Class<?> foo1 = cctor.createClass(true);
        Assertions.assertSame((Object)foo1.getClassLoader(), (Object)cctor.getClassLoader());
        Assertions.assertEquals((Object)"foo2", (Object)foo1.getSimpleName());
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("test", foo1.getName());
        JexlEngine jexl2 = new JexlBuilder().namespaces(ns).cache(16).create();
        jexl2.setClassLoader(cctor.getClassLoader());
        cctor.clear();
        MapContext ctxt = new MapContext();
        ctxt.set("value", (Object)1000);
        JexlScript script = jexl2.createScript("test:getValue()");
        Object result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)1010, (Object)result);
        cctor.setSeed(2);
        cctor.setCtorBody("value = (Integer) ctxt.get(\"value\") + 99;");
        Class<?> foo11 = cctor.createClass(true);
        Assertions.assertEquals((Object)"foo2", (Object)foo1.getSimpleName());
        Assertions.assertNotSame(foo11, foo1);
        foo1 = foo11;
        jexl2.setClassLoader(foo1.getClassLoader());
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)1099, (Object)result);
    }

    public static class TwoCtors {
        int value;

        public TwoCtors(int v) {
            this.value = v;
        }

        public TwoCtors(Number x) {
            this.value = -x.intValue();
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class ContextualCtor {
        int value = -1;

        public ContextualCtor(JexlContext ctxt) {
            this.value = (Integer)ctxt.get("value");
        }

        public ContextualCtor(JexlContext ctxt, int v) {
            this.value = (Integer)ctxt.get("value") + v;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class NsTest
    implements JexlContext.NamespaceFunctor {
        private final String className;

        public NsTest(String cls) {
            this.className = cls;
        }

        public Object createFunctor(JexlContext context) {
            JexlEngine jexl = JexlEngine.getThreadEngine();
            return jexl.newInstance(this.className, new Object[]{context});
        }
    }

    static final class ClassReference
    extends WeakReference<Class<?>> {
        ClassReference(Class<?> clazz, ReferenceQueue<Object> queue) {
            super(clazz, queue);
        }
    }

    static final class InstanceReference
    extends SoftReference<Object> {
        InstanceReference(Object obj, ReferenceQueue<Object> queue) {
            super(obj, queue);
        }
    }

    public static class BigObject {
        private final byte[] space = new byte[0x100000];
        private final int id;

        public BigObject(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

