/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;

public class DirectKeyEncryptionAlgorithm
implements KeyEncryptionProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(DirectKeyEncryptionAlgorithm.class);

    @Override
    public byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] theCek) {
        this.checkKeyEncryptionAlgorithm(headers);
        return new byte[0];
    }

    protected void checkKeyEncryptionAlgorithm(JweHeaders headers) {
        KeyAlgorithm keyAlgo = headers.getKeyEncryptionAlgorithm();
        if (keyAlgo != null && KeyAlgorithm.DIRECT != keyAlgo) {
            LOG.warning("Key encryption algorithm header is set");
            throw new JweException(JweException.Error.INVALID_KEY_ALGORITHM);
        }
    }

    @Override
    public KeyAlgorithm getAlgorithm() {
        return KeyAlgorithm.DIRECT;
    }
}

