/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public abstract class AbstractProtocolDecoderOutput
implements ProtocolDecoderOutput {
    protected final Queue<Object> messageQueue = new ArrayDeque<Object>();

    @Override
    public void write(Object message) {
        if (message == null) {
            throw new IllegalArgumentException("message");
        }
        this.messageQueue.add(message);
    }

    @Override
    public void flush(IoFilter.NextFilter nextFilter, IoSession session) {
        Object message = null;
        while ((message = this.messageQueue.poll()) != null) {
            nextFilter.messageReceived(session, message);
        }
    }
}

