/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.Arrays;
import net.sf.saxon.str.LargeTextBuffer;

public class Statistics {
    private int treesCreated = 0;
    private final int[] last10Nodes = new int[10];
    private final int[] last10Attributes = new int[10];
    private final int[] last10Namespaces = new int[10];
    private final int[] last10Characters = new int[10];

    public Statistics() {
        this(4000, 100, 20, 4000);
    }

    public Statistics(int nodes, int atts, int namespaces, int chars) {
        Arrays.fill(this.last10Nodes, nodes);
        Arrays.fill(this.last10Attributes, atts);
        Arrays.fill(this.last10Namespaces, namespaces);
        Arrays.fill(this.last10Characters, chars);
    }

    private int getUpperBound(int[] last10) {
        int bits = 0;
        for (int i = 0; i < 10; ++i) {
            bits |= last10[i];
        }
        return bits;
    }

    public int getAverageNodes() {
        return this.getUpperBound(this.last10Nodes);
    }

    public int getAverageAttributes() {
        return this.getUpperBound(this.last10Attributes);
    }

    public int getAverageNamespaces() {
        return this.getUpperBound(this.last10Namespaces);
    }

    public int getAverageCharacters() {
        return this.getUpperBound(this.last10Characters);
    }

    public synchronized void updateStatistics(int numberOfNodes, int numberOfAttributes, int numberOfNamespaces, LargeTextBuffer textBuffer) {
        int n0 = this.treesCreated;
        if (n0 < 1000000) {
            int n = this.treesCreated++ % 10;
            this.last10Nodes[n] = numberOfNodes;
            this.last10Attributes[n] = numberOfAttributes;
            this.last10Namespaces[n] = numberOfNamespaces;
            this.last10Characters[n] = Math.max(textBuffer.length(), 65536);
        }
    }

    public String toString() {
        return this.treesCreated + "(" + this.getAverageNodes() + "," + this.getAverageAttributes() + "," + this.getAverageNamespaces() + "," + this.getAverageCharacters() + ")";
    }
}

