/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.table;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.datagen.table.DataGenVisitorBase;
import org.apache.flink.connector.datagen.table.DataGeneratorContainer;
import org.apache.flink.connector.datagen.table.types.DataGeneratorMapper;
import org.apache.flink.connector.datagen.table.types.DecimalDataRandomGenerator;
import org.apache.flink.connector.datagen.table.types.RowDataGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.RandomGenerator;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;

@Internal
public class RandomGeneratorVisitor
extends DataGenVisitorBase {
    public static final int RANDOM_STRING_LENGTH_DEFAULT = 100;
    public static final int RANDOM_BYTES_LENGTH_DEFAULT = 100;
    public static final int RANDOM_COLLECTION_LENGTH_DEFAULT = 3;
    private static final float NULL_RATE_DEFAULT = 0.0f;
    private final ConfigOptions.OptionBuilder minKey;
    private final ConfigOptions.OptionBuilder maxKey;
    private final ConfigOptions.OptionBuilder maxPastKey;
    private final ConfigOptions.OptionBuilder nullRate;
    private final ConfigOptions.OptionBuilder varLen;

    public RandomGeneratorVisitor(String name, ReadableConfig config) {
        super(name, config);
        this.minKey = ConfigOptions.key((String)("fields." + name + "." + "min"));
        this.maxKey = ConfigOptions.key((String)("fields." + name + "." + "max"));
        this.maxPastKey = ConfigOptions.key((String)("fields." + name + "." + "max-past"));
        this.nullRate = ConfigOptions.key((String)("fields." + name + "." + "null-rate"));
        this.varLen = ConfigOptions.key((String)("fields." + name + "." + "var-len"));
    }

    @Override
    public DataGeneratorContainer visit(BooleanType booleanType) {
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.booleanGenerator().withNullRate(((Float)this.config.get(nr)).floatValue()), nr);
    }

    @Override
    public DataGeneratorContainer visit(CharType charType) {
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGeneratorVisitor.getRandomStringGenerator(charType.getLength()).withNullRate(((Float)this.config.get(nr)).floatValue()), nr);
    }

    @Override
    public DataGeneratorContainer visit(VarCharType varCharType) {
        ConfigOption<Integer> lenOption = this.getLengthOption(varCharType::getLength);
        int length = (Integer)this.config.get(lenOption) == Integer.MAX_VALUE ? 100 : (Integer)this.config.get(lenOption);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        ConfigOption varLenOption = this.varLen.booleanType().defaultValue((Object)false);
        return DataGeneratorContainer.of((DataGenerator)RandomGeneratorVisitor.getRandomStringGenerator(length).withNullRate(((Float)this.config.get(nr)).floatValue()).withVarLen(((Boolean)this.config.get(varLenOption)).booleanValue()), lenOption, nr, varLenOption);
    }

    @Override
    public DataGeneratorContainer visit(BinaryType binaryType) {
        return DataGeneratorContainer.of(RandomGeneratorVisitor.getRandomBytesGenerator(binaryType.getLength()), new ConfigOption[0]);
    }

    @Override
    public DataGeneratorContainer visit(VarBinaryType varBinaryType) {
        ConfigOption<Integer> lenOption = this.getLengthOption(varBinaryType::getLength);
        ConfigOption varLenOption = this.varLen.booleanType().defaultValue((Object)false);
        int length = (Integer)this.config.get(lenOption) == Integer.MAX_VALUE ? 100 : (Integer)this.config.get(lenOption);
        return DataGeneratorContainer.of((DataGenerator)RandomGeneratorVisitor.getRandomBytesGenerator(length).withVarLen(((Boolean)this.config.get(varLenOption)).booleanValue()), lenOption, varLenOption);
    }

    @Override
    public DataGeneratorContainer visit(TinyIntType tinyIntType) {
        ConfigOption min = this.minKey.intType().defaultValue((Object)-128);
        ConfigOption max = this.maxKey.intType().defaultValue((Object)127);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.byteGenerator((byte)((Integer)this.config.get(min)).byteValue(), (byte)((Integer)this.config.get(max)).byteValue()).withNullRate(((Float)this.config.get(nr)).floatValue()), min, max, nr);
    }

    @Override
    public DataGeneratorContainer visit(SmallIntType smallIntType) {
        ConfigOption min = this.minKey.intType().defaultValue((Object)Short.MIN_VALUE);
        ConfigOption max = this.maxKey.intType().defaultValue((Object)Short.MAX_VALUE);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.shortGenerator((short)((Integer)this.config.get(min)).shortValue(), (short)((Integer)this.config.get(max)).shortValue()).withNullRate(((Float)this.config.get(nr)).floatValue()), min, max, nr);
    }

    @Override
    public DataGeneratorContainer visit(IntType integerType) {
        ConfigOption min = this.minKey.intType().defaultValue((Object)Integer.MIN_VALUE);
        ConfigOption max = this.maxKey.intType().defaultValue((Object)Integer.MAX_VALUE);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.intGenerator((int)((Integer)this.config.get(min)), (int)((Integer)this.config.get(max))).withNullRate(((Float)this.config.get(nr)).floatValue()), min, max, nr);
    }

    @Override
    public DataGeneratorContainer visit(BigIntType bigIntType) {
        ConfigOption min = this.minKey.longType().defaultValue((Object)Long.MIN_VALUE);
        ConfigOption max = this.maxKey.longType().defaultValue((Object)Long.MAX_VALUE);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.longGenerator((long)((Long)this.config.get(min)), (long)((Long)this.config.get(max))).withNullRate(((Float)this.config.get(nr)).floatValue()), min, max, nr);
    }

    @Override
    public DataGeneratorContainer visit(FloatType floatType) {
        ConfigOption min = this.minKey.floatType().defaultValue((Object)Float.valueOf(Float.MIN_VALUE));
        ConfigOption max = this.maxKey.floatType().defaultValue((Object)Float.valueOf(Float.MAX_VALUE));
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.floatGenerator((float)((Float)this.config.get(min)).floatValue(), (float)((Float)this.config.get(max)).floatValue()).withNullRate(((Float)this.config.get(nr)).floatValue()), min, max, nr);
    }

    @Override
    public DataGeneratorContainer visit(DoubleType doubleType) {
        ConfigOption min = this.minKey.doubleType().defaultValue((Object)Double.MIN_VALUE);
        ConfigOption max = this.maxKey.doubleType().defaultValue((Object)Double.MAX_VALUE);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.doubleGenerator((double)((Double)this.config.get(min)), (double)((Double)this.config.get(max))).withNullRate(((Float)this.config.get(nr)).floatValue()), min, max, nr);
    }

    @Override
    public DataGeneratorContainer visit(DecimalType decimalType) {
        ConfigOption min = this.minKey.doubleType().defaultValue((Object)Double.MIN_VALUE);
        ConfigOption max = this.maxKey.doubleType().defaultValue((Object)Double.MAX_VALUE);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of(new DecimalDataRandomGenerator(decimalType.getPrecision(), decimalType.getScale(), (Double)this.config.get(min), (Double)this.config.get(max), ((Float)this.config.get(nr)).floatValue()), min, max, nr);
    }

    @Override
    public DataGeneratorContainer visit(YearMonthIntervalType yearMonthIntervalType) {
        ConfigOption min = this.minKey.intType().defaultValue((Object)0);
        ConfigOption max = this.maxKey.intType().defaultValue((Object)120000);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.intGenerator((int)((Integer)this.config.get(min)), (int)((Integer)this.config.get(max))).withNullRate(((Float)this.config.get(nr)).floatValue()), min, max, nr);
    }

    @Override
    public DataGeneratorContainer visit(DayTimeIntervalType dayTimeIntervalType) {
        ConfigOption min = this.minKey.longType().defaultValue((Object)Long.MIN_VALUE);
        ConfigOption max = this.maxKey.longType().defaultValue((Object)Long.MAX_VALUE);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.longGenerator((long)((Long)this.config.get(min)), (long)((Long)this.config.get(max))).withNullRate(((Float)this.config.get(nr)).floatValue()), min, max, nr);
    }

    @Override
    public DataGeneratorContainer visit(TimestampType timestampType) {
        ConfigOption maxPastOption = this.maxPastKey.durationType().defaultValue((Object)Duration.ZERO);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGeneratorVisitor.getRandomPastTimestampGenerator((Duration)this.config.get(maxPastOption)).withNullRate(((Float)this.config.get(nr)).floatValue()), maxPastOption, nr);
    }

    @Override
    public DataGeneratorContainer visit(ZonedTimestampType zonedTimestampType) {
        ConfigOption maxPastOption = this.maxPastKey.durationType().defaultValue((Object)Duration.ZERO);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGeneratorVisitor.getRandomPastTimestampGenerator((Duration)this.config.get(maxPastOption)).withNullRate(((Float)this.config.get(nr)).floatValue()), maxPastOption, nr);
    }

    @Override
    public DataGeneratorContainer visit(LocalZonedTimestampType localZonedTimestampType) {
        ConfigOption maxPastOption = this.maxPastKey.durationType().defaultValue((Object)Duration.ZERO);
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        return DataGeneratorContainer.of((DataGenerator)RandomGeneratorVisitor.getRandomPastTimestampGenerator((Duration)this.config.get(maxPastOption)).withNullRate(((Float)this.config.get(nr)).floatValue()), maxPastOption, nr);
    }

    @Override
    public DataGeneratorContainer visit(ArrayType arrayType) {
        ConfigOption<Integer> lenOption = this.getLengthOption(() -> 3);
        String fieldName = this.name + ".element";
        DataGeneratorContainer container = arrayType.getElementType().accept(new RandomGeneratorVisitor(fieldName, this.config));
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        RandomGenerator generator = RandomGenerator.arrayGenerator((DataGenerator)container.getGenerator(), (int)((Integer)this.config.get(lenOption)));
        Set<ConfigOption<?>> options = container.getOptions();
        options.add(nr);
        options.add(lenOption);
        return DataGeneratorContainer.of(new DataGeneratorMapper(generator, GenericArrayData::new, ((Float)this.config.get(nr)).floatValue()), options.toArray(new ConfigOption[0]));
    }

    @Override
    public DataGeneratorContainer visit(MultisetType multisetType) {
        ConfigOption<Integer> lenOption = this.getLengthOption(() -> 3);
        String fieldName = this.name + ".element";
        DataGeneratorContainer container = multisetType.getElementType().accept(new RandomGeneratorVisitor(fieldName, this.config));
        RandomGenerator mapGenerator = RandomGenerator.mapGenerator((DataGenerator)container.getGenerator(), (DataGenerator)RandomGenerator.intGenerator((int)0, (int)10), (int)((Integer)this.config.get(lenOption)));
        Set<ConfigOption<?>> options = container.getOptions();
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        options.add(nr);
        options.add(lenOption);
        return DataGeneratorContainer.of(new DataGeneratorMapper(mapGenerator, GenericMapData::new, ((Float)this.config.get(nr)).floatValue()), options.toArray(new ConfigOption[0]));
    }

    @Override
    public DataGeneratorContainer visit(MapType mapType) {
        ConfigOption<Integer> lenOption = this.getLengthOption(() -> 3);
        String keyName = this.name + ".key";
        String valName = this.name + ".value";
        DataGeneratorContainer keyContainer = mapType.getKeyType().accept(new RandomGeneratorVisitor(keyName, this.config));
        DataGeneratorContainer valContainer = mapType.getValueType().accept(new RandomGeneratorVisitor(valName, this.config));
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        Set<ConfigOption<?>> options = keyContainer.getOptions();
        options.addAll(valContainer.getOptions());
        options.add(nr);
        options.add(lenOption);
        RandomGenerator mapGenerator = RandomGenerator.mapGenerator((DataGenerator)keyContainer.getGenerator(), (DataGenerator)valContainer.getGenerator(), (int)((Integer)this.config.get(lenOption)));
        return DataGeneratorContainer.of(new DataGeneratorMapper(mapGenerator, GenericMapData::new, ((Float)this.config.get(nr)).floatValue()), options.toArray(new ConfigOption[0]));
    }

    @Override
    public DataGeneratorContainer visit(RowType rowType) {
        List fieldContainers = rowType.getFields().stream().map(field -> {
            String fieldName = this.name + "." + field.getName();
            return field.getType().accept(new RandomGeneratorVisitor(fieldName, this.config));
        }).collect(Collectors.toList());
        List<ConfigOption> fieldOptions = fieldContainers.stream().flatMap(container -> container.getOptions().stream()).collect(Collectors.toList());
        ConfigOption nr = this.nullRate.floatType().defaultValue((Object)Float.valueOf(0.0f));
        fieldOptions.add(nr);
        DataGenerator[] generators = (DataGenerator[])fieldContainers.stream().map(DataGeneratorContainer::getGenerator).toArray(DataGenerator[]::new);
        return DataGeneratorContainer.of(new RowDataGenerator(generators, rowType.getFieldNames(), ((Float)this.config.get(nr)).floatValue()), fieldOptions.toArray(new ConfigOption[0]));
    }

    @Override
    protected DataGeneratorContainer defaultMethod(LogicalType logicalType) {
        throw new ValidationException("Unsupported type: " + logicalType);
    }

    private ConfigOption<Integer> getLengthOption(Supplier<Integer> defaultLengthSupplier) {
        return ConfigOptions.key((String)String.join((CharSequence)".", "fields", this.name, "length")).intType().defaultValue((Object)defaultLengthSupplier.get());
    }

    private static RandomGenerator<StringData> getRandomStringGenerator(final int length) {
        return new RandomGenerator<StringData>(){

            public StringData next() {
                if (this.nullRate == 0.0f || ThreadLocalRandom.current().nextFloat() > this.nullRate) {
                    int len = RandomGeneratorVisitor.generateLength(length, this.varLen);
                    return StringData.fromString(this.random.nextHexString(len));
                }
                return null;
            }
        };
    }

    private static RandomGenerator<TimestampData> getRandomPastTimestampGenerator(final Duration maxPast) {
        return new RandomGenerator<TimestampData>(){

            public TimestampData next() {
                if (this.nullRate == 0.0f || ThreadLocalRandom.current().nextFloat() > this.nullRate) {
                    long maxPastMillis = maxPast.toMillis();
                    long past = maxPastMillis > 0L ? this.random.nextLong(0L, maxPastMillis) : 0L;
                    return TimestampData.fromEpochMillis(System.currentTimeMillis() - past);
                }
                return null;
            }
        };
    }

    private static RandomGenerator<byte[]> getRandomBytesGenerator(final int length) {
        return new RandomGenerator<byte[]>(){

            public byte[] next() {
                byte[] arr = new byte[RandomGeneratorVisitor.generateLength(length, this.varLen)];
                this.random.getRandomGenerator().nextBytes(arr);
                return arr;
            }
        };
    }

    private static int generateLength(int maxLength, boolean varLen) {
        return varLen ? ThreadLocalRandom.current().nextInt(1, maxLength) : maxLength;
    }
}

