/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.agents.api.event;

import org.apache.flink.agents.api.Event;

import java.util.List;
import java.util.Map;

/** Event representing a tool call request */
public class ToolRequestEvent extends Event {
    private final String model;
    private final List<Map<String, Object>> toolCalls;
    private final long timestamp;

    public ToolRequestEvent(String model, List<Map<String, Object>> toolCalls) {
        this.model = model;
        this.toolCalls = toolCalls;
        this.timestamp = System.currentTimeMillis();
    }

    public String getModel() {
        return model;
    }

    public List<Map<String, Object>> getToolCalls() {
        return toolCalls;
    }

    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public String toString() {
        return "ToolRequestEvent{"
                + "model='"
                + model
                + '\''
                + ", toolCalls="
                + toolCalls
                + ", timestamp="
                + timestamp
                + '}';
    }
}
