/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.python.operator;

import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.plan.PythonFunction;
import org.apache.flink.agents.plan.actions.Action;
import org.apache.flink.agents.runtime.operator.ActionTask;
import org.apache.flink.agents.runtime.python.context.PythonRunnerContextImpl;
import org.apache.flink.agents.runtime.python.event.PythonEvent;
import org.apache.flink.agents.runtime.python.operator.PythonGeneratorActionTask;
import org.apache.flink.agents.runtime.python.utils.PythonActionExecutor;
import org.apache.flink.util.Preconditions;

public class PythonActionTask
extends ActionTask {
    public PythonActionTask(Object key, Event event, Action action) {
        super(key, event, action);
        Preconditions.checkState((boolean)(action.getExec() instanceof PythonFunction));
        Preconditions.checkState((boolean)(event instanceof PythonEvent), (Object)("Python action only accept python event, but got " + String.valueOf(event)));
    }

    @Override
    public ActionTask.ActionTaskResult invoke() throws Exception {
        LOG.debug("Try execute python action {} for event {} with key {}.", this.action.getName(), this.event, this.key);
        this.runnerContext.checkNoPendingEvents();
        PythonActionExecutor pythonActionExecutor = this.getPythonActionExecutor();
        String pythonGeneratorRef = pythonActionExecutor.executePythonFunction((PythonFunction)this.action.getExec(), (PythonEvent)this.event, this.runnerContext);
        if (pythonGeneratorRef != null) {
            PythonGeneratorActionTask tempGeneratedActionTask = new PythonGeneratorActionTask(this.key, this.event, this.action, pythonGeneratorRef);
            tempGeneratedActionTask.setRunnerContext(this.runnerContext);
            return ((ActionTask)tempGeneratedActionTask).invoke();
        }
        return new ActionTask.ActionTaskResult(true, this.runnerContext.drainEvents(this.event.getSourceTimestamp()), null);
    }

    protected PythonActionExecutor getPythonActionExecutor() {
        Preconditions.checkState((this.runnerContext != null && this.runnerContext instanceof PythonRunnerContextImpl ? 1 : 0) != 0);
        return ((PythonRunnerContextImpl)this.runnerContext).getPythonActionExecutor();
    }
}

