/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.geode.GemFireIOException;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.DistributionConfigSnapshot;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RuntimeDistributionConfigImpl
extends DistributionConfigImpl {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -805637520096606113L;
    private final transient InternalDistributedSystem system;

    public RuntimeDistributionConfigImpl(InternalDistributedSystem system) {
        super(system.getOriginalConfig());
        this.system = system;
        this.modifiable = false;
    }

    @Override
    public void setLogLevel(int value) {
        this.logLevel = (Integer)this.checkAttribute("log-level", value);
        this.getAttSourceMap().put("log-level", ConfigSource.runtime());
        this.logConfigChanged();
    }

    @Override
    public void setStatisticSamplingEnabled(boolean newValue) {
        this.statisticSamplingEnabled = (Boolean)this.checkAttribute("statistic-sampling-enabled", newValue);
        this.getAttSourceMap().put("statistic-sampling-enabled", ConfigSource.runtime());
    }

    @Override
    public void setStatisticSampleRate(int value) {
        if ((value = ((Integer)this.checkAttribute("statistic-sample-rate", value)).intValue()) < 1000) {
            logger.info("Setting statistic-sample-rate to {} instead of the requested {} because VSD does not work with sub-second sampling.", (Object)1000, (Object)value);
            value = 1000;
        }
        this.statisticSampleRate = value;
    }

    @Override
    public void setStatisticArchiveFile(File value) {
        if ((value = (File)this.checkAttribute("statistic-archive-file", value)) == null) {
            value = new File("");
        }
        try {
            this.system.getStatSampler().changeArchive(value);
        }
        catch (GemFireIOException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.statisticArchiveFile = value;
        this.getAttSourceMap().put("statistic-archive-file", ConfigSource.runtime());
    }

    @Override
    public void setArchiveDiskSpaceLimit(int value) {
        this.archiveDiskSpaceLimit = (Integer)this.checkAttribute("archive-disk-space-limit", value);
        this.getAttSourceMap().put("archive-disk-space-limit", ConfigSource.runtime());
    }

    @Override
    public void setArchiveFileSizeLimit(int value) {
        this.archiveFileSizeLimit = (Integer)this.checkAttribute("archive-file-size-limit", value);
        this.getAttSourceMap().put("archive-file-size-limit", ConfigSource.runtime());
    }

    @Override
    public void setLogDiskSpaceLimit(int value) {
        this.logDiskSpaceLimit = (Integer)this.checkAttribute("log-disk-space-limit", value);
        this.getAttSourceMap().put("log-disk-space-limit", ConfigSource.runtime());
        this.logConfigChanged();
    }

    @Override
    public void setLogFileSizeLimit(int value) {
        this.logFileSizeLimit = (Integer)this.checkAttribute("log-file-size-limit", value);
        this.getAttSourceMap().put("log-file-size-limit", ConfigSource.runtime());
        this.logConfigChanged();
    }

    @Override
    public List<String> getModifiableAttributes() {
        String[] modifiables = new String[]{"http-service-port", "jmx-manager-http-port", "archive-disk-space-limit", "archive-file-size-limit", "log-disk-space-limit", "log-file-size-limit", "log-level", "statistic-archive-file", "statistic-sample-rate", "statistic-sampling-enabled"};
        return Arrays.asList(modifiables);
    }

    public DistributionConfig takeSnapshot() {
        return new DistributionConfigSnapshot(this);
    }

    private void logConfigChanged() {
        this.system.logConfigChanged();
    }
}

