/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.logging.internal.spi.LogFile;
import org.apache.logging.log4j.Logger;

public class TailLogResponse
extends AdminResponse {
    private static final Logger logger = LogService.getLogger();
    private String tail;
    private String childTail;

    public static TailLogResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        TailLogResponse m = new TailLogResponse();
        m.setRecipient(recipient);
        try {
            InternalDistributedSystem sys = dm.getSystem();
            if (sys.getLogFile().isPresent()) {
                LogFile logFile = sys.getLogFile().get();
                m.childTail = TailLogResponse.tailSystemLog(logFile.getChildLogFile());
                m.tail = TailLogResponse.tailSystemLog(sys.getConfig());
                if (m.tail == null) {
                    m.tail = "No log file was specified in the configuration, messages will be directed to stdout.";
                }
            } else {
                m.childTail = TailLogResponse.tailSystemLog((File)null);
                m.tail = TailLogResponse.tailSystemLog(sys.getConfig());
                if (m.tail == null) {
                    m.tail = "No log file was specified in the configuration, messages will be directed to stdout.";
                }
            }
        }
        catch (IOException e) {
            logger.warn("Error occurred while reading system log: {}", (Object)e.toString());
            m.tail = "";
        }
        return m;
    }

    public int getDSFID() {
        return 1062;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeString(this.tail, out);
        DataSerializer.writeString(this.childTail, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.tail = DataSerializer.readString(in);
        this.childTail = DataSerializer.readString(in);
    }

    public String getTail() {
        return this.tail;
    }

    public String getChildTail() {
        return this.childTail;
    }

    @Override
    public String toString() {
        return "TailLogResponse from " + this.getRecipient() + " <TAIL>" + this.getTail() + "</TAIL>";
    }

    public static String tailSystemLog(File logFile) throws IOException {
        if (logFile == null || logFile.equals(new File(""))) {
            return null;
        }
        int numLines = 30;
        int maxBuffer = 65500;
        long fileLength = logFile.length();
        byte[] buffer = fileLength > (long)maxBuffer ? new byte[maxBuffer] : new byte[(int)fileLength];
        int readSize = buffer.length;
        RandomAccessFile f = new RandomAccessFile(logFile, "r");
        f.seek(fileLength - (long)readSize);
        f.read(buffer, 0, readSize);
        f.close();
        String messageString = new String(buffer);
        char[] text = messageString.toCharArray();
        int j = 0;
        for (int i = text.length - 1; i >= 0; --i) {
            if (text[i] == '[') {
                ++j;
            }
            if (j != numLines) continue;
            messageString = messageString.substring(i);
            break;
        }
        return messageString.trim();
    }

    private static String tailSystemLog(DistributionConfig sc) throws IOException {
        File logFile = sc.getLogFile();
        if (logFile == null || logFile.equals(new File(""))) {
            return null;
        }
        if (!logFile.isAbsolute()) {
            logFile = new File(logFile.getAbsolutePath());
        }
        return TailLogResponse.tailSystemLog(logFile);
    }
}

