/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public final class InterIndexDiffFilter
extends TreeFilter {
    private static final int baseTree = 0;
    public static final TreeFilter INSTANCE = new InterIndexDiffFilter();

    @Override
    public boolean include(TreeWalk walker) {
        int n = walker.getTreeCount();
        if (n == 1) {
            return true;
        }
        int m = walker.getRawMode(0);
        int i2 = 1;
        while (i2 < n) {
            DirCacheIterator baseDirCache = walker.getTree(0, DirCacheIterator.class);
            DirCacheIterator newDirCache = walker.getTree(i2, DirCacheIterator.class);
            if (baseDirCache != null && newDirCache != null) {
                DirCacheEntry baseDci = baseDirCache.getDirCacheEntry();
                DirCacheEntry newDci = newDirCache.getDirCacheEntry();
                if (baseDci != null && newDci != null) {
                    if (baseDci.isAssumeValid() != newDci.isAssumeValid()) {
                        return true;
                    }
                    if (baseDci.isAssumeValid()) {
                        return false;
                    }
                }
            }
            if (walker.getRawMode(i2) != m || !walker.idEqual(i2, 0)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public boolean shouldBeRecursive() {
        return false;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "INTERINDEX_DIFF";
    }
}

