/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class GravitinoOptions {
    public static final String AUDIT = "audit";
    public static final String AUTO = "auto";
    public static final String CLIENT = "client";
    public static final String COLUMNFILE = "columnfile";
    public static final String COMMENT = "comment";
    public static final String DATATYPE = "datatype";
    public static final String DEFAULT = "default";
    public static final String DISTRIBUTION = "distribution";
    public static final String FILESET = "fileset";
    public static final String FORCE = "force";
    public static final String GROUP = "group";
    public static final String HELP = "help";
    public static final String IGNORE = "ignore";
    public static final String INDEX = "index";
    public static final String LOGIN = "login";
    public static final String METALAKE = "metalake";
    public static final String NAME = "name";
    public static final String NULL = "null";
    public static final String OUTPUT = "output";
    public static final String OWNER = "owner";
    public static final String PARTITION = "partition";
    public static final String POSITION = "position";
    public static final String PRIVILEGE = "privilege";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTY = "property";
    public static final String QUIET = "quiet";
    public static final String PROVIDER = "provider";
    public static final String RENAME = "rename";
    public static final String ROLE = "role";
    public static final String SERVER = "server";
    public static final String SIMPLE = "simple";
    public static final String SORTORDER = "sortorder";
    public static final String TAG = "tag";
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String VALUE = "value";
    public static final String VERSION = "version";
    public static final String ALL = "all";
    public static final String ENABLE = "enable";
    public static final String DISABLE = "disable";
    public static final String ALIAS = "alias";
    public static final String URIS = "uris";
    public static final String NEW_URI = "newuri";
    public static final String NEW_ALIAS = "newalias";
    public static final String REMOVE_ALIAS = "removealias";

    public Options options() {
        Options options = new Options();
        options.addOption(this.createSimpleOption("h", HELP, "command help information"));
        options.addOption(this.createSimpleOption(null, CLIENT, "Gravitino client version"));
        options.addOption(this.createSimpleOption("s", SERVER, "Gravitino server version"));
        options.addOption(this.createArgOption("u", URL, "Gravitino URL (default: http://localhost:8090)"));
        options.addOption(this.createArgOption("n", NAME, "full entity name (dot separated)"));
        options.addOption(this.createArgOption("m", METALAKE, "metalake name"));
        options.addOption(this.createSimpleOption("i", IGNORE, "ignore client/sever version check"));
        options.addOption(this.createSimpleOption("a", AUDIT, "display audit information"));
        options.addOption(this.createSimpleOption(null, SIMPLE, "simple authentication"));
        options.addOption(this.createArgOption(null, LOGIN, "user name"));
        options.addOption(this.createSimpleOption("x", INDEX, "display index information"));
        options.addOption(this.createSimpleOption("d", DISTRIBUTION, "display distribution information"));
        options.addOption(this.createSimpleOption(PARTITION, "display partition information"));
        options.addOption(this.createSimpleOption("o", OWNER, "display entity owner"));
        options.addOption(this.createSimpleOption(null, SORTORDER, "display sortorder information"));
        options.addOption(this.createSimpleOption(null, ENABLE, "enable entities"));
        options.addOption(this.createSimpleOption(null, DISABLE, "disable entities"));
        options.addOption(this.createSimpleOption(null, QUIET, "quiet mode"));
        options.addOption(this.createArgOption(RENAME, "new entity name"));
        options.addOption(this.createArgOption("c", COMMENT, "entity comment"));
        options.addOption(this.createArgOption("P", PROPERTY, "property name"));
        options.addOption(this.createArgOption("V", VALUE, "property value"));
        options.addOption(this.createArgOption("z", PROVIDER, "provider one of hadoop, hive, mysql, postgres, iceberg, kafka"));
        options.addOption(this.createArgOption("l", USER, "user name"));
        options.addOption(this.createArgOption("g", GROUP, "group name"));
        options.addOption(this.createArgOption(DATATYPE, "column data type"));
        options.addOption(this.createArgOption(POSITION, "position of column"));
        options.addOption(this.createArgOption(NULL, "column value can be null (true/false)"));
        options.addOption(this.createArgOption(AUTO, "column value auto-increments (true/false)"));
        options.addOption(this.createArgOption(DEFAULT, "default column value"));
        options.addOption(this.createArgOption(COLUMNFILE, "CSV file describing columns"));
        options.addOption(this.createSimpleOption(null, ALL, "on all entities"));
        options.addOption(this.createArgOption(null, URIS, "model version URIs"));
        options.addOption(this.createArgsOption(null, ALIAS, "model aliases"));
        options.addOption(this.createArgOption(null, VERSION, "Gravitino client version"));
        options.addOption(this.createArgOption(null, NEW_URI, "New uri of a model version"));
        options.addOption(this.createArgsOption(null, NEW_ALIAS, "New alias of a model version"));
        options.addOption(this.createArgsOption(null, REMOVE_ALIAS, "Remove alias of a model version"));
        options.addOption(this.createArgsOption("p", PROPERTIES, "property name/value pairs"));
        options.addOption(this.createArgsOption("t", TAG, "tag name"));
        options.addOption(this.createArgsOption(null, PRIVILEGE, "privilege(s)"));
        options.addOption(this.createArgsOption("r", ROLE, "role name"));
        options.addOption(this.createSimpleOption("f", FORCE, "force operation"));
        options.addOption(this.createArgOption(OUTPUT, "output format (plain/table)"));
        return options;
    }

    public Option createSimpleOption(String shortName, String longName, String description) {
        return new Option(shortName, longName, false, description);
    }

    public Option createSimpleOption(String longName, String description) {
        return new Option(null, longName, false, description);
    }

    public Option createArgOption(String shortName, String longName, String description) {
        return new Option(shortName, longName, true, description);
    }

    public Option createArgOption(String longName, String description) {
        return new Option(null, longName, true, description);
    }

    public Option createArgsOption(String shortName, String longName, String description) {
        return Option.builder().option(shortName).longOpt(longName).hasArgs().desc(description).build();
    }
}

