/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.commands.Command;

public class OwnerCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private final FullName name;
    private final String metalake;
    private final String entityName;
    private final String owner;
    private final String group;
    private final String entity;

    public OwnerCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context, String entity) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.owner = line.getOptionValue("user");
        this.group = line.getOptionValue("group");
        this.name = new FullName(line);
        this.metalake = this.name.getMetalakeName();
        this.entityName = this.name.getName();
        this.entity = entity;
    }

    @Override
    protected void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        if (this.entityName == null && !"metalake".equals(this.entity)) {
            System.err.println("Missing --name option.");
            Main.exit(-1);
        }
        if (!this.executeCommand()) {
            System.err.println("Unsupported or unknown command.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "set": {
                this.handleSetCommand();
                return true;
            }
        }
        return false;
    }

    private void handleDetailsCommand() {
        this.gravitinoCommandLine.newOwnerDetails(this.context, this.metalake, this.entityName, this.entity).validate().handle();
    }

    private void handleSetCommand() {
        if (this.owner != null && this.group == null) {
            this.gravitinoCommandLine.newSetOwner(this.context, this.metalake, this.entityName, this.entity, this.owner, false).validate().handle();
        } else if (this.owner == null && this.group != null) {
            this.gravitinoCommandLine.newSetOwner(this.context, this.metalake, this.entityName, this.entity, this.group, true).validate().handle();
        } else {
            System.err.println("Unsupported combination of options either use --name, --user, --group or --property and --value.");
            Main.exit(-1);
        }
    }
}

