/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import com.google.common.base.Joiner;
import java.io.File;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.GravitinoConfig;
import org.apache.gravitino.cli.KerberosData;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.OAuthData;
import org.apache.gravitino.cli.outputs.BaseOutputFormat;
import org.apache.gravitino.cli.outputs.PlainFormat;
import org.apache.gravitino.cli.outputs.TableFormat;
import org.apache.gravitino.client.DefaultOAuth2TokenProvider;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.client.GravitinoClientBase;
import org.apache.gravitino.client.KerberosTokenProvider;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public abstract class Command {
    public static final String OUTPUT_FORMAT_TABLE = "table";
    public static final String OUTPUT_FORMAT_PLAIN = "plain";
    public static final Joiner COMMA_JOINER = Joiner.on(", ").skipNulls();
    protected static String authentication = null;
    protected static String userName = null;
    protected final CommandContext context;
    private static final String SIMPLE_AUTH = "simple";
    private static final String OAUTH_AUTH = "oauth";
    private static final String KERBEROS_AUTH = "kerberos";
    private final String url;
    private final boolean ignoreVersions;
    private final String outputFormat;

    protected Command(CommandContext context) {
        this.context = context;
        this.url = context.url();
        this.ignoreVersions = context.ignoreVersions();
        this.outputFormat = context.outputFormat();
    }

    public void exitWithError(String error) {
        System.err.println(error);
        Main.exit(-1);
    }

    public void printInformation(String message) {
        if (this.context.quiet()) {
            return;
        }
        this.printResults(message);
    }

    public <T> void printResults(T entity) {
        this.output(entity);
    }

    public void printResults(String results) {
        BaseOutputFormat.output(results, System.out);
    }

    public static void setAuthenticationMode(String authentication, String userName) {
        Command.authentication = authentication;
        Command.userName = userName;
    }

    public abstract void handle();

    public Command validate() {
        return this;
    }

    protected void validatePropertyAndValue(String property, String value) {
        if (property == null && value == null) {
            this.exitWithError("Missing --property and --value options.");
        }
        if (property == null) {
            this.exitWithError("Missing --property option.");
        }
        if (value == null) {
            this.exitWithError("Missing --value option.");
        }
    }

    protected void validateProperty(String property) {
        if (property == null) {
            this.exitWithError("Missing --property option.");
        }
    }

    protected GravitinoClient buildClient(String metalake) throws NoSuchMetalakeException {
        GravitinoClient.ClientBuilder client = GravitinoClient.builder(this.url).withMetalake(metalake);
        return this.constructClient(client).build();
    }

    protected GravitinoAdminClient buildAdminClient() {
        GravitinoAdminClient.AdminClientBuilder client = GravitinoAdminClient.builder(this.url);
        return this.constructClient(client).build();
    }

    protected <T extends GravitinoClientBase> GravitinoClientBase.Builder<T> constructClient(GravitinoClientBase.Builder<T> builder) {
        if (this.ignoreVersions) {
            builder = builder.withVersionCheckDisabled();
        }
        if (authentication != null) {
            if (authentication.equals(SIMPLE_AUTH)) {
                builder = userName != null && !userName.isEmpty() ? builder.withSimpleAuth(userName) : builder.withSimpleAuth();
            } else if (authentication.equals(OAUTH_AUTH)) {
                GravitinoConfig config = new GravitinoConfig(null);
                OAuthData oauth = config.getOAuth();
                DefaultOAuth2TokenProvider tokenProvider = (DefaultOAuth2TokenProvider)((DefaultOAuth2TokenProvider.Builder)DefaultOAuth2TokenProvider.builder().withUri(oauth.getServerURI())).withCredential(oauth.getCredential()).withPath(oauth.getToken()).withScope(oauth.getScope()).build();
                builder = builder.withOAuth(tokenProvider);
            } else if (authentication.equals(KERBEROS_AUTH)) {
                GravitinoConfig config = new GravitinoConfig(null);
                KerberosData kerberos = config.getKerberos();
                KerberosTokenProvider tokenProvider = KerberosTokenProvider.builder().withClientPrincipal(kerberos.getPrincipal()).withKeyTabFile(new File(kerberos.getKeytabFile())).build();
                builder = builder.withKerberosAuth(tokenProvider);
            } else {
                this.exitWithError("Unsupported authentication type " + authentication);
            }
        }
        return builder;
    }

    private <T> void output(T entity) {
        if (this.outputFormat == null) {
            PlainFormat.output(entity, this.context);
            return;
        }
        if (this.outputFormat.equals(OUTPUT_FORMAT_TABLE)) {
            TableFormat.output(entity, this.context);
        } else if (this.outputFormat.equals(OUTPUT_FORMAT_PLAIN)) {
            PlainFormat.output(entity, this.context);
        } else {
            throw new IllegalArgumentException("Unsupported output format");
        }
    }
}

