/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.AuditCommand;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchRoleException;

public class RoleAudit
extends AuditCommand {
    protected final String metalake;
    protected final String role;

    public RoleAudit(CommandContext context, String metalake, String role) {
        super(context);
        this.metalake = metalake;
        this.role = role;
    }

    @Override
    public void handle() {
        Role result = null;
        try (GravitinoClient client = this.buildClient(this.metalake);){
            result = client.getRole(this.role);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchRoleException err) {
            this.exitWithError("Unknown role.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (result != null) {
            this.displayAuditInfo(result.auditInfo());
        }
    }
}

