/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Catalog;
import org.apache.gravitino.Schema;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.cli.utils.FullNameUtil;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.rel.Table;

public class UntagEntity
extends Command {
    protected final String metalake;
    protected final FullName name;
    protected final String[] tags;

    public UntagEntity(CommandContext context, String metalake, FullName name, String[] tags) {
        super(context);
        this.metalake = metalake;
        this.name = name;
        this.tags = tags;
    }

    @Override
    public void handle() {
        String entity = "unknown";
        CharSequence[] removeTags = new String[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            if (this.name.getLevel() == 3) {
                String catalog = this.name.getCatalogName();
                Catalog catalogObject = client.loadCatalog(catalog);
                switch (catalogObject.type()) {
                    case RELATIONAL: {
                        String table;
                        entity = table = this.name.getTableName();
                        Table gTable = catalogObject.asTableCatalog().loadTable(FullNameUtil.toTable(this.name));
                        removeTags = gTable.supportsTags().associateTags(null, this.tags);
                        break;
                    }
                    case MODEL: {
                        String model;
                        entity = model = this.name.getModelName();
                        Model gModel = catalogObject.asModelCatalog().getModel(FullNameUtil.toModel(this.name));
                        removeTags = gModel.supportsTags().associateTags(null, this.tags);
                        break;
                    }
                    case FILESET: {
                        String fileset;
                        entity = fileset = this.name.getFilesetName();
                        Fileset gFileset = catalogObject.asFilesetCatalog().loadFileset(FullNameUtil.toFileset(this.name));
                        removeTags = gFileset.supportsTags().associateTags(null, this.tags);
                        break;
                    }
                    case MESSAGING: {
                        String topic;
                        entity = topic = this.name.getTopicName();
                        Topic gTopic = catalogObject.asTopicCatalog().loadTopic(FullNameUtil.toTopic(this.name));
                        removeTags = gTopic.supportsTags().associateTags(null, this.tags);
                        break;
                    }
                }
            } else if (this.name.hasSchemaName()) {
                String catalog = this.name.getCatalogName();
                String schema = this.name.getSchemaName();
                Schema gSchema = client.loadCatalog(catalog).asSchemas().loadSchema(schema);
                removeTags = gSchema.supportsTags().associateTags(null, this.tags);
                entity = schema;
            } else if (this.name.hasCatalogName()) {
                String catalog = this.name.getCatalogName();
                Catalog gCatalog = client.loadCatalog(catalog);
                removeTags = gCatalog.supportsTags().associateTags(null, this.tags);
                entity = catalog;
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        String all = String.join((CharSequence)",", removeTags);
        if (all.equals("")) {
            all = "nothing";
        }
        if (this.tags.length > 1) {
            this.printInformation(entity + " removed tags " + String.join((CharSequence)",", this.tags) + " now tagged with " + all);
        } else {
            this.printInformation(entity + " removed tag " + this.tags[0] + " now tagged with " + all);
        }
    }

    @Override
    public Command validate() {
        if (this.name == null || !this.name.hasName().booleanValue()) {
            this.exitWithError("Missing --name option.");
        }
        return super.validate();
    }
}

