/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.utils.DateTimeUtils;

public class TimestampToNumericPrimitiveCastRule
extends AbstractCastRule<Timestamp, Number> {
    static final TimestampToNumericPrimitiveCastRule INSTANCE = new TimestampToNumericPrimitiveCastRule();

    private TimestampToNumericPrimitiveCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).input(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).target(DataTypeRoot.BIGINT).target(DataTypeRoot.INTEGER).build());
    }

    @Override
    public CastExecutor<Timestamp, Number> create(DataType inputType, DataType targetType) {
        if (inputType.is(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            if (targetType.is(DataTypeRoot.BIGINT)) {
                return value -> DateTimeUtils.unixTimestamp(value.getMillisecond());
            }
            if (targetType.is(DataTypeRoot.INTEGER)) {
                return value -> (int)DateTimeUtils.unixTimestamp(value.getMillisecond());
            }
        } else if (inputType.is(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            if (targetType.is(DataTypeRoot.BIGINT)) {
                return value -> DateTimeUtils.unixTimestamp(Timestamp.fromLocalDateTime(value.toLocalDateTime()).getMillisecond());
            }
            if (targetType.is(DataTypeRoot.INTEGER)) {
                return value -> (int)DateTimeUtils.unixTimestamp(Timestamp.fromLocalDateTime(value.toLocalDateTime()).getMillisecond());
            }
        }
        return null;
    }
}

