/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.paimon.data.columnar.heap.ElementCountable;
import org.apache.paimon.data.columnar.heap.HeapIntVector;
import org.apache.paimon.data.columnar.writable.AbstractWritableVector;
import org.apache.paimon.memory.MemorySegment;
import sun.misc.Unsafe;

public abstract class AbstractHeapVector
extends AbstractWritableVector
implements ElementCountable {
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    public static final Unsafe UNSAFE = MemorySegment.UNSAFE;
    public static final int BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    public static final int INT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
    public static final int LONG_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
    public static final int FLOAT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
    public static final int DOUBLE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
    protected boolean[] isNull;
    protected HeapIntVector dictionaryIds;

    public AbstractHeapVector(int capacity) {
        super(capacity);
        this.isNull = new boolean[capacity];
    }

    @Override
    public void reset() {
        super.reset();
        if (this.isNull.length != this.capacity) {
            this.isNull = new boolean[this.capacity];
        } else {
            Arrays.fill(this.isNull, false);
        }
        if (this.dictionaryIds != null) {
            this.dictionaryIds.reset();
        }
    }

    @Override
    public void setNullAt(int i) {
        this.isNull[i] = true;
        this.noNulls = false;
    }

    @Override
    public void setNulls(int i, int count) {
        for (int j = 0; j < count; ++j) {
            this.isNull[i + j] = true;
        }
        if (count > 0) {
            this.noNulls = false;
        }
    }

    @Override
    public void fillWithNulls() {
        this.noNulls = false;
        Arrays.fill(this.isNull, true);
    }

    @Override
    public boolean isNullAt(int i) {
        return this.isAllNull || !this.noNulls && this.isNull[i];
    }

    @Override
    public HeapIntVector reserveDictionaryIds(int capacity) {
        if (this.dictionaryIds == null) {
            this.dictionaryIds = new HeapIntVector(capacity);
        } else if (capacity > this.dictionaryIds.vector.length) {
            int current;
            for (current = this.dictionaryIds.vector.length; current < capacity; current <<= 1) {
            }
            this.dictionaryIds = new HeapIntVector(current);
        } else {
            this.dictionaryIds.reset();
        }
        return this.dictionaryIds;
    }

    @Override
    public HeapIntVector getDictionaryIds() {
        return this.dictionaryIds;
    }

    @Override
    protected void reserveInternal(int newCapacity) {
        if (this.isNull.length < newCapacity) {
            this.isNull = Arrays.copyOf(this.isNull, newCapacity);
        }
        this.reserveForHeapVector(newCapacity);
    }

    abstract void reserveForHeapVector(int var1);
}

