/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.memory.internal;

import java.util.logging.Logger;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BaseStateImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.MemoryCleaner;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.NioBits;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.StepBoolean;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.UnsafeUtil;

final class AllocateDirect {
    static final Logger LOG = Logger.getLogger(AllocateDirect.class.getCanonicalName());
    private final Deallocator deallocator;
    private final long nativeBaseOffset;
    private final MemoryCleaner cleaner;

    AllocateDirect(long capacityBytes) {
        long nativeAddress;
        boolean pageAligned = NioBits.isPageAligned();
        long pageSize = NioBits.pageSize();
        long allocationSize = capacityBytes + (pageAligned ? pageSize : 0L);
        NioBits.reserveMemory(allocationSize, capacityBytes);
        try {
            nativeAddress = UnsafeUtil.unsafe.allocateMemory(allocationSize);
        }
        catch (OutOfMemoryError err) {
            NioBits.unreserveMemory(allocationSize, capacityBytes);
            throw new RuntimeException(err);
        }
        this.nativeBaseOffset = pageAligned && nativeAddress % pageSize != 0L ? (nativeAddress & (pageSize - 1L ^ 0xFFFFFFFFFFFFFFFFL)) + pageSize : nativeAddress;
        this.deallocator = new Deallocator(nativeAddress, allocationSize, capacityBytes);
        this.cleaner = new MemoryCleaner(this, this.deallocator);
    }

    boolean doClose() {
        try {
            if (this.deallocator.deallocate(false)) {
                this.cleaner.clean();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            BaseStateImpl.reachabilityFence(this);
        }
    }

    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    StepBoolean getValid() {
        return this.deallocator.getValid();
    }

    static final class Deallocator
    implements Runnable {
        private final long nativeAddress;
        private final long allocationSize;
        private final long capacity;
        private final StepBoolean valid = new StepBoolean(true);

        Deallocator(long nativeAddress, long allocationSize, long capacity) {
            BaseStateImpl.currentDirectMemoryAllocations_.incrementAndGet();
            BaseStateImpl.currentDirectMemoryAllocated_.addAndGet(capacity);
            this.nativeAddress = nativeAddress;
            this.allocationSize = allocationSize;
            this.capacity = capacity;
            assert (nativeAddress != 0L);
        }

        StepBoolean getValid() {
            return this.valid;
        }

        @Override
        public void run() {
            this.deallocate(true);
        }

        boolean deallocate(boolean calledFromCleaner) {
            if (this.valid.change()) {
                if (calledFromCleaner) {
                    LOG.warning("A WritableHandle was not closed manually");
                }
                UnsafeUtil.unsafe.freeMemory(this.nativeAddress);
                NioBits.unreserveMemory(this.allocationSize, this.capacity);
                BaseStateImpl.currentDirectMemoryAllocations_.decrementAndGet();
                BaseStateImpl.currentDirectMemoryAllocated_.addAndGet(-this.capacity);
                return true;
            }
            return false;
        }
    }
}

