/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorIndexFileWriter;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFile;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.Preconditions;

public class DeletionVectorsIndexFile
extends IndexFile {
    public static final String DELETION_VECTORS_INDEX = "DELETION_VECTORS";
    public static final byte VERSION_ID_V1 = 1;
    private final MemorySize targetSizePerIndexFile;
    private final boolean bitmap64;

    public DeletionVectorsIndexFile(FileIO fileIO, PathFactory pathFactory, MemorySize targetSizePerIndexFile, boolean bitmap64) {
        super(fileIO, pathFactory);
        this.targetSizePerIndexFile = targetSizePerIndexFile;
        this.bitmap64 = bitmap64;
    }

    public boolean bitmap64() {
        return this.bitmap64;
    }

    public Map<String, DeletionVector> readAllDeletionVectors(IndexFileMeta fileMeta) {
        LinkedHashMap<String, DeletionVectorMeta> deletionVectorMetas = fileMeta.deletionVectorMetas();
        Preconditions.checkNotNull(deletionVectorMetas);
        String indexFileName = fileMeta.fileName();
        HashMap<String, DeletionVector> deletionVectors = new HashMap<String, DeletionVector>();
        Path filePath = this.pathFactory.toPath(indexFileName);
        try (SeekableInputStream inputStream = this.fileIO.newInputStream(filePath);){
            this.checkVersion((InputStream)inputStream);
            DataInputStream dataInputStream = new DataInputStream((InputStream)inputStream);
            for (DeletionVectorMeta deletionVectorMeta : deletionVectorMetas.values()) {
                deletionVectors.put(deletionVectorMeta.dataFileName(), DeletionVector.read(dataInputStream, Long.valueOf(deletionVectorMeta.length())));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read deletion vectors from file: " + filePath + ", deletionVectorMetas: " + deletionVectorMetas, e);
        }
        return deletionVectors;
    }

    public Map<String, DeletionVector> readAllDeletionVectors(List<IndexFileMeta> indexFiles) {
        HashMap<String, DeletionVector> deletionVectors = new HashMap<String, DeletionVector>();
        indexFiles.forEach(indexFile -> deletionVectors.putAll(this.readAllDeletionVectors((IndexFileMeta)indexFile)));
        return deletionVectors;
    }

    public Map<String, DeletionVector> readDeletionVector(Map<String, DeletionFile> dataFileToDeletionFiles) {
        HashMap<String, DeletionVector> deletionVectors = new HashMap<String, DeletionVector>();
        if (dataFileToDeletionFiles.isEmpty()) {
            return deletionVectors;
        }
        String indexFile = dataFileToDeletionFiles.values().stream().findAny().get().path();
        try (SeekableInputStream inputStream = this.fileIO.newInputStream(new Path(indexFile));){
            this.checkVersion((InputStream)inputStream);
            for (String dataFile : dataFileToDeletionFiles.keySet()) {
                DeletionFile deletionFile = dataFileToDeletionFiles.get(dataFile);
                Preconditions.checkArgument((boolean)deletionFile.path().equals(indexFile));
                inputStream.seek(deletionFile.offset());
                DataInputStream dataInputStream = new DataInputStream((InputStream)inputStream);
                deletionVectors.put(dataFile, DeletionVector.read(dataInputStream, deletionFile.length()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read deletion vector from file: " + indexFile, e);
        }
        return deletionVectors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeletionVector readDeletionVector(DeletionFile deletionFile) {
        String indexFile = deletionFile.path();
        try (SeekableInputStream inputStream = this.fileIO.newInputStream(new Path(indexFile));){
            this.checkVersion((InputStream)inputStream);
            Preconditions.checkArgument((boolean)deletionFile.path().equals(indexFile));
            inputStream.seek(deletionFile.offset());
            DataInputStream dataInputStream = new DataInputStream((InputStream)inputStream);
            DeletionVector deletionVector = DeletionVector.read(dataInputStream, deletionFile.length());
            return deletionVector;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read deletion vector from file: " + indexFile, e);
        }
    }

    public List<IndexFileMeta> write(Map<String, DeletionVector> input) {
        try {
            DeletionVectorIndexFileWriter writer = new DeletionVectorIndexFileWriter(this.fileIO, this.pathFactory, this.targetSizePerIndexFile);
            return writer.write(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write deletion vectors.", e);
        }
    }

    private void checkVersion(InputStream in) throws IOException {
        int version = in.read();
        if (version != 1) {
            throw new RuntimeException("Version not match, actual version: " + version + ", expected version: " + 1);
        }
    }
}

