/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.utils.PathFactory;

public abstract class IndexFile {
    protected final FileIO fileIO;
    protected final PathFactory pathFactory;

    public IndexFile(FileIO fileIO, PathFactory pathFactory) {
        this.fileIO = fileIO;
        this.pathFactory = pathFactory;
    }

    public long fileSize(String fileName) {
        try {
            return this.fileIO.getFileSize(this.pathFactory.toPath(fileName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void delete(String fileName) {
        this.fileIO.deleteQuietly(this.pathFactory.toPath(fileName));
    }

    public boolean exists(String fileName) {
        try {
            return this.fileIO.exists(this.pathFactory.toPath(fileName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

