/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.partition.PartitionExpireStrategyFactory;
import org.apache.paimon.partition.PartitionUpdateTimeExpireStrategy;
import org.apache.paimon.partition.PartitionValuesTimeExpireStrategy;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public abstract class PartitionExpireStrategy {
    protected final List<String> partitionKeys;
    private final RowDataToObjectArrayConverter toObjectArrayConverter;

    public PartitionExpireStrategy(RowType partitionType) {
        this.toObjectArrayConverter = new RowDataToObjectArrayConverter(partitionType);
        this.partitionKeys = partitionType.getFieldNames();
    }

    public Map<String, String> toPartitionString(Object[] array) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.partitionKeys.size());
        for (int i = 0; i < this.partitionKeys.size(); ++i) {
            map.put(this.partitionKeys.get(i), array[i].toString());
        }
        return map;
    }

    public List<String> toPartitionValue(Object[] array) {
        ArrayList<String> list = new ArrayList<String>(this.partitionKeys.size());
        for (int i = 0; i < this.partitionKeys.size(); ++i) {
            list.add(array[i].toString());
        }
        return list;
    }

    public Object[] convertPartition(BinaryRow partition) {
        return this.toObjectArrayConverter.convert((InternalRow)partition);
    }

    public abstract List<PartitionEntry> selectExpiredPartitions(FileStoreScan var1, LocalDateTime var2);

    public static PartitionExpireStrategy createPartitionExpireStrategy(CoreOptions options, RowType partitionType, @Nullable CatalogLoader catalogLoader, @Nullable Identifier identifier) {
        switch (options.partitionExpireStrategy()) {
            case UPDATE_TIME: {
                return new PartitionUpdateTimeExpireStrategy(partitionType);
            }
            case VALUES_TIME: {
                return new PartitionValuesTimeExpireStrategy(options, partitionType);
            }
            case CUSTOM: {
                return ((PartitionExpireStrategyFactory)PartitionExpireStrategyFactory.INSTANCE.get()).create(catalogLoader, identifier, partitionType);
            }
        }
        throw new IllegalArgumentException("Unknown partitionExpireStrategy: " + options.partitionExpireStrategy());
    }
}

