/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.ReadPlanStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.SnapshotManager;

public class StaticFromTimestampStartingScanner
extends ReadPlanStartingScanner {
    private final Snapshot snapshot;

    public StaticFromTimestampStartingScanner(SnapshotManager snapshotManager, long startupMillis) {
        super(snapshotManager);
        this.snapshot = StaticFromTimestampStartingScanner.timeTravelToTimestamp(snapshotManager, startupMillis);
        if (this.snapshot == null) {
            Snapshot earliestSnapshot = snapshotManager.earliestSnapshot();
            throw new IllegalArgumentException(String.format("There is currently no snapshot earlier than or equal to timestamp [%s], the earliest snapshot's timestamp is [%s]", startupMillis, earliestSnapshot == null ? "null" : String.valueOf(earliestSnapshot.timeMillis())));
        }
        this.startingSnapshotId = this.snapshot.id();
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public SnapshotReader configure(SnapshotReader snapshotReader) {
        return snapshotReader.withMode(ScanMode.ALL).withSnapshot(this.snapshot);
    }

    @Nullable
    public static Snapshot timeTravelToTimestamp(SnapshotManager snapshotManager, long timestamp) {
        return snapshotManager.earlierOrEqualTimeMills(timestamp);
    }
}

