/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.io.IOException;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.partition.file.SuccessFile;
import org.apache.paimon.table.sink.TagCallback;

public class SuccessFileTagCallback
implements TagCallback {
    private static final String SUCCESS_FILE_SUFFIX = "_SUCCESS";
    private static final String SUCCESS_FILE_DIRECTORY = "tag-success-file";
    private final FileIO fileIO;
    private final Path successFileDirectory;

    public SuccessFileTagCallback(FileIO fileIO, Path tagDirectory) {
        this.fileIO = fileIO;
        this.successFileDirectory = new Path(tagDirectory, SUCCESS_FILE_DIRECTORY);
        try {
            fileIO.checkOrMkdirs(this.successFileDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void notifyCreation(String tagName) {
        Path tagSuccessPath = this.tagSuccessFilePath(tagName);
        long currentTime = System.currentTimeMillis();
        SuccessFile successFile = new SuccessFile(currentTime, currentTime);
        try {
            if (this.fileIO.exists(tagSuccessPath)) {
                successFile = SuccessFile.fromPath(this.fileIO, tagSuccessPath).updateModificationTime(currentTime);
            }
            this.fileIO.overwriteFileUtf8(tagSuccessPath, successFile.toJson());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void notifyDeletion(String tagName) {
        Path tagSuccessPath = this.tagSuccessFilePath(tagName);
        this.fileIO.deleteQuietly(tagSuccessPath);
    }

    @VisibleForTesting
    public Path tagSuccessFilePath(String tagName) {
        return new Path(this.successFileDirectory, tagName + SUCCESS_FILE_SUFFIX);
    }

    @Override
    public void close() throws Exception {
    }
}

