/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Data;
import org.apache.arrow.c.jni.JniWrapper;
import org.apache.arrow.c.jni.PrivateData;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.Schema;

final class ArrayStreamExporter {
    private final BufferAllocator allocator;

    ArrayStreamExporter(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    void export(ArrowArrayStream stream, ArrowReader reader) {
        ExportedArrayStreamPrivateData data = new ExportedArrayStreamPrivateData(this.allocator, reader);
        try {
            JniWrapper.get().exportArrayStream(stream.memoryAddress(), data);
        }
        catch (Exception e) {
            data.close();
            throw e;
        }
    }

    static class ExportedArrayStreamPrivateData
    implements PrivateData {
        final BufferAllocator allocator;
        final ArrowReader reader;
        byte[] lastError;

        ExportedArrayStreamPrivateData(BufferAllocator allocator, ArrowReader reader) {
            this.allocator = allocator;
            this.reader = reader;
        }

        private int setLastError(Throwable err) {
            try {
                StringWriter buf = new StringWriter();
                PrintWriter writer = new PrintWriter(buf);
                err.printStackTrace(writer);
                this.lastError = buf.toString().getBytes(StandardCharsets.UTF_8);
            }
            catch (Throwable e) {
                this.lastError = null;
            }
            return 5;
        }

        int getNext(long arrayAddress) {
            int n;
            block10: {
                ArrowArray out = ArrowArray.wrap(arrayAddress);
                Throwable throwable = null;
                try {
                    if (this.reader.loadNextBatch()) {
                        Data.exportVectorSchemaRoot(this.allocator, this.reader.getVectorSchemaRoot(), (DictionaryProvider)this.reader, out);
                    } else {
                        out.markReleased();
                    }
                    n = 0;
                    if (out == null) break block10;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out != null) {
                                ExportedArrayStreamPrivateData.$closeResource(throwable, out);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable e) {
                        return this.setLastError(e);
                    }
                }
                ExportedArrayStreamPrivateData.$closeResource(throwable, out);
            }
            return n;
        }

        int getSchema(long schemaAddress) {
            int n;
            block8: {
                ArrowSchema out = ArrowSchema.wrap(schemaAddress);
                Throwable throwable = null;
                try {
                    Schema schema = this.reader.getVectorSchemaRoot().getSchema();
                    Data.exportSchema(this.allocator, schema, (DictionaryProvider)this.reader, out);
                    n = 0;
                    if (out == null) break block8;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out != null) {
                                ExportedArrayStreamPrivateData.$closeResource(throwable, out);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable e) {
                        return this.setLastError(e);
                    }
                }
                ExportedArrayStreamPrivateData.$closeResource(throwable, out);
            }
            return n;
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }
    }
}

