/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.hudi.backend.hms.kerberos;

import java.util.Map;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public class AuthenticationConfig
extends Config {
    public static final String AUTH_TYPE_KEY = "authentication.type";
    public static final String IMPERSONATION_ENABLE_KEY = "authentication.impersonation-enable";
    public static final boolean KERBEROS_DEFAULT_IMPERSONATION_ENABLE = false;
    public static final ConfigEntry<String> AUTH_TYPE_ENTRY = new ConfigBuilder("authentication.type").doc("The type of authentication for Hudi catalog, currently we only support simple and Kerberos").version("1.0.0").stringConf().createWithDefault((Object)"simple");
    public static final ConfigEntry<Boolean> ENABLE_IMPERSONATION_ENTRY = new ConfigBuilder("authentication.impersonation-enable").doc("Whether to enable impersonation for the Hudi catalog").version("1.0.0").booleanConf().createWithDefault((Object)false);

    public AuthenticationConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    public String getAuthType() {
        return (String)this.get(AUTH_TYPE_ENTRY);
    }

    public boolean isKerberosAuth() {
        return AuthenticationType.KERBEROS.name().equalsIgnoreCase(this.getAuthType());
    }

    static enum AuthenticationType {
        SIMPLE,
        KERBEROS;

    }
}

