/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.provider;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.service.provider.DynamicIcebergConfigProvider;
import org.apache.gravitino.iceberg.service.provider.IcebergConfigProvider;
import org.apache.gravitino.iceberg.service.provider.StaticIcebergConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergConfigProviderFactory {
    public static final Logger LOG = LoggerFactory.getLogger(IcebergConfigProviderFactory.class);
    private static final ImmutableMap<String, String> ICEBERG_CATALOG_CONFIG_PROVIDER_NAMES = ImmutableMap.of((Object)"static-config-provider", (Object)StaticIcebergConfigProvider.class.getCanonicalName(), (Object)"dynamic-config-provider", (Object)DynamicIcebergConfigProvider.class.getCanonicalName());

    public static IcebergConfigProvider create(Map<String, String> properties) {
        String providerName = (String)new IcebergConfig(properties).get(IcebergConfig.ICEBERG_REST_CATALOG_CONFIG_PROVIDER);
        String className = (String)ICEBERG_CATALOG_CONFIG_PROVIDER_NAMES.getOrDefault((Object)providerName, (Object)providerName);
        LOG.info("Load Iceberg catalog provider: {}.", (Object)className);
        try {
            Class<?> providerClz = Class.forName(className);
            return (IcebergConfigProvider)providerClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

