/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.ImmutableCommitMetrics;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.Timer;
import org.immutables.value.Value;

@Value.Immutable
public abstract class CommitMetrics {
    public static final String TOTAL_DURATION = "total-duration";
    public static final String ATTEMPTS = "attempts";

    public static CommitMetrics noop() {
        return CommitMetrics.of(MetricsContext.nullMetrics());
    }

    public abstract MetricsContext metricsContext();

    @Value.Derived
    public Timer totalDuration() {
        return this.metricsContext().timer(TOTAL_DURATION, TimeUnit.NANOSECONDS);
    }

    @Value.Derived
    public Counter attempts() {
        return this.metricsContext().counter(ATTEMPTS, MetricsContext.Unit.COUNT);
    }

    public static CommitMetrics of(MetricsContext metricsContext) {
        return ImmutableCommitMetrics.builder().metricsContext(metricsContext).build();
    }
}

