/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.operation.Operation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Update
implements Operation {
    private List<Long> removedFragmentIds;
    private List<FragmentMetadata> updatedFragments;
    private List<FragmentMetadata> newFragments;

    private Update(List<Long> removedFragmentIds, List<FragmentMetadata> updatedFragments, List<FragmentMetadata> newFragments) {
        this.removedFragmentIds = removedFragmentIds;
        this.updatedFragments = updatedFragments;
        this.newFragments = newFragments;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Long> removedFragmentIds() {
        return this.removedFragmentIds;
    }

    public List<FragmentMetadata> updatedFragments() {
        return this.updatedFragments;
    }

    public List<FragmentMetadata> newFragments() {
        return this.newFragments;
    }

    @Override
    public String name() {
        return "Update";
    }

    public String toString() {
        return String.format("Update{removedFragmentIds=%s, updatedFragments=%s, newFragments=%s}", this.removedFragmentIds, this.updatedFragments, this.newFragments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Update that = (Update)o;
        return Objects.equals(this.removedFragmentIds, that.removedFragmentIds) && Objects.equals(this.updatedFragments, that.updatedFragments) && Objects.equals(this.newFragments, that.newFragments);
    }

    public static class Builder {
        private List<Long> removedFragmentIds = Collections.emptyList();
        private List<FragmentMetadata> updatedFragments = Collections.emptyList();
        private List<FragmentMetadata> newFragments = Collections.emptyList();

        private Builder() {
        }

        public Builder removedFragmentIds(List<Long> removedFragmentIds) {
            this.removedFragmentIds = removedFragmentIds;
            return this;
        }

        public Builder updatedFragments(List<FragmentMetadata> updatedFragments) {
            this.updatedFragments = updatedFragments;
            return this;
        }

        public Builder newFragments(List<FragmentMetadata> newFragments) {
            this.newFragments = newFragments;
            return this;
        }

        public Update build() {
            return new Update(this.removedFragmentIds, this.updatedFragments, this.newFragments);
        }
    }
}

