/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.schema;

import java.util.Optional;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class ColumnAlteration {
    private String path;
    private Optional<String> rename;
    private Optional<Boolean> nullable;
    private Optional<ArrowType> dataType;

    private ColumnAlteration(String path) {
        this.path = path;
        this.rename = Optional.empty();
        this.nullable = Optional.empty();
        this.dataType = Optional.empty();
    }

    public String getPath() {
        return this.path;
    }

    public Optional<String> getRename() {
        return this.rename;
    }

    public Optional<Boolean> getNullable() {
        return this.nullable;
    }

    public Optional<ArrowType> getDataType() {
        return this.dataType;
    }

    public static class Builder {
        private final ColumnAlteration columnAlteration;

        public Builder(String path) {
            this.columnAlteration = new ColumnAlteration(path);
        }

        public Builder rename(String rename) {
            this.columnAlteration.rename = Optional.of(rename);
            return this;
        }

        public Builder nullable(boolean nullable) {
            this.columnAlteration.nullable = Optional.of(nullable);
            return this;
        }

        public Builder castTo(ArrowType dataType) {
            this.columnAlteration.dataType = Optional.of(dataType);
            return this;
        }

        public ColumnAlteration build() {
            return this.columnAlteration;
        }
    }
}

