/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.input.UnsynchronizedBufferedReader;

final class ExtendedBufferedReader
extends UnsynchronizedBufferedReader {
    private int lastChar = -2;
    private int lastCharMark = -2;
    private long lineNumber;
    private long lineNumberMark;
    private long position;
    private long positionMark;

    ExtendedBufferedReader(Reader reader) {
        super(reader);
    }

    public void close() throws IOException {
        this.lastChar = -1;
        super.close();
    }

    int getLastChar() {
        return this.lastChar;
    }

    long getLineNumber() {
        if (this.lastChar == 13 || this.lastChar == 10 || this.lastChar == -2 || this.lastChar == -1) {
            return this.lineNumber;
        }
        return this.lineNumber + 1L;
    }

    long getPosition() {
        return this.position;
    }

    public void mark(int readAheadLimit) throws IOException {
        this.lineNumberMark = this.lineNumber;
        this.lastCharMark = this.lastChar;
        this.positionMark = this.position;
        super.mark(readAheadLimit);
    }

    public int read() throws IOException {
        int current = super.read();
        if (current == 13 || current == 10 && this.lastChar != 13 || current == -1 && this.lastChar != 13 && this.lastChar != 10 && this.lastChar != -1) {
            ++this.lineNumber;
        }
        this.lastChar = current;
        ++this.position;
        return this.lastChar;
    }

    public int read(char[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int len = super.read(buf, offset, length);
        if (len > 0) {
            for (int i = offset; i < offset + len; ++i) {
                char ch = buf[i];
                if (ch == '\n') {
                    if (13 == (i > offset ? buf[i - 1] : this.lastChar)) continue;
                    ++this.lineNumber;
                    continue;
                }
                if (ch != '\r') continue;
                ++this.lineNumber;
            }
            this.lastChar = buf[offset + len - 1];
        } else if (len == -1) {
            this.lastChar = -1;
        }
        this.position += (long)len;
        return len;
    }

    public String readLine() throws IOException {
        if (this.peek() == -1) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        while (true) {
            int next;
            int current;
            if ((current = this.read()) == 13 && (next = this.peek()) == 10) {
                this.read();
            }
            if (current == -1 || current == 10 || current == 13) break;
            buffer.append((char)current);
        }
        return buffer.toString();
    }

    public void reset() throws IOException {
        this.lineNumber = this.lineNumberMark;
        this.lastChar = this.lastCharMark;
        this.position = this.positionMark;
        super.reset();
    }
}

