/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.circuitBreaker;

import io.openlineage.client.circuitBreaker.CircuitBreaker;
import io.openlineage.client.circuitBreaker.CircuitBreakerBuilder;
import io.openlineage.client.circuitBreaker.CircuitBreakerConfig;
import io.openlineage.client.circuitBreaker.JavaRuntimeCircuitBreakerBuilder;
import io.openlineage.client.circuitBreaker.NoOpCircuitBreakerBuilder;
import io.openlineage.client.circuitBreaker.SimpleMemoryCircuitBreakerBuilder;
import io.openlineage.client.circuitBreaker.StaticCircuitBreakerBuilder;
import io.openlineage.client.circuitBreaker.TaskQueueCircuitBreakerBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CircuitBreakerResolver {
    private static List<CircuitBreakerBuilder> builders = Arrays.asList(new StaticCircuitBreakerBuilder(), new SimpleMemoryCircuitBreakerBuilder(), new JavaRuntimeCircuitBreakerBuilder(), new TaskQueueCircuitBreakerBuilder());

    public static Class<? extends CircuitBreakerConfig> resolveCircuitBreakerConfigByType(String type) {
        CircuitBreakerBuilder builder = CircuitBreakerResolver.getCircuitBreakerBuilder(b -> b.getType().equalsIgnoreCase(type));
        return builder.getConfig().getClass();
    }

    public static String resolveCircuitBreakerTypeByConfigClass(Class circuitBreakerConfigClass) {
        CircuitBreakerBuilder builder = CircuitBreakerResolver.getCircuitBreakerBuilder(b -> b.getConfig().getClass().equals(circuitBreakerConfigClass));
        return builder.getType();
    }

    public static CircuitBreaker resolveCircuitBreakerByConfig(CircuitBreakerConfig circuitBreakerConfig) {
        CircuitBreakerBuilder builder = CircuitBreakerResolver.getCircuitBreakerBuilder(b -> b.getConfig().getClass().equals(circuitBreakerConfig.getClass()));
        return builder.build(circuitBreakerConfig);
    }

    private static CircuitBreakerBuilder getCircuitBreakerBuilder(Predicate<CircuitBreakerBuilder> predicate) {
        return Stream.concat(builders.stream(), StreamSupport.stream(CircuitBreakerServiceLoader.load().spliterator(), false)).filter(predicate).findFirst().orElse(new NoOpCircuitBreakerBuilder());
    }

    static class CircuitBreakerServiceLoader {
        CircuitBreakerServiceLoader() {
        }

        static ServiceLoader<CircuitBreakerBuilder> load() {
            return ServiceLoader.load(CircuitBreakerBuilder.class);
        }
    }
}

