/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.utils.filesystem;

import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.client.utils.filesystem.FilesystemDatasetExtractor;
import io.openlineage.client.utils.filesystem.FilesystemUriSanitizer;
import java.net.URI;
import java.util.Optional;

public class ObjectStorageDatasetExtractor
implements FilesystemDatasetExtractor {
    private final String scheme;

    public ObjectStorageDatasetExtractor(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public boolean isDefinedAt(URI location) {
        return location.getScheme().startsWith(this.scheme);
    }

    @Override
    public DatasetIdentifier extract(URI location) {
        URI namespace = new URI(location.getScheme(), location.getAuthority(), null, null, null);
        String name = location.getPath();
        return this.extract(namespace, name);
    }

    @Override
    public DatasetIdentifier extract(URI location, String rawName) {
        URI fixedLocation = new URI(this.scheme, location.getAuthority(), location.getPath(), null, null);
        String namespace = FilesystemUriSanitizer.removeLastSlash(fixedLocation.toString());
        String name = Optional.of(rawName).map(FilesystemUriSanitizer::removeFirstSlash).map(FilesystemUriSanitizer::removeLastSlash).map(FilesystemUriSanitizer::nonEmptyPath).get();
        return new DatasetIdentifier(name, namespace);
    }
}

