/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.math;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorDouble;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.utils.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class MathLogFunction
extends AbstractFunction {
    private static final long serialVersionUID = -3726921342776002687L;

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        Number num = FunctionUtils.getNumberValue(arg1, env);
        if (TypeUtils.isDecimal(num)) {
            return new AviatorDecimal(TypeUtils.ln(env, (BigDecimal)num));
        }
        if (TypeUtils.isBigInt(num)) {
            return new AviatorDecimal(TypeUtils.ln(env, new BigDecimal((BigInteger)num)));
        }
        return new AviatorDouble(Math.log(num.doubleValue()));
    }

    @Override
    public String getName() {
        return "math.log";
    }
}

