/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.InlineMe;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Version;
import org.apache.gravitino.client.AuthDataProvider;
import org.apache.gravitino.client.CustomTokenProvider;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GravitinoMetalake;
import org.apache.gravitino.client.GravitinoVersion;
import org.apache.gravitino.client.HTTPClient;
import org.apache.gravitino.client.KerberosTokenProvider;
import org.apache.gravitino.client.OAuth2TokenProvider;
import org.apache.gravitino.client.ObjectMapperProvider;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.client.SimpleTokenProvider;
import org.apache.gravitino.dto.responses.MetalakeResponse;
import org.apache.gravitino.dto.responses.VersionResponse;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public abstract class GravitinoClientBase
implements Closeable {
    protected final RESTClient restClient;
    protected static final String API_METALAKES_LIST_PATH = "api/metalakes";
    protected static final String API_METALAKES_IDENTIFIER_PATH = "api/metalakes/";

    protected GravitinoClientBase(String uri, AuthDataProvider authDataProvider, boolean checkVersion, Map<String, String> headers, Map<String, String> properties) {
        ObjectMapper mapper = ObjectMapperProvider.objectMapper();
        this.restClient = checkVersion ? HTTPClient.builder(properties).uri(uri).withAuthDataProvider(authDataProvider).withObjectMapper(mapper).withPreConnectHandler(this::checkVersion).withHeaders(headers).build() : HTTPClient.builder(properties).uri(uri).withAuthDataProvider(authDataProvider).withObjectMapper(mapper).withHeaders(headers).build();
    }

    public void checkVersion() {
        GravitinoVersion serverVersion = this.serverVersion();
        GravitinoVersion clientVersion = this.clientVersion();
        if (!clientVersion.compatibleWithServerVersion(serverVersion)) {
            throw new GravitinoRuntimeException("Gravitino does not support the case that the client-side version is higher than the server version.The client version is %s, and the server version %s", new Object[]{clientVersion.version(), serverVersion.version()});
        }
    }

    public GravitinoVersion clientVersion() {
        return new GravitinoVersion(Version.getCurrentVersionDTO());
    }

    public GravitinoMetalake loadMetalake(String metalakeName) throws NoSuchMetalakeException {
        this.checkMetalakeName(metalakeName);
        MetalakeResponse resp = this.restClient.get(API_METALAKES_IDENTIFIER_PATH + metalakeName, MetalakeResponse.class, Collections.emptyMap(), ErrorHandlers.metalakeErrorHandler());
        resp.validate();
        return DTOConverters.toMetaLake(resp.getMetalake(), this.restClient);
    }

    public void checkMetalakeName(String metalakeName) {
        NameIdentifier identifier = NameIdentifier.parse((String)metalakeName);
        Namespace.check((identifier.namespace() != null && identifier.namespace().isEmpty() ? 1 : 0) != 0, (String)"Metalake namespace must be non-null and empty, the input namespace is %s", (Object[])new Object[]{identifier.namespace()});
    }

    @Deprecated
    @InlineMe(replacement="this.serverVersion()")
    public final GravitinoVersion getVersion() {
        return this.serverVersion();
    }

    public GravitinoVersion serverVersion() {
        VersionResponse resp = this.restClient.get("api/version", VersionResponse.class, Collections.emptyMap(), ErrorHandlers.restErrorHandler());
        resp.validate();
        return new GravitinoVersion(resp.getVersion());
    }

    @Override
    public void close() {
        if (this.restClient != null) {
            try {
                this.restClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    RESTClient restClient() {
        return this.restClient;
    }

    public static abstract class Builder<T> {
        protected String uri;
        protected AuthDataProvider authDataProvider;
        protected boolean checkVersion = true;
        protected Map<String, String> headers = ImmutableMap.of();
        protected Map<String, String> properties = ImmutableMap.of();

        protected Builder(String uri) {
            this.uri = uri;
        }

        public Builder<T> withSimpleAuth() {
            this.authDataProvider = new SimpleTokenProvider();
            return this;
        }

        public Builder<T> withSimpleAuth(String userName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)userName), (Object)"userName can't be blank");
            this.authDataProvider = new SimpleTokenProvider(userName);
            return this;
        }

        public Builder<T> withVersionCheckDisabled() {
            this.checkVersion = false;
            return this;
        }

        public Builder<T> withOAuth(OAuth2TokenProvider dataProvider) {
            this.authDataProvider = dataProvider;
            return this;
        }

        public Builder<T> withKerberosAuth(KerberosTokenProvider dataProvider) {
            try {
                if (this.uri != null) {
                    dataProvider.setHost(new URI(this.uri).getHost());
                }
            }
            catch (URISyntaxException ue) {
                throw new IllegalArgumentException("URI has the wrong format", ue);
            }
            this.authDataProvider = dataProvider;
            return this;
        }

        public Builder<T> withCustomTokenAuth(CustomTokenProvider dataProvider) {
            this.authDataProvider = dataProvider;
            return this;
        }

        public Builder<T> withHeaders(Map<String, String> headers) {
            if (headers != null) {
                this.headers = ImmutableMap.copyOf(headers);
            }
            return this;
        }

        public Builder<T> withClientConfig(Map<String, String> properties) {
            if (properties != null) {
                this.properties = ImmutableMap.copyOf(properties);
            }
            return this;
        }

        public abstract T build();
    }
}

