/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourcesTracker;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizedResource;

class LocalCacheCleaner {
    private long currentSize;
    private final long targetSize;
    private final DeletionService delService;
    private final SortedMap<LocalizedResource, LocalResourcesTracker> resourceMap;

    LocalCacheCleaner(DeletionService delService, long targetSize) {
        this(delService, targetSize, new LRUComparator());
    }

    LocalCacheCleaner(DeletionService delService, long targetSize, Comparator<? super LocalizedResource> cmp) {
        this(delService, targetSize, new TreeMap<LocalizedResource, LocalResourcesTracker>(cmp));
    }

    LocalCacheCleaner(DeletionService delService, long targetSize, SortedMap<LocalizedResource, LocalResourcesTracker> resourceMap) {
        this.resourceMap = resourceMap;
        this.delService = delService;
        this.targetSize = targetSize;
    }

    public void addResources(LocalResourcesTracker newTracker) {
        for (LocalizedResource resource : newTracker) {
            this.currentSize += resource.getSize();
            if (resource.getRefCount() > 0) continue;
            this.resourceMap.put(resource, newTracker);
        }
    }

    public LocalCacheCleanerStats cleanCache() {
        LocalCacheCleanerStats stats = new LocalCacheCleanerStats(this.currentSize);
        Iterator<Map.Entry<LocalizedResource, LocalResourcesTracker>> i = this.resourceMap.entrySet().iterator();
        while (this.currentSize - stats.totalDelSize > this.targetSize && i.hasNext()) {
            Map.Entry<LocalizedResource, LocalResourcesTracker> rsrc = i.next();
            LocalizedResource resource = rsrc.getKey();
            LocalResourcesTracker tracker = rsrc.getValue();
            if (!tracker.remove(resource, this.delService)) continue;
            stats.incDelSize(tracker.getUser(), resource.getSize());
        }
        this.resourceMap.clear();
        return stats;
    }

    private static class LRUComparator
    implements Comparator<LocalizedResource>,
    Serializable {
        private static final long serialVersionUID = 7034380228434701685L;

        private LRUComparator() {
        }

        @Override
        public int compare(LocalizedResource r1, LocalizedResource r2) {
            long ret = r1.getTimestamp() - r2.getTimestamp();
            if (0L == ret) {
                return System.identityHashCode(r1) - System.identityHashCode(r2);
            }
            return ret > 0L ? 1 : -1;
        }
    }

    static class LocalCacheCleanerStats {
        private final Map<String, Long> userDelSizes = new TreeMap<String, Long>();
        private final long cacheSizeBeforeClean;
        private long totalDelSize;
        private long publicDelSize;
        private long privateDelSize;

        LocalCacheCleanerStats(long cacheSizeBeforeClean) {
            this.cacheSizeBeforeClean = cacheSizeBeforeClean;
        }

        void incDelSize(String user, long delSize) {
            this.totalDelSize += delSize;
            if (user == null) {
                this.publicDelSize += delSize;
            } else {
                this.privateDelSize += delSize;
                Long userDel = this.userDelSizes.get(user);
                if (userDel != null) {
                    userDel = userDel + delSize;
                    this.userDelSizes.put(user, userDel);
                } else {
                    this.userDelSizes.put(user, delSize);
                }
            }
        }

        Map<String, Long> getUserDelSizes() {
            return Collections.unmodifiableMap(this.userDelSizes);
        }

        long getCacheSizeBeforeClean() {
            return this.cacheSizeBeforeClean;
        }

        long getTotalDelSize() {
            return this.totalDelSize;
        }

        long getPublicDelSize() {
            return this.publicDelSize;
        }

        long getPrivateDelSize() {
            return this.privateDelSize;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Cache Size Before Clean: ").append(this.cacheSizeBeforeClean).append(", ");
            sb.append("Total Deleted: ").append(this.totalDelSize).append(", ");
            sb.append("Public Deleted: ").append(this.publicDelSize).append(", ");
            sb.append("Private Deleted: ").append(this.privateDelSize);
            return sb.toString();
        }

        public String toStringDetailed() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString());
            sb.append(", Private Deleted Detail: {");
            for (Map.Entry<String, Long> e : this.userDelSizes.entrySet()) {
                sb.append(" ").append(e.getKey()).append(":").append(e.getValue());
            }
            sb.append(" }");
            return sb.toString();
        }
    }
}

