/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestBufferedMutator2 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBufferedMutator2.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"example-table");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");
    private static byte[] VALUE = new byte[1024];
    private static Connection CONN;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, CF);
        CONN = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        Bytes.random((byte[])VALUE);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CONN.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMaxMutationsFlush() throws IOException {
        BufferedMutator mutator = CONN.getBufferedMutator(new BufferedMutatorParams(TABLE_NAME).setMaxMutations(3));
        mutator.mutate((Mutation)new Put(Bytes.toBytes((int)0)).addColumn(CF, CQ, VALUE));
        mutator.mutate((Mutation)new Put(Bytes.toBytes((int)1)).addColumn(CF, CQ, VALUE));
        mutator.mutate((Mutation)new Put(Bytes.toBytes((int)2)).addColumn(CF, CQ, VALUE));
        Table table = CONN.getTable(TABLE_NAME);
        Assert.assertArrayEquals((byte[])VALUE, (byte[])table.get(new Get(Bytes.toBytes((int)0))).getValue(CF, CQ));
        Assert.assertArrayEquals((byte[])VALUE, (byte[])table.get(new Get(Bytes.toBytes((int)1))).getValue(CF, CQ));
        Assert.assertArrayEquals((byte[])VALUE, (byte[])table.get(new Get(Bytes.toBytes((int)2))).getValue(CF, CQ));
    }
}

