/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestBulkLoadReplicationHFileRefs
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBulkLoadReplicationHFileRefs.class);
    private static final String PEER1_CLUSTER_ID = "peer1";
    private static final String PEER2_CLUSTER_ID = "peer2";
    private static final String REPLICATE_NAMESPACE = "replicate_ns";
    private static final String NO_REPLICATE_NAMESPACE = "no_replicate_ns";
    private static final TableName REPLICATE_TABLE = TableName.valueOf((String)"replicate_ns", (String)"replicate_table");
    private static final TableName NO_REPLICATE_TABLE = TableName.valueOf((String)"no_replicate_ns", (String)"no_replicate_table");
    private static final byte[] CF_A = Bytes.toBytes((String)"cfa");
    private static final byte[] CF_B = Bytes.toBytes((String)"cfb");
    private byte[] row = Bytes.toBytes((String)"r1");
    private byte[] qualifier = Bytes.toBytes((String)"q1");
    private byte[] value = Bytes.toBytes((String)"v1");
    @ClassRule
    public static TemporaryFolder testFolder = new TemporaryFolder();
    private static final Path BULK_LOAD_BASE_DIR = new Path("/bulk_dir");
    private static Admin admin1;
    private static Admin admin2;
    private static ReplicationQueueStorage queueStorage;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestBulkLoadReplicationHFileRefs.setupBulkLoadConfigsForCluster(CONF1, PEER1_CLUSTER_ID);
        TestBulkLoadReplicationHFileRefs.setupBulkLoadConfigsForCluster(CONF2, PEER2_CLUSTER_ID);
        TestReplicationBase.setUpBeforeClass();
        admin1 = UTIL1.getConnection().getAdmin();
        admin2 = UTIL2.getConnection().getAdmin();
        queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)UTIL1.getZooKeeperWatcher(), (Configuration)UTIL1.getConfiguration());
        admin1.createNamespace(NamespaceDescriptor.create((String)REPLICATE_NAMESPACE).build());
        admin2.createNamespace(NamespaceDescriptor.create((String)REPLICATE_NAMESPACE).build());
        admin1.createNamespace(NamespaceDescriptor.create((String)NO_REPLICATE_NAMESPACE).build());
        admin2.createNamespace(NamespaceDescriptor.create((String)NO_REPLICATE_NAMESPACE).build());
    }

    protected static void setupBulkLoadConfigsForCluster(Configuration config, String clusterReplicationId) throws Exception {
        config.setBoolean("hbase.replication.bulkload.enabled", true);
        config.set("hbase.replication.cluster.id", clusterReplicationId);
        File sourceConfigFolder = testFolder.newFolder(clusterReplicationId);
        File sourceConfigFile = new File(sourceConfigFolder.getAbsolutePath() + "/hbase-site.xml");
        config.writeXml((OutputStream)new FileOutputStream(sourceConfigFile));
        config.set("hbase.replication.conf.dir", testFolder.getRoot().getAbsolutePath());
    }

    @Before
    public void setUp() throws Exception {
        for (ReplicationPeerDescription peer : admin1.listReplicationPeers()) {
            admin1.removeReplicationPeer(peer.getPeerId());
        }
    }

    @After
    public void teardown() throws Exception {
        for (ReplicationPeerDescription peer : admin1.listReplicationPeers()) {
            admin1.removeReplicationPeer(peer.getPeerId());
        }
        for (TableName tableName : admin1.listTableNames()) {
            UTIL1.deleteTable(tableName);
        }
        for (TableName tableName : admin2.listTableNames()) {
            UTIL2.deleteTable(tableName);
        }
    }

    @Test
    public void testWhenExcludeCF() throws Exception {
        this.createTableOnClusters(REPLICATE_TABLE, CF_A, CF_B);
        HashMap excludeTableCFs = Maps.newHashMap();
        excludeTableCFs.put(REPLICATE_TABLE, Lists.newArrayList((Object[])new String[]{Bytes.toString((byte[])CF_B)}));
        ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL2.getClusterKey()).setReplicateAllUserTables(true).setExcludeTableCFsMap((Map)excludeTableCFs).build();
        admin1.addReplicationPeer("2", peerConfig);
        Assert.assertTrue((boolean)peerConfig.needToReplicate(REPLICATE_TABLE));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(REPLICATE_TABLE, CF_A));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(REPLICATE_TABLE, CF_B));
        Assert.assertEquals((long)0L, (long)queueStorage.getAllHFileRefs().size());
        this.bulkLoadOnCluster(REPLICATE_TABLE, CF_B);
        Threads.sleep((long)1000L);
        Table table2 = UTIL2.getConnection().getTable(REPLICATE_TABLE);
        Result result = table2.get(new Get(this.row));
        Assert.assertTrue((boolean)Bytes.equals(null, (byte[])result.getValue(CF_B, this.qualifier)));
        Assert.assertEquals((long)0L, (long)queueStorage.getAllHFileRefs().size());
    }

    @Test
    public void testWhenExcludeTable() throws Exception {
        this.createTableOnClusters(REPLICATE_TABLE, new byte[][]{CF_A});
        this.createTableOnClusters(NO_REPLICATE_TABLE, new byte[][]{CF_A});
        HashMap excludeTableCFs = Maps.newHashMap();
        excludeTableCFs.put(NO_REPLICATE_TABLE, null);
        ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL2.getClusterKey()).setReplicateAllUserTables(true).setExcludeTableCFsMap((Map)excludeTableCFs).build();
        admin1.addReplicationPeer("2", peerConfig);
        Assert.assertTrue((boolean)peerConfig.needToReplicate(REPLICATE_TABLE));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(NO_REPLICATE_TABLE));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(REPLICATE_TABLE, CF_A));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(NO_REPLICATE_TABLE, CF_A));
        Assert.assertEquals((long)0L, (long)queueStorage.getAllHFileRefs().size());
        this.bulkLoadOnCluster(NO_REPLICATE_TABLE, CF_A);
        Threads.sleep((long)1000L);
        Table table2 = UTIL2.getConnection().getTable(NO_REPLICATE_TABLE);
        Result result = table2.get(new Get(this.row));
        Assert.assertTrue((boolean)Bytes.equals(null, (byte[])result.getValue(CF_A, this.qualifier)));
        Assert.assertEquals((long)0L, (long)queueStorage.getAllHFileRefs().size());
    }

    @Test
    public void testWhenExcludeNamespace() throws Exception {
        this.createTableOnClusters(REPLICATE_TABLE, new byte[][]{CF_A});
        this.createTableOnClusters(NO_REPLICATE_TABLE, new byte[][]{CF_A});
        ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL2.getClusterKey()).setReplicateAllUserTables(true).setExcludeNamespaces((Set)Sets.newHashSet((Object[])new String[]{NO_REPLICATE_NAMESPACE})).build();
        admin1.addReplicationPeer("2", peerConfig);
        Assert.assertTrue((boolean)peerConfig.needToReplicate(REPLICATE_TABLE));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(NO_REPLICATE_TABLE));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(REPLICATE_TABLE, CF_A));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(NO_REPLICATE_TABLE, CF_A));
        Assert.assertEquals((long)0L, (long)queueStorage.getAllHFileRefs().size());
        byte[] row = Bytes.toBytes((String)"001");
        byte[] value = Bytes.toBytes((String)"v1");
        this.bulkLoadOnCluster(NO_REPLICATE_TABLE, CF_A);
        Threads.sleep((long)1000L);
        Table table2 = UTIL2.getConnection().getTable(NO_REPLICATE_TABLE);
        Result result = table2.get(new Get(row));
        Assert.assertTrue((boolean)Bytes.equals(null, (byte[])result.getValue(CF_A, this.qualifier)));
        Assert.assertEquals((long)0L, (long)queueStorage.getAllHFileRefs().size());
    }

    protected void bulkLoadOnCluster(TableName tableName, byte[] family) throws Exception {
        String bulkLoadFilePath = this.createHFileForFamilies(family);
        this.copyToHdfs(family, bulkLoadFilePath, UTIL1.getDFSCluster());
        BulkLoadHFilesTool bulkLoadHFilesTool = new BulkLoadHFilesTool(UTIL1.getConfiguration());
        bulkLoadHFilesTool.bulkLoad(tableName, BULK_LOAD_BASE_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createHFileForFamilies(byte[] family) throws IOException {
        CellBuilder cellBuilder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY);
        cellBuilder.setRow(this.row).setFamily(family).setQualifier(this.qualifier).setValue(this.value).setType(Cell.Type.Put);
        HFile.WriterFactory hFileFactory = HFile.getWriterFactoryNoCache((Configuration)UTIL1.getConfiguration());
        File hFileLocation = testFolder.newFile();
        try (FSDataOutputStream out = new FSDataOutputStream((OutputStream)new FileOutputStream(hFileLocation), null);){
            hFileFactory.withOutputStream(out);
            hFileFactory.withFileContext(new HFileContextBuilder().build());
            try (HFile.Writer writer = hFileFactory.create();){
                writer.append((Cell)new KeyValue(cellBuilder.build()));
            }
        }
        return hFileLocation.getAbsoluteFile().getAbsolutePath();
    }

    private void copyToHdfs(byte[] family, String bulkLoadFilePath, MiniDFSCluster cluster) throws Exception {
        Path bulkLoadDir = new Path(BULK_LOAD_BASE_DIR, Bytes.toString((byte[])family));
        cluster.getFileSystem().mkdirs(bulkLoadDir);
        cluster.getFileSystem().copyFromLocalFile(new Path(bulkLoadFilePath), bulkLoadDir);
    }

    private void createTableOnClusters(TableName tableName, byte[] ... cfs) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] cf : cfs) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])cf).setScope(1).build());
        }
        TableDescriptor td = builder.build();
        admin1.createTable(td);
        admin2.createTable(td);
    }
}

