/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.ArrayList;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.mapreduce.WALInputFormat;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MapReduceTests.class, SmallTests.class})
public class TestWALInputFormat {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALInputFormat.class);

    @Test
    public void testAddFile() {
        ArrayList lfss = new ArrayList();
        LocatedFileStatus lfs = (LocatedFileStatus)Mockito.mock(LocatedFileStatus.class);
        long now = EnvironmentEdgeManager.currentTime();
        Mockito.when((Object)lfs.getPath()).thenReturn((Object)new Path("/name." + now));
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)now, (long)now);
        Assert.assertEquals((long)1L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)(now - 1L), (long)(now - 1L));
        Assert.assertEquals((long)1L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)(now - 2L), (long)(now - 1L));
        Assert.assertEquals((long)1L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)(now - 2L), (long)now);
        Assert.assertEquals((long)2L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)Long.MIN_VALUE, (long)now);
        Assert.assertEquals((long)3L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
        Assert.assertEquals((long)4L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)now, (long)(now + 2L));
        Assert.assertEquals((long)5L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)(now + 1L), (long)(now + 2L));
        Assert.assertEquals((long)5L, (long)lfss.size());
        Mockito.when((Object)lfs.getPath()).thenReturn((Object)new Path("/name"));
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
        Assert.assertEquals((long)6L, (long)lfss.size());
        Mockito.when((Object)lfs.getPath()).thenReturn((Object)new Path("/name.123"));
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
        Assert.assertEquals((long)7L, (long)lfss.size());
        Mockito.when((Object)lfs.getPath()).thenReturn((Object)new Path("/name." + now + ".meta"));
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)now, (long)now);
        Assert.assertEquals((long)8L, (long)lfss.size());
    }
}

