/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Job {
    private static final Logger log = LoggerFactory.getLogger(Job.class);
    private long id;
    private long tenantId = 0L;
    private long monitorId;
    private Map<String, String> metadata;
    private Map<String, String> labels;
    private Map<String, String> annotations;
    private boolean hide = true;
    private String category;
    private String app;
    private Map<String, String> name;
    private Map<String, String> help;
    private Map<String, String> helpLink;
    private long timestamp;
    private long defaultInterval = 600L;
    private ConcurrentLinkedDeque<Long> intervals;
    private boolean isCyclic = false;
    private List<ParamDefine> params;
    private List<Metrics> metrics;
    private List<Configmap> configmap;
    private boolean isSd = false;
    private boolean prometheusProxyMode = false;
    private String scheduleType = "interval";
    private String cronExpression = null;
    @JsonIgnore
    private Map<String, Configmap> envConfigmaps;
    @JsonIgnore
    private transient long dispatchTime;
    @JsonIgnore
    private transient LinkedList<Set<Metrics>> priorMetrics;
    @JsonIgnore
    private transient List<CollectRep.MetricsData> responseDataTemp;

    public synchronized void constructPriorMetrics() {
        long now = System.currentTimeMillis();
        Map<Byte, List<Metrics>> currentCollectMetrics = this.metrics.stream().filter(metrics -> now >= metrics.getCollectTime() + metrics.getInterval() * 1000L).peek(metric -> {
            metric.setCollectTime(now);
            if ((metric.getAliasFields() == null || metric.getAliasFields().isEmpty()) && metric.getFields() != null) {
                metric.setAliasFields(metric.getFields().stream().map(Metrics.Field::getField).collect(Collectors.toList()));
            }
            if (metric.getPriority() == null) {
                metric.setPriority((byte)127);
            }
        }).collect(Collectors.groupingBy(Metrics::getPriority));
        if (currentCollectMetrics.isEmpty()) {
            Optional<Metrics> defaultMetricOption = this.metrics.stream().filter(metric -> metric.getPriority() == 0).findFirst();
            if (defaultMetricOption.isPresent()) {
                Metrics defaultMetric = defaultMetricOption.get();
                defaultMetric.setCollectTime(now);
                currentCollectMetrics.put((byte)0, Collections.singletonList(defaultMetric));
            } else {
                log.error("metrics must has one priority 0 metrics at least.");
            }
        }
        this.priorMetrics = new LinkedList();
        currentCollectMetrics.values().forEach(metric -> {
            Set metricsSet = Collections.synchronizedSet(new HashSet(metric));
            this.priorMetrics.add(metricsSet);
        });
        this.priorMetrics.sort(Comparator.comparing(e -> {
            Optional metric = e.stream().findAny();
            if (metric.isPresent()) {
                return ((Metrics)metric.get()).getPriority();
            }
            return (byte)127;
        }));
        this.envConfigmaps = new HashMap<String, Configmap>(8);
    }

    public synchronized Set<Metrics> getNextCollectMetrics(Metrics metrics, boolean first) {
        if (this.priorMetrics == null || this.priorMetrics.isEmpty()) {
            return null;
        }
        Set<Metrics> metricsSet = this.priorMetrics.peek();
        if (first) {
            if (metricsSet.isEmpty()) {
                log.error("metrics must has one [availability] metrics at least.");
            }
            return metricsSet;
        }
        if (metrics == null) {
            log.error("metrics can not null when not first get");
            return null;
        }
        if (!metricsSet.remove(metrics)) {
            log.warn("Job {} appId {} app {} metrics {} remove empty error in priorMetrics.", new Object[]{this.id, this.monitorId, this.app, metrics.getName()});
        }
        if (metricsSet.isEmpty()) {
            this.priorMetrics.poll();
            if (this.priorMetrics.isEmpty()) {
                return null;
            }
            Set<Metrics> source = this.priorMetrics.peek();
            return new HashSet<Metrics>(source);
        }
        return Collections.emptySet();
    }

    public void addCollectMetricsData(CollectRep.MetricsData metricsData) {
        if (this.responseDataTemp == null) {
            this.responseDataTemp = new LinkedList<CollectRep.MetricsData>();
        }
        this.responseDataTemp.add(metricsData);
    }

    public Map<String, Configmap> getEnvConfigmaps() {
        return this.envConfigmaps;
    }

    public void addEnvConfigmaps(Map<String, Configmap> envConfigmaps) {
        if (this.envConfigmaps == null) {
            this.envConfigmaps = envConfigmaps;
        } else {
            this.envConfigmaps.putAll(envConfigmaps);
        }
    }

    public Job clone() {
        return (Job)JsonUtil.fromJson(JsonUtil.toJson(this), this.getClass());
    }

    public void initIntervals() {
        LinkedList<Long> metricsIntervals = new LinkedList<Long>();
        for (Metrics metrics : this.getMetrics()) {
            metrics.setCollectTime(0L);
            if (metrics.getInterval() <= 0L) {
                metrics.setInterval(this.defaultInterval);
            }
            if (metricsIntervals.contains(metrics.getInterval())) continue;
            metricsIntervals.add(metrics.getInterval());
        }
        this.generateMetricsIntervals(metricsIntervals);
    }

    public static long gcd(long a, long b) {
        while (b != 0L) {
            long temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    public static long lcm(List<Long> array) {
        if (array != null && !array.isEmpty()) {
            long result = array.get(0);
            for (int i = 1; i < array.size(); ++i) {
                result = result / Job.gcd(result, array.get(i)) * array.get(i);
            }
            return result;
        }
        return 0L;
    }

    public synchronized void generateMetricsIntervals(List<Long> metricsIntervals) {
        long lcm = Job.lcm(metricsIntervals);
        LinkedList<Long> refreshTimes = new LinkedList<Long>();
        Iterator<Long> iterator = metricsIntervals.iterator();
        while (iterator.hasNext()) {
            long interval;
            for (long t = interval = iterator.next().longValue(); t <= lcm; t += interval) {
                if (refreshTimes.contains(t)) continue;
                refreshTimes.add(t);
            }
        }
        Collections.sort(refreshTimes);
        LinkedList<Long> intervals = new LinkedList<Long>();
        intervals.add((Long)refreshTimes.get(0));
        for (int i = 1; i < refreshTimes.size(); ++i) {
            intervals.add((Long)refreshTimes.get(i) - (Long)refreshTimes.get(i - 1));
        }
        this.setIntervals(new ConcurrentLinkedDeque<Long>(intervals));
    }

    public synchronized long getInterval() {
        Long interval;
        if (!CollectionUtils.isEmpty(this.intervals) && (interval = this.intervals.removeFirst()) != null) {
            this.intervals.addLast(interval);
            return interval;
        }
        return this.getDefaultInterval();
    }

    public static JobBuilder builder() {
        return new JobBuilder();
    }

    public long getId() {
        return this.id;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public long getMonitorId() {
        return this.monitorId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public boolean isHide() {
        return this.hide;
    }

    public String getCategory() {
        return this.category;
    }

    public String getApp() {
        return this.app;
    }

    public Map<String, String> getName() {
        return this.name;
    }

    public Map<String, String> getHelp() {
        return this.help;
    }

    public Map<String, String> getHelpLink() {
        return this.helpLink;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getDefaultInterval() {
        return this.defaultInterval;
    }

    public ConcurrentLinkedDeque<Long> getIntervals() {
        return this.intervals;
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public List<ParamDefine> getParams() {
        return this.params;
    }

    public List<Metrics> getMetrics() {
        return this.metrics;
    }

    public List<Configmap> getConfigmap() {
        return this.configmap;
    }

    public boolean isSd() {
        return this.isSd;
    }

    public boolean isPrometheusProxyMode() {
        return this.prometheusProxyMode;
    }

    public String getScheduleType() {
        return this.scheduleType;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public long getDispatchTime() {
        return this.dispatchTime;
    }

    public LinkedList<Set<Metrics>> getPriorMetrics() {
        return this.priorMetrics;
    }

    public List<CollectRep.MetricsData> getResponseDataTemp() {
        return this.responseDataTemp;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public void setMonitorId(long monitorId) {
        this.monitorId = monitorId;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setName(Map<String, String> name) {
        this.name = name;
    }

    public void setHelp(Map<String, String> help) {
        this.help = help;
    }

    public void setHelpLink(Map<String, String> helpLink) {
        this.helpLink = helpLink;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setDefaultInterval(long defaultInterval) {
        this.defaultInterval = defaultInterval;
    }

    public void setIntervals(ConcurrentLinkedDeque<Long> intervals) {
        this.intervals = intervals;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
    }

    public void setParams(List<ParamDefine> params) {
        this.params = params;
    }

    public void setMetrics(List<Metrics> metrics) {
        this.metrics = metrics;
    }

    public void setConfigmap(List<Configmap> configmap) {
        this.configmap = configmap;
    }

    public void setSd(boolean isSd) {
        this.isSd = isSd;
    }

    public void setPrometheusProxyMode(boolean prometheusProxyMode) {
        this.prometheusProxyMode = prometheusProxyMode;
    }

    public void setScheduleType(String scheduleType) {
        this.scheduleType = scheduleType;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @JsonIgnore
    public void setEnvConfigmaps(Map<String, Configmap> envConfigmaps) {
        this.envConfigmaps = envConfigmaps;
    }

    @JsonIgnore
    public void setDispatchTime(long dispatchTime) {
        this.dispatchTime = dispatchTime;
    }

    @JsonIgnore
    public void setPriorMetrics(LinkedList<Set<Metrics>> priorMetrics) {
        this.priorMetrics = priorMetrics;
    }

    @JsonIgnore
    public void setResponseDataTemp(List<CollectRep.MetricsData> responseDataTemp) {
        this.responseDataTemp = responseDataTemp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job other = (Job)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getTenantId() != other.getTenantId()) {
            return false;
        }
        if (this.getMonitorId() != other.getMonitorId()) {
            return false;
        }
        if (this.isHide() != other.isHide()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getDefaultInterval() != other.getDefaultInterval()) {
            return false;
        }
        if (this.isCyclic() != other.isCyclic()) {
            return false;
        }
        if (this.isSd() != other.isSd()) {
            return false;
        }
        if (this.isPrometheusProxyMode() != other.isPrometheusProxyMode()) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        Map<String, String> this$name = this.getName();
        Map<String, String> other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Map<String, String> this$help = this.getHelp();
        Map<String, String> other$help = other.getHelp();
        if (this$help == null ? other$help != null : !((Object)this$help).equals(other$help)) {
            return false;
        }
        Map<String, String> this$helpLink = this.getHelpLink();
        Map<String, String> other$helpLink = other.getHelpLink();
        if (this$helpLink == null ? other$helpLink != null : !((Object)this$helpLink).equals(other$helpLink)) {
            return false;
        }
        ConcurrentLinkedDeque<Long> this$intervals = this.getIntervals();
        ConcurrentLinkedDeque<Long> other$intervals = other.getIntervals();
        if (this$intervals == null ? other$intervals != null : !this$intervals.equals(other$intervals)) {
            return false;
        }
        List<ParamDefine> this$params = this.getParams();
        List<ParamDefine> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        List<Metrics> this$metrics = this.getMetrics();
        List<Metrics> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        List<Configmap> this$configmap = this.getConfigmap();
        List<Configmap> other$configmap = other.getConfigmap();
        if (this$configmap == null ? other$configmap != null : !((Object)this$configmap).equals(other$configmap)) {
            return false;
        }
        String this$scheduleType = this.getScheduleType();
        String other$scheduleType = other.getScheduleType();
        if (this$scheduleType == null ? other$scheduleType != null : !this$scheduleType.equals(other$scheduleType)) {
            return false;
        }
        String this$cronExpression = this.getCronExpression();
        String other$cronExpression = other.getCronExpression();
        if (this$cronExpression == null ? other$cronExpression != null : !this$cronExpression.equals(other$cronExpression)) {
            return false;
        }
        Map<String, Configmap> this$envConfigmaps = this.getEnvConfigmaps();
        Map<String, Configmap> other$envConfigmaps = other.getEnvConfigmaps();
        return !(this$envConfigmaps == null ? other$envConfigmaps != null : !((Object)this$envConfigmaps).equals(other$envConfigmaps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Job;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $tenantId = this.getTenantId();
        result = result * 59 + (int)($tenantId >>> 32 ^ $tenantId);
        long $monitorId = this.getMonitorId();
        result = result * 59 + (int)($monitorId >>> 32 ^ $monitorId);
        result = result * 59 + (this.isHide() ? 79 : 97);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $defaultInterval = this.getDefaultInterval();
        result = result * 59 + (int)($defaultInterval >>> 32 ^ $defaultInterval);
        result = result * 59 + (this.isCyclic() ? 79 : 97);
        result = result * 59 + (this.isSd() ? 79 : 97);
        result = result * 59 + (this.isPrometheusProxyMode() ? 79 : 97);
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        Map<String, String> $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Map<String, String> $help = this.getHelp();
        result = result * 59 + ($help == null ? 43 : ((Object)$help).hashCode());
        Map<String, String> $helpLink = this.getHelpLink();
        result = result * 59 + ($helpLink == null ? 43 : ((Object)$helpLink).hashCode());
        ConcurrentLinkedDeque<Long> $intervals = this.getIntervals();
        result = result * 59 + ($intervals == null ? 43 : $intervals.hashCode());
        List<ParamDefine> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        List<Metrics> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        List<Configmap> $configmap = this.getConfigmap();
        result = result * 59 + ($configmap == null ? 43 : ((Object)$configmap).hashCode());
        String $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : $scheduleType.hashCode());
        String $cronExpression = this.getCronExpression();
        result = result * 59 + ($cronExpression == null ? 43 : $cronExpression.hashCode());
        Map<String, Configmap> $envConfigmaps = this.getEnvConfigmaps();
        result = result * 59 + ($envConfigmaps == null ? 43 : ((Object)$envConfigmaps).hashCode());
        return result;
    }

    public String toString() {
        return "Job(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", monitorId=" + this.getMonitorId() + ", metadata=" + this.getMetadata() + ", labels=" + this.getLabels() + ", annotations=" + this.getAnnotations() + ", hide=" + this.isHide() + ", category=" + this.getCategory() + ", app=" + this.getApp() + ", name=" + this.getName() + ", help=" + this.getHelp() + ", helpLink=" + this.getHelpLink() + ", timestamp=" + this.getTimestamp() + ", defaultInterval=" + this.getDefaultInterval() + ", intervals=" + this.getIntervals() + ", isCyclic=" + this.isCyclic() + ", params=" + this.getParams() + ", metrics=" + this.getMetrics() + ", configmap=" + this.getConfigmap() + ", isSd=" + this.isSd() + ", prometheusProxyMode=" + this.isPrometheusProxyMode() + ", scheduleType=" + this.getScheduleType() + ", cronExpression=" + this.getCronExpression() + ", envConfigmaps=" + this.getEnvConfigmaps() + ", dispatchTime=" + this.getDispatchTime() + ", priorMetrics=" + this.getPriorMetrics() + ", responseDataTemp=" + this.getResponseDataTemp() + ")";
    }

    public Job(long id, long tenantId, long monitorId, Map<String, String> metadata, Map<String, String> labels, Map<String, String> annotations, boolean hide, String category, String app, Map<String, String> name, Map<String, String> help, Map<String, String> helpLink, long timestamp, long defaultInterval, ConcurrentLinkedDeque<Long> intervals, boolean isCyclic, List<ParamDefine> params, List<Metrics> metrics, List<Configmap> configmap, boolean isSd, boolean prometheusProxyMode, String scheduleType, String cronExpression, Map<String, Configmap> envConfigmaps, long dispatchTime, LinkedList<Set<Metrics>> priorMetrics, List<CollectRep.MetricsData> responseDataTemp) {
        this.id = id;
        this.tenantId = tenantId;
        this.monitorId = monitorId;
        this.metadata = metadata;
        this.labels = labels;
        this.annotations = annotations;
        this.hide = hide;
        this.category = category;
        this.app = app;
        this.name = name;
        this.help = help;
        this.helpLink = helpLink;
        this.timestamp = timestamp;
        this.defaultInterval = defaultInterval;
        this.intervals = intervals;
        this.isCyclic = isCyclic;
        this.params = params;
        this.metrics = metrics;
        this.configmap = configmap;
        this.isSd = isSd;
        this.prometheusProxyMode = prometheusProxyMode;
        this.scheduleType = scheduleType;
        this.cronExpression = cronExpression;
        this.envConfigmaps = envConfigmaps;
        this.dispatchTime = dispatchTime;
        this.priorMetrics = priorMetrics;
        this.responseDataTemp = responseDataTemp;
    }

    public Job() {
    }

    public static class JobBuilder {
        private long id;
        private long tenantId;
        private long monitorId;
        private Map<String, String> metadata;
        private Map<String, String> labels;
        private Map<String, String> annotations;
        private boolean hide;
        private String category;
        private String app;
        private Map<String, String> name;
        private Map<String, String> help;
        private Map<String, String> helpLink;
        private long timestamp;
        private long defaultInterval;
        private ConcurrentLinkedDeque<Long> intervals;
        private boolean isCyclic;
        private List<ParamDefine> params;
        private List<Metrics> metrics;
        private List<Configmap> configmap;
        private boolean isSd;
        private boolean prometheusProxyMode;
        private String scheduleType;
        private String cronExpression;
        private Map<String, Configmap> envConfigmaps;
        private long dispatchTime;
        private LinkedList<Set<Metrics>> priorMetrics;
        private List<CollectRep.MetricsData> responseDataTemp;

        JobBuilder() {
        }

        public JobBuilder id(long id) {
            this.id = id;
            return this;
        }

        public JobBuilder tenantId(long tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public JobBuilder monitorId(long monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public JobBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public JobBuilder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public JobBuilder annotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public JobBuilder hide(boolean hide) {
            this.hide = hide;
            return this;
        }

        public JobBuilder category(String category) {
            this.category = category;
            return this;
        }

        public JobBuilder app(String app) {
            this.app = app;
            return this;
        }

        public JobBuilder name(Map<String, String> name) {
            this.name = name;
            return this;
        }

        public JobBuilder help(Map<String, String> help) {
            this.help = help;
            return this;
        }

        public JobBuilder helpLink(Map<String, String> helpLink) {
            this.helpLink = helpLink;
            return this;
        }

        public JobBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public JobBuilder defaultInterval(long defaultInterval) {
            this.defaultInterval = defaultInterval;
            return this;
        }

        public JobBuilder intervals(ConcurrentLinkedDeque<Long> intervals) {
            this.intervals = intervals;
            return this;
        }

        public JobBuilder isCyclic(boolean isCyclic) {
            this.isCyclic = isCyclic;
            return this;
        }

        public JobBuilder params(List<ParamDefine> params) {
            this.params = params;
            return this;
        }

        public JobBuilder metrics(List<Metrics> metrics) {
            this.metrics = metrics;
            return this;
        }

        public JobBuilder configmap(List<Configmap> configmap) {
            this.configmap = configmap;
            return this;
        }

        public JobBuilder isSd(boolean isSd) {
            this.isSd = isSd;
            return this;
        }

        public JobBuilder prometheusProxyMode(boolean prometheusProxyMode) {
            this.prometheusProxyMode = prometheusProxyMode;
            return this;
        }

        public JobBuilder scheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        public JobBuilder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        @JsonIgnore
        public JobBuilder envConfigmaps(Map<String, Configmap> envConfigmaps) {
            this.envConfigmaps = envConfigmaps;
            return this;
        }

        @JsonIgnore
        public JobBuilder dispatchTime(long dispatchTime) {
            this.dispatchTime = dispatchTime;
            return this;
        }

        @JsonIgnore
        public JobBuilder priorMetrics(LinkedList<Set<Metrics>> priorMetrics) {
            this.priorMetrics = priorMetrics;
            return this;
        }

        @JsonIgnore
        public JobBuilder responseDataTemp(List<CollectRep.MetricsData> responseDataTemp) {
            this.responseDataTemp = responseDataTemp;
            return this;
        }

        public Job build() {
            return new Job(this.id, this.tenantId, this.monitorId, this.metadata, this.labels, this.annotations, this.hide, this.category, this.app, this.name, this.help, this.helpLink, this.timestamp, this.defaultInterval, this.intervals, this.isCyclic, this.params, this.metrics, this.configmap, this.isSd, this.prometheusProxyMode, this.scheduleType, this.cronExpression, this.envConfigmaps, this.dispatchTime, this.priorMetrics, this.responseDataTemp);
        }

        public String toString() {
            return "Job.JobBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", monitorId=" + this.monitorId + ", metadata=" + this.metadata + ", labels=" + this.labels + ", annotations=" + this.annotations + ", hide=" + this.hide + ", category=" + this.category + ", app=" + this.app + ", name=" + this.name + ", help=" + this.help + ", helpLink=" + this.helpLink + ", timestamp=" + this.timestamp + ", defaultInterval=" + this.defaultInterval + ", intervals=" + this.intervals + ", isCyclic=" + this.isCyclic + ", params=" + this.params + ", metrics=" + this.metrics + ", configmap=" + this.configmap + ", isSd=" + this.isSd + ", prometheusProxyMode=" + this.prometheusProxyMode + ", scheduleType=" + this.scheduleType + ", cronExpression=" + this.cronExpression + ", envConfigmaps=" + this.envConfigmaps + ", dispatchTime=" + this.dispatchTime + ", priorMetrics=" + this.priorMetrics + ", responseDataTemp=" + this.responseDataTemp + ")";
        }
    }
}

