/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.Telemetry;
import io.questdb.TelemetryConfigLogger;
import io.questdb.cairo.CairoEngine;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.tasks.AbstractTelemetryTask;
import java.io.Closeable;

public class TelemetryJob
extends SynchronizedJob
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TelemetryJob.class);
    private final ObjList<Telemetry<? extends AbstractTelemetryTask>> telemetries;
    private final TelemetryConfigLogger telemetryConfigLogger;

    public TelemetryJob(CairoEngine engine) throws SqlException {
        try {
            this.telemetries = engine.getTelemetries();
            this.telemetryConfigLogger = new TelemetryConfigLogger(engine);
            try (SqlCompiler compiler = engine.getSqlCompiler();){
                SqlExecutionContextImpl sqlExecutionContext = new SqlExecutionContextImpl(engine, 1){

                    @Override
                    public boolean shouldLogSql() {
                        return false;
                    }
                };
                sqlExecutionContext.with(engine.getConfiguration().getFactoryProvider().getSecurityContextFactory().getRootContext(), null, null);
                int n = this.telemetries.size();
                for (int i = 0; i < n; ++i) {
                    this.telemetries.getQuick(i).init(engine, compiler, sqlExecutionContext);
                }
                this.telemetryConfigLogger.init(engine, compiler, sqlExecutionContext);
            }
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void close() {
        int n = this.telemetries.size();
        for (int i = 0; i < n; ++i) {
            this.telemetries.getQuick(i).clear();
        }
        Misc.free(this.telemetryConfigLogger);
    }

    @Override
    public boolean runSerially() {
        int n = this.telemetries.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.telemetries.getQuick(i).consumeAll();
                continue;
            }
            catch (Throwable th) {
                LOG.error().$("failed to process ").$(this.telemetries.getQuick(i).getName()).$(" event").$(th).$();
            }
        }
        return false;
    }
}

