/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.Metrics;
import io.questdb.cairo.AlterTableContextException;
import io.questdb.cairo.AttachDetachStatus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoKeywords;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.ColumnTaskJob;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.ColumnVersionWriter;
import io.questdb.cairo.DatabaseCheckpointStatus;
import io.questdb.cairo.DdlListener;
import io.questdb.cairo.DedupColumnCommitAddresses;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.IndexBuilder;
import io.questdb.cairo.LifecycleManager;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.MetadataCacheWriter;
import io.questdb.cairo.O3Basket;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3MutableAtomicInteger;
import io.questdb.cairo.O3OpenColumnJob;
import io.questdb.cairo.O3PartitionJob;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.SymbolColumnIndexer;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.SymbolValueCountCollector;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.TableWriterSegmentCopyInfo;
import io.questdb.cairo.TableWriterSegmentFileCache;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxWriter;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.TxnScoreboardPool;
import io.questdb.cairo.UpdateOperator;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.file.BlockFileWriter;
import io.questdb.cairo.frm.Frame;
import io.questdb.cairo.frm.FrameAlgebra;
import io.questdb.cairo.frm.file.FrameFactory;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.vm.NullMapWriter;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMAT;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.cairo.vm.api.NullMemory;
import io.questdb.cairo.wal.MetadataService;
import io.questdb.cairo.wal.SymbolMapDiff;
import io.questdb.cairo.wal.SymbolMapDiffCursor;
import io.questdb.cairo.wal.SymbolMapDiffEntry;
import io.questdb.cairo.wal.TableWriterPressureControl;
import io.questdb.cairo.wal.WalTxnDetails;
import io.questdb.cairo.wal.WriterRowUtils;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.ConvertOperatorImpl;
import io.questdb.griffin.DropIndexOperator;
import io.questdb.griffin.PurgingOperator;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.UpdateOperatorImpl;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.griffin.engine.table.parquet.MappedMemoryPartitionDescriptor;
import io.questdb.griffin.engine.table.parquet.ParquetCompression;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;
import io.questdb.griffin.engine.table.parquet.PartitionEncoder;
import io.questdb.griffin.engine.table.parquet.RowGroupBuffers;
import io.questdb.griffin.engine.table.parquet.RowGroupStatBuffers;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.DirectIntList;
import io.questdb.std.DirectLongList;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.LongList;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.std.PagedDirectLongList;
import io.questdb.std.ReadOnlyObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Uuid;
import io.questdb.std.Vect;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import io.questdb.tasks.ColumnIndexerTask;
import io.questdb.tasks.ColumnTask;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import io.questdb.tasks.O3PartitionTask;
import io.questdb.tasks.TableWriterTask;
import java.io.Closeable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableWriter
implements TableWriterAPI,
MetadataService,
Closeable {
    public static final int O3_BLOCK_DATA = 2;
    public static final int O3_BLOCK_MERGE = 3;
    public static final int O3_BLOCK_NONE = -1;
    public static final int O3_BLOCK_O3 = 1;
    public static final int PARTITION_SINK_SIZE_LONGS = 8;
    public static final int PARTITION_SINK_COL_TOP_OFFSET = 64;
    public static final int TIMESTAMP_MERGE_ENTRY_BYTES = 16;
    private static final long IGNORE = -1L;
    private static final Log LOG = LogFactory.getLog(TableWriter.class);
    private static final int MAX_MID_SUB_PARTITION_COUNT = 1;
    private static final Runnable NOOP = () -> {};
    private static final Row NOOP_ROW = new NoOpRow();
    private static final int O3_ERRNO_FATAL = 0x7FFFFFFE;
    private static final int ROW_ACTION_NO_PARTITION = 1;
    private static final int ROW_ACTION_NO_TIMESTAMP = 2;
    private static final int ROW_ACTION_O3 = 3;
    private static final int ROW_ACTION_OPEN_PARTITION = 0;
    private static final int ROW_ACTION_SWITCH_PARTITION = 4;
    final ObjList<MemoryMA> columns;
    private final AlterOperation alterOp = new AlterOperation();
    private final LongConsumer appendTimestampSetter;
    private final DatabaseCheckpointStatus checkpointStatus;
    private final ColumnVersionWriter columnVersionWriter;
    private final MPSequence commandPubSeq;
    private final RingQueue<TableWriterTask> commandQueue;
    private final SCSequence commandSubSeq;
    private final CairoConfiguration configuration;
    private final long dataAppendPageSize;
    private final DdlListener ddlListener;
    private final MemoryMAR ddlMem;
    private final ObjList<ColumnIndexer> denseIndexers = new ObjList();
    private final ObjList<MapWriter> denseSymbolMapWriters;
    private final int detachedMkDirMode;
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final int fileOperationRetryCount;
    private final SOCountDownLatch indexLatch = new SOCountDownLatch();
    private final LongList indexSequences = new LongList();
    private final ObjList<ColumnIndexer> indexers;
    private final MessageBus messageBus;
    private final TableWriterMetadata metadata;
    private final Metrics metrics;
    private final boolean mixedIOFlag;
    private final int mkDirMode;
    private final ObjList<Runnable> nullSetters;
    private final ObjectPool<O3Basket> o3BasketPool = new ObjectPool<O3Basket>(O3Basket::new, 64);
    private final ObjectPool<O3MutableAtomicInteger> o3ColumnCounters = new ObjectPool<O3MutableAtomicInteger>(O3MutableAtomicInteger::new, 64);
    private final int o3ColumnMemorySize;
    private final ObjList<MemoryCR> o3ColumnOverrides;
    private final SOUnboundedCountDownLatch o3DoneLatch = new SOUnboundedCountDownLatch();
    private final AtomicInteger o3ErrorCount = new AtomicInteger();
    private final long[] o3LastTimestampSpreads;
    private final AtomicLong o3PartitionUpdRemaining = new AtomicLong();
    private final boolean o3QuickSortEnabled;
    private final Path other;
    private final MessageBus ownMessageBus;
    private final boolean parallelIndexerEnabled;
    private final DirectIntList parquetColumnIdsAndTypes;
    private final PartitionDecoder parquetDecoder = new PartitionDecoder();
    private final RowGroupStatBuffers parquetStatBuffers;
    private final int partitionBy;
    private final DateFormat partitionDirFmt;
    private final LongList partitionRemoveCandidates = new LongList();
    private final Path path;
    private final int pathRootSize;
    private final int pathSize;
    private final FragileCode RECOVER_FROM_META_RENAME_FAILURE = this::recoverFromMetaRenameFailure;
    private final AtomicLong physicallyWrittenRowsSinceLastCommit = new AtomicLong();
    private final Row row = new RowImpl();
    private final LongList rowValueIsNotNull = new LongList();
    private final TableWriterSegmentCopyInfo segmentCopyInfo = new TableWriterSegmentCopyInfo();
    private final TableWriterSegmentFileCache segmentFileCache;
    private final TxReader slaveTxReader;
    private final ObjList<MapWriter> symbolMapWriters;
    private final IntList symbolRewriteMap = new IntList();
    private final MemoryMARW todoMem = Vm.getCMARWInstance();
    private final TxWriter txWriter;
    private final TxnScoreboard txnScoreboard;
    private final Utf8StringSink utf8Sink = new Utf8StringSink();
    private final FindVisitor removePartitionDirsNotAttached = this::removePartitionDirsNotAttached;
    private final Uuid uuid = new Uuid();
    private final LowerCaseCharSequenceIntHashMap validationMap = new LowerCaseCharSequenceIntHashMap();
    private ObjList<? extends MemoryA> activeColumns;
    private ObjList<Runnable> activeNullSetters;
    private ColumnVersionReader attachColumnVersionReader;
    private IndexBuilder attachIndexBuilder;
    private long attachMaxTimestamp;
    private MemoryCMR attachMetaMem;
    private TableWriterMetadata attachMetadata;
    private long attachMinTimestamp;
    private TxReader attachTxReader;
    private long avgRecordSize;
    private boolean avoidIndexOnCommit = false;
    private BlockFileWriter blockFileWriter;
    private int columnCount;
    private long commitRowCount;
    private long committedMasterRef;
    private ConvertOperatorImpl convertOperatorImpl;
    private DedupColumnCommitAddresses dedupColumnCommitAddresses;
    private byte dedupMode = 0;
    private String designatedTimestampColumnName;
    private boolean distressed = false;
    private DropIndexOperator dropIndexOperator;
    private int indexCount;
    private int lastErrno;
    private boolean lastOpenPartitionIsReadOnly;
    private long lastOpenPartitionTs = Long.MIN_VALUE;
    private long lastOpenPartitionTxnName = -1L;
    private long lastPartitionTimestamp;
    private long lastWalCommitTimestampMicros;
    private LifecycleManager lifecycleManager;
    private long lockFd = -2L;
    private long masterRef = 0L;
    private boolean memColumnShifted;
    private int metaPrevIndex;
    private final FragileCode RECOVER_FROM_TODO_WRITE_FAILURE = this::recoverFromTodoWriteFailure;
    private int metaSwapIndex;
    private long minSplitPartitionTimestamp;
    private long noOpRowCount;
    private ReadOnlyObjList<? extends MemoryCR> o3Columns;
    private long o3CommitBatchTimestampMin = Long.MAX_VALUE;
    private long o3EffectiveLag = 0L;
    private boolean o3InError = false;
    private long o3MasterRef = -1L;
    private ObjList<MemoryCARW> o3MemColumns1;
    private ObjList<MemoryCARW> o3MemColumns2;
    private ObjList<Runnable> o3NullSetters1;
    private ObjList<Runnable> o3NullSetters2;
    private PagedDirectLongList o3PartitionUpdateSink;
    private long o3RowCount;
    private MemoryMAT o3TimestampMem;
    private MemoryARW o3TimestampMemCpy;
    private volatile boolean o3oomObserved;
    private long partitionTimestampHi;
    private boolean performRecovery;
    private boolean processingQueue;
    private PurgingOperator purgingOperator;
    private boolean removeDirOnCancelRow = true;
    private int rowAction = 0;
    private TableToken tableToken;
    private final ColumnTaskHandler cthAppendWalColumnToLastPartition = this::cthAppendWalColumnToLastPartition;
    private final ColumnTaskHandler cthO3SortColumnRef = this::cthO3SortColumn;
    private final ColumnTaskHandler cthMergeWalColumnWithLag = this::cthMergeWalColumnWithLag;
    private final ColumnTaskHandler cthO3MoveUncommittedRef = this::cthO3MoveUncommitted;
    private final ColumnTaskHandler cthO3ShiftColumnInLagToTopRef = this::cthO3ShiftColumnInLagToTop;
    private DirectLongList tempDirectMemList;
    private long tempMem16b = Unsafe.malloc(16L, 56);
    private LongConsumer timestampSetter;
    private long todoTxn;
    private final FragileCode RECOVER_FROM_SWAP_RENAME_FAILURE = this::recoverFromSwapRenameFailure;
    private final FragileCode RECOVER_FROM_COLUMN_OPEN_FAILURE = this::recoverOpenColumnFailure;
    private UpdateOperatorImpl updateOperatorImpl;
    private long walRowsProcessed;
    private WalTxnDetails walTxnDetails;
    private final ColumnTaskHandler cthMapSymbols = this::processWalCommitBlock_sortWalSegmentTimestamps_dispatchColumnSortTasks_mapSymbols;
    private final ColumnTaskHandler cthMergeWalColumnManySegments = this::processWalCommitBlock_sortWalSegmentTimestamps_dispatchColumnSortTasks_mergeShuffleWalColumnManySegments;

    public TableWriter(CairoConfiguration configuration, TableToken tableToken, MessageBus messageBus, MessageBus ownMessageBus, boolean lock, LifecycleManager lifecycleManager, CharSequence root, DdlListener ddlListener, DatabaseCheckpointStatus checkpointStatus, CairoEngine cairoEngine) {
        this(configuration, tableToken, messageBus, ownMessageBus, lock, lifecycleManager, root, ddlListener, checkpointStatus, cairoEngine, cairoEngine.getTxnScoreboardPool());
    }

    public TableWriter(CairoConfiguration configuration, TableToken tableToken, MessageBus messageBus, MessageBus ownMessageBus, boolean lock, LifecycleManager lifecycleManager, CharSequence root, DdlListener ddlListener, DatabaseCheckpointStatus checkpointStatus, CairoEngine cairoEngine, TxnScoreboardPool txnScoreboardPool) {
        LOG.info().$("open '").$safe(tableToken.getTableName()).$('\'').$();
        this.configuration = configuration;
        this.ddlListener = ddlListener;
        this.checkpointStatus = checkpointStatus;
        this.mixedIOFlag = configuration.isWriterMixedIOEnabled();
        this.metrics = configuration.getMetrics();
        this.ownMessageBus = ownMessageBus;
        this.messageBus = ownMessageBus != null ? ownMessageBus : messageBus;
        this.lifecycleManager = lifecycleManager;
        this.parallelIndexerEnabled = configuration.isParallelIndexingEnabled();
        this.ff = configuration.getFilesFacade();
        this.mkDirMode = configuration.getMkDirMode();
        this.detachedMkDirMode = configuration.getDetachedMkDirMode();
        this.fileOperationRetryCount = configuration.getFileOperationRetryCount();
        this.tableToken = tableToken;
        this.o3QuickSortEnabled = configuration.isO3QuickSortEnabled();
        this.engine = cairoEngine;
        this.lastWalCommitTimestampMicros = configuration.getMicrosecondClock().getTicks();
        try {
            this.path = new Path();
            this.path.of(root);
            this.pathRootSize = this.path.size();
            this.path.concat(tableToken);
            this.other = new Path();
            this.other.of(root).concat(tableToken);
            this.pathSize = this.path.size();
            if (lock) {
                this.lock();
            } else {
                this.lockFd = -1L;
            }
            int todo = this.readTodo();
            if (todo == 2) {
                this.repairMetaRename((int)this.todoMem.getLong(48L));
            }
            this.ddlMem = Vm.getCMARWInstance();
            this.metadata = new TableWriterMetadata(this.tableToken);
            TableWriter.openMetaFile(this.ff, this.path, this.pathSize, this.ddlMem, this.metadata);
            this.partitionBy = this.metadata.getPartitionBy();
            this.txWriter = new TxWriter(this.ff, configuration).ofRW(this.path.concat("_txn").$(), this.partitionBy);
            this.txnScoreboard = txnScoreboardPool.getTxnScoreboard(tableToken);
            this.path.trimTo(this.pathSize);
            this.columnVersionWriter = TableWriter.openColumnVersionFile(configuration, this.path, this.pathSize, this.partitionBy != 3);
            this.o3ColumnOverrides = this.metadata.isWalEnabled() ? new ObjList() : null;
            this.parquetStatBuffers = new RowGroupStatBuffers(56);
            this.parquetColumnIdsAndTypes = new DirectIntList(2L, 56);
            if (this.metadata.isWalEnabled()) {
                this.o3ColumnMemorySize = (int)Files.PAGE_SIZE;
                this.dataAppendPageSize = tableToken.isSystem() ? configuration.getSystemDataAppendPageSize() : configuration.getDataAppendPageSize();
            } else if (tableToken.isSystem()) {
                this.o3ColumnMemorySize = configuration.getSystemO3ColumnMemorySize();
                this.dataAppendPageSize = configuration.getSystemDataAppendPageSize();
            } else {
                this.o3ColumnMemorySize = configuration.getO3ColumnMemorySize();
                this.dataAppendPageSize = configuration.getDataAppendPageSize();
            }
            switch (todo) {
                case 1: {
                    this.repairTruncate();
                    break;
                }
                case -1: 
                case 2: {
                    break;
                }
                default: {
                    LOG.error().$("ignoring unknown *todo* [code=").$(todo).I$();
                }
            }
            this.columnCount = this.metadata.getColumnCount();
            if (this.metadata.getTimestampIndex() > -1) {
                this.designatedTimestampColumnName = this.metadata.getColumnName(this.metadata.getTimestampIndex());
            }
            this.rowValueIsNotNull.extendAndSet(this.columnCount, 0L);
            this.columns = new ObjList(this.columnCount * 2);
            this.o3MemColumns1 = new ObjList(this.columnCount * 2);
            this.o3MemColumns2 = new ObjList(this.columnCount * 2);
            this.o3Columns = this.o3MemColumns1;
            this.activeColumns = this.columns;
            this.symbolMapWriters = new ObjList(this.columnCount);
            this.indexers = new ObjList(this.columnCount);
            this.denseSymbolMapWriters = new ObjList(this.metadata.getSymbolMapCount());
            this.nullSetters = new ObjList(this.columnCount);
            this.o3NullSetters1 = new ObjList(this.columnCount);
            this.o3NullSetters2 = new ObjList(this.columnCount);
            this.activeNullSetters = this.nullSetters;
            if (PartitionBy.isPartitioned(this.partitionBy)) {
                this.partitionDirFmt = PartitionBy.getPartitionDirFormatMethod(this.partitionBy);
                this.partitionTimestampHi = this.txWriter.getLastPartitionTimestamp();
            } else {
                this.partitionDirFmt = null;
            }
            this.configureColumnMemory();
            this.configureTimestampSetter();
            this.appendTimestampSetter = this.timestampSetter;
            this.configureAppendPosition();
            this.purgeUnusedPartitions();
            this.minSplitPartitionTimestamp = this.findMinSplitPartitionTimestamp();
            this.clearTodoLog();
            this.slaveTxReader = new TxReader(this.ff);
            this.commandQueue = new RingQueue<TableWriterTask>(TableWriterTask::new, configuration.getWriterCommandQueueSlotSize(), configuration.getWriterCommandQueueCapacity(), 51);
            this.commandSubSeq = new SCSequence();
            this.commandPubSeq = new MPSequence(this.commandQueue.getCycle());
            this.commandPubSeq.then(this.commandSubSeq).then(this.commandPubSeq);
            this.o3LastTimestampSpreads = new long[configuration.getO3LagCalculationWindowsSize()];
            Arrays.fill(this.o3LastTimestampSpreads, 0L);
            this.segmentFileCache = this.metadata.isWalEnabled() ? new TableWriterSegmentFileCache(tableToken, configuration) : null;
        }
        catch (Throwable e) {
            this.doClose(false);
            throw e;
        }
    }

    public static void consumeColumnTasks0(RingQueue<ColumnTask> queue, int queuedCount, Sequence subSeq, SOUnboundedCountDownLatch o3DoneLatch) {
        while (!o3DoneLatch.done(queuedCount)) {
            long cursor = subSeq.next();
            if (cursor > -1L) {
                ColumnTaskJob.processColumnTask(queue.get(cursor), cursor, subSeq);
                continue;
            }
            Os.pause();
        }
    }

    public static int getPrimaryColumnIndex(int index) {
        return index * 2;
    }

    public static int getSecondaryColumnIndex(int index) {
        return TableWriter.getPrimaryColumnIndex(index) + 1;
    }

    public static long getTimestampIndexValue(long timestampIndexAddr, long indexRow) {
        return Unsafe.getUnsafe().getLong(timestampIndexAddr + indexRow * 16L);
    }

    public static void validateDesignatedTimestampBounds(long timestamp) {
        if (timestamp == Long.MIN_VALUE) {
            throw CairoException.nonCritical().put("designated timestamp column cannot be NULL");
        }
        if (timestamp < 0L) {
            throw CairoException.nonCritical().put("designated timestamp before 1970-01-01 is not allowed");
        }
        if (timestamp >= 253402300800000000L) {
            throw CairoException.nonCritical().put("designated timestamp beyond 9999-12-31 is not allowed");
        }
    }

    @Override
    public void addColumn(@NotNull CharSequence columnName, int columnType, SecurityContext securityContext) {
        this.addColumn(columnName, columnType, this.configuration.getDefaultSymbolCapacity(), this.configuration.getDefaultSymbolCacheFlag(), false, 0, false, false, securityContext);
    }

    @Override
    public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isDedupKey) {
        this.addColumn(columnName, columnType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, false, isDedupKey, null);
    }

    @Override
    public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential, boolean isDedupKey, SecurityContext securityContext) {
        assert (this.txWriter.getLagRowCount() == 0);
        assert (indexValueBlockCapacity == Numbers.ceilPow2(indexValueBlockCapacity)) : "power of 2 expected";
        assert (symbolCapacity == Numbers.ceilPow2(symbolCapacity)) : "power of 2 expected";
        this.checkDistressed();
        this.checkColumnName(columnName);
        if (this.metadata.getColumnIndexQuiet(columnName) != -1) {
            throw CairoException.duplicateColumn(columnName);
        }
        this.commit();
        long columnNameTxn = this.getTxn();
        LOG.info().$("adding column '").$safe(columnName).$('[').$(ColumnType.nameOf(columnType)).$("], columnName txn ").$(columnNameTxn).$(" to ").$substr(this.pathRootSize, this.path).$();
        this.addColumnToMeta(columnName, columnType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, isDedupKey, columnNameTxn, -1, this.metadata);
        int columnIndex = this.columnCount - 1;
        this.columnVersionWriter.upsertDefaultTxnName(columnIndex, columnNameTxn, this.txWriter.getLastPartitionTimestamp());
        if (this.txWriter.getTransientRowCount() > 0L || !PartitionBy.isPartitioned(this.partitionBy)) {
            try {
                this.openNewColumnFiles(columnName, columnType, isIndexed, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                this.runFragile(this.RECOVER_FROM_COLUMN_OPEN_FAILURE, e);
            }
        }
        this.clearTodoAndCommitMetaStructureVersion();
        try {
            if (!Os.isWindows()) {
                try {
                    this.ff.fsyncAndClose(TableUtils.openRO(this.ff, this.path.$(), LOG));
                }
                catch (CairoException e) {
                    LOG.error().$("could not fsync after column added, non-critical [path=").$(this.path).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                }
            }
            if (securityContext != null) {
                this.ddlListener.onColumnAdded(securityContext, this.tableToken, columnName);
            }
            try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
                metadataRW.hydrateTable(this.metadata);
            }
        }
        catch (CairoError err) {
            throw err;
        }
        catch (Throwable th) {
            this.throwDistressException(th);
        }
    }

    @Override
    public void addIndex(@NotNull CharSequence columnName, int indexValueBlockSize) {
        assert (indexValueBlockSize == Numbers.ceilPow2(indexValueBlockSize)) : "power of 2 expected";
        this.checkDistressed();
        int columnIndex = this.metadata.getColumnIndexQuiet(columnName);
        if (columnIndex == -1) {
            throw CairoException.invalidMetadataRecoverable("column does not exist", columnName);
        }
        TableColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        this.commit();
        if (columnMetadata.isSymbolIndexFlag()) {
            throw CairoException.invalidMetadataRecoverable("column is already indexed", columnName);
        }
        int existingType = columnMetadata.getColumnType();
        LOG.info().$("adding index to '").$safe(columnName).$("' [").$(ColumnType.nameOf(existingType)).$(", path=").$substr(this.pathRootSize, this.path).I$();
        if (!ColumnType.isSymbol(existingType)) {
            LOG.error().$("cannot create index for [column='").$safe(columnName).$(", type=").$(ColumnType.nameOf(existingType)).$(", path=").$substr(this.pathRootSize, this.path).I$();
            throw CairoException.invalidMetadataRecoverable("cannot create index, column type is not SYMBOL", columnName);
        }
        SymbolColumnIndexer indexer = new SymbolColumnIndexer(this.configuration);
        this.writeIndex(columnName, indexValueBlockSize, columnIndex, indexer);
        columnMetadata.setSymbolIndexFlag(true);
        columnMetadata.setIndexValueBlockCapacity(indexValueBlockSize);
        this.rewriteAndSwapMetadata(this.metadata);
        this.clearTodoAndCommitMeta();
        this.indexers.extendAndSet(columnIndex, indexer);
        this.populateDenseIndexerList();
        try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
            metadataRW.hydrateTable(this.metadata);
        }
        LOG.info().$("ADDED index to '").$safe(columnName).$('[').$(ColumnType.nameOf(existingType)).$("]' to ").$substr(this.pathRootSize, this.path).$();
    }

    public void addPhysicallyWrittenRows(long rows) {
        this.physicallyWrittenRowsSinceLastCommit.addAndGet(rows);
        this.metrics.tableWriterMetrics().addPhysicallyWrittenRows(rows);
    }

    public long apply(AbstractOperation operation, long seqTxn) {
        try {
            this.setSeqTxn(seqTxn);
            long txnBefore = this.getTxn();
            long rowsAffected = operation.apply(this, true);
            if (txnBefore == this.getTxn()) {
                this.txWriter.commit(this.denseSymbolMapWriters);
            }
            return rowsAffected;
        }
        catch (CairoException ex) {
            this.rollback();
            if (ex.isWALTolerable()) {
                this.commitSeqTxn(seqTxn);
                return 0L;
            }
            this.setSeqTxn(seqTxn - 1L);
            throw ex;
        }
        catch (Throwable th) {
            try {
                this.rollback();
            }
            catch (Throwable th2) {
                LOG.critical().$("could not rollback, table is distressed [table=").$safe(this.tableToken.getTableName()).$(", error=").$(th2).I$();
            }
            throw th;
        }
    }

    @Override
    public long apply(AlterOperation alterOp, boolean contextAllowsAnyStructureChanges) throws AlterTableContextException {
        return alterOp.apply(this, contextAllowsAnyStructureChanges);
    }

    @Override
    public long apply(UpdateOperation operation) {
        return operation.apply(this, true);
    }

    @Override
    public AttachDetachStatus attachPartition(long timestamp) {
        return this.attachPartition(timestamp, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttachDetachStatus attachPartition(long timestamp, long partitionSize) {
        boolean isParquet;
        boolean isSoftLink;
        assert (this.metadata.getTimestampIndex() > -1);
        if (this.txWriter.attachedPartitionsContains(timestamp)) {
            LOG.info().$("partition is already attached [path=").$substr(this.pathRootSize, this.path).I$();
            return AttachDetachStatus.ATTACH_ERR_PARTITION_EXISTS;
        }
        if (this.inTransaction()) {
            assert (!this.tableToken.isWal());
            LOG.info().$("committing open transaction before applying attach partition command [table=").$safe(this.tableToken.getTableName()).$(", partition=").$ts(timestamp).I$();
            this.commit();
            if (this.txWriter.attachedPartitionsContains(timestamp)) {
                LOG.info().$("partition is already attached [path=").$substr(this.pathRootSize, this.path).I$();
                return AttachDetachStatus.ATTACH_ERR_PARTITION_EXISTS;
            }
        }
        TableUtils.setPathForNativePartition(this.path.trimTo(this.pathSize), this.partitionBy, timestamp, this.getTxn());
        if (this.ff.exists(this.path.$())) {
            return AttachDetachStatus.ATTACH_ERR_DIR_EXISTS;
        }
        Path detachedPath = Path.PATH.get().of(this.configuration.getDbRoot()).concat(this.tableToken);
        TableUtils.setPathForNativePartition(detachedPath, this.partitionBy, timestamp, -1L);
        detachedPath.put(this.configuration.getAttachPartitionSuffix()).$();
        int detachedRootLen = detachedPath.size();
        boolean forceRenamePartitionDir = partitionSize < 0L;
        boolean checkPassed = false;
        long parquetSize = -1L;
        try {
            if (this.ff.exists(detachedPath.$())) {
                isSoftLink = this.ff.isSoftLink(detachedPath.$());
                isParquet = this.ff.exists(detachedPath.concat("data.parquet").$());
                if (isParquet) {
                    parquetSize = this.ff.length(detachedPath.$());
                }
                String timestampColName = this.metadata.getColumnMetadata(this.metadata.getTimestampIndex()).getColumnName();
                if (partitionSize > -1L) {
                    this.readPartitionMinMaxTimestamps(timestamp, detachedPath.trimTo(detachedRootLen), timestampColName, parquetSize, partitionSize);
                } else {
                    partitionSize = this.readPartitionSizeMinMaxTimestamps(timestamp, detachedPath.trimTo(detachedRootLen), timestampColName, parquetSize);
                }
                if (partitionSize < 1L) {
                    AttachDetachStatus attachDetachStatus = AttachDetachStatus.ATTACH_ERR_EMPTY_PARTITION;
                    return attachDetachStatus;
                }
                if (forceRenamePartitionDir && !this.attachPrepare(timestamp, partitionSize, detachedPath, detachedRootLen)) {
                    this.attachValidateMetadata(partitionSize, detachedPath.trimTo(detachedRootLen), timestamp);
                }
                if (forceRenamePartitionDir && this.configuration.attachPartitionCopy() && !isSoftLink) {
                    if (this.ff.copyRecursive(detachedPath.trimTo(detachedRootLen), this.path, this.configuration.getMkDirMode()) != 0) {
                        LOG.error().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(detachedPath).$(", to=").$(this.path).I$();
                        AttachDetachStatus attachDetachStatus = AttachDetachStatus.ATTACH_ERR_COPY;
                        return attachDetachStatus;
                    }
                    LOG.info().$("copied partition dir [from=").$(detachedPath).$(", to=").$(this.path).I$();
                } else {
                    if (this.ff.rename(detachedPath.trimTo(detachedRootLen).$(), this.path.$()) != 0) {
                        LOG.error().$("could not rename [errno=").$(this.ff.errno()).$(", from=").$(detachedPath).$(", to=").$(this.path).I$();
                        AttachDetachStatus attachDetachStatus = AttachDetachStatus.ATTACH_ERR_RENAME;
                        return attachDetachStatus;
                    }
                    LOG.info().$("renamed partition dir [from=").$(detachedPath).$(", to=").$(this.path).I$();
                }
            } else {
                LOG.info().$("attach partition command failed, partition to attach does not exist [path=").$(detachedPath).I$();
                AttachDetachStatus timestampColName = AttachDetachStatus.ATTACH_ERR_MISSING_PARTITION;
                return timestampColName;
            }
            checkPassed = true;
        }
        finally {
            this.path.trimTo(this.pathSize);
            if (!checkPassed) {
                this.columnVersionWriter.readUnsafe();
            }
        }
        try {
            if (!$assertionsDisabled) {
                if (timestamp > this.attachMinTimestamp) throw new AssertionError();
                if (this.attachMinTimestamp > this.attachMaxTimestamp) {
                    throw new AssertionError();
                }
            }
            long nextMinTimestamp = Math.min(this.attachMinTimestamp, this.txWriter.getMinTimestamp());
            long nextMaxTimestamp = Math.max(this.attachMaxTimestamp, this.txWriter.getMaxTimestamp());
            boolean appendPartitionAttached = this.size() == 0L || this.txWriter.getNextPartitionTimestamp(nextMaxTimestamp) > this.txWriter.getNextPartitionTimestamp(this.txWriter.getMaxTimestamp());
            this.txWriter.beginPartitionSizeUpdate();
            this.txWriter.updatePartitionSizeByTimestamp(timestamp, partitionSize, this.getTxn());
            this.txWriter.finishPartitionSizeUpdate(nextMinTimestamp, nextMaxTimestamp);
            if (isSoftLink) {
                this.txWriter.setPartitionReadOnlyByTimestamp(timestamp, true);
            }
            if (isParquet) {
                this.txWriter.setPartitionParquetFormat(timestamp, parquetSize, true);
            }
            this.txWriter.bumpTruncateVersion();
            this.columnVersionWriter.commit();
            this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
            this.txWriter.commit(this.denseSymbolMapWriters);
            LOG.info().$("partition attached [table=").$safe(this.tableToken.getTableName()).$(", partition=").$ts(timestamp).I$();
            if (!appendPartitionAttached) return AttachDetachStatus.OK;
            LOG.info().$("switch partition after partition attach [tableName=").$safe(this.tableToken.getTableName()).$(", partition=").$ts(timestamp).I$();
            this.freeColumns(true);
            this.configureAppendPosition();
            return AttachDetachStatus.OK;
        }
        catch (Throwable e) {
            LOG.critical().$("failed on attaching partition to the table and rolling back [tableName=").$safe(this.tableToken.getTableName()).$(", error=").$(e).I$();
            this.rollback();
            throw e;
        }
    }

    @Override
    public void changeCacheFlag(int columnIndex, boolean cache) {
        this.checkDistressed();
        this.commit();
        MapWriter symbolMapWriter = this.symbolMapWriters.getQuick(columnIndex);
        if (symbolMapWriter.isCached() != cache) {
            symbolMapWriter.updateCacheFlag(cache);
            TableColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
            columnMetadata.setSymbolCacheFlag(cache);
            this.writeMetadataToDisk();
        }
    }

    @Override
    public void changeColumnType(CharSequence name, int newType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential, SecurityContext securityContext) {
        int existingColIndex = this.metadata.getColumnIndexQuiet(name);
        if (existingColIndex < 0) {
            throw CairoException.nonCritical().put("cannot change column type, column does not exist [table=").put(this.tableToken.getTableName()).put(", column=").put(name).put(']');
        }
        CharSequence columnName = this.metadata.getColumnName(existingColIndex);
        if (existingColIndex == this.metadata.getTimestampIndex()) {
            throw CairoException.nonCritical().put("cannot change column type, column is the designated timestamp [table=").put(this.tableToken.getTableName()).put(", column=").put(columnName).put(']');
        }
        int existingType = this.metadata.getColumnType(existingColIndex);
        assert (existingType > 0);
        if (existingType == newType) {
            throw CairoException.nonCritical().put("cannot change column type, new type is the same as existing [table=").put(this.tableToken.getTableName()).put(", column=").put(columnName).put(']');
        }
        ConvertOperatorImpl convertOperator = this.getConvertOperator();
        try {
            this.commit();
            LOG.info().$("converting column [table=").$(this.tableToken).$(", column=").$safe(columnName).$(", from=").$(ColumnType.nameOf(existingType)).$(", to=").$(ColumnType.nameOf(newType)).I$();
            boolean isDedupKey = this.metadata.isDedupKey(existingColIndex);
            int columnIndex = this.columnCount;
            long columnNameTxn = this.getTxn();
            long firstPartitionTsm = this.columnVersionWriter.getColumnTopPartitionTimestamp(existingColIndex);
            this.columnVersionWriter.upsertDefaultTxnName(columnIndex, columnNameTxn, firstPartitionTsm);
            if (ColumnType.isSymbol(newType)) {
                this.createSymbolMapWriter(columnName, columnNameTxn, symbolCapacity, symbolCacheFlag);
            } else {
                this.symbolMapWriters.extendAndSet(this.columnCount, NullMapWriter.INSTANCE);
            }
            boolean existingIsIndexed = this.metadata.isColumnIndexed(existingColIndex) && existingType == 12;
            convertOperator.convertColumn((String)columnName, existingColIndex, existingType, existingIsIndexed, columnIndex, newType);
            this.metadata.removeColumn(existingColIndex);
            this.freeColumnMemory(existingColIndex);
            this.removeSymbolMapWriter(existingColIndex);
            this.addColumnToMeta(columnName, newType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, isDedupKey, columnNameTxn, existingColIndex, this.metadata);
            if (this.txWriter.getTransientRowCount() > 0L || !PartitionBy.isPartitioned(this.partitionBy)) {
                long partitionTimestamp = this.txWriter.getLastPartitionTimestamp();
                this.setStateForTimestamp(this.path, partitionTimestamp);
                this.openColumnFiles(columnName, columnNameTxn, columnIndex, this.path.size());
                this.setColumnAppendPosition(columnIndex, this.txWriter.getTransientRowCount(), false);
                this.path.trimTo(this.pathSize);
            }
            if (isIndexed) {
                SymbolColumnIndexer indexer = (SymbolColumnIndexer)this.indexers.get(columnIndex);
                this.writeIndex(columnName, indexValueBlockCapacity, columnIndex, indexer);
                this.indexers.extendAndSet(columnIndex, indexer);
                this.populateDenseIndexerList();
            }
            this.clearTodoAndCommitMetaStructureVersion();
        }
        catch (Throwable th) {
            LOG.critical().$("could not change column type [table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(columnName).$(", error=").$(th).I$();
            this.distressed = true;
            throw th;
        }
        finally {
            convertOperator.finishColumnConversion();
            this.path.trimTo(this.pathSize);
        }
        try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
            metadataRW.hydrateTable(this.metadata);
        }
    }

    @Override
    public void changeSymbolCapacity(CharSequence colName, int newSymbolCapacity, SecurityContext securityContext) {
        int columnIndex = this.metadata.getColumnIndexQuiet(colName);
        if (columnIndex < 0) {
            LOG.error().$("cannot change column type, column does not exist [table=").$(this.tableToken).$(", column=").$safe(colName).I$();
            return;
        }
        CharSequence columnName = this.metadata.getColumnName(columnIndex);
        int existingType = this.metadata.getColumnType(columnIndex);
        assert (existingType > 0);
        if (!ColumnType.isSymbol(existingType)) {
            LOG.error().$("cannot symbol capacity, column is not symbol [table=").$(this.tableToken).$(", column=").$safe(columnName).$(", columnType=").$(ColumnType.nameOf(existingType)).I$();
            return;
        }
        SymbolMapWriter oldSymbolWriter = (SymbolMapWriter)this.symbolMapWriters.getQuick(columnIndex);
        int oldCapacity = oldSymbolWriter.getSymbolCapacity();
        boolean symbolCacheFlag = this.metadata.getColumnMetadata(columnIndex).isSymbolCacheFlag();
        newSymbolCapacity = Numbers.ceilPow2(newSymbolCapacity);
        try {
            TableUtils.validateSymbolCapacity(0, newSymbolCapacity);
        }
        catch (SqlException e) {
            LOG.error().$("invalid symbol capacity to change to [table=").$(this.tableToken).$(", column=").$safe(columnName).$(", from=").$(oldCapacity).$(", to=").$(newSymbolCapacity).I$();
            throw CairoException.nonCritical().put("invalid symbol capacity [name=").put(columnName).put(", capacity=").put(newSymbolCapacity).put(']');
        }
        LOG.info().$("changing symbol capacity [table=").$(this.tableToken).$(", column=").$safe(columnName).$(", from=").$(oldCapacity).$(", to=").$(newSymbolCapacity).I$();
        if (oldCapacity == newSymbolCapacity) {
            return;
        }
        try {
            this.commit();
            long columnNameTxn = this.getTxn();
            this.metadata.updateColumnSymbolCapacity(columnIndex, newSymbolCapacity);
            this.rewriteAndSwapMetadata(this.metadata);
            try {
                this.clearTodoLog();
                this.hardLinkAndPurgeColumnFiles((String)columnName, columnIndex, this.metadata.isIndexed(columnIndex), columnName, 12, true);
                oldSymbolWriter.rebuildCapacity(this.configuration, this.path, columnName, columnNameTxn, newSymbolCapacity, symbolCacheFlag);
            }
            catch (CairoException e) {
                this.throwDistressException(e);
            }
            this.bumpMetadataVersion();
            this.finishColumnPurge();
            long transientRowCount = this.txWriter.getTransientRowCount();
            if (transientRowCount > 0L) {
                long partitionTimestamp = this.txWriter.getLastPartitionTimestamp();
                this.setStateForTimestamp(this.path, partitionTimestamp);
                int plen = this.path.size();
                this.openColumnFiles(columnName, columnNameTxn, columnIndex, this.path.size());
                this.setColumnAppendPosition(columnIndex, transientRowCount, false);
                this.path.trimTo(this.pathSize);
                if (this.metadata.isIndexed(columnIndex)) {
                    ColumnIndexer indexer = this.indexers.get(columnIndex);
                    long columnTop = this.columnVersionWriter.getColumnTopQuick(partitionTimestamp, columnIndex);
                    assert (indexer != null);
                    indexer.configureFollowerAndWriter(this.path.trimTo(plen), columnName, columnNameTxn, this.getPrimaryColumn(columnIndex), columnTop);
                }
            }
        }
        catch (Throwable th) {
            LOG.critical().$("could not change column type [table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(columnName).$(", error=").$(th).I$();
            this.distressed = true;
            throw th;
        }
        finally {
            this.partitionRemoveCandidates.clear();
            this.path.trimTo(this.pathSize);
        }
        try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
            metadataRW.hydrateTable(this.metadata);
        }
    }

    public boolean checkScoreboardHasReadersBeforeLastCommittedTxn() {
        if (this.checkpointStatus.partitionsLocked()) {
            return true;
        }
        return this.txnScoreboard.hasEarlierTxnLocks(this.txWriter.getTxn());
    }

    @Override
    public void close() {
        if (this.lifecycleManager.close() && this.isOpen()) {
            this.doClose(true);
        }
    }

    public void closeActivePartition(boolean truncate) {
        LOG.debug().$("closing last partition [table=").$safe(this.tableToken.getTableName()).I$();
        this.closeAppendMemoryTruncate(truncate);
        this.freeIndexers();
    }

    @Override
    public void commit() {
        this.commit(0L);
    }

    public void commitSeqTxn(long seqTxn) {
        this.txWriter.setSeqTxn(seqTxn);
        this.txWriter.commit(this.denseSymbolMapWriters);
    }

    public void commitSeqTxn() {
        if (this.txWriter.inTransaction()) {
            this.metrics.tableWriterMetrics().incrementCommits();
            this.syncColumns();
        }
        this.txWriter.commit(this.denseSymbolMapWriters);
    }

    public void commitWalInsertTransactions(Path walPath, long seqTxn, TableWriterPressureControl pressureControl) {
        boolean committed;
        long initialCommittedRowCount;
        block13: {
            if (this.hasO3() || this.columnVersionWriter.hasChanges()) {
                this.distressed = true;
                throw CairoException.critical(0).put("cannot process WAL while in transaction");
            }
            this.physicallyWrittenRowsSinceLastCommit.set(0L);
            this.txWriter.beginPartitionSizeUpdate();
            long commitToTimestamp = this.walTxnDetails.getCommitToTimestamp(seqTxn);
            int transactionBlock = this.calculateInsertTransactionBlock(seqTxn, pressureControl);
            initialCommittedRowCount = this.txWriter.getRowCount();
            this.walRowsProcessed = 0L;
            try {
                if (transactionBlock == 1) {
                    committed = this.processWalCommit(walPath, seqTxn, pressureControl, commitToTimestamp);
                    break block13;
                }
                try {
                    int blockSize = this.processWalCommitBlock(seqTxn, transactionBlock, pressureControl);
                    committed = blockSize > 0;
                    seqTxn += (long)(blockSize - 1);
                }
                catch (CairoException e) {
                    if (e.isBlockApplyError()) {
                        if (this.configuration.getDebugWalApplyBlockFailureNoRetry()) {
                            throw e;
                        }
                        pressureControl.onBlockApplyError();
                        pressureControl.updateInflightTxnBlockLength(1L, Math.max(1L, this.walTxnDetails.getSegmentRowHi(seqTxn) - this.walTxnDetails.getSegmentRowLo(seqTxn)));
                        LOG.info().$("failed to apply block, trying to apply 1 by 1 [table=").$(this.tableToken).$(", startTxn=").$(seqTxn).I$();
                        committed = this.processWalCommit(walPath, seqTxn, pressureControl, commitToTimestamp);
                        break block13;
                    }
                    throw e;
                }
            }
            catch (CairoException e) {
                if (e.isOutOfMemory()) {
                    this.distressed = true;
                }
                throw e;
            }
        }
        this.walTxnDetails.setIncrementRowsCommitted(this.walRowsProcessed);
        if (committed) {
            assert (this.txWriter.getLagRowCount() == 0);
            this.txWriter.setSeqTxn(seqTxn);
            this.txWriter.setLagTxnCount(0);
            this.txWriter.setLagOrdered(true);
            this.commit00();
            this.lastWalCommitTimestampMicros = this.configuration.getMicrosecondClock().getTicks();
            this.housekeep();
            this.shrinkO3Mem();
            assert (this.txWriter.getPartitionCount() == 0 || this.txWriter.getMinTimestamp() >= this.txWriter.getPartitionTimestampByIndex(0));
            LOG.debug().$("table ranges after the commit [table=").$(this.tableToken).$(", minTs=").$ts(this.txWriter.getMinTimestamp()).$(", maxTs=").$ts(this.txWriter.getMaxTimestamp()).I$();
        }
        assert ((long)this.txWriter.getLagTxnCount() == seqTxn - this.txWriter.getSeqTxn());
        this.metrics.tableWriterMetrics().addCommittedRows(this.txWriter.getRowCount() - initialCommittedRowCount);
    }

    @Override
    public boolean convertPartitionNativeToParquet(long partitionTimestamp) {
        long parquetFileLength;
        int memoryTag = 16;
        assert (this.metadata.getTimestampIndex() > -1);
        assert (PartitionBy.isPartitioned(this.partitionBy));
        if (this.inTransaction()) {
            assert (!this.tableToken.isWal());
            LOG.info().$("committing open transaction before applying convert partition to parquet command [table=").$safe(this.tableToken.getTableName()).$(", partition=").$ts(partitionTimestamp).I$();
            this.commit();
        }
        if ((partitionTimestamp = this.txWriter.getLogicalPartitionTimestamp(partitionTimestamp)) == this.txWriter.getLogicalPartitionTimestamp(this.txWriter.getMaxTimestamp())) {
            LOG.info().$("skipping active partition as it cannot be converted to parquet format [table=").$safe(this.tableToken.getTableName()).$(", partition=").$ts(partitionTimestamp).I$();
            return true;
        }
        int partitionIndex = this.txWriter.getPartitionIndex(partitionTimestamp);
        if (partitionIndex < 0) {
            this.formatPartitionForTimestamp(partitionTimestamp, -1L);
            throw CairoException.nonCritical().put("cannot convert partition to parquet, partition does not exist [table=").put(this.tableToken.getTableName()).put(", partition=").put(this.utf8Sink).put(']');
        }
        if (this.txWriter.isPartitionParquet(partitionIndex)) {
            return true;
        }
        this.lastPartitionTimestamp = this.txWriter.getLastPartitionTimestamp();
        boolean lastPartitionConverted = this.lastPartitionTimestamp == partitionTimestamp;
        this.squashPartitionForce(partitionIndex);
        long partitionNameTxn = this.txWriter.getPartitionNameTxn(partitionIndex);
        TableUtils.setPathForNativePartition(this.path.trimTo(this.pathSize), this.partitionBy, partitionTimestamp, partitionNameTxn);
        int partitionDirLen = this.path.size();
        if (!this.ff.exists(this.path.$())) {
            throw CairoException.nonCritical().put("partition directory does not exist [path=").put(this.path).put(']');
        }
        TableUtils.setPathForNativePartition(this.other.trimTo(this.pathSize), this.partitionBy, partitionTimestamp, this.getTxn());
        TableUtils.createDirsOrFail(this.ff, this.other.slash(), this.configuration.getMkDirMode());
        int newPartitionDirLen = this.other.size();
        TableUtils.setPathForParquetPartition(this.other.trimTo(this.pathSize), this.partitionBy, partitionTimestamp, this.getTxn());
        LOG.info().$("converting partition to parquet [path=").$substr(this.pathRootSize, this.path).I$();
        try (MappedMemoryPartitionDescriptor partitionDescriptor = new MappedMemoryPartitionDescriptor(this.ff);){
            long partitionRowCount = this.getPartitionSize(partitionIndex);
            int timestampIndex = this.metadata.getTimestampIndex();
            partitionDescriptor.of(this.getTableToken().getTableName(), partitionRowCount, timestampIndex);
            int columnCount = this.metadata.getColumnCount();
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                long columnRowCount;
                int columnType = this.metadata.getColumnType(columnIndex);
                if (columnType <= 0) continue;
                CharSequence columnName = this.metadata.getColumnName(columnIndex);
                int columnId = this.metadata.getColumnMetadata(columnIndex).getWriterIndex();
                long columnNameTxn = this.getColumnNameTxn(partitionTimestamp, columnIndex);
                long columnTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, columnIndex);
                long l = columnRowCount = columnTop != -1L ? partitionRowCount - columnTop : 0L;
                if (columnRowCount > 0L) {
                    if (ColumnType.isSymbol(columnType)) {
                        partitionDescriptor.addColumn(columnName, columnType, columnId, columnTop);
                        long columnSize = columnRowCount * (long)ColumnType.sizeOf(columnType);
                        long columnAddr = TableUtils.mapRO(this.ff, TableUtils.dFile(this.path.trimTo(partitionDirLen), columnName, columnNameTxn), LOG, columnSize, 16);
                        partitionDescriptor.setColumnAddr(columnAddr, columnSize);
                        long defaultColumnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(columnIndex);
                        TableUtils.offsetFileName(this.path.trimTo(this.pathSize), columnName, defaultColumnNameTxn);
                        if (!this.ff.exists(this.path.$())) {
                            LOG.error().$(this.path).$(" is not found").$();
                            throw CairoException.fileNotFound().put("offset file does not exist: ").put(this.path);
                        }
                        long fileLength = this.ff.length(this.path.$());
                        if (fileLength < 64L) {
                            LOG.error().$(this.path).$("symbol file is too small [fileLength=").$(fileLength).$(']').$();
                            throw CairoException.critical(0).put("SymbolMap is too short: ").put(this.path);
                        }
                        int symbolCount = this.getSymbolMapWriter(columnIndex).getSymbolCount();
                        long offsetsMemSize = SymbolMapWriter.keyToOffset(symbolCount + 1);
                        long symbolOffsetsAddr = TableUtils.mapRO(this.ff, this.path.$(), LOG, offsetsMemSize, 16);
                        partitionDescriptor.setSymbolOffsetsAddr(symbolOffsetsAddr + 64L, symbolCount);
                        LPSZ charFileName = TableUtils.charFileName(this.path.trimTo(this.pathSize), columnName, defaultColumnNameTxn);
                        long columnSecondarySize = this.ff.length(charFileName);
                        long columnSecondaryAddr = TableUtils.mapRO(this.ff, charFileName, LOG, columnSecondarySize, 16);
                        partitionDescriptor.setSecondaryColumnAddr(columnSecondaryAddr, columnSecondarySize);
                        TableUtils.setPathForNativePartition(this.path.trimTo(this.pathSize), this.partitionBy, partitionTimestamp, partitionNameTxn);
                        continue;
                    }
                    if (ColumnType.isVarSize(columnType)) {
                        partitionDescriptor.addColumn(columnName, columnType, columnId, columnTop);
                        ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                        long auxVectorSize = columnTypeDriver.getAuxVectorSize(columnRowCount);
                        long auxVectorAddr = TableUtils.mapRO(this.ff, TableUtils.iFile(this.path.trimTo(partitionDirLen), columnName, columnNameTxn), LOG, auxVectorSize, 16);
                        partitionDescriptor.setSecondaryColumnAddr(auxVectorAddr, auxVectorSize);
                        long dataSize = columnTypeDriver.getDataVectorSizeAt(auxVectorAddr, columnRowCount - 1L);
                        if (dataSize < columnTypeDriver.getDataVectorMinEntrySize() || dataSize >= 0x10000000000L) {
                            LOG.critical().$("Invalid var len column size [column=").$safe(columnName).$(", size=").$(dataSize).$(", path=").$(this.path).I$();
                            throw CairoException.critical(0).put("Invalid column size [column=").put(this.path).put(", size=").put(dataSize).put(']');
                        }
                        long dataAddr = dataSize > 0L ? TableUtils.mapRO(this.ff, TableUtils.dFile(this.path.trimTo(partitionDirLen), columnName, columnNameTxn), LOG, dataSize, 16) : 0L;
                        partitionDescriptor.setColumnAddr(dataAddr, dataSize);
                        continue;
                    }
                    long mapBytes = columnRowCount * (long)ColumnType.sizeOf(columnType);
                    long fixedAddr = TableUtils.mapRO(this.ff, TableUtils.dFile(this.path.trimTo(partitionDirLen), columnName, columnNameTxn), LOG, mapBytes, 16);
                    partitionDescriptor.addColumn(columnName, columnType, columnId, columnTop, fixedAddr, mapBytes, 0L, 0L, 0L, 0L);
                    continue;
                }
                partitionDescriptor.addColumn(columnName, columnType, columnId, partitionRowCount);
            }
            CairoConfiguration config = this.getConfiguration();
            int compressionCodec = config.getPartitionEncoderParquetCompressionCodec();
            int compressionLevel = config.getPartitionEncoderParquetCompressionLevel();
            int rowGroupSize = config.getPartitionEncoderParquetRowGroupSize();
            int dataPageSize = config.getPartitionEncoderParquetDataPageSize();
            boolean statisticsEnabled = config.isPartitionEncoderParquetStatisticsEnabled();
            boolean rawArrayEncoding = config.isPartitionEncoderParquetRawArrayEncoding();
            int parquetVersion = config.getPartitionEncoderParquetVersion();
            PartitionEncoder.encodeWithOptions(partitionDescriptor, this.other, ParquetCompression.packCompressionCodecLevel(compressionCodec, compressionLevel), statisticsEnabled, rawArrayEncoding, rowGroupSize, dataPageSize, parquetVersion);
            parquetFileLength = this.ff.length(this.other.$());
        }
        catch (CairoException e) {
            LOG.error().$("could not convert partition to parquet [table=").$safe(this.tableToken.getTableName()).$(", partition=").$ts(partitionTimestamp).$(", error=").$safe(e.getMessage()).I$();
            if (!this.ff.rmdir(this.other.trimTo(newPartitionDirLen).slash())) {
                LOG.error().$("could not remove parquet file [path=").$(this.other).I$();
            }
            throw e;
        }
        finally {
            this.path.trimTo(this.pathSize);
            this.other.trimTo(this.pathSize);
        }
        LOG.info().$("copying index files to parquet [path=").$substr(this.pathRootSize, this.path).I$();
        this.copyPartitionIndexFiles(partitionTimestamp, partitionDirLen, newPartitionDirLen);
        long originalSize = this.txWriter.getPartitionSize(partitionIndex);
        this.txWriter.updatePartitionSizeAndTxnByRawIndex(partitionIndex * 4, originalSize);
        this.txWriter.setPartitionParquetFormat(partitionTimestamp, parquetFileLength);
        this.txWriter.bumpPartitionTableVersion();
        this.txWriter.commit(this.denseSymbolMapWriters);
        if (lastPartitionConverted) {
            this.closeActivePartition(false);
        }
        this.safeDeletePartitionDir(partitionTimestamp, partitionNameTxn);
        if (lastPartitionConverted) {
            this.openPartition(partitionTimestamp, this.txWriter.getTransientRowCount());
            this.setAppendPosition(this.txWriter.getTransientRowCount(), false);
        }
        return true;
    }

    @Override
    public boolean convertPartitionParquetToNative(long partitionTimestamp) {
        int partitionIndex;
        assert (this.metadata.getTimestampIndex() > -1);
        assert (PartitionBy.isPartitioned(this.partitionBy));
        if (this.inTransaction()) {
            LOG.info().$("committing open transaction before applying convert partition to parquet command [table=").$safe(this.tableToken.getTableName()).$(", partition=").$ts(partitionTimestamp).I$();
            this.commit();
        }
        if ((partitionIndex = this.txWriter.getPartitionIndex(partitionTimestamp = this.txWriter.getLogicalPartitionTimestamp(partitionTimestamp))) < 0) {
            this.formatPartitionForTimestamp(partitionTimestamp, -1L);
            throw CairoException.nonCritical().put("cannot convert parquet partition to native, partition does not exist [table=").put(this.tableToken.getTableName()).put(", partition=").put(this.utf8Sink).put(']');
        }
        if (!this.txWriter.isPartitionParquet(partitionIndex)) {
            return true;
        }
        this.lastPartitionTimestamp = this.txWriter.getLastPartitionTimestamp();
        boolean lastPartitionConverted = this.lastPartitionTimestamp == partitionTimestamp;
        long partitionNameTxn = this.txWriter.getPartitionNameTxn(partitionIndex);
        TableUtils.setPathForNativePartition(this.path.trimTo(this.pathSize), this.partitionBy, partitionTimestamp, partitionNameTxn);
        int partitionDirLen = this.path.size();
        TableUtils.setPathForParquetPartition(this.path.trimTo(this.pathSize), this.partitionBy, partitionTimestamp, partitionNameTxn);
        if (!this.ff.exists(this.path.$())) {
            throw CairoException.nonCritical().put("partition path does not exist [path=").put(this.path).put(']');
        }
        TableUtils.setPathForNativePartition(this.other.trimTo(this.pathSize), this.partitionBy, partitionTimestamp, this.getTxn());
        TableUtils.createDirsOrFail(this.ff, this.other.slash(), this.configuration.getMkDirMode());
        int newPartitionDirLen = this.other.size();
        DirectLongList columnFdAndDataSize = this.getTempDirectLongList(3L * (long)this.columnCount);
        LOG.info().$("converting parquet partition to native [path=").$substr(this.pathRootSize, this.path).I$();
        long parquetSize = this.txWriter.getPartitionParquetFileSize(partitionIndex);
        long parquetAddr = TableUtils.mapRO(this.ff, this.path.$(), LOG, parquetSize, 17);
        long parquetRowCount = 0L;
        try (RowGroupBuffers rowGroupBuffers = new RowGroupBuffers(66);){
            this.parquetDecoder.of(parquetAddr, parquetSize, 66);
            GenericRecordMetadata metadata = new GenericRecordMetadata();
            PartitionDecoder.Metadata parquetMetadata = this.parquetDecoder.metadata();
            parquetMetadata.copyTo(metadata, false);
            this.parquetColumnIdsAndTypes.clear();
            int n = metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                long auxIndex;
                int columnType = metadata.getColumnType(i);
                String columnName = metadata.getColumnName(i);
                long columnNameTxn = this.getColumnNameTxn(partitionTimestamp, i);
                this.parquetColumnIdsAndTypes.add(i);
                this.parquetColumnIdsAndTypes.add(columnType);
                if (ColumnType.isVarSize(columnType)) {
                    auxIndex = columnFdAndDataSize.size();
                    columnFdAndDataSize.add(-1L);
                    columnFdAndDataSize.add(-1L);
                    columnFdAndDataSize.add(0L);
                    long dstAuxFd = TableUtils.openAppend(this.ff, TableUtils.iFile(this.other.trimTo(newPartitionDirLen), columnName, columnNameTxn), LOG);
                    columnFdAndDataSize.set(auxIndex, dstAuxFd);
                    long dstDataFd = TableUtils.openAppend(this.ff, TableUtils.dFile(this.other.trimTo(newPartitionDirLen), columnName, columnNameTxn), LOG);
                    columnFdAndDataSize.set(auxIndex + 1L, dstDataFd);
                    continue;
                }
                auxIndex = columnFdAndDataSize.size();
                columnFdAndDataSize.add(-1L);
                columnFdAndDataSize.add(-1L);
                columnFdAndDataSize.add(0L);
                long dstFixFd = TableUtils.openAppend(this.ff, TableUtils.dFile(this.other.trimTo(newPartitionDirLen), columnName, columnNameTxn), LOG);
                columnFdAndDataSize.set(auxIndex + 1L, dstFixFd);
            }
            int rowGroupCount = parquetMetadata.rowGroupCount();
            for (int rowGroupIndex = 0; rowGroupIndex < rowGroupCount; ++rowGroupIndex) {
                long rowGroupRowCount = this.parquetDecoder.decodeRowGroup(rowGroupBuffers, this.parquetColumnIdsAndTypes, rowGroupIndex, 0, parquetMetadata.rowGroupSize(rowGroupIndex));
                parquetRowCount += rowGroupRowCount;
                int n2 = metadata.getColumnCount();
                for (int columnIndex = 0; columnIndex < n2; ++columnIndex) {
                    int columnType = metadata.getColumnType(columnIndex);
                    long srcDataPtr = rowGroupBuffers.getChunkDataPtr(columnIndex);
                    long srcDataSize = rowGroupBuffers.getChunkDataSize(columnIndex);
                    long srcAuxPtr = rowGroupBuffers.getChunkAuxPtr(columnIndex);
                    long srcAuxSize = rowGroupBuffers.getChunkAuxSize(columnIndex);
                    if (ColumnType.isVarSize(columnType)) {
                        ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                        long dstAuxFd = columnFdAndDataSize.get(3L * (long)columnIndex);
                        long dstDataFd = columnFdAndDataSize.get(3L * (long)columnIndex + 1L);
                        long dataVecBytesWritten = columnFdAndDataSize.get(3L * (long)columnIndex + 2L);
                        if (rowGroupIndex > 0) {
                            columnTypeDriver.shiftCopyAuxVector(-dataVecBytesWritten, srcAuxPtr, 0L, rowGroupRowCount - 1L, srcAuxPtr, srcAuxSize);
                            long adjust = columnTypeDriver.getMinAuxVectorSize();
                            srcAuxPtr += adjust;
                            srcAuxSize -= adjust;
                        }
                        this.appendBuffer(dstDataFd, srcDataPtr, srcDataSize);
                        this.appendBuffer(dstAuxFd, srcAuxPtr, srcAuxSize);
                        columnFdAndDataSize.set(3L * (long)columnIndex + 2L, dataVecBytesWritten + srcDataSize);
                        continue;
                    }
                    long dstFixFd = columnFdAndDataSize.get(3L * (long)columnIndex + 1L);
                    this.appendBuffer(dstFixFd, srcDataPtr, srcDataSize);
                }
            }
        }
        catch (CairoException e) {
            LOG.error().$("could not convert partition to native [table=").$safe(this.tableToken.getTableName()).$(", partition=").$ts(partitionTimestamp).$(", error=").$safe(e.getMessage()).I$();
            if (!this.ff.rmdir(this.other.trimTo(newPartitionDirLen).slash())) {
                LOG.error().$("could not remove native partition dir [path=").$(this.other).I$();
            }
            throw e;
        }
        finally {
            this.path.trimTo(this.pathSize);
            this.other.trimTo(this.pathSize);
            long n = columnFdAndDataSize.size() / 3L;
            for (long i = 0L; i < n; ++i) {
                long dstAuxFd = columnFdAndDataSize.get(3L * i);
                this.ff.close(dstAuxFd);
                long dstDataFd = columnFdAndDataSize.get(3L * i + 1L);
                this.ff.close(dstDataFd);
            }
            columnFdAndDataSize.resetCapacity();
            this.parquetDecoder.close();
            this.ff.munmap(parquetAddr, parquetSize, 17);
        }
        LOG.info().$("copying index files to native [path=").$substr(this.pathRootSize, this.path).I$();
        this.copyPartitionIndexFiles(partitionTimestamp, partitionDirLen, newPartitionDirLen);
        this.txWriter.updatePartitionSizeAndTxnByRawIndex(partitionIndex * 4, parquetRowCount);
        this.txWriter.resetPartitionParquetFormat(partitionTimestamp);
        this.txWriter.bumpPartitionTableVersion();
        this.txWriter.commit(this.denseSymbolMapWriters);
        if (lastPartitionConverted) {
            this.closeActivePartition(false);
        }
        this.safeDeletePartitionDir(partitionTimestamp, partitionNameTxn);
        if (lastPartitionConverted) {
            this.openPartition(partitionTimestamp, this.txWriter.getTransientRowCount());
            this.setAppendPosition(this.txWriter.getTransientRowCount(), false);
        }
        return true;
    }

    public void destroy() {
        LOG.info().$("closing table files [table=").$(this.tableToken).I$();
        this.distressed = true;
        this.doClose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachDetachStatus detachPartition(long timestamp) {
        long partitionNameTxn;
        block33: {
            assert (this.metadata.getTimestampIndex() > -1);
            assert (PartitionBy.isPartitioned(this.partitionBy));
            if (this.inTransaction()) {
                assert (!this.tableToken.isWal());
                LOG.info().$("committing open transaction before applying detach partition command [table=").$safe(this.tableToken.getTableName()).$(", partition=").$ts(timestamp).I$();
                this.commit();
            }
            if ((timestamp = this.txWriter.getLogicalPartitionTimestamp(timestamp)) == this.txWriter.getLogicalPartitionTimestamp(this.txWriter.getMaxTimestamp())) {
                return AttachDetachStatus.DETACH_ERR_ACTIVE;
            }
            int partitionIndex = this.txWriter.getPartitionIndex(timestamp);
            if (partitionIndex < 0) {
                assert (!this.txWriter.attachedPartitionsContains(timestamp));
                return AttachDetachStatus.DETACH_ERR_MISSING_PARTITION;
            }
            this.squashPartitionForce(partitionIndex);
            assert (this.txWriter.getLogicalPartitionTimestamp(this.txWriter.getPartitionTimestampByIndex(partitionIndex + 1)) != timestamp);
            long minTimestamp = this.txWriter.getMinTimestamp();
            partitionNameTxn = this.txWriter.getPartitionNameTxn(partitionIndex);
            Path detachedPath = Path.PATH.get();
            try {
                AttachDetachStatus attachDetachStatus;
                int detachedPathLen;
                TableUtils.setPathForNativePartition(this.path.trimTo(this.pathSize), this.partitionBy, timestamp, partitionNameTxn);
                if (!this.ff.exists(this.path.$())) {
                    LOG.error().$("partition folder does not exist [path=").$substr(this.pathRootSize, this.path).I$();
                    AttachDetachStatus attachDetachStatus2 = AttachDetachStatus.DETACH_ERR_MISSING_PARTITION_DIR;
                    return attachDetachStatus2;
                }
                if (this.ff.isSoftLink(this.path.$())) {
                    detachedPathLen = 0;
                    attachDetachStatus = AttachDetachStatus.OK;
                    LOG.info().$("detaching partition via unlink [path=").$substr(this.pathRootSize, this.path).I$();
                } else {
                    detachedPath.of(this.configuration.getDbRoot()).concat(this.tableToken.getDirName());
                    int detachedRootLen = detachedPath.size();
                    if (!this.ff.exists(detachedPath.slash$()) && 0 != this.ff.mkdirs(detachedPath, this.detachedMkDirMode)) {
                        LOG.error().$("could no create detached partition folder [errno=").$(this.ff.errno()).$(", path=").$(detachedPath).I$();
                        AttachDetachStatus attachDetachStatus3 = AttachDetachStatus.DETACH_ERR_MKDIR;
                        return attachDetachStatus3;
                    }
                    TableUtils.setPathForNativePartition(detachedPath.trimTo(detachedRootLen), this.partitionBy, timestamp, -1L);
                    detachedPath.put(".detached");
                    detachedPathLen = detachedPath.size();
                    if (this.ff.exists(detachedPath.$())) {
                        LOG.error().$("detached partition folder already exist [path=").$(detachedPath).I$();
                        AttachDetachStatus attachDetachStatus4 = AttachDetachStatus.DETACH_ERR_ALREADY_DETACHED;
                        return attachDetachStatus4;
                    }
                    if (this.ff.hardLinkDirRecursive(this.path, detachedPath, this.detachedMkDirMode) != 0) {
                        if (this.ff.isCrossDeviceCopyError(this.ff.errno())) {
                            if (this.ff.copyRecursive(this.path, detachedPath, this.detachedMkDirMode) != 0) {
                                LOG.critical().$("could not copy detached partition [errno=").$(this.ff.errno()).$(", from=").$(this.path).$(", to=").$(detachedPath).I$();
                                AttachDetachStatus attachDetachStatus5 = AttachDetachStatus.DETACH_ERR_COPY;
                                return attachDetachStatus5;
                            }
                        } else {
                            LOG.critical().$("could not create hard link to detached partition [errno=").$(this.ff.errno()).$(", from=").$(this.path).$(", to=").$(detachedPath).I$();
                            AttachDetachStatus attachDetachStatus6 = AttachDetachStatus.DETACH_ERR_HARD_LINK;
                            return attachDetachStatus6;
                        }
                    }
                    this.other.of(this.path).trimTo(this.pathSize).concat("_meta").$();
                    detachedPath.trimTo(detachedPathLen).concat("_meta").$();
                    attachDetachStatus = AttachDetachStatus.OK;
                    if (-1 == this.copyOverwrite(detachedPath)) {
                        attachDetachStatus = AttachDetachStatus.DETACH_ERR_COPY_META;
                        LOG.critical().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(this.other).$(", to=").$(detachedPath).I$();
                    } else {
                        this.other.parent().concat("_cv").$();
                        detachedPath.parent().concat("_cv").$();
                        if (-1 == this.copyOverwrite(detachedPath)) {
                            attachDetachStatus = AttachDetachStatus.DETACH_ERR_COPY_META;
                            LOG.critical().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(this.other).$(", to=").$(detachedPath).I$();
                        } else {
                            this.other.parent().concat("_txn").$();
                            detachedPath.parent().concat("_txn").$();
                            if (-1 == this.copyOverwrite(detachedPath)) {
                                attachDetachStatus = AttachDetachStatus.DETACH_ERR_COPY_META;
                                LOG.critical().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(this.other).$(", to=").$(detachedPath).I$();
                            }
                        }
                    }
                }
                if (attachDetachStatus == AttachDetachStatus.OK) {
                    long nextMinTimestamp = minTimestamp;
                    if (timestamp == this.txWriter.getPartitionTimestampByIndex(0)) {
                        nextMinTimestamp = this.readMinTimestamp();
                    }
                    this.txWriter.beginPartitionSizeUpdate();
                    this.txWriter.removeAttachedPartitions(timestamp);
                    this.txWriter.setMinTimestamp(nextMinTimestamp);
                    this.txWriter.finishPartitionSizeUpdate(nextMinTimestamp, this.txWriter.getMaxTimestamp());
                    this.txWriter.bumpTruncateVersion();
                    this.columnVersionWriter.removePartition(timestamp);
                    this.columnVersionWriter.commit();
                    this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
                    this.txWriter.commit(this.denseSymbolMapWriters);
                    break block33;
                }
                detachedPath.trimTo(detachedPathLen).slash().$();
                if (this.ff.rmdir(detachedPath)) {
                    LOG.error().$("could not rollback detached copy (rmdir) [errno=").$(this.ff.errno()).$(", undo=").$(detachedPath).$(", original=").$(this.path).I$();
                }
                AttachDetachStatus attachDetachStatus7 = attachDetachStatus;
                return attachDetachStatus7;
            }
            finally {
                this.path.trimTo(this.pathSize);
                this.other.trimTo(this.pathSize);
            }
        }
        this.safeDeletePartitionDir(timestamp, partitionNameTxn);
        return AttachDetachStatus.OK;
    }

    @Override
    public void disableDeduplication() {
        assert (this.txWriter.getLagRowCount() == 0);
        this.checkDistressed();
        LOG.info().$("disabling row deduplication [table=").$safe(this.tableToken.getTableName()).I$();
        for (int i = 0; i < this.columnCount; ++i) {
            this.metadata.getColumnMetadata(i).setDedupKeyFlag(false);
        }
        this.rewriteAndSwapMetadata(this.metadata);
        this.clearTodoAndCommitMetaStructureVersion();
        if (this.dedupColumnCommitAddresses != null) {
            this.dedupColumnCommitAddresses.setDedupColumnCount(0);
        }
        try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
            metadataRW.hydrateTable(this.metadata);
        }
    }

    @Override
    public void dropIndex(@NotNull CharSequence name) {
        this.checkDistressed();
        int columnIndex = this.metadata.getColumnIndexQuiet(name);
        if (columnIndex == -1) {
            throw CairoException.invalidMetadataRecoverable("column does not exist", name);
        }
        CharSequence columnName = this.metadata.getColumnName(columnIndex);
        TableColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        if (!columnMetadata.isSymbolIndexFlag()) {
            throw CairoException.invalidMetadataRecoverable("column is not indexed", columnName);
        }
        int defaultIndexValueBlockSize = Numbers.ceilPow2(this.configuration.getIndexValueBlockSize());
        if (this.inTransaction()) {
            assert (!this.tableToken.isWal());
            LOG.info().$("committing current transaction before DROP INDEX execution [txn=").$(this.txWriter.getTxn()).$(", table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(columnName).I$();
            this.commit();
        }
        try {
            LOG.info().$("removing index [txn=").$(this.txWriter.getTxn()).$(", table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(columnName).I$();
            if (this.dropIndexOperator == null) {
                this.dropIndexOperator = new DropIndexOperator(this.configuration, this, this.path, this.other, this.pathSize, this.getPurgingOperator());
            }
            this.dropIndexOperator.executeDropIndex((String)columnName, columnIndex);
            columnMetadata.setSymbolIndexFlag(false);
            columnMetadata.setIndexValueBlockCapacity(defaultIndexValueBlockSize);
            this.rewriteAndSwapMetadata(this.metadata);
            this.clearTodoAndCommitMeta();
            ColumnIndexer columnIndexer = this.indexers.getQuick(columnIndex);
            if (columnIndexer != null) {
                this.indexers.setQuick(columnIndex, null);
                Misc.free(columnIndexer);
                this.populateDenseIndexerList();
            }
            this.finishColumnPurge();
            LOG.info().$("REMOVED index [txn=").$(this.txWriter.getTxn()).I$();
            try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
                metadataRW.hydrateTable(this.metadata);
            }
            LOG.info().$("END DROP INDEX [txn=").$(this.txWriter.getTxn()).$(", table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(columnName).I$();
        }
        catch (CairoException e) {
            LOG.critical().$("exception on index drop [txn=").$(this.txWriter.getTxn()).$(", table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(columnName).$(", errno=").$(e.errno).$(", error=").$(e).I$();
            throw CairoException.critical(e.errno).put("cannot remove index for [txn=").put(this.txWriter.getTxn()).put(", table=").put(this.tableToken.getTableName()).put(", column=").put(columnName).put("]: ").put(e.getMessage());
        }
        catch (Throwable e) {
            LOG.critical().$("exception on index drop [txn=").$(this.txWriter.getTxn()).$(", table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(columnName).$(", error=").$(e).I$();
            throw CairoException.critical(0).put("cannot remove index for [txn=").put(this.txWriter.getTxn()).put(", table=").put(this.tableToken.getTableName()).put(", column=").put(columnName).put("]: ").put(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enableDeduplicationWithUpsertKeys(LongList columnsIndexes) {
        assert (this.txWriter.getLagRowCount() == 0);
        this.checkDistressed();
        LogRecord logRec = LOG.info().$("enabling row deduplication [table=").$safe(this.tableToken.getTableName()).$(", columns=[");
        boolean isSubsetOfOldKeys = true;
        try {
            int upsertKeyColumn = columnsIndexes.size();
            for (int i = 0; i < upsertKeyColumn; ++i) {
                int dedupColIndex = (int)columnsIndexes.getQuick(i);
                if (dedupColIndex < 0 || dedupColIndex >= this.metadata.getColumnCount()) {
                    throw CairoException.critical(0).put("Invalid column index to make a dedup key [table=").put(this.tableToken.getTableName()).put(", columnIndex=").put(dedupColIndex);
                }
                int columnType = this.metadata.getColumnType(dedupColIndex);
                if (columnType < 0) {
                    throw CairoException.critical(0).put("Invalid column used as deduplicate key, column is dropped [table=").put(this.tableToken.getTableName()).put(", columnIndex=").put(dedupColIndex);
                }
                isSubsetOfOldKeys &= this.metadata.isDedupKey(dedupColIndex);
                if (i > 0) {
                    logRec.$(',');
                }
                logRec.$safe(this.getColumnNameSafe(dedupColIndex)).$(':').$(ColumnType.nameOf(columnType));
            }
        }
        finally {
            logRec.I$();
        }
        columnsIndexes.sort();
        int j = 0;
        for (int i = 0; i < this.columnCount && j < columnsIndexes.size(); ++i) {
            if ((long)i != columnsIndexes.getQuick(j)) continue;
            this.metadata.getColumnMetadata(i).setDedupKeyFlag(true);
            ++j;
        }
        this.rewriteAndSwapMetadata(this.metadata);
        this.clearTodoAndCommitMetaStructureVersion();
        if (this.dedupColumnCommitAddresses == null) {
            this.dedupColumnCommitAddresses = new DedupColumnCommitAddresses();
        } else {
            this.dedupColumnCommitAddresses.clear();
        }
        this.dedupColumnCommitAddresses.setDedupColumnCount(columnsIndexes.size() - 1);
        try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
            metadataRW.hydrateTable(this.metadata);
        }
        return isSubsetOfOldKeys;
    }

    public void enforceTtl() {
        this.partitionRemoveCandidates.clear();
        int ttl = this.metadata.getTtlHoursOrMonths();
        if (ttl == 0) {
            return;
        }
        if (this.metadata.getPartitionBy() == 3) {
            LOG.error().$("TTL set on a non-partitioned table. Ignoring");
            return;
        }
        if (this.getPartitionCount() < 2) {
            return;
        }
        long maxTimestamp = this.getMaxTimestamp();
        long evictedPartitionTimestamp = -1L;
        boolean dropped = false;
        do {
            boolean shouldEvict;
            long partitionTimestamp = this.getPartitionTimestamp(0);
            long floorTimestamp = this.txWriter.getPartitionFloor(partitionTimestamp);
            if (evictedPartitionTimestamp != -1L && floorTimestamp == evictedPartitionTimestamp) {
                assert (partitionTimestamp != floorTimestamp) : "Expected a higher part of a split partition";
                dropped |= this.dropPartitionByExactTimestamp(partitionTimestamp);
                continue;
            }
            long partitionCeiling = this.txWriter.getNextLogicalPartitionTimestamp(partitionTimestamp);
            boolean bl = ttl > 0 ? maxTimestamp - partitionCeiling >= 3600000000L * (long)ttl : (shouldEvict = Timestamps.getMonthsBetween(partitionCeiling, maxTimestamp) >= (long)(-ttl));
            if (!shouldEvict) break;
            LOG.info().$("Partition's TTL expired, evicting. table=").$safe(this.metadata.getTableName()).$(" partitionTs=").microTime(partitionTimestamp).$();
            dropped |= this.dropPartitionByExactTimestamp(partitionTimestamp);
            evictedPartitionTimestamp = partitionTimestamp;
        } while (this.getPartitionCount() > 1);
        if (dropped) {
            this.commitRemovePartitionOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceRemovePartitions(LongList partitionTimestamps) {
        long minTimestamp = this.txWriter.getMinTimestamp();
        long maxTimestamp = this.txWriter.getMaxTimestamp();
        boolean firstPartitionDropped = false;
        boolean activePartitionDropped = false;
        this.txWriter.beginPartitionSizeUpdate();
        this.partitionRemoveCandidates.clear();
        int removedCount = 0;
        for (int i = 0; i < partitionTimestamps.size(); ++i) {
            long timestamp = partitionTimestamps.getQuick(i);
            int index = this.txWriter.getPartitionIndex(timestamp);
            if (index < 0) {
                LOG.debug().$("partition is already removed [path=").$substr(this.pathRootSize, this.path).$(", partitionTimestamp=").$ts(timestamp).I$();
                continue;
            }
            ++removedCount;
            if (!activePartitionDropped) {
                boolean bl = activePartitionDropped = timestamp == this.txWriter.getPartitionTimestampByTimestamp(maxTimestamp);
                if (activePartitionDropped) {
                    this.closeActivePartition(false);
                }
            }
            firstPartitionDropped |= timestamp == this.txWriter.getPartitionTimestampByIndex(0);
            this.columnVersionWriter.removePartition(timestamp);
            this.txWriter.removeAttachedPartitions(timestamp);
            this.partitionRemoveCandidates.add(timestamp, this.txWriter.getPartitionNameTxn(index));
        }
        if (removedCount > 0) {
            if (this.txWriter.getPartitionCount() > 0) {
                if (firstPartitionDropped) {
                    minTimestamp = this.readMinTimestamp();
                    this.txWriter.setMinTimestamp(minTimestamp);
                }
                if (activePartitionDropped) {
                    int partitionIndex = this.txWriter.getPartitionCount() - 1;
                    long activePartitionTs = this.txWriter.getPartitionTimestampByIndex(partitionIndex);
                    long activePartitionRows = this.txWriter.getPartitionSize(partitionIndex);
                    long parquetSize = this.txWriter.getPartitionParquetFileSize(partitionIndex);
                    long txn = this.txWriter.getPartitionNameTxn(partitionIndex);
                    TableUtils.setPathForNativePartition(this.path.trimTo(this.pathSize), this.partitionBy, activePartitionTs, txn);
                    try {
                        this.readPartitionMinMaxTimestamps(activePartitionTs, this.path, this.metadata.getColumnName(this.metadata.getTimestampIndex()), parquetSize, activePartitionRows);
                        maxTimestamp = this.attachMaxTimestamp;
                    }
                    finally {
                        this.path.trimTo(this.pathSize);
                    }
                }
                this.txWriter.finishPartitionSizeUpdate(minTimestamp, maxTimestamp);
                if (activePartitionDropped) {
                    this.openLastPartition();
                }
                this.txWriter.bumpTruncateVersion();
                this.columnVersionWriter.commit();
                this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
                this.txWriter.commit(this.denseSymbolMapWriters);
            } else {
                this.rowAction = 0;
                this.txWriter.resetTimestamp();
                this.columnVersionWriter.truncate();
                this.freeColumns(false);
                this.releaseIndexerWriters();
                this.txWriter.truncate(this.columnVersionWriter.getVersion(), this.denseSymbolMapWriters);
            }
            this.processPartitionRemoveCandidates();
        }
    }

    public long getAppliedSeqTxn() {
        return this.txWriter.getSeqTxn() + (long)this.txWriter.getLagTxnCount();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getColumnIndex(CharSequence name) {
        int index = this.metadata.getColumnIndexQuiet(name);
        if (index > -1) {
            return index;
        }
        throw CairoException.critical(0).put("column '").put(name).put("' does not exist");
    }

    public long getColumnNameTxn(long partitionTimestamp, int columnIndex) {
        return this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
    }

    public long getColumnStructureVersion() {
        return this.txWriter.getColumnStructureVersion();
    }

    public long getColumnTop(long partitionTimestamp, int columnIndex, long defaultValue) {
        long colTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, columnIndex);
        return colTop > -1L ? colTop : defaultValue;
    }

    public long getDataAppendPageSize() {
        return this.dataAppendPageSize;
    }

    public DedupColumnCommitAddresses getDedupCommitAddresses() {
        return this.dedupColumnCommitAddresses;
    }

    public ObjList<MapWriter> getDenseSymbolMapWriters() {
        return this.denseSymbolMapWriters;
    }

    public String getDesignatedTimestampColumnName() {
        return this.designatedTimestampColumnName;
    }

    public FilesFacade getFilesFacade() {
        return this.ff;
    }

    public long getMaxTimestamp() {
        return this.txWriter.getMaxTimestamp();
    }

    @Override
    public int getMetaMaxUncommittedRows() {
        return this.metadata.getMaxUncommittedRows();
    }

    @Override
    public TableMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public long getMetadataVersion() {
        return this.txWriter.getMetadataVersion();
    }

    public long getO3RowCount() {
        return this.hasO3() ? this.getO3RowCount0() : 0L;
    }

    @Override
    public int getPartitionBy() {
        return this.partitionBy;
    }

    public int getPartitionCount() {
        return this.txWriter.getPartitionCount();
    }

    public byte getPartitionFormat(int partitionIndex) {
        return this.txWriter.isPartitionParquet(partitionIndex) ? (byte)1 : 0;
    }

    public int getPartitionIndexByTimestamp(long timestamp) {
        return this.txWriter.getPartitionIndex(timestamp);
    }

    public long getPartitionNameTxn(int partitionIndex) {
        return this.txWriter.getPartitionNameTxn(partitionIndex);
    }

    public long getPartitionNameTxnByPartitionTimestamp(long partitionTimestamp) {
        return this.txWriter.getPartitionNameTxnByPartitionTimestamp(partitionTimestamp, -1L);
    }

    public long getPartitionO3SplitThreshold() {
        long splitMinSizeBytes = this.configuration.getPartitionO3SplitMinSize();
        return splitMinSizeBytes / (this.avgRecordSize != 0L ? this.avgRecordSize : (this.avgRecordSize = TableUtils.estimateAvgRecordSize(this.metadata)));
    }

    public long getPartitionParquetFileSize(int partitionIndex) {
        return this.txWriter.getPartitionParquetFileSize(partitionIndex);
    }

    public long getPartitionSize(int partitionIndex) {
        if (partitionIndex == this.txWriter.getPartitionCount() - 1 || !PartitionBy.isPartitioned(this.partitionBy)) {
            return this.txWriter.getTransientRowCount();
        }
        return this.txWriter.getPartitionSize(partitionIndex);
    }

    public long getPartitionTimestamp(int partitionIndex) {
        return this.txWriter.getPartitionTimestampByIndex(partitionIndex);
    }

    public long getPhysicallyWrittenRowsSinceLastCommit() {
        return this.physicallyWrittenRowsSinceLastCommit.get();
    }

    public long getRowCount() {
        return this.txWriter.getRowCount();
    }

    public long getSeqTxn() {
        return this.txWriter.getSeqTxn();
    }

    public MemoryMA getStorageColumn(int index) {
        return this.columns.getQuick(index);
    }

    @Override
    public int getSymbolCountWatermark(int columnIndex) {
        return -1;
    }

    public int getSymbolIndexNoTransientCountUpdate(int columnIndex, CharSequence symValue) {
        return this.symbolMapWriters.getQuick(columnIndex).put(symValue, SymbolValueCountCollector.NOOP);
    }

    public MapWriter getSymbolMapWriter(int columnIndex) {
        return this.symbolMapWriters.getQuick(columnIndex);
    }

    @Override
    @NotNull
    public TableToken getTableToken() {
        return this.tableToken;
    }

    public long getTransientRowCount() {
        return this.txWriter.getTransientRowCount();
    }

    public long getTruncateVersion() {
        return this.txWriter.getTruncateVersion();
    }

    public TxWriter getTxWriter() {
        return this.txWriter;
    }

    public long getTxn() {
        return this.txWriter.getTxn();
    }

    public TxnScoreboard getTxnScoreboard() {
        return this.txnScoreboard;
    }

    @Override
    public long getUncommittedRowCount() {
        return this.masterRef - this.committedMasterRef >> 1;
    }

    @Override
    public UpdateOperator getUpdateOperator() {
        if (this.updateOperatorImpl == null) {
            this.updateOperatorImpl = new UpdateOperatorImpl(this.configuration, this, this.path, this.pathSize, this.getPurgingOperator());
        }
        return this.updateOperatorImpl;
    }

    public WalTxnDetails getWalTnxDetails() {
        return this.walTxnDetails;
    }

    public void goActive() {
    }

    public void goPassive() {
        Misc.freeObjListAndKeepObjects(this.o3MemColumns1);
        Misc.freeObjListAndKeepObjects(this.o3MemColumns2);
    }

    public boolean hasO3() {
        return this.o3MasterRef > -1L;
    }

    @Override
    public void ic(long o3MaxLag) {
        this.commit(o3MaxLag);
    }

    @Override
    public void ic() {
        this.commit(this.metadata.getO3MaxLag());
    }

    public boolean inTransaction() {
        return this.txWriter != null && (this.txWriter.inTransaction() || this.hasO3() || this.columnVersionWriter != null && this.columnVersionWriter.hasChanges());
    }

    public boolean isCommitDedupMode() {
        if (!this.isDeduplicationEnabled()) {
            return false;
        }
        return this.dedupMode == 0 || this.dedupMode == 2;
    }

    public boolean isCommitPlainInsert() {
        return (this.dedupMode == 1 || !this.isDeduplicationEnabled()) && this.dedupMode != 3;
    }

    public boolean isCommitReplaceMode() {
        return this.dedupMode == 3;
    }

    public boolean isDeduplicationEnabled() {
        int tsIndex = this.metadata.timestampIndex;
        return tsIndex > -1 && this.metadata.isDedupKey(tsIndex);
    }

    public boolean isDistressed() {
        return this.distressed;
    }

    public boolean isOpen() {
        return this.tempMem16b != 0L;
    }

    public boolean isPartitionReadOnly(int partitionIndex) {
        return this.txWriter.isPartitionReadOnly(partitionIndex);
    }

    public boolean isSymbolMapWriterCached(int columnIndex) {
        return this.symbolMapWriters.getQuick(columnIndex).isCached();
    }

    public void markDistressed() {
        this.distressed = true;
    }

    public void markSeqTxnCommitted(long seqTxn) {
        this.setSeqTxn(seqTxn);
        this.txWriter.commit(this.denseSymbolMapWriters);
    }

    @Override
    public Row newRow() {
        return this.newRow(0L);
    }

    @Override
    public Row newRow(long timestamp) {
        if (this.rowAction != 2) {
            TableWriter.validateDesignatedTimestampBounds(timestamp);
        }
        switch (this.rowAction) {
            case 1: {
                if (timestamp < this.txWriter.getMaxTimestamp()) {
                    throw CairoException.nonCritical().put("cannot insert rows out of order to non-partitioned table. Table=").put(this.path);
                }
                this.bumpMasterRef();
                this.updateMaxTimestamp(timestamp);
                break;
            }
            case 2: {
                this.bumpMasterRef();
                break;
            }
            case 3: {
                this.bumpMasterRef();
                this.o3TimestampSetter(timestamp);
                return this.row;
            }
            case 0: {
                if (this.txWriter.getMaxTimestamp() == Long.MIN_VALUE) {
                    this.txWriter.setMinTimestamp(timestamp);
                    this.initLastPartition(this.txWriter.getPartitionTimestampByTimestamp(timestamp));
                }
                this.rowAction = 4;
            }
            case 4: {
                this.bumpMasterRef();
                if (timestamp > this.partitionTimestampHi || timestamp < this.txWriter.getMaxTimestamp()) {
                    if (timestamp < this.txWriter.getMaxTimestamp()) {
                        return this.newRowO3(timestamp);
                    }
                    if (PartitionBy.isPartitioned(this.partitionBy)) {
                        this.switchPartition(this.txWriter.getPartitionTimestampByTimestamp(timestamp));
                    }
                }
                if (this.lastOpenPartitionIsReadOnly) {
                    --this.masterRef;
                    ++this.noOpRowCount;
                    return NOOP_ROW;
                }
                this.updateMaxTimestamp(timestamp);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid row action constant");
            }
        }
        this.txWriter.append();
        return this.row;
    }

    @Override
    public Row newRowDeferTimestamp() {
        throw new UnsupportedOperationException();
    }

    public void o3BumpErrorCount(boolean oom) {
        this.o3ErrorCount.incrementAndGet();
        if (oom) {
            this.o3oomObserved = true;
        }
    }

    public void openLastPartition() {
        try {
            this.openLastPartitionAndSetAppendPosition(this.txWriter.getLastPartitionTimestamp());
        }
        catch (Throwable e) {
            this.freeColumns(false);
            throw e;
        }
    }

    public void processCommandQueue(TableWriterTask cmd, Sequence commandSubSeq, long cursor, boolean contextAllowsAnyStructureChanges) {
        if (cmd.getTableId() == (long)this.getMetadata().getTableId()) {
            switch (cmd.getType()) {
                case 2: {
                    this.processAsyncWriterCommand(this.alterOp, cmd, cursor, commandSubSeq, contextAllowsAnyStructureChanges);
                    break;
                }
                case 3: {
                    this.processAsyncWriterCommand(cmd.getAsyncWriterCommand(), cmd, cursor, commandSubSeq, false);
                    break;
                }
                default: {
                    LOG.error().$("unknown TableWriterTask type, ignored: ").$(cmd.getType()).$();
                    commandSubSeq.done(cursor);
                    break;
                }
            }
        } else {
            LOG.info().$("not my command [cmdTableId=").$(cmd.getTableId()).$(", cmdTableName=").$(cmd.getTableToken()).$(", myTableId=").$(this.getMetadata().getTableId()).$(", myTableName=").$safe(this.tableToken.getTableName()).I$();
            commandSubSeq.done(cursor);
        }
    }

    public void publishAsyncWriterCommand(AsyncWriterCommand asyncWriterCommand) {
        while (true) {
            long seq;
            if ((seq = this.commandPubSeq.next()) > -1L) {
                TableWriterTask task = this.commandQueue.get(seq);
                asyncWriterCommand.serialize(task);
                assert (task.getInstance() == asyncWriterCommand.getCorrelationId());
                this.commandPubSeq.done(seq);
                return;
            }
            if (seq == -1L) {
                throw CairoException.nonCritical().put("could not publish, command queue is full [table=").put(this.tableToken.getTableName()).put(']');
            }
            Os.pause();
        }
    }

    public void readWalTxnDetails(TransactionLogCursor transactionLogCursor) {
        if (this.walTxnDetails == null) {
            this.walTxnDetails = new WalTxnDetails(this.ff, this.configuration, this.getWalMaxLagRows());
        }
        this.walTxnDetails.readObservableTxnMeta(this.other, transactionLogCursor, this.pathSize, this.getAppliedSeqTxn(), this.txWriter.getMaxTimestamp());
    }

    public final void removeAllPartitions() {
        if (this.size() == 0L) {
            return;
        }
        if (this.partitionBy == 3) {
            throw CairoException.critical(0).put("cannot remove partitions from non-partitioned table");
        }
        this.txWriter.beginPartitionSizeUpdate();
        this.closeActivePartition(false);
        this.scheduleRemoveAllPartitions();
        this.columnVersionWriter.truncate();
        this.txWriter.removeAllPartitions();
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.commit(this.denseSymbolMapWriters);
        this.rowAction = 0;
        this.closeActivePartition(false);
        this.processPartitionRemoveCandidates();
        LOG.info().$("removed all partitions (soft truncated) [name=").$safe(this.tableToken.getTableName()).I$();
    }

    @Override
    public void removeColumn(@NotNull CharSequence name) {
        boolean timestamp;
        assert (this.txWriter.getLagRowCount() == 0);
        this.checkDistressed();
        this.checkColumnName(name);
        int index = this.getColumnIndex(name);
        int type = this.metadata.getColumnType(index);
        boolean isIndexed = this.metadata.isIndexed(index);
        CharSequence columnName = this.metadata.getColumnName(index);
        LOG.info().$("removing [column=").$safe(name).$(", path=").$substr(this.pathRootSize, this.path).I$();
        int timestampIndex = this.metadata.getTimestampIndex();
        boolean bl = timestamp = index == timestampIndex;
        if (timestamp && PartitionBy.isPartitioned(this.partitionBy)) {
            throw CairoException.nonCritical().put("cannot remove timestamp from partitioned table");
        }
        this.commit();
        this.metadata.removeColumn(index);
        if (timestamp) {
            this.metadata.clearTimestampIndex();
        }
        this.rewriteAndSwapMetadata(this.metadata);
        try {
            this.freeColumnMemory(index);
            this.removeSymbolMapWriter(index);
            if (timestamp) {
                this.txWriter.resetTimestamp();
                this.timestampSetter = value -> {};
            }
            this.removeColumnFiles(index, (String)columnName, type, isIndexed);
            this.clearTodoAndCommitMetaStructureVersion();
            this.finishColumnPurge();
            try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
                metadataRW.hydrateTable(this.metadata);
            }
            LOG.info().$("REMOVED column '").$safe(name).$('[').$(ColumnType.nameOf(type)).$("]' from ").$substr(this.pathRootSize, this.path).$();
        }
        catch (CairoError err) {
            throw err;
        }
        catch (Throwable th) {
            this.throwDistressException(th);
        }
    }

    @Override
    public boolean removePartition(long timestamp) {
        long partitionTimestamp;
        this.partitionRemoveCandidates.clear();
        if (!PartitionBy.isPartitioned(this.partitionBy)) {
            return false;
        }
        this.commit();
        long logicalPartitionTimestampToDelete = this.txWriter.getLogicalPartitionTimestamp(timestamp);
        int partitionIndex = this.txWriter.findAttachedPartitionRawIndexByLoTimestamp(logicalPartitionTimestampToDelete);
        if (partitionIndex < 0) {
            partitionIndex = -partitionIndex - 1;
        }
        partitionIndex /= 4;
        boolean dropped = false;
        while (partitionIndex < this.txWriter.getPartitionCount() && this.txWriter.getLogicalPartitionTimestamp(partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(partitionIndex)) == logicalPartitionTimestampToDelete) {
            dropped |= this.dropPartitionByExactTimestamp(partitionTimestamp);
        }
        if (dropped) {
            this.commitRemovePartitionOperation();
        }
        return dropped;
    }

    @Override
    public void renameColumn(@NotNull CharSequence name, @NotNull CharSequence newName, SecurityContext securityContext) {
        this.checkDistressed();
        this.checkColumnName(newName);
        int index = this.getColumnIndex(name);
        int type = this.metadata.getColumnType(index);
        boolean isIndexed = this.metadata.isIndexed(index);
        CharSequence columnName = this.metadata.getColumnName(index);
        LOG.info().$("renaming column '").$safe(columnName).$('[').$(ColumnType.nameOf(type)).$("]' to '").$safe(newName).$("' in ").$substr(this.pathRootSize, this.path).$();
        this.commit();
        this.metadata.renameColumn(columnName, newName);
        CharSequence newColumnName = this.metadata.getColumnName(index);
        this.rewriteAndSwapMetadata(this.metadata);
        try {
            this.clearTodoLog();
            this.hardLinkAndPurgeColumnFiles((String)columnName, index, isIndexed, newColumnName, type, false);
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        this.bumpMetadataAndColumnStructureVersion();
        this.finishColumnPurge();
        if (index == this.metadata.getTimestampIndex()) {
            this.designatedTimestampColumnName = newColumnName;
        }
        if (securityContext != null) {
            this.ddlListener.onColumnRenamed(securityContext, this.tableToken, columnName, newColumnName);
        }
        try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
            metadataRW.hydrateTable(this.metadata);
        }
        LOG.info().$("RENAMED column '").$safe(columnName).$("' to '").$safe(newColumnName).$("' from ").$substr(this.pathRootSize, this.path).$();
    }

    @Override
    public void renameTable(@NotNull CharSequence fromTableName, @NotNull CharSequence toTableName) {
        LOG.debug().$("renaming table [path=").$substr(this.pathRootSize, this.path).$(", seqTxn=").$(this.txWriter.getSeqTxn()).I$();
        try {
            TableUtils.overwriteTableNameFile(this.path, this.ddlMem, this.ff, toTableName);
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
        this.bumpColumnStructureVersion();
    }

    @Override
    public void rollback() {
        this.checkDistressed();
        if (this.o3InError || this.inTransaction()) {
            try {
                LOG.info().$("tx rollback [name=").$safe(this.tableToken.getTableName()).I$();
                this.partitionRemoveCandidates.clear();
                this.o3CommitBatchTimestampMin = Long.MAX_VALUE;
                if ((this.masterRef & 1L) != 0L) {
                    LOG.critical().$("detected line append failure, writer marked as distressed [table=").$(this.tableToken).I$();
                    this.distressed = true;
                    this.checkDistressed();
                }
                this.freeColumns(false);
                this.txWriter.unsafeLoadAll();
                this.rollbackIndexes();
                this.rollbackSymbolTables(true);
                this.columnVersionWriter.readUnsafe();
                this.closeActivePartition(false);
                this.purgeUnusedPartitions();
                this.configureAppendPosition();
                this.o3InError = false;
                this.o3MasterRef = -1L;
                LOG.info().$("tx rollback complete [table=").$(this.tableToken).I$();
                this.processCommandQueue(false);
                this.metrics.tableWriterMetrics().incrementRollbacks();
            }
            catch (Throwable e) {
                LOG.critical().$("could not perform rollback [table=").$(this.tableToken).$(", msg=").$(e).I$();
                this.distressed = true;
            }
            this.checkDistressed();
        }
    }

    public void setExtensionListener(ExtensionListener listener) {
        this.txWriter.setExtensionListener(listener);
    }

    public void setLifecycleManager(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    @Override
    public void setMatViewRefresh(int refreshType, int timerInterval, char timerUnit, long timerStart, @Nullable CharSequence timerTimeZone, int periodLength, char periodLengthUnit, int periodDelay, char periodDelayUnit) {
        assert (this.tableToken.isMatView());
        MatViewDefinition oldDefinition = this.engine.getMatViewGraph().getViewDefinition(this.tableToken);
        if (oldDefinition == null) {
            throw CairoException.nonCritical().put("could not find definition [view=").put(this.tableToken.getTableName()).put(']');
        }
        MatViewDefinition newDefinition = oldDefinition.updateRefreshParams(refreshType, timerInterval, timerUnit, timerStart, Chars.toString(timerTimeZone), periodLength, periodLengthUnit, periodDelay, periodDelayUnit);
        this.updateMatViewDefinition(newDefinition);
    }

    @Override
    public void setMatViewRefreshLimit(int limitHoursOrMonths) {
        assert (this.tableToken.isMatView());
        MatViewDefinition oldDefinition = this.engine.getMatViewGraph().getViewDefinition(this.tableToken);
        if (oldDefinition == null) {
            throw CairoException.nonCritical().put("could not find definition [view=").put(this.tableToken.getTableName()).put(']');
        }
        MatViewDefinition newDefinition = oldDefinition.updateRefreshLimit(limitHoursOrMonths);
        this.updateMatViewDefinition(newDefinition);
    }

    @Override
    public void setMatViewRefreshTimer(long start, int interval, char unit) {
        assert (this.tableToken.isMatView());
        MatViewDefinition oldDefinition = this.engine.getMatViewGraph().getViewDefinition(this.tableToken);
        if (oldDefinition == null) {
            throw CairoException.nonCritical().put("could not find definition [view=").put(this.tableToken.getTableName()).put(']');
        }
        MatViewDefinition newDefinition = oldDefinition.updateTimer(interval, unit, start);
        this.updateMatViewDefinition(newDefinition);
    }

    @Override
    public void setMetaMaxUncommittedRows(int maxUncommittedRows) {
        this.commit();
        this.metadata.setMaxUncommittedRows(maxUncommittedRows);
        this.writeMetadataToDisk();
    }

    @Override
    public void setMetaO3MaxLag(long o3MaxLagUs) {
        this.commit();
        this.metadata.setO3MaxLag(o3MaxLagUs);
        this.writeMetadataToDisk();
    }

    @Override
    public void setMetaTtl(int ttlHoursOrMonths) {
        this.commit();
        this.metadata.setTtlHoursOrMonths(ttlHoursOrMonths);
        this.writeMetadataToDisk();
    }

    public void setSeqTxn(long seqTxn) {
        assert (this.txWriter.getLagRowCount() == 0 && this.txWriter.getLagTxnCount() == 0);
        this.txWriter.setSeqTxn(seqTxn);
    }

    public long size() {
        return this.txWriter.getRowCount() + this.getO3RowCount();
    }

    public void squashAllPartitionsIntoOne() {
        this.squashSplitPartitions(0, this.txWriter.getPartitionCount(), 1, false);
    }

    @Override
    public void squashPartitions() {
        for (int i = 0; i < this.txWriter.getPartitionCount(); ++i) {
            this.squashPartitionForce(i);
        }
        if (this.isLastPartitionClosed() && !this.isEmptyTable()) {
            this.openLastPartition();
        }
    }

    @Override
    public boolean supportsMultipleWriters() {
        return false;
    }

    @Override
    public void tick() {
        this.tick(false);
    }

    public void tick(boolean contextAllowsAnyStructureChanges) {
        this.processCommandQueue(contextAllowsAnyStructureChanges);
    }

    public String toString() {
        return "TableWriter{name=" + this.tableToken.getTableName() + "}";
    }

    public void transferLock(long lockFd) {
        assert (lockFd > -1L);
        this.lockFd = lockFd;
    }

    @Override
    public final void truncate() {
        this.truncate(false);
    }

    @Override
    public final void truncateSoft() {
        this.truncate(true);
    }

    public void updateTableToken(TableToken tableToken) {
        this.tableToken = tableToken;
        this.metadata.updateTableToken(tableToken);
    }

    public void upsertColumnVersion(long partitionTimestamp, int columnIndex, long columnTop) {
        this.columnVersionWriter.upsert(partitionTimestamp, columnIndex, this.txWriter.txn, columnTop);
    }

    public void warmUp() {
        Row r = this.newRow(Math.max(0L, this.txWriter.getMaxTimestamp()));
        try {
            for (int i = 0; i < this.columnCount; ++i) {
                r.putByte(i, (byte)0);
            }
        }
        finally {
            r.cancel();
        }
    }

    private static void clearMemColumnShifts(ObjList<MemoryCARW> memColumns) {
        int n = memColumns.size();
        for (int i = 0; i < n; ++i) {
            MemoryCARW col = memColumns.get(i);
            if (col == null) continue;
            col.shiftAddressRight(0L);
        }
    }

    private static void closeRemove(FilesFacade ff, long fd, LPSZ path) {
        if (!ff.closeRemove(fd, path)) {
            throw CairoException.critical(ff.errno()).put("cannot remove ").put(path);
        }
    }

    private static void configureNullSetters(ObjList<Runnable> nullers, int columnType, MemoryA dataMem, MemoryA auxMem) {
        short columnTag = ColumnType.tagOf(columnType);
        if (ColumnType.isVarSize(columnTag)) {
            ColumnTypeDriver typeDriver = ColumnType.getDriver(columnTag);
            nullers.add(() -> typeDriver.appendNull(auxMem, dataMem));
        } else {
            switch (columnTag) {
                case 1: 
                case 2: {
                    nullers.add(() -> dataMem.putByte((byte)0));
                    break;
                }
                case 10: {
                    nullers.add(() -> dataMem.putDouble(Double.NaN));
                    break;
                }
                case 9: {
                    nullers.add(() -> dataMem.putFloat(Float.NaN));
                    break;
                }
                case 5: {
                    nullers.add(() -> dataMem.putInt(Integer.MIN_VALUE));
                    break;
                }
                case 25: {
                    nullers.add(() -> dataMem.putInt(0));
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    nullers.add(() -> dataMem.putLong(Long.MIN_VALUE));
                    break;
                }
                case 19: 
                case 24: {
                    nullers.add(() -> dataMem.putLong128(Long.MIN_VALUE, Long.MIN_VALUE));
                    break;
                }
                case 13: {
                    nullers.add(() -> dataMem.putLong256(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE));
                    break;
                }
                case 3: {
                    nullers.add(() -> dataMem.putShort((short)0));
                    break;
                }
                case 4: {
                    nullers.add(() -> dataMem.putChar('\u0000'));
                    break;
                }
                case 12: {
                    nullers.add(() -> dataMem.putInt(Integer.MIN_VALUE));
                    break;
                }
                case 14: {
                    nullers.add(() -> dataMem.putByte((byte)-1));
                    break;
                }
                case 15: {
                    nullers.add(() -> dataMem.putShort((short)-1));
                    break;
                }
                case 16: {
                    nullers.add(() -> dataMem.putInt(-1));
                    break;
                }
                case 17: {
                    nullers.add(() -> dataMem.putLong(-1L));
                    break;
                }
                default: {
                    nullers.add(NOOP);
                }
            }
        }
    }

    private static void linkFile(FilesFacade ff, LPSZ from, LPSZ to) {
        if (ff.exists(from)) {
            if (ff.hardLink(from, to) == 0) {
                LOG.debug().$("renamed [from=").$(from).$(", to=").$(to).I$();
                return;
            }
            if (ff.exists(to)) {
                LOG.info().$("rename destination file exists, assuming previously failed rename attempt [path=").$(to).I$();
                try {
                    ff.remove(to);
                }
                catch (CairoException e) {
                    if (Os.isWindows() && ff.errno() == 5) {
                        LOG.info().$("cannot delete file to create link with the same name, assuming already correctly linked [path=").$(to).$(", linkSrc=").$(from).I$();
                        return;
                    }
                    throw e;
                }
                if (ff.hardLink(from, to) == 0) {
                    LOG.debug().$("renamed [from=").$(from).$(", to=").$(to).I$();
                    return;
                }
            }
            throw CairoException.critical(ff.errno()).put("could not create hard link [errno=").put(ff.errno()).put(", from=").put(from).put(", to=").put(to).put(']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static ColumnVersionWriter openColumnVersionFile(CairoConfiguration configuration, Path path, int rootLen, boolean partitioned) {
        path.concat("_cv");
        try {
            ColumnVersionWriter columnVersionWriter = new ColumnVersionWriter(configuration, path.$(), partitioned);
            return columnVersionWriter;
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openMetaFile(FilesFacade ff, Path path, int rootLen, MemoryMR ddlMem, TableWriterMetadata metadata) {
        path.concat("_meta");
        try (MemoryMR memoryMR = ddlMem;){
            ddlMem.smallFile(ff, path.$(), 12);
            metadata.reload(ddlMem);
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    private static void removeFileOrLog(FilesFacade ff, LPSZ name) {
        if (!ff.removeQuiet(name)) {
            LOG.error().$("could not remove [errno=").$(ff.errno()).$(", file=").$(name).I$();
        }
    }

    private void addColumnToMeta(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isDedupKey, long columnNameTxn, int replaceColumnIndex, TableWriterMetadata metadata) {
        int prevReplaceColumnIndex = replaceColumnIndex;
        while (prevReplaceColumnIndex > -1) {
            replaceColumnIndex = prevReplaceColumnIndex;
            prevReplaceColumnIndex = metadata.getReplacingColumnIndex(replaceColumnIndex);
        }
        metadata.addColumn(columnName, columnType, isIndexed, indexValueBlockCapacity, metadata.getColumnCount(), symbolCapacity, isDedupKey, replaceColumnIndex, symbolCacheFlag);
        this.rewriteAndSwapMetadata(metadata);
        if (replaceColumnIndex < 0) {
            if (ColumnType.isSymbol(columnType)) {
                try {
                    this.createSymbolMapWriter(columnName, columnNameTxn, symbolCapacity, symbolCacheFlag);
                }
                catch (CairoException e) {
                    try {
                        this.recoverFromSymbolMapWriterFailure(columnName);
                    }
                    catch (CairoException e2) {
                        LOG.error().$("DOUBLE ERROR: 1st: {").$(e).$('}').$();
                        this.throwDistressException(e2);
                    }
                    throw e;
                }
            }
            this.symbolMapWriters.extendAndSet(this.columnCount, NullMapWriter.INSTANCE);
        }
        this.configureColumn(columnType, isIndexed, this.columnCount);
        if (isIndexed) {
            this.populateDenseIndexerList();
        }
        ++this.columnCount;
    }

    private void appendBuffer(long fd, long address, long len) {
        if (this.ff.append(fd, address, len) != len) {
            throw CairoException.critical(this.ff.errno()).put("cannot append data [fd=").put(fd).put(", len=").put(len).put(']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long applyFromWalLagToLastPartition(long commitToTimestamp, boolean allowPartial) {
        long lagMinTimestamp = this.txWriter.getLagMinTimestamp();
        if (!this.isCommitDedupMode() && this.txWriter.getLagRowCount() > 0 && this.txWriter.isLagOrdered() && this.txWriter.getMaxTimestamp() <= lagMinTimestamp && this.txWriter.getPartitionTimestampByTimestamp(lagMinTimestamp) == this.lastPartitionTimestamp) {
            long lagMaxTimestamp = this.txWriter.getLagMaxTimestamp();
            if (lagMaxTimestamp <= (commitToTimestamp = Math.min(commitToTimestamp, this.partitionTimestampHi))) {
                LOG.debug().$("fast apply full lag to last partition [table=").$(this.tableToken).I$();
                this.applyLagToLastPartition(lagMaxTimestamp, this.txWriter.getLagRowCount(), Long.MAX_VALUE);
                this.txWriter.setSeqTxn(this.txWriter.getSeqTxn() + (long)this.txWriter.getLagTxnCount());
                this.txWriter.setLagTxnCount(0);
                this.txWriter.setLagRowCount(0);
                return lagMaxTimestamp;
            }
            if (allowPartial && lagMinTimestamp <= commitToTimestamp) {
                long lagRows = this.txWriter.getLagRowCount();
                long timestampMapOffset = this.txWriter.getTransientRowCount() * 8L;
                long timestampMapSize = lagRows * 8L;
                long timestampMaAddr = this.mapAppendColumnBuffer(this.getPrimaryColumn(this.metadata.getTimestampIndex()), timestampMapOffset, timestampMapSize, false);
                try {
                    long timestampAddr = Math.abs(timestampMaAddr);
                    long binarySearchInsertionPoint = Vect.binarySearch64Bit(timestampAddr, commitToTimestamp, 0L, lagRows - 1L, 1);
                    long applyCount = binarySearchInsertionPoint < 0L ? -binarySearchInsertionPoint - 1L : binarySearchInsertionPoint + 1L;
                    long newMinLagTimestamp = Unsafe.getUnsafe().getLong(timestampAddr + applyCount * 8L);
                    long newMaxTimestamp = Unsafe.getUnsafe().getLong(timestampAddr + (applyCount - 1L) * 8L);
                    assert (newMinLagTimestamp > commitToTimestamp && commitToTimestamp >= newMaxTimestamp);
                    this.applyLagToLastPartition(newMaxTimestamp, (int)applyCount, newMinLagTimestamp);
                    LOG.debug().$("partial apply lag to last partition [table=").$(this.tableToken).$(" ,lagSize=").$(lagRows).$(" ,rowApplied=").$(applyCount).$(", commitToTimestamp=").$(commitToTimestamp).$(", newMaxTimestamp=").$(newMaxTimestamp).$(", newMinLagTimestamp=").$(newMinLagTimestamp).I$();
                    long l = newMaxTimestamp;
                    return l;
                }
                finally {
                    this.mapAppendColumnBufferRelease(timestampMaAddr, timestampMapOffset, timestampMapSize);
                }
            }
        }
        return Long.MIN_VALUE;
    }

    private boolean applyFromWalLagToLastPartitionPossible(long commitToTimestamp, long lagRowCount, boolean lagOrdered, long committedMaxTimestamp, long lagMinTimestamp, long lagMaxTimestamp) {
        return !this.isCommitDedupMode() && lagRowCount > 0L && lagOrdered && committedMaxTimestamp <= lagMinTimestamp && this.txWriter.getPartitionTimestampByTimestamp(lagMinTimestamp) == this.lastPartitionTimestamp && lagMaxTimestamp <= Math.min(commitToTimestamp, this.partitionTimestampHi);
    }

    private void applyLagToLastPartition(long maxTimestamp, int lagRowCount, long lagMinTimestamp) {
        long initialTransientRowCount = this.txWriter.transientRowCount;
        this.txWriter.transientRowCount += (long)lagRowCount;
        this.txWriter.updatePartitionSizeByTimestamp(this.lastPartitionTimestamp, this.txWriter.transientRowCount);
        this.txWriter.setMinTimestamp(Math.min(this.txWriter.getMinTimestamp(), this.txWriter.getLagMinTimestamp()));
        this.txWriter.setLagMinTimestamp(lagMinTimestamp);
        if (this.txWriter.getLagRowCount() == lagRowCount) {
            this.txWriter.setLagMaxTimestamp(Long.MIN_VALUE);
        }
        this.txWriter.setLagRowCount(this.txWriter.getLagRowCount() - lagRowCount);
        this.txWriter.setMaxTimestamp(maxTimestamp);
        if (this.indexCount > 0) {
            long newTransientRowCount = this.txWriter.getTransientRowCount();
            int shl = ColumnType.pow2SizeOf(12);
            int n = this.metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (this.metadata.getColumnType(i) != 12 || !this.metadata.isColumnIndexed(i)) continue;
                this.getPrimaryColumn(i).jumpTo(newTransientRowCount << shl);
            }
            this.updateIndexesParallel(initialTransientRowCount, newTransientRowCount);
        }
        long partitionTruncateRowCount = this.txWriter.getTransientRowCount();
        this.setAppendPosition(partitionTruncateRowCount, false);
    }

    private boolean assertColumnPositionIncludeWalLag() {
        return this.txWriter.getLagRowCount() == 0 || this.columns.get(TableWriter.getPrimaryColumnIndex(this.metadata.getTimestampIndex())).getAppendOffset() == (this.txWriter.getTransientRowCount() + (long)this.txWriter.getLagRowCount()) * 8L;
    }

    private void attachPartitionCheckFilesMatchFixedColumn(int columnType, long partitionSize, long columnTop, String columnName, long columnNameTxn, Path partitionPath, long partitionTimestamp, int columnIndex) {
        long columnSize = partitionSize - columnTop;
        if (columnSize == 0L) {
            return;
        }
        TableUtils.dFile(partitionPath, columnName, columnNameTxn);
        if (!this.ff.exists(partitionPath.$())) {
            LOG.info().$("attaching partition with missing column [path=").$substr(this.pathRootSize, partitionPath).I$();
            this.columnVersionWriter.upsertColumnTop(partitionTimestamp, columnIndex, partitionSize);
        } else {
            long fileSize = this.ff.length(partitionPath.$());
            if (fileSize < columnSize << ColumnType.pow2SizeOf(columnType)) {
                throw CairoException.critical(0).put("Column file is too small. ").put("Partition files inconsistent [file=").put(partitionPath).put(", expectedSize=").put(columnSize << ColumnType.pow2SizeOf(columnType)).put(", actual=").put(fileSize).put(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachPartitionCheckFilesMatchVarSizeColumn(long partitionSize, long columnTop, String columnName, long columnNameTxn, Path partitionPath, long partitionTimestamp, int columnIndex, int columnType) throws CairoException {
        block12: {
            long columnSize = partitionSize - columnTop;
            if (columnSize == 0L) {
                return;
            }
            int pathLen = partitionPath.size();
            TableUtils.iFile(partitionPath, columnName, columnNameTxn);
            long indexLength = this.ff.length(partitionPath.$());
            if (indexLength > 0L) {
                long indexFd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
                try {
                    long fileSize = this.ff.length(indexFd);
                    ColumnTypeDriver driver = ColumnType.getDriver(columnType);
                    long expectedFileSize = driver.getAuxVectorSize(columnSize);
                    if (fileSize < expectedFileSize) {
                        throw CairoException.critical(0).put("Column file is too small. ").put("Partition files inconsistent [file=").put(partitionPath).put(",expectedSize=").put(expectedFileSize).put(",actual=").put(fileSize).put(']');
                    }
                    long mappedAddr = TableUtils.mapRO(this.ff, indexFd, expectedFileSize, 0);
                    try {
                        long dataLength;
                        partitionPath.trimTo(pathLen);
                        TableUtils.dFile(partitionPath, columnName, columnNameTxn);
                        long prevDataAddress = dataLength = this.ff.length(partitionPath.$());
                        for (long row = columnSize - 1L; row >= 0L; --row) {
                            long dataAddress = driver.getDataVectorOffset(mappedAddr, row);
                            if (dataAddress < 0L || dataAddress > dataLength) {
                                throw CairoException.critical(0).put("Variable size column has invalid data address value [path=").put(this.path).put(", row=").put(row).put(", dataAddress=").put(dataAddress).put(", dataFileSize=").put(dataLength).put(']');
                            }
                            if (dataAddress > prevDataAddress) {
                                throw CairoException.critical(0).put("Variable size column has invalid data address value [path=").put(partitionPath).put(", row=").put(row).put(", dataAddress=").put(dataAddress).put(", prevDataAddress=").put(prevDataAddress).put(", dataFileSize=").put(dataLength).put(']');
                            }
                            prevDataAddress = dataAddress;
                        }
                        break block12;
                    }
                    finally {
                        this.ff.munmap(mappedAddr, expectedFileSize, 0);
                    }
                }
                finally {
                    this.ff.close(indexFd);
                }
            }
            LOG.info().$("attaching partition with missing column [path=").$(partitionPath).I$();
            this.columnVersionWriter.upsertColumnTop(partitionTimestamp, columnIndex, partitionSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachPartitionCheckSymbolColumn(long partitionSize, long columnTop, String columnName, long columnNameTxn, Path partitionPath, long partitionTimestamp, int columnIndex) {
        long columnSize = partitionSize - columnTop;
        if (columnSize == 0L) {
            return;
        }
        int pathLen = partitionPath.size();
        TableUtils.dFile(partitionPath, columnName, columnNameTxn);
        if (!this.ff.exists(partitionPath.$())) {
            this.columnVersionWriter.upsertColumnTop(partitionTimestamp, columnIndex, partitionSize);
            return;
        }
        long fd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
        try {
            long fileSize = this.ff.length(fd);
            int typeSize = 4;
            long expectedSize = columnSize * (long)typeSize;
            if (fileSize < expectedSize) {
                throw CairoException.critical(0).put("Column file is too small. ").put("Partition files inconsistent [file=").put(partitionPath).put(", expectedSize=").put(expectedSize).put(", actual=").put(fileSize).put(']');
            }
            long address = TableUtils.mapRO(this.ff, fd, fileSize, 0);
            try {
                int maxKey = Vect.maxInt(address, columnSize);
                int symbolValues = this.symbolMapWriters.getQuick(columnIndex).getSymbolCount();
                if (maxKey >= symbolValues) {
                    throw CairoException.critical(0).put("Symbol file does not match symbol column [file=").put(this.path).put(", key=").put(maxKey).put(", columnKeys=").put(symbolValues).put(']');
                }
                int minKey = Vect.minInt(address, columnSize);
                if (minKey != Integer.MIN_VALUE && minKey < 0) {
                    throw CairoException.critical(0).put("Symbol file does not match symbol column, invalid key [file=").put(this.path).put(", key=").put(minKey).put(']');
                }
            }
            finally {
                this.ff.munmap(address, fileSize, 0);
            }
            if (this.metadata.isColumnIndexed(columnIndex)) {
                BitmapIndexUtils.valueFileName(partitionPath.trimTo(pathLen), columnName, columnNameTxn);
                if (!this.ff.exists(partitionPath.$())) {
                    throw CairoException.fileNotFound().put("Symbol index value file does not exist [file=").put(partitionPath).put(']');
                }
                BitmapIndexUtils.keyFileName(partitionPath.trimTo(pathLen), columnName, columnNameTxn);
                if (!this.ff.exists(partitionPath.$())) {
                    throw CairoException.fileNotFound().put("Symbol index key file does not exist [file=").put(partitionPath).put(']');
                }
            }
        }
        finally {
            this.ff.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attachPrepare(long partitionTimestamp, long partitionSize, Path detachedPath, int detachedPartitionRoot) {
        try {
            detachedPath.trimTo(detachedPartitionRoot).concat("_meta");
            if (!this.ff.exists(detachedPath.$())) {
                LOG.info().$("detached ").$("_meta").$(" file not found, skipping check [path=").$(detachedPath).I$();
                boolean bl = false;
                return bl;
            }
            if (this.attachMetadata == null) {
                this.attachMetaMem = Vm.getCMRInstance();
                this.attachMetadata = new TableWriterMetadata(this.tableToken);
            }
            this.attachMetaMem.smallFile(this.ff, detachedPath.$(), 12);
            this.attachMetadata.reload(this.attachMetaMem);
            if (this.metadata.getTableId() != this.attachMetadata.getTableId()) {
                throw CairoException.detachedMetadataMismatch("table_id");
            }
            if (this.metadata.getTimestampIndex() != this.attachMetadata.getTimestampIndex()) {
                throw CairoException.detachedMetadataMismatch("timestamp_index");
            }
            detachedPath.trimTo(detachedPartitionRoot).concat("_cv").$();
            if (!this.ff.exists(detachedPath.$())) {
                LOG.error().$("detached _dcv file not found, skipping check [path=").$(detachedPath).I$();
                boolean bl = false;
                return bl;
            }
            if (this.attachColumnVersionReader == null) {
                this.attachColumnVersionReader = new ColumnVersionReader();
            }
            this.attachColumnVersionReader.ofRO(this.ff, detachedPath.$());
            this.attachColumnVersionReader.readUnsafe();
            this.columnVersionWriter.overrideColumnVersions(partitionTimestamp, this.attachColumnVersionReader);
            for (int colIdx = 0; colIdx < this.columnCount; ++colIdx) {
                int attachColType;
                CharSequence columnName = this.metadata.getColumnName(colIdx);
                int detColIdx = this.attachMetadata.getColumnIndexQuiet(columnName);
                if (detColIdx == -1) {
                    this.columnVersionWriter.upsertColumnTop(partitionTimestamp, colIdx, partitionSize);
                    continue;
                }
                if (detColIdx != colIdx) {
                    throw CairoException.detachedColumnMetadataMismatch(colIdx, columnName, "name");
                }
                int tableColType = this.metadata.getColumnType(colIdx);
                if (tableColType != (attachColType = this.attachMetadata.getColumnType(detColIdx)) && tableColType != -attachColType) {
                    throw CairoException.detachedColumnMetadataMismatch(colIdx, columnName, "type");
                }
                if (tableColType != attachColType) {
                    LOG.info().$("detached partition has column deleted while the table has the same column alive [tableName=").$safe(this.tableToken.getTableName()).$(", column=").$safe(columnName).$(", columnType=").$(ColumnType.nameOf(tableColType)).I$();
                    this.columnVersionWriter.upsertColumnTop(partitionTimestamp, colIdx, partitionSize);
                }
                if (!ColumnType.isSymbol(tableColType)) continue;
                boolean isIndexedNow = this.metadata.isColumnIndexed(colIdx);
                boolean wasIndexedAtDetached = this.attachMetadata.isColumnIndexed(detColIdx);
                int indexValueBlockCapacityNow = this.metadata.getIndexValueBlockCapacity(colIdx);
                int indexValueBlockCapacityDetached = this.attachMetadata.getIndexValueBlockCapacity(detColIdx);
                if (!isIndexedNow && wasIndexedAtDetached) {
                    long columnNameTxn = this.attachColumnVersionReader.getColumnNameTxn(partitionTimestamp, colIdx);
                    BitmapIndexUtils.keyFileName(detachedPath.trimTo(detachedPartitionRoot), columnName, columnNameTxn);
                    TableWriter.removeFileOrLog(this.ff, detachedPath.$());
                    BitmapIndexUtils.valueFileName(detachedPath.trimTo(detachedPartitionRoot), columnName, columnNameTxn);
                    TableWriter.removeFileOrLog(this.ff, detachedPath.$());
                    continue;
                }
                if (!isIndexedNow || wasIndexedAtDetached && indexValueBlockCapacityNow == indexValueBlockCapacityDetached) continue;
                detachedPath.trimTo(detachedPartitionRoot);
                this.rebuildAttachedPartitionColumnIndex(partitionTimestamp, partitionSize, columnName);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Misc.free(this.attachColumnVersionReader);
            Misc.free(this.attachMetaMem);
            Misc.free(this.attachIndexBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachValidateMetadata(long partitionSize, Path partitionPath, long partitionTimestamp) throws CairoException {
        int rootLen = partitionPath.size();
        int size = this.metadata.getColumnCount();
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            try {
                long columnTop;
                CharSequence columnName = this.metadata.getColumnName(columnIndex);
                int columnType = this.metadata.getColumnType(columnIndex);
                if ((long)columnType <= -1L || (columnTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, columnIndex)) < 0L || columnTop == partitionSize) continue;
                long columnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(columnIndex);
                short type = ColumnType.tagOf(columnType);
                if (ColumnType.isSymbol(type)) {
                    this.attachPartitionCheckSymbolColumn(partitionSize, columnTop, (String)columnName, columnNameTxn, partitionPath, partitionTimestamp, columnIndex);
                    continue;
                }
                if (ColumnType.isVarSize(type)) {
                    this.attachPartitionCheckFilesMatchVarSizeColumn(partitionSize, columnTop, (String)columnName, columnNameTxn, partitionPath, partitionTimestamp, columnIndex, columnType);
                    continue;
                }
                if (ColumnType.isFixedSize(type)) {
                    this.attachPartitionCheckFilesMatchFixedColumn(columnType, partitionSize, columnTop, (String)columnName, columnNameTxn, partitionPath, partitionTimestamp, columnIndex);
                    continue;
                }
                if ($assertionsDisabled) continue;
                throw new AssertionError();
            }
            finally {
                partitionPath.trimTo(rootLen);
            }
        }
    }

    private void bumpColumnStructureVersion() {
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.bumpColumnStructureVersion(this.denseSymbolMapWriters);
        assert ((long)this.txWriter.getMetadataVersion() == this.metadata.getMetadataVersion());
    }

    private void bumpMasterRef() {
        if ((this.masterRef & 1L) == 0L) {
            ++this.masterRef;
        } else {
            this.cancelRowAndBump();
        }
    }

    private void bumpMetadataAndColumnStructureVersion() {
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.bumpMetadataAndColumnStructureVersion(this.denseSymbolMapWriters);
        assert ((long)this.txWriter.getMetadataVersion() == this.metadata.getMetadataVersion());
    }

    private void bumpMetadataVersion() {
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.bumpMetadataVersion(this.denseSymbolMapWriters);
        assert ((long)this.txWriter.getMetadataVersion() == this.metadata.getMetadataVersion());
    }

    private int calculateInsertTransactionBlock(long seqTxn, TableWriterPressureControl pressureControl) {
        if (this.txWriter.getLagRowCount() > 0) {
            pressureControl.updateInflightTxnBlockLength(1L, Math.max(1L, this.walTxnDetails.getSegmentRowHi(seqTxn) - this.walTxnDetails.getSegmentRowLo(seqTxn)));
            return 1;
        }
        return this.walTxnDetails.calculateInsertTransactionBlock(seqTxn, pressureControl, this.getWalMaxLagRows());
    }

    private boolean canSquashOverwritePartitionTail(int partitionIndex) {
        long fromTxn = this.txWriter.getPartitionNameTxn(partitionIndex);
        if (fromTxn < 0L) {
            fromTxn = 0L;
        }
        long toTxn = this.txWriter.getTxn();
        if (partitionIndex + 1 < this.txWriter.getPartitionCount() && this.txWriter.getLogicalPartitionTimestamp(this.txWriter.getPartitionTimestampByIndex(partitionIndex)) == this.txWriter.getLogicalPartitionTimestamp(this.txWriter.getPartitionTimestampByIndex(partitionIndex + 1))) {
            toTxn = Math.max(fromTxn + 1L, this.getPartitionNameTxn(partitionIndex + 1) + 1L);
        }
        return this.txnScoreboard.isRangeAvailable(fromTxn, toTxn);
    }

    private void cancelRowAndBump() {
        this.rowCancel();
        ++this.masterRef;
    }

    private void checkColumnName(CharSequence name) {
        if (!TableUtils.isValidColumnName(name, this.configuration.getMaxFileNameLength())) {
            throw CairoException.nonCritical().put("invalid column name [table=").put(this.tableToken.getTableName()).put(", column=").putAsPrintable(name).put(']');
        }
    }

    private void checkDistressed() {
        if (!this.distressed) {
            return;
        }
        throw new CairoError("Table '" + this.tableToken.getTableName() + "' is distressed");
    }

    private void checkO3Errors() {
        if (this.o3ErrorCount.get() > 0) {
            if (this.lastErrno == 0x7FFFFFFE) {
                this.distressed = true;
                throw new CairoError("commit failed with fatal error, see logs for details [table=" + this.tableToken.getTableName() + ", tableDir=" + this.tableToken.getDirName() + "]");
            }
            throw CairoException.critical(this.lastErrno).setOutOfMemory(this.o3oomObserved).put("commit failed, see logs for details [table=").put(this.tableToken.getTableName()).put(", tableDir=").put(this.tableToken.getDirName()).put(']');
        }
    }

    private void clearMemColumnShifts() {
        TableWriter.clearMemColumnShifts(this.o3MemColumns1);
        TableWriter.clearMemColumnShifts(this.o3MemColumns2);
        this.memColumnShifted = false;
    }

    private void clearO3() {
        this.o3MasterRef = -1L;
        this.rowAction = 4;
        this.activeColumns = this.columns;
        this.activeNullSetters = this.nullSetters;
    }

    private void clearTodoAndCommitMeta() {
        try {
            this.clearTodoLog();
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        this.bumpMetadataVersion();
    }

    private void clearTodoAndCommitMetaStructureVersion() {
        try {
            this.clearTodoLog();
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        this.bumpMetadataAndColumnStructureVersion();
    }

    private void clearTodoLog() {
        try {
            this.todoMem.putLong(0L, ++this.todoTxn);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(8L, 0L);
            this.todoMem.putLong(16L, 0L);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(32L, 0L);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(24L, this.todoTxn);
            this.todoMem.jumpTo(40L);
            this.todoMem.sync(false);
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
    }

    private void closeAppendMemoryTruncate(boolean truncate) {
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            MemoryMA m = this.columns.getQuick(i);
            if (m == null) continue;
            m.close(truncate);
        }
    }

    private void commit(long o3MaxLag) {
        this.checkDistressed();
        this.physicallyWrittenRowsSinceLastCommit.set(0L);
        if (this.o3InError) {
            this.rollback();
            return;
        }
        if ((this.masterRef & 1L) != 0L) {
            this.rowCancel();
        }
        if (this.inTransaction()) {
            boolean o3 = this.hasO3();
            if (o3) {
                boolean noop = this.o3Commit(o3MaxLag);
                if (noop) {
                    this.committedMasterRef = this.masterRef;
                    return;
                }
                if (o3MaxLag > 0L && this.reconcileOptimisticPartitions()) {
                    this.lastPartitionTimestamp = this.txWriter.getLastPartitionTimestamp();
                    this.partitionTimestampHi = this.txWriter.getNextPartitionTimestamp(this.txWriter.getMaxTimestamp()) - 1L;
                    this.openLastPartition();
                }
            } else if (this.noOpRowCount > 0L) {
                LOG.critical().$("o3 ignoring write on read-only partition [table=").$(this.tableToken).$(", timestamp=").$ts(this.lastOpenPartitionTs).$(", numRows=").$(this.noOpRowCount).$();
            }
            long committedRowCount = this.txWriter.unsafeCommittedFixedRowCount() + this.txWriter.unsafeCommittedTransientRowCount();
            long rowsAdded = this.txWriter.getRowCount() - committedRowCount;
            this.commit00();
            this.housekeep();
            this.metrics.tableWriterMetrics().addCommittedRows(rowsAdded);
            if (!o3) {
                this.addPhysicallyWrittenRows(rowsAdded);
            }
            this.noOpRowCount = 0L;
            LOG.debug().$("table ranges after the commit [table=").$(this.tableToken).$(", minTs=").$ts(this.txWriter.getMinTimestamp()).$(", maxTs=").$ts(this.txWriter.getMaxTimestamp()).I$();
        }
    }

    private void commit00() {
        this.updateIndexes();
        this.syncColumns();
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.commit(this.denseSymbolMapWriters);
        this.committedMasterRef = this.masterRef;
    }

    private void commitRemovePartitionOperation() {
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.commit(this.denseSymbolMapWriters);
        this.processPartitionRemoveCandidates();
    }

    private void configureAppendPosition() {
        boolean partitioned = PartitionBy.isPartitioned(this.partitionBy);
        if (this.txWriter.getMaxTimestamp() > Long.MIN_VALUE || !partitioned) {
            this.initLastPartition(this.txWriter.getMaxTimestamp());
            if (partitioned) {
                this.partitionTimestampHi = this.txWriter.getNextPartitionTimestamp(this.txWriter.getMaxTimestamp()) - 1L;
                this.rowAction = 0;
                this.timestampSetter = this.appendTimestampSetter;
            } else if (this.metadata.getTimestampIndex() < 0) {
                this.rowAction = 2;
            } else {
                this.rowAction = 1;
                this.timestampSetter = this.appendTimestampSetter;
            }
        } else {
            this.rowAction = 0;
            this.timestampSetter = this.appendTimestampSetter;
        }
        this.activeColumns = this.columns;
        this.activeNullSetters = this.nullSetters;
    }

    private void configureColumn(int type, boolean indexFlag, int index) {
        MemoryCARW o3AuxMem2;
        MemoryCARW o3AuxMem1;
        MemoryMAR auxMem;
        MemoryCARW o3DataMem2;
        MemoryCARW o3DataMem1;
        MemoryMAR dataMem;
        if (type > 0) {
            dataMem = Vm.getPMARInstance(this.configuration);
            o3DataMem1 = Vm.getCARWInstance(this.o3ColumnMemorySize, this.configuration.getO3MemMaxPages(), 45);
            o3DataMem2 = Vm.getCARWInstance(this.o3ColumnMemorySize, this.configuration.getO3MemMaxPages(), 45);
            if (ColumnType.isVarSize(type)) {
                auxMem = Vm.getPMARInstance(this.configuration);
                o3AuxMem1 = Vm.getCARWInstance(this.o3ColumnMemorySize, this.configuration.getO3MemMaxPages(), 45);
                o3AuxMem2 = Vm.getCARWInstance(this.o3ColumnMemorySize, this.configuration.getO3MemMaxPages(), 45);
            } else {
                auxMem = null;
                o3AuxMem1 = null;
                o3AuxMem2 = null;
            }
        } else {
            auxMem = NullMemory.INSTANCE;
            dataMem = auxMem;
            o3DataMem2 = o3AuxMem2 = NullMemory.INSTANCE;
            o3AuxMem1 = o3AuxMem2;
            o3DataMem1 = o3AuxMem2;
        }
        int baseIndex = TableWriter.getPrimaryColumnIndex(index);
        this.columns.extendAndSet(baseIndex, dataMem);
        this.columns.extendAndSet(baseIndex + 1, auxMem);
        this.o3MemColumns1.extendAndSet(baseIndex, o3DataMem1);
        this.o3MemColumns1.extendAndSet(baseIndex + 1, o3AuxMem1);
        this.o3MemColumns2.extendAndSet(baseIndex, o3DataMem2);
        this.o3MemColumns2.extendAndSet(baseIndex + 1, o3AuxMem2);
        TableWriter.configureNullSetters(this.nullSetters, type, dataMem, auxMem);
        TableWriter.configureNullSetters(this.o3NullSetters1, type, o3DataMem1, o3AuxMem1);
        TableWriter.configureNullSetters(this.o3NullSetters2, type, o3DataMem2, o3AuxMem2);
        if (indexFlag && type > 0) {
            this.indexers.extendAndSet(index, new SymbolColumnIndexer(this.configuration));
        }
        this.rowValueIsNotNull.add(0L);
    }

    private void configureColumnMemory() {
        int timestampIndex;
        this.symbolMapWriters.setPos(this.columnCount);
        int dedupColCount = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.metadata.getColumnType(i);
            this.configureColumn(type, this.metadata.isColumnIndexed(i), i);
            if (type <= -1) continue;
            if (ColumnType.isSymbol(type)) {
                int symbolIndex = this.denseSymbolMapWriters.size();
                long columnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(i);
                SymbolMapWriter symbolMapWriter = new SymbolMapWriter(this.configuration, this.path.trimTo(this.pathSize), this.metadata.getColumnName(i), columnNameTxn, this.txWriter.getSymbolValueCount(symbolIndex), symbolIndex, this.txWriter);
                this.symbolMapWriters.extendAndSet(i, symbolMapWriter);
                this.denseSymbolMapWriters.add(symbolMapWriter);
            }
            if (!this.metadata.isDedupKey(i)) continue;
            ++dedupColCount;
        }
        if (this.isDeduplicationEnabled()) {
            this.dedupColumnCommitAddresses = new DedupColumnCommitAddresses();
            this.dedupColumnCommitAddresses.setDedupColumnCount(dedupColCount - 1);
        }
        if ((timestampIndex = this.metadata.getTimestampIndex()) != -1) {
            this.o3TimestampMem = this.o3MemColumns1.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
            this.o3TimestampMemCpy = this.o3MemColumns2.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
        }
    }

    private void configureTimestampSetter() {
        int index = this.metadata.getTimestampIndex();
        if (index == -1) {
            this.timestampSetter = value -> {};
        } else {
            this.nullSetters.setQuick(index, NOOP);
            this.o3NullSetters1.setQuick(index, NOOP);
            this.o3NullSetters2.setQuick(index, NOOP);
            this.timestampSetter = this.getPrimaryColumn(index)::putLong;
        }
    }

    private void consumeColumnTasks(RingQueue<ColumnTask> queue, int queuedCount) {
        MCSequence subSeq = this.messageBus.getColumnTaskSubSeq();
        TableWriter.consumeColumnTasks0(queue, queuedCount, subSeq, this.o3DoneLatch);
        this.checkO3Errors();
    }

    private int copyOverwrite(Path to) {
        int res = this.ff.copy(this.other.$(), to.$());
        if (Os.isWindows() && res == -1 && this.ff.errno() == 80) {
            if (!this.ff.removeQuiet(to.$())) {
                return -1;
            }
            return this.ff.copy(this.other.$(), to.$());
        }
        return res;
    }

    private void copyPartitionIndexFiles(long partitionTimestamp, int partitionDirLen, int newPartitionDirLen) {
        try {
            int columnCount = this.metadata.getColumnCount();
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                long columnTop;
                CharSequence columnName = this.metadata.getColumnName(columnIndex);
                if (!ColumnType.isSymbol(this.metadata.getColumnType(columnIndex)) || !this.metadata.isIndexed(columnIndex) || (columnTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, columnIndex)) == -1L) continue;
                long columnNameTxn = this.getColumnNameTxn(partitionTimestamp, columnIndex);
                BitmapIndexUtils.keyFileName(this.path.trimTo(partitionDirLen), columnName, columnNameTxn);
                BitmapIndexUtils.keyFileName(this.other.trimTo(newPartitionDirLen), columnName, columnNameTxn);
                if (this.ff.copy(this.path.$(), this.other.$()) < 0) {
                    throw CairoException.critical(this.ff.errno()).put("could not copy index key file [table=").put(this.tableToken.getTableName()).put(", column=").put(columnName).put(']');
                }
                BitmapIndexUtils.valueFileName(this.path.trimTo(partitionDirLen), columnName, columnNameTxn);
                BitmapIndexUtils.valueFileName(this.other.trimTo(newPartitionDirLen), columnName, columnNameTxn);
                if (this.ff.copy(this.path.$(), this.other.$()) >= 0) continue;
                throw CairoException.critical(this.ff.errno()).put("could not copy index value file [table=").put(this.tableToken.getTableName()).put(", column=").put(columnName).put(']');
            }
        }
        catch (CairoException e) {
            LOG.error().$("could not copy index files [table=").$safe(this.tableToken.getTableName()).$(", partition=").$ts(partitionTimestamp).$(", error=").$safe(e.getMessage()).I$();
            if (!this.ff.rmdir(this.other.trimTo(newPartitionDirLen).slash())) {
                LOG.error().$("could not remove partition dir [path=").$(this.other).I$();
            }
            throw e;
        }
        finally {
            this.path.trimTo(this.pathSize);
            this.other.trimTo(this.pathSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexFiles(CharSequence columnName, long columnNameTxn, int indexValueBlockCapacity, int plen, boolean force) {
        try {
            BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn);
            if (!force && this.ff.exists(this.path.$())) {
                return;
            }
            this.ff.removeQuiet(this.path.$());
            try {
                this.ddlMem.smallFile(this.ff, this.path.$(), 12);
                this.ddlMem.truncate();
                BitmapIndexWriter.initKeyMemory(this.ddlMem, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                LOG.error().$("could not create index [name=").$(this.path).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                if (!this.ff.removeQuiet(this.path.$())) {
                    LOG.critical().$("could not remove '").$(this.path).$("'. Please remove MANUALLY.").$("[errno=").$(this.ff.errno()).I$();
                }
                throw e;
            }
            finally {
                this.ddlMem.close();
            }
            if (!this.ff.touch(BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn))) {
                LOG.error().$("could not create index [name=").$(this.path).$(", errno=").$(this.ff.errno()).I$();
                throw CairoException.critical(this.ff.errno()).put("could not create index [name=").put(this.path).put(']');
            }
        }
        finally {
            this.path.trimTo(plen);
        }
    }

    private void createSymbolMapWriter(CharSequence name, long columnNameTxn, int symbolCapacity, boolean symbolCacheFlag) {
        MapWriter.createSymbolMapFiles(this.ff, this.ddlMem, this.path, name, columnNameTxn, symbolCapacity, symbolCacheFlag);
        SymbolMapWriter w = new SymbolMapWriter(this.configuration, this.path, name, columnNameTxn, 0, this.denseSymbolMapWriters.size(), this.txWriter);
        try {
            w.truncate();
        }
        catch (Throwable t) {
            w.close();
            throw t;
        }
        this.denseSymbolMapWriters.add(w);
        this.symbolMapWriters.extendAndSet(this.columnCount, w);
    }

    private boolean createWalSymbolMapping(SymbolMapDiff symbolMapDiff, int columnIndex, IntList symbolMap) {
        SymbolMapDiffEntry entry;
        int cleanSymbolCount = symbolMapDiff.getCleanSymbolCount();
        symbolMap.setPos(symbolMapDiff.getRecordCount());
        symbolMap.setAll(symbolMapDiff.getRecordCount(), -1);
        MapWriter mapWriter = this.symbolMapWriters.get(columnIndex);
        boolean identical = true;
        if (symbolMapDiff.hasNullValue()) {
            mapWriter.updateNullFlag(true);
        }
        while ((entry = symbolMapDiff.nextEntry()) != null) {
            CharSequence symbolValue = entry.getSymbol();
            int newKey = mapWriter.put(symbolValue);
            identical &= newKey == entry.getKey();
            symbolMap.set(entry.getKey() - cleanSymbolCount, newKey);
        }
        return identical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cthAppendWalColumnToLastPartition(int columnIndex, int columnType, long timestampColumnIndex, long copyRowCount, long ignore, long columnRowCount, long existingLagRows, long symbolsFlags) {
        block21: {
            if (this.o3ErrorCount.get() > 0) {
                return;
            }
            try {
                long o3dstDataOffset;
                long dataVectorCopySize;
                long o3srcDataOffset;
                boolean designatedTimestamp = (long)columnIndex == timestampColumnIndex;
                MemoryCR o3SrcDataMem = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                MemoryCR o3srcAuxMem = this.o3Columns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
                MemoryMA dstDataMem = this.columns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                MemoryMA dstAuxMem = this.columns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
                long dstRowCount = this.txWriter.getTransientRowCount() - this.getColumnTop(columnIndex) + existingLagRows;
                if (ColumnType.isVarSize(columnType)) {
                    ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                    long committedAuxOffset = columnTypeDriver.getAuxVectorOffset(columnRowCount);
                    long o3srcAuxMemAddr = o3srcAuxMem.addressOf(0L);
                    o3srcDataOffset = columnTypeDriver.getDataVectorOffset(o3srcAuxMemAddr, columnRowCount);
                    dataVectorCopySize = columnTypeDriver.getDataVectorSize(o3srcAuxMemAddr, columnRowCount, columnRowCount + copyRowCount - 1L);
                    long o3dstAuxOffset = columnTypeDriver.getAuxVectorOffset(dstRowCount);
                    long o3dstAuxSize = columnTypeDriver.getAuxVectorSize(copyRowCount);
                    o3dstDataOffset = o3dstAuxOffset > 0L ? dstDataMem.getAppendOffset() : 0L;
                    long o3dstAuxAddr = this.mapAppendColumnBuffer(dstAuxMem, o3dstAuxOffset, o3dstAuxSize, true);
                    assert (o3dstAuxAddr != 0L);
                    try {
                        long shift = o3srcDataOffset - o3dstDataOffset;
                        columnTypeDriver.shiftCopyAuxVector(shift, o3srcAuxMem.addressOf(committedAuxOffset), 0L, copyRowCount - 1L, Math.abs(o3dstAuxAddr), o3dstAuxSize);
                    }
                    finally {
                        this.mapAppendColumnBufferRelease(o3dstAuxAddr, o3dstAuxOffset, o3dstAuxSize);
                    }
                } else {
                    int shl = ColumnType.pow2SizeOf(columnType);
                    o3srcDataOffset = designatedTimestamp ? columnRowCount << 4 : columnRowCount << shl;
                    dataVectorCopySize = copyRowCount << shl;
                    o3dstDataOffset = dstRowCount << shl;
                }
                dstDataMem.jumpTo(o3dstDataOffset + dataVectorCopySize);
                if (!designatedTimestamp && dataVectorCopySize > 0L) {
                    if (this.mixedIOFlag) {
                        if (o3SrcDataMem.isFileBased()) {
                            long bytesWritten = this.ff.copyData(o3SrcDataMem.getFd(), dstDataMem.getFd(), o3srcDataOffset, o3dstDataOffset, dataVectorCopySize);
                            if (bytesWritten != dataVectorCopySize) {
                                throw CairoException.critical(this.ff.errno()).put("could not copy WAL column (fd-fd) [dstFd=").put(dstDataMem.getFd()).put(", column=").put(this.getColumnNameSafe(columnIndex)).put(", o3dstDataOffset=").put(o3dstDataOffset).put(", srcFd=").put(o3SrcDataMem.getFd()).put(", dataVectorCopySize=").put(dataVectorCopySize).put(", bytesWritten=").put(bytesWritten).put(']');
                            }
                        } else {
                            long bytesWritten = this.ff.write(dstDataMem.getFd(), o3SrcDataMem.addressOf(o3srcDataOffset), dataVectorCopySize, o3dstDataOffset);
                            if (bytesWritten != dataVectorCopySize) {
                                throw CairoException.critical(this.ff.errno()).put("could not copy WAL column (mem-fd) [fd=").put(dstDataMem.getFd()).put(", column=").put(this.getColumnNameSafe(columnIndex)).put(", columnType").put(ColumnType.nameOf(columnType)).put(", o3dstDataOffset=").put(o3dstDataOffset).put(", o3srcDataOffset=").put(o3srcDataOffset).put(", dataVectorCopySize=").put(dataVectorCopySize).put(", bytesWritten=").put(bytesWritten).put(']');
                            }
                        }
                        break block21;
                    }
                    long destAddr = this.mapAppendColumnBuffer(dstDataMem, o3dstDataOffset, dataVectorCopySize, true);
                    try {
                        Vect.memcpy(Math.abs(destAddr), o3SrcDataMem.addressOf(o3srcDataOffset), dataVectorCopySize);
                        break block21;
                    }
                    finally {
                        this.mapAppendColumnBufferRelease(destAddr, o3dstDataOffset, dataVectorCopySize);
                    }
                }
                if (!designatedTimestamp) break block21;
                long srcLo = o3SrcDataMem.addressOf(o3srcDataOffset);
                long destAddr = this.mapAppendColumnBuffer(dstDataMem, o3dstDataOffset, dataVectorCopySize, true);
                try {
                    Vect.copyFromTimestampIndex(srcLo, 0L, copyRowCount - 1L, Math.abs(destAddr));
                }
                finally {
                    this.mapAppendColumnBufferRelease(destAddr, o3dstDataOffset, dataVectorCopySize);
                }
            }
            catch (Throwable th) {
                this.handleColumnTaskException("could not copy WAL column", columnIndex, columnType, copyRowCount, columnRowCount, existingLagRows, symbolsFlags, th);
            }
        }
    }

    private void cthMergeWalColumnWithLag(int columnIndex, int columnType, long timestampColumnIndex, long mergedTimestampAddress, long mergeCount, long lagRows, long mappedRowLo, long mappedRowHi) {
        if (ColumnType.isVarSize(columnType)) {
            this.cthMergeWalVarColumnWithLag(columnIndex, columnType, mergedTimestampAddress, mergeCount, lagRows, mappedRowLo, mappedRowHi);
        } else if ((long)columnIndex != timestampColumnIndex) {
            this.cthMergeWalFixColumnWithLag(columnIndex, columnType, mergedTimestampAddress, mergeCount, lagRows, mappedRowLo, mappedRowHi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cthMergeWalFixColumnWithLag(int columnIndex, int columnType, long mergeIndex, long mergeCount, long lagRows, long mappedRowLo, long mappedRowHi) {
        if (this.o3ErrorCount.get() > 0) {
            return;
        }
        try {
            int primaryColumnIndex = TableWriter.getPrimaryColumnIndex(columnIndex);
            MemoryMA lagMem = this.columns.getQuick(primaryColumnIndex);
            MemoryCR mappedMem = this.o3Columns.getQuick(primaryColumnIndex);
            MemoryCARW destMem = this.o3MemColumns2.getQuick(primaryColumnIndex);
            int shl = ColumnType.pow2SizeOf(columnType);
            destMem.jumpTo(mergeCount << shl);
            long srcMapped = mappedMem.addressOf(mappedRowLo << shl) - (mappedRowLo << shl);
            long lagMemOffset = lagRows > 0L ? this.txWriter.getTransientRowCount() - this.getColumnTop(columnIndex) << shl : 0L;
            long lagAddr = this.mapAppendColumnBuffer(lagMem, lagMemOffset, lagRows << shl, false);
            try {
                long srcLag = Math.abs(lagAddr);
                destMem.shiftAddressRight(0L);
                long dest = destMem.addressOf(0L);
                if (srcLag == 0L && lagRows != 0L) {
                    throw CairoException.critical(0).put("cannot sort WAL data, lag rows are missing [table").put(this.tableToken.getTableName()).put(", column=").put(this.getColumnNameSafe(columnIndex)).put(", type=").put(ColumnType.nameOf(columnType)).put(", lagRows=").put(lagRows).put(']');
                }
                if (srcMapped == 0L) {
                    throw CairoException.critical(0).put("cannot sort WAL data, rows are missing [table").put(this.tableToken.getTableName()).put(", column=").put(this.getColumnNameSafe(columnIndex)).put(", type=").put(ColumnType.nameOf(columnType)).put(']');
                }
                if (dest == 0L) {
                    throw CairoException.critical(0).put("cannot sort WAL data, destination buffer is empty [table").put(this.tableToken.getTableName()).put(", column=").put(this.getColumnNameSafe(columnIndex)).put(", type=").put(ColumnType.nameOf(columnType)).put(']');
                }
                switch (shl) {
                    case 0: {
                        Vect.mergeShuffle8Bit(srcLag, srcMapped, dest, mergeIndex, mergeCount);
                        return;
                    }
                    case 1: {
                        Vect.mergeShuffle16Bit(srcLag, srcMapped, dest, mergeIndex, mergeCount);
                        return;
                    }
                    case 2: {
                        Vect.mergeShuffle32Bit(srcLag, srcMapped, dest, mergeIndex, mergeCount);
                        return;
                    }
                    case 3: {
                        Vect.mergeShuffle64Bit(srcLag, srcMapped, dest, mergeIndex, mergeCount);
                        return;
                    }
                    case 4: {
                        Vect.mergeShuffle128Bit(srcLag, srcMapped, dest, mergeIndex, mergeCount);
                        return;
                    }
                    case 5: {
                        Vect.mergeShuffle256Bit(srcLag, srcMapped, dest, mergeIndex, mergeCount);
                        return;
                    }
                    default: {
                        assert (false) : "col type is unsupported";
                        return;
                    }
                }
            }
            finally {
                this.mapAppendColumnBufferRelease(lagAddr, lagMemOffset, lagRows << shl);
            }
        }
        catch (Throwable e) {
            this.handleColumnTaskException("could not merge fix WAL column", columnIndex, columnType, mergeIndex, lagRows, mappedRowLo, mappedRowHi, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cthMergeWalVarColumnWithLag(int columnIndex, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexCount, long lagRows, long mappedRowLo, long mappedRowHi) {
        if (this.o3ErrorCount.get() > 0) {
            return;
        }
        try {
            int primaryIndex = TableWriter.getPrimaryColumnIndex(columnIndex);
            int secondaryIndex = primaryIndex + 1;
            MemoryCR o3dataMem = this.o3Columns.getQuick(primaryIndex);
            MemoryCR o3auxMem = this.o3Columns.getQuick(secondaryIndex);
            MemoryMA lagDataMem = this.columns.getQuick(primaryIndex);
            MemoryMA lagAuxMem = this.columns.getQuick(secondaryIndex);
            MemoryCARW dstDataAddr = this.o3MemColumns2.getQuick(primaryIndex);
            MemoryCARW dstAuxAddr = this.o3MemColumns2.getQuick(secondaryIndex);
            ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
            long srcMappedDataAddr = o3dataMem.addressOf(0L);
            long srcMappedAuxAddr = o3auxMem.addressOf(0L);
            long src1DataSize = columnTypeDriver.getDataVectorSize(srcMappedAuxAddr, mappedRowLo, mappedRowHi - 1L);
            assert (o3dataMem.size() >= src1DataSize);
            long lagAuxOffset = lagRows > 0L ? columnTypeDriver.getAuxVectorOffset(this.txWriter.getTransientRowCount() - this.getColumnTop(columnIndex)) : 0L;
            long lagAuxSize = columnTypeDriver.getAuxVectorSize(lagRows);
            long signedLagAuxAddr = lagRows > 0L ? this.mapAppendColumnBuffer(lagAuxMem, lagAuxOffset, lagAuxSize, false) : 0L;
            try {
                long lagAuxAddr = Math.abs(signedLagAuxAddr);
                long lagDataBegin = lagRows > 0L ? columnTypeDriver.getDataVectorOffset(lagAuxAddr, 0L) : 0L;
                long lagDataSize = lagRows > 0L ? columnTypeDriver.getDataVectorSizeAt(lagAuxAddr, lagRows - 1L) : 0L;
                long lagDataMapAddr = lagRows > 0L ? this.mapAppendColumnBuffer(lagDataMem, lagDataBegin, lagDataSize, false) : 0L;
                try {
                    long lagDataAddr = Math.abs(lagDataMapAddr) - lagDataBegin;
                    dstDataAddr.jumpTo(src1DataSize + lagDataSize);
                    dstAuxAddr.jumpTo(columnTypeDriver.getAuxVectorSize(timestampMergeIndexCount));
                    ColumnType.getDriver(columnType).o3ColumnMerge(timestampMergeIndexAddr, timestampMergeIndexCount, lagAuxAddr, lagDataAddr, srcMappedAuxAddr, srcMappedDataAddr, dstAuxAddr.addressOf(0L), dstDataAddr.addressOf(0L), 0L);
                }
                finally {
                    this.mapAppendColumnBufferRelease(lagDataMapAddr, lagDataBegin, lagDataSize);
                }
            }
            finally {
                this.mapAppendColumnBufferRelease(signedLagAuxAddr, lagAuxOffset, lagAuxSize);
            }
        }
        catch (Throwable e) {
            this.handleColumnTaskException("could not merge varsize WAL column", columnIndex, columnType, timestampMergeIndexAddr, lagRows, mappedRowLo, mappedRowHi, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cthO3MoveUncommitted(int columnIndex, int columnType, long timestampColumnIndex, long committedTransientRowCount, long ignore1, long transientRowsAdded, long ignore2, long ignore3) {
        block20: {
            if (this.o3ErrorCount.get() > 0) {
                return;
            }
            try {
                long alignedExtraLen;
                boolean locallyMapped;
                long srcFixLen;
                long srcFixOffset;
                if ((long)columnIndex != timestampColumnIndex) {
                    long colDataExtraSize;
                    long colDataOffset;
                    MemoryMA colDataMem = this.getPrimaryColumn(columnIndex);
                    MemoryARW o3DataMem = this.o3MemColumns1.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                    MemoryARW o3auxMem = this.o3MemColumns1.get(TableWriter.getSecondaryColumnIndex(columnIndex));
                    long o3dataOffset = o3DataMem.getAppendOffset();
                    long columnTop = this.getColumnTop(columnIndex);
                    if (columnTop > 0L) {
                        LOG.debug().$("move uncommitted [columnTop=").$(columnTop).$(", columnIndex=").$(columnIndex).$(", committedTransientRowCount=").$(committedTransientRowCount).$(", transientRowsAdded=").$(transientRowsAdded).I$();
                    }
                    long committedRowCount = committedTransientRowCount - columnTop;
                    if (ColumnType.isVarSize(columnType)) {
                        long alignedExtraLen2;
                        boolean locallyMapped2;
                        ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                        MemoryMA colAuxMem = this.getSecondaryColumn(columnIndex);
                        long colAuxMemOffset = columnTypeDriver.getAuxVectorOffset(committedRowCount);
                        long colAuxMemRequiredSize = columnTypeDriver.getAuxVectorSize(transientRowsAdded);
                        long o3auxMemAppendOffset = o3auxMem.getAppendOffset();
                        long offsetLimit = o3auxMemAppendOffset + columnTypeDriver.getAuxVectorOffset(transientRowsAdded);
                        o3auxMem.jumpTo(offsetLimit);
                        long colAuxMemAddr = colAuxMem.map(colAuxMemOffset, colAuxMemRequiredSize);
                        boolean bl = locallyMapped2 = colAuxMemAddr == 0L;
                        if (!locallyMapped2) {
                            alignedExtraLen2 = 0L;
                        } else {
                            long alignedOffset = Files.floorPageSize(colAuxMemOffset);
                            alignedExtraLen2 = colAuxMemOffset - alignedOffset;
                            colAuxMemAddr = TableUtils.mapRO(this.ff, colAuxMem.getFd(), colAuxMemRequiredSize + alignedExtraLen2, alignedOffset, 12);
                        }
                        colDataOffset = columnTypeDriver.getDataVectorOffset(colAuxMemAddr + alignedExtraLen2, 0L);
                        long dstAddr = o3auxMem.addressOf(o3auxMemAppendOffset) - columnTypeDriver.getMinAuxVectorSize();
                        long dstAddrLimit = o3auxMem.addressOf(offsetLimit);
                        long dstAddrSize = dstAddrLimit - dstAddr;
                        columnTypeDriver.shiftCopyAuxVector(colDataOffset - o3dataOffset, colAuxMemAddr + alignedExtraLen2, 0L, transientRowsAdded - 1L, dstAddr, dstAddrSize);
                        if (locallyMapped2) {
                            this.ff.munmap(colAuxMemAddr, colAuxMemRequiredSize + alignedExtraLen2, 12);
                        }
                        colDataExtraSize = colDataMem.getAppendOffset() - colDataOffset;
                        colAuxMem.jumpTo(columnTypeDriver.getAuxVectorSize(committedRowCount));
                    } else {
                        int shl = ColumnType.pow2SizeOf(columnType);
                        colDataExtraSize = transientRowsAdded << shl;
                        colDataOffset = committedRowCount << shl;
                    }
                    o3DataMem.jumpTo(o3dataOffset + colDataExtraSize);
                    long o3dataAddr = o3DataMem.addressOf(o3dataOffset);
                    long sourceAddress = colDataMem.map(colDataOffset, colDataExtraSize);
                    if (sourceAddress != 0L) {
                        Vect.memcpy(o3dataAddr, sourceAddress, colDataExtraSize);
                    } else {
                        long alignedOffset = Files.floorPageSize(colDataOffset);
                        long alignedExtraLen3 = colDataOffset - alignedOffset;
                        long size = colDataExtraSize + alignedExtraLen3;
                        if (size > 0L) {
                            sourceAddress = TableUtils.mapRO(this.ff, colDataMem.getFd(), size, alignedOffset, 12);
                            Vect.memcpy(o3dataAddr, sourceAddress + alignedExtraLen3, colDataExtraSize);
                            this.ff.munmap(sourceAddress, size, 12);
                        }
                    }
                    colDataMem.jumpTo(colDataOffset);
                    break block20;
                }
                int shl = ColumnType.pow2SizeOf(8);
                MemoryMA srcDataMem = this.getPrimaryColumn(columnIndex);
                long address = srcDataMem.map(srcFixOffset = committedTransientRowCount << shl, srcFixLen = transientRowsAdded << shl);
                boolean bl = locallyMapped = address == 0L;
                if (!locallyMapped) {
                    alignedExtraLen = 0L;
                } else {
                    long alignedOffset = Files.floorPageSize(srcFixOffset);
                    alignedExtraLen = srcFixOffset - alignedOffset;
                    address = TableUtils.mapRO(this.ff, srcDataMem.getFd(), srcFixLen + alignedExtraLen, alignedOffset, 12);
                }
                try {
                    for (long n = 0L; n < transientRowsAdded; ++n) {
                        long ts = Unsafe.getUnsafe().getLong(address + alignedExtraLen + (n << shl));
                        this.o3TimestampMem.putLong128(ts, this.o3RowCount + n);
                    }
                }
                finally {
                    if (locallyMapped) {
                        this.ff.munmap(address, srcFixLen + alignedExtraLen, 12);
                    }
                }
                srcDataMem.jumpTo(srcFixOffset);
            }
            catch (Throwable ex) {
                this.handleColumnTaskException("could not move uncommitted data", columnIndex, columnType, committedTransientRowCount, transientRowsAdded, ignore1, ignore2, ex);
            }
        }
    }

    private void cthO3ShiftColumnInLagToTop(int columnIndex, int columnType, long timestampColumnIndex, long copyToLagRowCount, long ignore, long columnDataRowOffset, long existingLagRows, long excludeSymbols) {
        if (this.o3ErrorCount.get() > 0) {
            return;
        }
        try {
            if ((long)columnIndex != timestampColumnIndex) {
                MemoryCR srcDataMem = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                MemoryCR srcAuxMem = this.o3Columns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
                MemoryARW dstDataMem = this.o3MemColumns1.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                MemoryARW dstAuxMem = this.o3MemColumns1.get(TableWriter.getSecondaryColumnIndex(columnIndex));
                if (srcDataMem == dstDataMem && excludeSymbols > 0L && columnType == 12) {
                    return;
                }
                if (ColumnType.isVarSize(columnType)) {
                    ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                    long dataOffset = columnTypeDriver.getDataVectorOffset(srcAuxMem.addressOf(0L), columnDataRowOffset);
                    long dataSize = columnTypeDriver.getDataVectorSize(srcAuxMem.addressOf(0L), columnDataRowOffset, columnDataRowOffset + copyToLagRowCount - 1L);
                    long destOffset = existingLagRows == 0L ? 0L : columnTypeDriver.getDataVectorOffset(dstAuxMem.addressOf(0L), existingLagRows);
                    long rowLimit = columnTypeDriver.getAuxVectorSize(existingLagRows + copyToLagRowCount);
                    dstAuxMem.jumpTo(rowLimit);
                    long dstAddr = dstAuxMem.addressOf(columnTypeDriver.getAuxVectorOffset(existingLagRows));
                    long dstAddrLimit = dstAuxMem.addressOf(rowLimit);
                    long dstAddrSize = dstAddrLimit - dstAddr;
                    columnTypeDriver.shiftCopyAuxVector(dataOffset - destOffset, srcAuxMem.addressOf(columnTypeDriver.getAuxVectorOffset(columnDataRowOffset)), 0L, copyToLagRowCount - 1L, dstAddr, dstAddrSize);
                    dstDataMem.jumpTo(destOffset + dataSize);
                    assert (srcDataMem.size() >= dataSize);
                    Vect.memmove(dstDataMem.addressOf(destOffset), srcDataMem.addressOf(dataOffset), dataSize);
                } else {
                    int shl = ColumnType.pow2SizeOf(columnType);
                    long sourceOffset = columnDataRowOffset << shl;
                    long size = copyToLagRowCount << shl;
                    long destOffset = existingLagRows << shl;
                    dstDataMem.jumpTo(destOffset + size);
                    assert (srcDataMem.size() >= size);
                    Vect.memmove(dstDataMem.addressOf(destOffset), srcDataMem.addressOf(sourceOffset), size);
                }
            } else {
                MemoryCR o3SrcDataMem = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                long sourceOffset = columnDataRowOffset << 4;
                this.o3TimestampMem.jumpTo(copyToLagRowCount + existingLagRows << 4);
                long dstTimestampAddr = this.o3TimestampMem.getAddress() + (existingLagRows << 4);
                Vect.shiftTimestampIndex(o3SrcDataMem.addressOf(sourceOffset), copyToLagRowCount, dstTimestampAddr);
            }
        }
        catch (Throwable ex) {
            this.handleColumnTaskException("could not shift o3 lag", columnIndex, columnType, copyToLagRowCount, columnDataRowOffset, existingLagRows, excludeSymbols, ex);
        }
    }

    private void cthO3SortColumn(int columnIndex, int columnType, long timestampColumnIndex, long sortedTimestampsAddr, long sortedTimestampsRowCount, long long2, long long3, long long4) {
        if (ColumnType.isVarSize(columnType)) {
            this.cthO3SortVarColumn(columnIndex, columnType, sortedTimestampsAddr, sortedTimestampsRowCount);
        } else if ((long)columnIndex != timestampColumnIndex) {
            this.cthO3SortFixColumn(columnIndex, columnType, sortedTimestampsAddr, sortedTimestampsRowCount);
        }
    }

    private void cthO3SortFixColumn(int columnIndex, int columnType, long sortedTimestampsAddr, long sortedTimestampsRowCount) {
        if (this.o3ErrorCount.get() > 0) {
            return;
        }
        try {
            int columnOffset = TableWriter.getPrimaryColumnIndex(columnIndex);
            MemoryCR mem = this.o3Columns.getQuick(columnOffset);
            MemoryCARW mem2 = this.o3MemColumns2.getQuick(columnOffset);
            int shl = ColumnType.pow2SizeOf(columnType);
            long src = mem.addressOf(0L);
            mem2.jumpTo(sortedTimestampsRowCount << shl);
            long tgtDataAddr = mem2.addressOf(0L);
            switch (shl) {
                case 0: {
                    Vect.indexReshuffle8Bit(src, tgtDataAddr, sortedTimestampsAddr, sortedTimestampsRowCount);
                    break;
                }
                case 1: {
                    Vect.indexReshuffle16Bit(src, tgtDataAddr, sortedTimestampsAddr, sortedTimestampsRowCount);
                    break;
                }
                case 2: {
                    Vect.indexReshuffle32Bit(src, tgtDataAddr, sortedTimestampsAddr, sortedTimestampsRowCount);
                    break;
                }
                case 3: {
                    Vect.indexReshuffle64Bit(src, tgtDataAddr, sortedTimestampsAddr, sortedTimestampsRowCount);
                    break;
                }
                case 4: {
                    Vect.indexReshuffle128Bit(src, tgtDataAddr, sortedTimestampsAddr, sortedTimestampsRowCount);
                    break;
                }
                case 5: {
                    Vect.indexReshuffle256Bit(src, tgtDataAddr, sortedTimestampsAddr, sortedTimestampsRowCount);
                    break;
                }
                default: {
                    assert (false) : "col type is unsupported";
                    break;
                }
            }
        }
        catch (Throwable th) {
            this.handleColumnTaskException("could not sort fix o3 column", columnIndex, columnType, sortedTimestampsAddr, sortedTimestampsRowCount, -1L, -1L, th);
        }
    }

    private void cthO3SortVarColumn(int columnIndex, int columnType, long sortedTimestampsAddr, long sortedTimestampsRowCount) {
        if (this.o3ErrorCount.get() > 0) {
            return;
        }
        try {
            int primaryIndex = TableWriter.getPrimaryColumnIndex(columnIndex);
            int secondaryIndex = primaryIndex + 1;
            ColumnType.getDriver(columnType).o3sort(sortedTimestampsAddr, sortedTimestampsRowCount, this.o3Columns.getQuick(primaryIndex), this.o3Columns.getQuick(secondaryIndex), this.o3MemColumns2.getQuick(primaryIndex), this.o3MemColumns2.getQuick(secondaryIndex));
        }
        catch (Throwable th) {
            this.handleColumnTaskException("could not sort varsize o3 column", columnIndex, columnType, sortedTimestampsAddr, -1L, -1L, -1L, th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long deduplicateSortedIndex(long longIndexLength, long indexSrcAddr, long indexDstAddr, long tempIndexAddr, long lagRows) {
        int dedupKeyIndex = 0;
        long dedupCommitAddr = 0L;
        try {
            if (this.dedupColumnCommitAddresses.getColumnCount() > 0) {
                dedupCommitAddr = this.dedupColumnCommitAddresses.allocateBlock();
                for (int i = 0; i < this.metadata.getColumnCount(); ++i) {
                    int columnType = this.metadata.getColumnType(i);
                    if (i == this.metadata.getTimestampIndex() || columnType <= 0 || !this.metadata.isDedupKey(i)) continue;
                    long addr = DedupColumnCommitAddresses.setColValues(dedupCommitAddr, dedupKeyIndex++, columnType, ColumnType.isVarSize(columnType) ? -1 : ColumnType.sizeOf(columnType), 0L);
                    if (!ColumnType.isVarSize(columnType)) {
                        int shl = ColumnType.pow2SizeOf(columnType);
                        long lagMemOffset = lagRows > 0L ? this.txWriter.getTransientRowCount() - this.getColumnTop(i) << shl : 0L;
                        long lagMapSize = lagRows << shl;
                        long lagKeyAddr = lagRows > 0L ? this.mapAppendColumnBuffer(this.columns.get(TableWriter.getPrimaryColumnIndex(i)), lagMemOffset, lagMapSize, false) : 0L;
                        long o3ColumnData = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(i)).addressOf(0L);
                        assert (o3ColumnData != 0L);
                        DedupColumnCommitAddresses.setColAddressValues(addr, o3ColumnData);
                        DedupColumnCommitAddresses.setO3DataAddressValues(addr, Math.abs(lagKeyAddr));
                        DedupColumnCommitAddresses.setReservedValuesSet1(addr, lagKeyAddr, lagMemOffset, lagMapSize);
                        continue;
                    }
                    ColumnTypeDriver driver = ColumnType.getDriver(columnType);
                    MemoryCR o3VarColumn = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(i));
                    long o3ColumnVarDataAddr = o3VarColumn.addressOf(0L);
                    long o3ColumnVarAuxAddr = this.o3Columns.get(TableWriter.getSecondaryColumnIndex(i)).addressOf(0L);
                    long o3ColumnVarDataSize = o3VarColumn.addressHi() - o3ColumnVarDataAddr;
                    DedupColumnCommitAddresses.setColAddressValues(addr, o3ColumnVarAuxAddr, o3ColumnVarDataAddr, o3ColumnVarDataSize);
                    if (lagRows > 0L) {
                        long roLo = this.txWriter.getTransientRowCount() - this.getColumnTop(i);
                        long lagAuxOffset = driver.getAuxVectorOffset(roLo);
                        long lagAuxSize = driver.getAuxVectorSize(lagRows);
                        long lagAuxKeyAddrRaw = this.mapAppendColumnBuffer(this.columns.get(TableWriter.getSecondaryColumnIndex(i)), lagAuxOffset, lagAuxSize, false);
                        long lagAuxKeyAddr = Math.abs(lagAuxKeyAddrRaw);
                        long lagVarDataOffset = driver.getDataVectorOffset(lagAuxKeyAddr, 0L);
                        long lagVarDataSize = driver.getDataVectorSize(lagAuxKeyAddr, 0L, lagRows - 1L);
                        long lagVarDataAddrRaw = this.mapAppendColumnBuffer(this.columns.get(TableWriter.getPrimaryColumnIndex(i)), lagVarDataOffset, lagVarDataSize, false);
                        long lagVarDataAddr = Math.abs(lagVarDataAddrRaw);
                        DedupColumnCommitAddresses.setO3DataAddressValues(addr, lagAuxKeyAddr, lagVarDataAddr - lagVarDataOffset, lagVarDataSize + lagVarDataOffset);
                        DedupColumnCommitAddresses.setReservedValuesSet1(addr, lagAuxKeyAddrRaw, lagAuxOffset, lagAuxSize);
                        DedupColumnCommitAddresses.setReservedValuesSet2(addr, lagVarDataAddrRaw, lagVarDataOffset);
                        continue;
                    }
                    DedupColumnCommitAddresses.setO3DataAddressValues(addr, 0L, 0L, 0L);
                }
                assert (dedupKeyIndex <= this.dedupColumnCommitAddresses.getColumnCount());
            }
            long deduplicatedRowCount = Vect.dedupSortedTimestampIndexIntKeysChecked(indexSrcAddr, longIndexLength, indexDstAddr, tempIndexAddr, dedupKeyIndex, DedupColumnCommitAddresses.getAddress(dedupCommitAddr));
            LOG.info().$("WAL dedup sorted commit index [table=").$(this.tableToken).$(", totalRows=").$(longIndexLength).$(", lagRows=").$(lagRows).$(", dups=").$(deduplicatedRowCount > 0L ? longIndexLength - deduplicatedRowCount : 0L).I$();
            long l = deduplicatedRowCount;
            return l;
        }
        finally {
            if (this.dedupColumnCommitAddresses.getColumnCount() > 0 && lagRows > 0L) {
                for (int i = 0; i < dedupKeyIndex; ++i) {
                    long lagAuxAddr = DedupColumnCommitAddresses.getColReserved1(dedupCommitAddr, i);
                    long lagAuxMemOffset = DedupColumnCommitAddresses.getColReserved2(dedupCommitAddr, i);
                    long mapAuxSize = DedupColumnCommitAddresses.getColReserved3(dedupCommitAddr, i);
                    this.mapAppendColumnBufferRelease(lagAuxAddr, lagAuxMemOffset, mapAuxSize);
                    long mapVarSize = DedupColumnCommitAddresses.getO3VarDataLen(dedupCommitAddr, i);
                    if (mapVarSize <= 0L) continue;
                    long lagVarAddr = DedupColumnCommitAddresses.getColReserved4(dedupCommitAddr, i);
                    long lagVarMemOffset = DedupColumnCommitAddresses.getColReserved5(dedupCommitAddr, i);
                    assert (mapVarSize > lagVarMemOffset);
                    this.mapAppendColumnBufferRelease(lagVarAddr, lagVarMemOffset, mapVarSize - lagVarMemOffset);
                }
            }
            this.dedupColumnCommitAddresses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchColumnTasks(long long0, long long1, long long2, long long3, long long4, ColumnTaskHandler taskHandler) {
        long timestampColumnIndex = this.metadata.getTimestampIndex();
        MPSequence pubSeq = this.messageBus.getColumnTaskPubSeq();
        RingQueue<ColumnTask> queue = this.messageBus.getColumnTaskQueue();
        this.o3DoneLatch.reset();
        this.o3ErrorCount.set(0);
        this.lastErrno = 0;
        int queuedCount = 0;
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            int columnType = this.metadata.getColumnType(columnIndex);
            if (columnType <= 0) continue;
            long cursor = pubSeq.next();
            if (cursor > -1L) {
                try {
                    ColumnTask task = queue.get(cursor);
                    task.of(this.o3DoneLatch, columnIndex, columnType, timestampColumnIndex, long0, long1, long2, long3, long4, taskHandler);
                    continue;
                }
                finally {
                    ++queuedCount;
                    pubSeq.done(cursor);
                }
            }
            taskHandler.run(columnIndex, columnType, timestampColumnIndex, long0, long1, long2, long3, long4);
        }
        this.consumeColumnTasks(queue, queuedCount);
    }

    private void doClose(boolean truncate) {
        boolean tx = this.inTransaction();
        this.freeSymbolMapWriters();
        Misc.freeObjList(this.indexers);
        this.denseIndexers.clear();
        Misc.free(this.txWriter);
        Misc.free(this.ddlMem);
        Misc.free(this.other);
        Misc.free(this.todoMem);
        Misc.free(this.attachMetaMem);
        Misc.free(this.attachColumnVersionReader);
        Misc.free(this.attachIndexBuilder);
        Misc.free(this.columnVersionWriter);
        Misc.free(this.o3PartitionUpdateSink);
        Misc.free(this.slaveTxReader);
        Misc.free(this.commandQueue);
        Misc.free(this.dedupColumnCommitAddresses);
        Misc.free(this.parquetDecoder);
        Misc.free(this.parquetStatBuffers);
        Misc.free(this.parquetColumnIdsAndTypes);
        Misc.free(this.segmentCopyInfo);
        Misc.free(this.walTxnDetails);
        Misc.free(this.blockFileWriter);
        this.tempDirectMemList = Misc.free(this.tempDirectMemList);
        if (this.segmentFileCache != null) {
            this.segmentFileCache.closeWalFiles();
        }
        this.updateOperatorImpl = Misc.free(this.updateOperatorImpl);
        this.convertOperatorImpl = Misc.free(this.convertOperatorImpl);
        this.dropIndexOperator = null;
        this.noOpRowCount = 0L;
        this.lastOpenPartitionTs = Long.MIN_VALUE;
        this.lastOpenPartitionIsReadOnly = false;
        assert (!truncate || this.distressed || this.assertColumnPositionIncludeWalLag());
        this.freeColumns(truncate & !this.distressed);
        try {
            this.releaseLock(!truncate | tx | this.performRecovery | this.distressed);
        }
        finally {
            Misc.free(this.txnScoreboard);
            Misc.free(this.path);
            Misc.free(this.o3TimestampMem);
            Misc.free(this.o3TimestampMemCpy);
            Misc.free(this.ownMessageBus);
            if (this.tempMem16b != 0L) {
                this.tempMem16b = Unsafe.free(this.tempMem16b, 16L, 56);
            }
            LOG.info().$("closed '").$(this.tableToken).I$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropPartitionByExactTimestamp(long timestamp) {
        long minTimestamp = this.txWriter.getMinTimestamp();
        long maxTimestamp = this.txWriter.getMaxTimestamp();
        int index = this.txWriter.getPartitionIndex(timestamp);
        if (index < 0) {
            LOG.error().$("partition is already removed [path=").$substr(this.pathRootSize, this.path).$(", partitionTimestamp=").$ts(timestamp).I$();
            return false;
        }
        long partitionNameTxn = this.txWriter.getPartitionNameTxnByPartitionTimestamp(timestamp);
        if (timestamp == this.txWriter.getPartitionTimestampByTimestamp(maxTimestamp)) {
            long prevTimestamp;
            long newTransientRowCount;
            long nextMaxTimestamp;
            if (index == 0) {
                nextMaxTimestamp = Long.MIN_VALUE;
                newTransientRowCount = 0L;
                prevTimestamp = 0L;
            } else {
                int prevIndex = index - 1;
                long parquetSize = this.txWriter.getPartitionParquetFileSize(prevIndex);
                prevTimestamp = this.txWriter.getPartitionTimestampByIndex(prevIndex);
                newTransientRowCount = this.txWriter.getPartitionSize(prevIndex);
                try {
                    TableUtils.setPathForNativePartition(this.path.trimTo(this.pathSize), this.partitionBy, prevTimestamp, this.txWriter.getPartitionNameTxn(prevIndex));
                    this.readPartitionMinMaxTimestamps(prevTimestamp, this.path, this.metadata.getColumnName(this.metadata.getTimestampIndex()), parquetSize, newTransientRowCount);
                    nextMaxTimestamp = this.attachMaxTimestamp;
                }
                finally {
                    this.path.trimTo(this.pathSize);
                }
            }
            this.txWriter.beginPartitionSizeUpdate();
            this.txWriter.removeAttachedPartitions(timestamp);
            this.txWriter.finishPartitionSizeUpdate(index == 0 ? Long.MAX_VALUE : this.txWriter.getMinTimestamp(), nextMaxTimestamp);
            this.txWriter.bumpTruncateVersion();
            this.columnVersionWriter.removePartition(timestamp);
            this.columnVersionWriter.replaceInitialPartitionRecords(this.txWriter.getLastPartitionTimestamp(), this.txWriter.getTransientRowCount());
            this.closeActivePartition(false);
            if (index != 0) {
                this.openPartition(prevTimestamp, newTransientRowCount);
                this.setAppendPosition(newTransientRowCount, false);
            } else {
                this.rowAction = 0;
            }
        } else {
            long nextMinTimestamp = minTimestamp;
            if (timestamp == this.txWriter.getPartitionTimestampByIndex(0)) {
                nextMinTimestamp = this.readMinTimestamp();
            }
            this.txWriter.beginPartitionSizeUpdate();
            this.txWriter.removeAttachedPartitions(timestamp);
            this.txWriter.setMinTimestamp(nextMinTimestamp);
            this.txWriter.finishPartitionSizeUpdate(nextMinTimestamp, this.txWriter.getMaxTimestamp());
            this.txWriter.bumpTruncateVersion();
            this.columnVersionWriter.removePartition(timestamp);
        }
        this.partitionRemoveCandidates.add(timestamp, partitionNameTxn);
        return true;
    }

    private long findMinSplitPartitionTimestamp() {
        int n = this.txWriter.getPartitionCount();
        for (int i = 0; i < n; ++i) {
            long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(i);
            if (this.txWriter.getLogicalPartitionTimestamp(partitionTimestamp) == partitionTimestamp) continue;
            return partitionTimestamp;
        }
        return Long.MAX_VALUE;
    }

    private void finishColumnPurge() {
        if (this.purgingOperator == null) {
            return;
        }
        boolean asyncOnly = this.checkScoreboardHasReadersBeforeLastCommittedTxn();
        this.purgingOperator.purge(this.path.trimTo(this.pathSize), this.tableToken, this.partitionBy, asyncOnly, this.getTruncateVersion(), this.getTxn());
        this.purgingOperator.clear();
    }

    private void finishO3Append(long o3LagRowCount) {
        if (this.denseIndexers.size() == 0) {
            this.populateDenseIndexerList();
        }
        this.path.trimTo(this.pathSize);
        boolean bl = this.avoidIndexOnCommit = this.o3ErrorCount.get() == 0;
        if (o3LagRowCount == 0L) {
            this.clearO3();
            LOG.debug().$("lag segment is empty").$();
        } else {
            this.o3MasterRef = this.masterRef - o3LagRowCount * 2L + 1L;
            LOG.debug().$("adjusted [o3RowCount=").$(this.getO3RowCount0()).I$();
        }
    }

    private void finishO3Commit(long partitionTimestampHiLimit) {
        if (!this.o3InError) {
            this.updateO3ColumnTops();
        }
        if (!this.isEmptyTable() && (this.isLastPartitionClosed() || this.partitionTimestampHi > partitionTimestampHiLimit)) {
            this.openPartition(this.txWriter.getLastPartitionTimestamp(), this.txWriter.getTransientRowCount());
        }
        try {
            if (this.txWriter.getTransientRowCount() > 0L) {
                this.setAppendPosition(this.txWriter.getTransientRowCount(), !this.metadata.isWalEnabled());
            }
        }
        catch (Throwable e) {
            LOG.critical().$("data is committed but writer failed to update its state `").$(e).$('`').$();
            this.distressed = true;
            throw e;
        }
        this.metrics.tableWriterMetrics().incrementO3Commits();
    }

    private Utf8Sequence formatPartitionForTimestamp(long partitionTimestamp, long nameTxn) {
        this.utf8Sink.clear();
        TableUtils.setSinkForNativePartition(this.utf8Sink, this.partitionBy, partitionTimestamp, nameTxn);
        return this.utf8Sink;
    }

    private void freeAndRemoveColumnPair(ObjList<MemoryMA> columns, int pi, int si) {
        Misc.free(columns.getAndSetQuick(pi, NullMemory.INSTANCE));
        Misc.free(columns.getAndSetQuick(si, NullMemory.INSTANCE));
    }

    private void freeAndRemoveO3ColumnPair(ObjList<MemoryCARW> columns, int pi, int si) {
        Misc.free(columns.getAndSetQuick(pi, NullMemory.INSTANCE));
        Misc.free(columns.getAndSetQuick(si, NullMemory.INSTANCE));
    }

    private void freeColumnMemory(int columnIndex) {
        int pi = TableWriter.getPrimaryColumnIndex(columnIndex);
        int si = TableWriter.getSecondaryColumnIndex(columnIndex);
        this.freeNullSetter(this.nullSetters, columnIndex);
        this.freeNullSetter(this.o3NullSetters1, columnIndex);
        this.freeNullSetter(this.o3NullSetters2, columnIndex);
        this.freeAndRemoveColumnPair(this.columns, pi, si);
        this.freeAndRemoveO3ColumnPair(this.o3MemColumns1, pi, si);
        this.freeAndRemoveO3ColumnPair(this.o3MemColumns2, pi, si);
        if (columnIndex < this.indexers.size()) {
            Misc.free(this.indexers.getAndSetQuick(columnIndex, null));
            this.populateDenseIndexerList();
        }
    }

    private void freeColumns(boolean truncate) {
        if (this.columns != null) {
            this.closeAppendMemoryTruncate(truncate);
        }
        Misc.freeObjListAndKeepObjects(this.o3MemColumns1);
        Misc.freeObjListAndKeepObjects(this.o3MemColumns2);
    }

    private void freeIndexers() {
        if (this.indexers != null) {
            int n = this.indexers.size();
            for (int i = 0; i < n; ++i) {
                ColumnIndexer indexer = this.indexers.getQuick(i);
                if (indexer == null) continue;
                this.indexers.getQuick(i).releaseIndexWriter();
            }
            this.denseIndexers.clear();
        }
    }

    private void freeNullSetter(ObjList<Runnable> nullSetters, int columnIndex) {
        nullSetters.setQuick(columnIndex, NOOP);
    }

    private void freeSymbolMapWriters() {
        if (this.denseSymbolMapWriters != null) {
            int n = this.denseSymbolMapWriters.size();
            for (int i = 0; i < n; ++i) {
                Misc.freeIfCloseable(this.denseSymbolMapWriters.getQuick(i));
            }
            this.denseSymbolMapWriters.clear();
        }
        if (this.symbolMapWriters != null) {
            this.symbolMapWriters.clear();
        }
    }

    private CharSequence getColumnNameSafe(int columnIndex) {
        try {
            return this.metadata.getColumnName(columnIndex);
        }
        catch (Throwable th) {
            return "<unknown, index: " + columnIndex + ">";
        }
    }

    private ConvertOperatorImpl getConvertOperator() {
        if (this.convertOperatorImpl == null) {
            this.convertOperatorImpl = new ConvertOperatorImpl(this.configuration, this, this.columnVersionWriter, this.path, this.pathSize, this.getPurgingOperator(), this.messageBus);
        }
        return this.convertOperatorImpl;
    }

    private long getO3RowCount0() {
        return (this.masterRef - this.o3MasterRef + 1L) / 2L;
    }

    private long getPartitionTimestampOrMax(int partitionIndex) {
        if (partitionIndex < this.txWriter.getPartitionCount()) {
            return this.txWriter.getPartitionTimestampByIndex(partitionIndex);
        }
        return Long.MAX_VALUE;
    }

    private MemoryMA getPrimaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getPrimaryColumnIndex(column));
    }

    private PurgingOperator getPurgingOperator() {
        if (this.purgingOperator == null) {
            this.purgingOperator = new PurgingOperator(LOG, this.configuration, this.messageBus);
        } else {
            this.purgingOperator.clear();
        }
        return this.purgingOperator;
    }

    private MemoryMA getSecondaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getSecondaryColumnIndex(column));
    }

    @NotNull
    private DirectLongList getTempDirectLongList(long capacity) {
        if (this.tempDirectMemList == null) {
            this.tempDirectMemList = new DirectLongList(capacity, 56);
            this.tempDirectMemList.zero();
            return this.tempDirectMemList;
        }
        this.tempDirectMemList.clear();
        this.tempDirectMemList.setCapacity(capacity);
        this.tempDirectMemList.zero();
        return this.tempDirectMemList;
    }

    private long getWalMaxLagRows() {
        return Math.min(Math.max(0L, (long)this.configuration.getWalLagRowsMultiplier() * (long)this.metadata.getMaxUncommittedRows()), this.getWalMaxLagSize());
    }

    private long getWalMaxLagSize() {
        long maxLagSize = this.configuration.getWalMaxLagSize();
        return maxLagSize / (this.avgRecordSize != 0L ? this.avgRecordSize : (this.avgRecordSize = TableUtils.estimateAvgRecordSize(this.metadata)));
    }

    private void handleColumnTaskException(String message, int columnIndex, int columnType, long long0, long long1, long long2, long long3, Throwable e) {
        this.o3ErrorCount.incrementAndGet();
        LogRecord logRecord = LOG.critical().$(message + " [table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(this.getColumnNameSafe(columnIndex)).$(", type=").$(ColumnType.nameOf(columnType)).$(", long0=").$(long0).$(", long1=").$(long1).$(", long2=").$(long2).$(", long3=").$(long3);
        if (e instanceof CairoException) {
            this.o3oomObserved = ((CairoException)e).isOutOfMemory();
            this.lastErrno = this.lastErrno == 0 ? ((CairoException)e).errno : this.lastErrno;
            logRecord.$(", msg=").$safe(((CairoException)e).getFlyweightMessage()).$(", errno=").$(this.lastErrno).I$();
        } else {
            this.lastErrno = 0x7FFFFFFE;
            logRecord.$(", ex=").$(e).I$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hardLinkAndPurgeColumnFiles(String columnName, int columnIndex, boolean isIndexed, CharSequence newName, int columnType, boolean symbolCapacityChange) {
        try {
            PurgingOperator purgingOperator = this.getPurgingOperator();
            long newColumnNameTxn = this.getTxn();
            long defaultColumnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(columnIndex);
            if (PartitionBy.isPartitioned(this.partitionBy)) {
                int i = this.txWriter.getPartitionCount() - 1;
                while ((long)i > -1L) {
                    long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(i);
                    long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
                    long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
                    this.hardLinkAndPurgeColumnFiles(columnName, columnIndex, columnType, isIndexed, newName, partitionTimestamp, partitionNameTxn, newColumnNameTxn, columnNameTxn);
                    if ((long)this.columnVersionWriter.getRecordIndex(partitionTimestamp, columnIndex) > -1L) {
                        long columnTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, columnIndex);
                        this.columnVersionWriter.upsert(partitionTimestamp, columnIndex, newColumnNameTxn, columnTop);
                    }
                    --i;
                }
            } else {
                long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(this.txWriter.getLastPartitionTimestamp(), columnIndex);
                this.hardLinkAndPurgeColumnFiles(columnName, columnIndex, columnType, isIndexed, newName, this.txWriter.getLastPartitionTimestamp(), -1L, newColumnNameTxn, columnNameTxn);
                long columnTop = this.columnVersionWriter.getColumnTop(this.txWriter.getLastPartitionTimestamp(), columnIndex);
                this.columnVersionWriter.upsert(this.txWriter.getLastPartitionTimestamp(), columnIndex, newColumnNameTxn, columnTop);
            }
            if (ColumnType.isSymbol(columnType)) {
                try {
                    TableWriter.linkFile(this.ff, TableUtils.charFileName(this.path.trimTo(this.pathSize), columnName, defaultColumnNameTxn), TableUtils.charFileName(this.other.trimTo(this.pathSize), newName, newColumnNameTxn));
                    if (!symbolCapacityChange) {
                        TableWriter.linkFile(this.ff, TableUtils.offsetFileName(this.path.trimTo(this.pathSize), columnName, defaultColumnNameTxn), TableUtils.offsetFileName(this.other.trimTo(this.pathSize), newName, newColumnNameTxn));
                        TableWriter.linkFile(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.pathSize), columnName, defaultColumnNameTxn), BitmapIndexUtils.keyFileName(this.other.trimTo(this.pathSize), newName, newColumnNameTxn));
                        TableWriter.linkFile(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.pathSize), columnName, defaultColumnNameTxn), BitmapIndexUtils.valueFileName(this.other.trimTo(this.pathSize), newName, newColumnNameTxn));
                    } else {
                        this.ff.copy(TableUtils.offsetFileName(this.path.trimTo(this.pathSize), columnName, defaultColumnNameTxn), TableUtils.offsetFileName(this.other.trimTo(this.pathSize), newName, newColumnNameTxn));
                    }
                }
                catch (Throwable e) {
                    this.ff.removeQuiet(TableUtils.offsetFileName(this.other.trimTo(this.pathSize), newName, newColumnNameTxn));
                    this.ff.removeQuiet(TableUtils.charFileName(this.other.trimTo(this.pathSize), newName, newColumnNameTxn));
                    this.ff.removeQuiet(BitmapIndexUtils.keyFileName(this.other.trimTo(this.pathSize), newName, newColumnNameTxn));
                    this.ff.removeQuiet(BitmapIndexUtils.valueFileName(this.other.trimTo(this.pathSize), newName, newColumnNameTxn));
                    throw e;
                }
                purgingOperator.add(columnIndex, columnName, columnType, isIndexed, defaultColumnNameTxn, -9223372036854775807L, -1L);
            }
            long columnAddedPartition = this.columnVersionWriter.getColumnTopPartitionTimestamp(columnIndex);
            this.columnVersionWriter.upsertDefaultTxnName(columnIndex, newColumnNameTxn, columnAddedPartition);
        }
        finally {
            this.path.trimTo(this.pathSize);
            this.other.trimTo(this.pathSize);
        }
    }

    private void hardLinkAndPurgeColumnFiles(String columnName, int columnIndex, int columnType, boolean isIndexed, CharSequence newName, long partitionTimestamp, long partitionNameTxn, long newColumnNameTxn, long columnNameTxn) {
        TableUtils.setPathForNativePartition(this.path, this.partitionBy, partitionTimestamp, partitionNameTxn);
        TableUtils.setPathForNativePartition(this.other, this.partitionBy, partitionTimestamp, partitionNameTxn);
        int plen = this.path.size();
        TableWriter.linkFile(this.ff, TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn), TableUtils.dFile(this.other.trimTo(plen), newName, newColumnNameTxn));
        if (ColumnType.isVarSize(columnType)) {
            TableWriter.linkFile(this.ff, TableUtils.iFile(this.path.trimTo(plen), columnName, columnNameTxn), TableUtils.iFile(this.other.trimTo(plen), newName, newColumnNameTxn));
        } else if (ColumnType.isSymbol(columnType) && isIndexed) {
            TableWriter.linkFile(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn), BitmapIndexUtils.keyFileName(this.other.trimTo(plen), newName, newColumnNameTxn));
            TableWriter.linkFile(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn), BitmapIndexUtils.valueFileName(this.other.trimTo(plen), newName, newColumnNameTxn));
        }
        this.path.trimTo(this.pathSize);
        this.other.trimTo(this.pathSize);
        this.purgingOperator.add(columnIndex, columnName, columnType, isIndexed, columnNameTxn, partitionTimestamp, partitionNameTxn);
    }

    private void housekeep() {
        try {
            this.squashSplitPartitions(this.minSplitPartitionTimestamp, this.txWriter.getMaxTimestamp(), this.configuration.getO3LastPartitionMaxSplits());
            this.processPartitionRemoveCandidates();
            this.metrics.tableWriterMetrics().incrementCommits();
            this.enforceTtl();
        }
        catch (Throwable e) {
            LOG.error().$("data has been persisted, but we could not perform housekeeping [table=").$(this.tableToken).$(", error=").$(e).I$();
            CairoException ex = e instanceof Sinkable ? CairoException.nonCritical().put("Data has been persisted, but we could not perform housekeeping [ex=").put((Sinkable)((Object)e)).put(']') : CairoException.nonCritical().put("Data has been persisted, but we could not perform housekeeping [ex=").put(e.getMessage()).put(']');
            ex.setHousekeeping(true);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexHistoricPartitions(SymbolColumnIndexer indexer, CharSequence columnName, int indexValueBlockSize, int columnIndex) {
        long ts = this.txWriter.getMaxTimestamp();
        if (ts > Long.MIN_VALUE) {
            try {
                int n = this.txWriter.getPartitionCount() - 1;
                for (int i = 0; i < n; ++i) {
                    long timestamp = this.txWriter.getPartitionTimestampByIndex(i);
                    this.path.trimTo(this.pathSize);
                    this.setStateForTimestamp(this.path, timestamp);
                    if (!this.ff.exists(this.path.$())) continue;
                    int plen = this.path.size();
                    long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(timestamp, columnIndex);
                    if (this.txWriter.isPartitionParquet(i)) {
                        this.indexParquetPartition(indexer, columnName, i, columnIndex, columnNameTxn, indexValueBlockSize, plen, timestamp);
                        continue;
                    }
                    if (!this.ff.exists(TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn))) continue;
                    this.indexNativePartition(indexer, columnName, columnIndex, columnNameTxn, indexValueBlockSize, plen, timestamp);
                }
            }
            finally {
                indexer.releaseIndexWriter();
            }
        }
    }

    private void indexLastPartition(SymbolColumnIndexer indexer, CharSequence columnName, long columnNameTxn, int columnIndex, int indexValueBlockSize) {
        int plen = this.path.size();
        this.createIndexFiles(columnName, columnNameTxn, indexValueBlockSize, plen, true);
        long lastPartitionTs = this.txWriter.getLastPartitionTimestamp();
        long columnTop = this.columnVersionWriter.getColumnTopQuick(lastPartitionTs, columnIndex);
        indexer.configureFollowerAndWriter(this.path.trimTo(plen), columnName, columnNameTxn, this.getPrimaryColumn(columnIndex), columnTop);
        indexer.refreshSourceAndIndex(0L, this.txWriter.getTransientRowCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexNativePartition(SymbolColumnIndexer indexer, CharSequence columnName, int columnIndex, long columnNameTxn, int indexValueBlockSize, int plen, long timestamp) {
        this.path.trimTo(plen);
        LOG.info().$("indexing [path=").$substr(this.pathRootSize, this.path).I$();
        this.createIndexFiles(columnName, columnNameTxn, indexValueBlockSize, plen, true);
        long partitionSize = this.txWriter.getPartitionRowCountByTimestamp(timestamp);
        long columnTop = this.columnVersionWriter.getColumnTop(timestamp, columnIndex);
        if (columnTop > -1L && partitionSize > columnTop) {
            long columnDataFd = TableUtils.openRO(this.ff, TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn), LOG);
            try {
                indexer.configureWriter(this.path.trimTo(plen), columnName, columnNameTxn, columnTop);
                indexer.index(this.ff, columnDataFd, columnTop, partitionSize);
            }
            finally {
                this.ff.close(columnDataFd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexParquetPartition(SymbolColumnIndexer indexer, CharSequence columnName, int partitionIndex, int columnIndex, long columnNameTxn, int indexValueBlockSize, int plen, long timestamp) {
        this.path.trimTo(plen);
        LOG.info().$("indexing parquet [path=").$substr(this.pathRootSize, this.path).I$();
        long parquetAddr = 0L;
        long parquetSize = 0L;
        try (RowGroupBuffers rowGroupBuffers = new RowGroupBuffers(56);){
            parquetSize = this.txWriter.getPartitionParquetFileSize(partitionIndex);
            parquetAddr = TableUtils.mapRO(this.ff, this.path.concat("data.parquet").$(), LOG, parquetSize, 17);
            this.parquetDecoder.of(parquetAddr, parquetSize, 65);
            PartitionDecoder.Metadata parquetMetadata = this.parquetDecoder.metadata();
            int parquetColumnIndex = -1;
            int cnt = parquetMetadata.columnCount();
            for (int idx = 0; idx < cnt; ++idx) {
                if (parquetMetadata.columnId(idx) != columnIndex) continue;
                parquetColumnIndex = idx;
                break;
            }
            if (parquetColumnIndex == -1) {
                this.path.trimTo(plen);
                LOG.error().$("could not find symbol column for indexing in parquet, skipping [path=").$substr(this.pathRootSize, this.path).$(", columnIndex=").$(columnIndex).I$();
                return;
            }
            this.createIndexFiles(columnName, columnNameTxn, indexValueBlockSize, plen, true);
            long partitionSize = this.txWriter.getPartitionRowCountByTimestamp(timestamp);
            long columnTop = this.columnVersionWriter.getColumnTop(timestamp, columnIndex);
            if (columnTop > -1L && partitionSize > columnTop) {
                indexer.configureWriter(this.path.trimTo(plen), columnName, columnNameTxn, columnTop);
                this.parquetColumnIdsAndTypes.clear();
                this.parquetColumnIdsAndTypes.add(parquetColumnIndex);
                this.parquetColumnIdsAndTypes.add(12);
                long rowCount = 0L;
                int rowGroupCount = parquetMetadata.rowGroupCount();
                BitmapIndexWriter indexWriter = indexer.getWriter();
                for (int rowGroupIndex = 0; rowGroupIndex < rowGroupCount; ++rowGroupIndex) {
                    int rowGroupSize = parquetMetadata.rowGroupSize(rowGroupIndex);
                    if (rowCount + (long)rowGroupSize <= columnTop) {
                        rowCount += (long)rowGroupSize;
                        continue;
                    }
                    this.parquetDecoder.decodeRowGroup(rowGroupBuffers, this.parquetColumnIdsAndTypes, rowGroupIndex, (int)Math.max(0L, columnTop - rowCount), rowGroupSize);
                    long rowId = Math.max(rowCount, columnTop);
                    long addr = rowGroupBuffers.getChunkDataPtr(0);
                    long size = rowGroupBuffers.getChunkDataSize(0);
                    long p = addr;
                    long lim = addr + size;
                    while (p < lim) {
                        indexWriter.add(TableUtils.toIndexKey(Unsafe.getUnsafe().getInt(p)), rowId);
                        p += 4L;
                        ++rowId;
                    }
                    rowCount += (long)rowGroupSize;
                }
                indexWriter.setMaxValue(partitionSize - 1L);
            }
        }
        finally {
            this.ff.munmap(parquetAddr, parquetSize, 17);
            Misc.free(this.parquetDecoder);
        }
    }

    private void initLastPartition(long timestamp) {
        long ts = this.repairDataGaps(timestamp);
        this.openLastPartitionAndSetAppendPosition(ts);
        this.populateDenseIndexerList();
        if (this.performRecovery) {
            this.performRecovery();
        }
        this.txWriter.initLastPartition(ts);
    }

    private boolean isEmptyTable() {
        return this.txWriter.getPartitionCount() == 0 && this.txWriter.getLagRowCount() == 0;
    }

    private boolean isLastPartitionClosed() {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.metadata.getColumnType(i) <= 0) continue;
            return !this.columns.getQuick(TableWriter.getPrimaryColumnIndex(i)).isOpen();
        }
        return false;
    }

    private void lock() {
        try {
            this.path.trimTo(this.pathSize);
            this.performRecovery = this.ff.exists(TableUtils.lockName(this.path));
            this.lockFd = TableUtils.lock(this.ff, this.path.$());
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
        if (this.lockFd == -1L) {
            throw CairoException.critical(this.ff.errno()).put("cannot lock table: ").put(this.path.$());
        }
    }

    private long mapAppendColumnBuffer(MemoryMA column, long offset, long size, boolean rw) {
        if (size == 0L) {
            return 0L;
        }
        column.jumpTo(offset + size);
        long address = column.map(offset, size);
        if (address != 0L) {
            return address;
        }
        return -TableUtils.mapAppendColumnBuffer(this.ff, column.getFd(), offset, size, rw, 12);
    }

    private void mapAppendColumnBufferRelease(long address, long offset, long size) {
        if (address < 0L) {
            TableUtils.mapAppendColumnBufferRelease(this.ff, -address, offset, size, 12);
        }
    }

    private Row newRowO3(long timestamp) {
        LOG.info().$("switched to o3 [table=").$safe(this.tableToken.getTableName()).I$();
        this.txWriter.beginPartitionSizeUpdate();
        this.o3OpenColumns();
        this.o3InError = false;
        this.o3MasterRef = this.masterRef;
        this.rowAction = 3;
        this.o3TimestampSetter(timestamp);
        return this.row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean o3Commit(long o3MaxLag) {
        this.o3RowCount = this.getO3RowCount0();
        long o3LagRowCount = 0L;
        long maxUncommittedRows = this.metadata.getMaxUncommittedRows();
        int timestampColumnIndex = this.metadata.getTimestampIndex();
        this.lastPartitionTimestamp = this.txWriter.getPartitionTimestampByTimestamp(this.partitionTimestampHi);
        long partitionTimestampHiLimit = this.txWriter.getNextPartitionTimestamp(this.partitionTimestampHi) - 1L;
        try {
            long srcOooMax;
            this.o3RowCount += this.o3MoveUncommitted();
            LOG.debug().$("sorting o3 [table=").$safe(this.tableToken.getTableName()).I$();
            long sortedTimestampsAddr = this.o3TimestampMem.getAddress();
            assert (this.o3TimestampMem.getAppendOffset() == this.o3RowCount * 16L);
            if (this.o3RowCount > 600L || !this.o3QuickSortEnabled) {
                this.o3TimestampMemCpy.jumpTo(this.o3TimestampMem.getAppendOffset());
                Vect.radixSortLongIndexAscInPlace(sortedTimestampsAddr, this.o3RowCount, this.o3TimestampMemCpy.addressOf(0L));
            } else {
                Vect.quickSortLongIndexAscInPlace(sortedTimestampsAddr, this.o3RowCount);
            }
            long o3TimestampMin = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, 0L);
            if (o3TimestampMin < 0L) {
                this.o3InError = true;
                throw CairoException.nonCritical().put("O3 commit encountered timestamp before 1970-01-01");
            }
            long o3TimestampMax = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, this.o3RowCount - 1L);
            if (o3TimestampMax < 0L) {
                this.o3InError = true;
                throw CairoException.nonCritical().put("O3 commit encountered timestamp before 1970-01-01");
            }
            assert (o3TimestampMin <= o3TimestampMax);
            if (o3MaxLag > 0L) {
                long lagError = 0L;
                if (this.getMaxTimestamp() != Long.MIN_VALUE) {
                    lagError = this.getMaxTimestamp() - this.o3CommitBatchTimestampMin;
                    int n = this.o3LastTimestampSpreads.length - 1;
                    if (lagError > 0L) {
                        this.o3EffectiveLag += (long)((double)lagError * this.configuration.getO3LagIncreaseFactor());
                        this.o3EffectiveLag = Math.min(this.o3EffectiveLag, o3MaxLag);
                    } else {
                        this.o3EffectiveLag += (long)((double)lagError * this.configuration.getO3LagDecreaseFactor());
                        this.o3EffectiveLag = Math.max(0L, this.o3EffectiveLag);
                    }
                    long max = Long.MIN_VALUE;
                    for (int i = 0; i < n; ++i) {
                        long e;
                        this.o3LastTimestampSpreads[i] = e = this.o3LastTimestampSpreads[i + 1];
                        max = Math.max(e, max);
                    }
                    this.o3LastTimestampSpreads[n] = this.o3EffectiveLag;
                    this.o3EffectiveLag = Math.max(this.o3EffectiveLag, max);
                } else {
                    this.o3EffectiveLag = o3MaxLag;
                }
                long lagThresholdTimestamp = o3TimestampMax - this.o3EffectiveLag;
                if (lagThresholdTimestamp >= o3TimestampMin) {
                    long lagThresholdRow = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, lagThresholdTimestamp, 0L, this.o3RowCount - 1L, 1);
                    o3LagRowCount = this.o3RowCount - lagThresholdRow - 1L;
                    if (o3LagRowCount > maxUncommittedRows) {
                        o3LagRowCount = maxUncommittedRows;
                        srcOooMax = this.o3RowCount - maxUncommittedRows;
                    } else {
                        srcOooMax = lagThresholdRow + 1L;
                    }
                } else {
                    o3LagRowCount = this.o3RowCount;
                    if (o3LagRowCount > maxUncommittedRows) {
                        o3LagRowCount = maxUncommittedRows / 2L;
                        srcOooMax = this.o3RowCount - o3LagRowCount;
                    } else {
                        srcOooMax = 0L;
                    }
                }
                LOG.info().$("o3 commit [table=").$safe(this.tableToken.getTableName()).$(", maxUncommittedRows=").$(maxUncommittedRows).$(", o3TimestampMin=").$ts(o3TimestampMin).$(", o3TimestampMax=").$ts(o3TimestampMax).$(", o3MaxLagUs=").$(o3MaxLag).$(", o3EffectiveLagUs=").$(this.o3EffectiveLag).$(", lagError=").$(lagError).$(", o3SpreadUs=").$(o3TimestampMax - o3TimestampMin).$(", lagThresholdTimestamp=").$ts(lagThresholdTimestamp).$(", o3LagRowCount=").$(o3LagRowCount).$(", srcOooMax=").$(srcOooMax).$(", o3RowCount=").$(this.o3RowCount).I$();
            } else {
                LOG.info().$("o3 commit [table=").$safe(this.tableToken.getTableName()).$(", o3RowCount=").$(this.o3RowCount).I$();
                srcOooMax = this.o3RowCount;
            }
            this.o3CommitBatchTimestampMin = Long.MAX_VALUE;
            if (srcOooMax == 0L) {
                boolean lagError = true;
                return lagError;
            }
            o3TimestampMax = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOooMax - 1L);
            long sortedTimestampsRowCount = this.o3RowCount;
            this.dispatchColumnTasks(sortedTimestampsAddr, sortedTimestampsRowCount, -1L, -1L, -1L, this.cthO3SortColumnRef);
            this.swapO3ColumnsExcept(timestampColumnIndex);
            LOG.info().$("sorted [table=").$safe(this.tableToken.getTableName()).$(", o3RowCount=").$(this.o3RowCount).I$();
            this.processO3Block(o3LagRowCount, timestampColumnIndex, sortedTimestampsAddr, srcOooMax, o3TimestampMin, o3TimestampMax, true, 0L, TableWriterPressureControl.EMPTY);
        }
        finally {
            this.finishO3Append(o3LagRowCount);
        }
        this.finishO3Commit(partitionTimestampHiLimit);
        return false;
    }

    private void o3CommitPartitionAsync(AtomicInteger columnCounter, long maxTimestamp, long sortedTimestampsAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long partitionTimestamp, long srcDataMax, boolean last, long srcNameTxn, O3Basket o3Basket, long newPartitionSize, long oldPartitionSize, long partitionUpdateSinkAddr, long dedupColSinkAddr, boolean isParquet, long o3TimestampLo, long o3TimestampHi) {
        long cursor = this.messageBus.getO3PartitionPubSeq().next();
        if (cursor > -1L) {
            O3PartitionTask task = this.messageBus.getO3PartitionQueue().get(cursor);
            task.of(this.path, this.partitionBy, this.columns, this.o3Columns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, partitionTimestamp, maxTimestamp, srcDataMax, srcNameTxn, last, this.getTxn(), sortedTimestampsAddr, this, columnCounter, o3Basket, newPartitionSize, oldPartitionSize, partitionUpdateSinkAddr, dedupColSinkAddr, isParquet, o3TimestampLo, o3TimestampHi);
            this.messageBus.getO3PartitionPubSeq().done(cursor);
        } else {
            O3PartitionJob.processPartition(this.path, this.partitionBy, this.columns, this.o3Columns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, partitionTimestamp, maxTimestamp, srcDataMax, srcNameTxn, last, this.getTxn(), sortedTimestampsAddr, this, columnCounter, o3Basket, newPartitionSize, oldPartitionSize, partitionUpdateSinkAddr, dedupColSinkAddr, isParquet, o3TimestampLo, o3TimestampHi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3ConsumePartitionUpdateSink() {
        long blockIndex = -1L;
        long commitTransientRowCount = this.txWriter.transientRowCount;
        boolean partitionsRemoved = false;
        boolean firstPartitionRemoved = false;
        boolean lastPartitionRemoved = false;
        while ((blockIndex = this.o3PartitionUpdateSink.nextBlockIndex(blockIndex)) > -1L) {
            long blockAddress = this.o3PartitionUpdateSink.getBlockAddress(blockIndex);
            long partitionTimestamp = Unsafe.getUnsafe().getLong(blockAddress);
            long timestampMin = Unsafe.getUnsafe().getLong(blockAddress + 8L);
            if (partitionTimestamp == -1L || timestampMin == -1L) continue;
            long srcDataNewPartitionSize = Unsafe.getUnsafe().getLong(blockAddress + 16L);
            long srcDataOldPartitionSize = Unsafe.getUnsafe().getLong(blockAddress + 24L);
            long flags = Unsafe.getUnsafe().getLong(blockAddress + 32L);
            boolean partitionMutates = Numbers.decodeLowInt(flags) != 0;
            boolean isLastWrittenPartition = this.o3PartitionUpdateSink.nextBlockIndex(blockIndex) == -1L;
            long o3SplitPartitionSize = Unsafe.getUnsafe().getLong(blockAddress + 40L);
            if (!partitionMutates && srcDataNewPartitionSize < 0L) continue;
            boolean isMinPartitionUpdate = partitionTimestamp == this.txWriter.getPartitionTimestampByTimestamp(this.txWriter.getMinTimestamp()) && partitionTimestamp == this.txWriter.getPartitionTimestampByTimestamp(timestampMin);
            boolean isFirstPartitionReplaced = this.isCommitReplaceMode() && isMinPartitionUpdate;
            this.txWriter.minTimestamp = isFirstPartitionReplaced ? timestampMin : Math.min(timestampMin, this.txWriter.minTimestamp);
            int partitionIndexRaw = this.txWriter.findAttachedPartitionRawIndexByLoTimestamp(partitionTimestamp);
            long newPartitionTimestamp = partitionTimestamp;
            int newPartitionIndex = partitionIndexRaw;
            if (partitionIndexRaw < 0) {
                partitionTimestamp = this.txWriter.getPartitionTimestampByTimestamp(partitionTimestamp);
                partitionIndexRaw = this.txWriter.findAttachedPartitionRawIndexByLoTimestamp(partitionTimestamp);
            }
            if (this.isCommitReplaceMode() && srcDataOldPartitionSize > 0L && srcDataNewPartitionSize < srcDataOldPartitionSize) {
                if (!partitionMutates) {
                    this.o3ConsumePartitionUpdateSink_trimPartitionColumnTops(partitionTimestamp, srcDataNewPartitionSize);
                }
                if (partitionTimestamp == this.lastPartitionTimestamp) {
                    partitionsRemoved = true;
                    lastPartitionRemoved = true;
                }
            }
            if (partitionTimestamp == this.lastPartitionTimestamp && newPartitionTimestamp == partitionTimestamp) {
                if (partitionMutates) {
                    this.closeActivePartition(true);
                } else if (!isLastWrittenPartition) {
                    this.closeActivePartition(srcDataNewPartitionSize);
                } else {
                    this.setAppendPosition(srcDataNewPartitionSize, false);
                }
            }
            if (partitionTimestamp < this.lastPartitionTimestamp) {
                this.txWriter.fixedRowCount += srcDataNewPartitionSize - srcDataOldPartitionSize + o3SplitPartitionSize;
            } else {
                if (partitionTimestamp != this.lastPartitionTimestamp) {
                    this.txWriter.fixedRowCount += commitTransientRowCount;
                }
                if (o3SplitPartitionSize > 0L) {
                    this.txWriter.fixedRowCount += srcDataNewPartitionSize;
                    commitTransientRowCount = o3SplitPartitionSize;
                } else {
                    commitTransientRowCount = srcDataNewPartitionSize;
                }
            }
            LOG.info().$("o3 partition update [timestampMin=").$ts(timestampMin).$(", last=").$(partitionTimestamp == this.lastPartitionTimestamp).$(", partitionTimestamp=").$ts(partitionTimestamp).$(", partitionMutates=").$(partitionMutates).$(", lastPartitionTimestamp=").$ts(this.lastPartitionTimestamp).$(", srcDataOldPartitionSize=").$(srcDataOldPartitionSize).$(", srcDataNewPartitionSize=").$(srcDataNewPartitionSize).$(", o3SplitPartitionSize=").$(o3SplitPartitionSize).$(", commitTransientRowCount=").$(commitTransientRowCount).$(", fixedRowCount=").$(this.txWriter.fixedRowCount).I$();
            if (newPartitionTimestamp != partitionTimestamp) {
                LOG.info().$("o3 split partition [table=").$safe(this.tableToken.getTableName()).$(", part1=").$(this.formatPartitionForTimestamp(partitionTimestamp, this.txWriter.getPartitionNameTxnByPartitionTimestamp(partitionTimestamp))).$(", part1OldSize=").$(srcDataOldPartitionSize).$(", part1NewSize=").$(srcDataNewPartitionSize).$(", part2=").$(this.formatPartitionForTimestamp(newPartitionTimestamp, this.txWriter.txn)).$(", part2Size=").$(o3SplitPartitionSize).I$();
                this.minSplitPartitionTimestamp = Math.min(this.minSplitPartitionTimestamp, newPartitionTimestamp);
                this.txWriter.bumpPartitionTableVersion();
                this.txWriter.updateAttachedPartitionSizeByRawIndex(newPartitionIndex, newPartitionTimestamp, o3SplitPartitionSize, this.txWriter.txn);
                if (partitionTimestamp == this.lastPartitionTimestamp) {
                    long committedLastPartitionSize = this.txWriter.getPartitionRowCountByTimestamp(partitionTimestamp);
                    this.closeActivePartition(committedLastPartitionSize);
                }
            }
            if (partitionMutates && newPartitionTimestamp == partitionTimestamp) {
                long srcNameTxn = this.txWriter.getPartitionNameTxnByRawIndex(partitionIndexRaw);
                LOG.info().$("merged partition [table=`").$safe(this.tableToken.getTableName()).$("`, ts=").$ts(partitionTimestamp).$(", txn=").$(this.txWriter.txn).$(", rows=").$(srcDataNewPartitionSize).I$();
                if (this.isCommitReplaceMode() && srcDataNewPartitionSize == 0L) {
                    boolean isSplitPartition;
                    int partIndex = this.txWriter.getPartitionIndex(partitionTimestamp);
                    boolean bl = isSplitPartition = partIndex > 0 && this.txWriter.getPartitionFloor(this.txWriter.getPartitionTimestampByIndex(partIndex - 1)) == this.txWriter.getPartitionFloor(partitionTimestamp);
                    if (!isSplitPartition) {
                        LOG.info().$("partition is fully removed in range replace [table=").$(this.tableToken).$(", ts=").$ts(partitionTimestamp).I$();
                        this.txWriter.removeAttachedPartitions(partitionTimestamp);
                        this.columnVersionWriter.removePartition(partitionTimestamp);
                        this.partitionRemoveCandidates.add(partitionTimestamp, srcNameTxn);
                    } else {
                        this.txWriter.updatePartitionSizeByTimestamp(partitionTimestamp, srcDataNewPartitionSize);
                    }
                    partitionsRemoved = true;
                    firstPartitionRemoved |= partIndex == 0;
                    boolean removedIsLast = partIndex == this.txWriter.getPartitionCount();
                    lastPartitionRemoved |= removedIsLast;
                    if (!removedIsLast) continue;
                    if (partIndex > 0) {
                        int newLastPartitionIndex = partIndex - 1;
                        long newLastPartitionTimestamp = this.txWriter.getPartitionTimestampByIndex(newLastPartitionIndex);
                        long newLastPartitionSize = this.txWriter.getPartitionSize(newLastPartitionIndex);
                        this.columnVersionWriter.replaceInitialPartitionRecords(newLastPartitionTimestamp, newLastPartitionSize);
                        this.o3ConsumePartitionUpdateSink_trimPartitionColumnTops(newLastPartitionTimestamp, newLastPartitionSize);
                        continue;
                    }
                    this.columnVersionWriter.truncate();
                    continue;
                }
                long parquetFileSize = Unsafe.getUnsafe().getLong(blockAddress + 56L);
                if (parquetFileSize > -1L) {
                    this.txWriter.updatePartitionSizeByRawIndex(partitionIndexRaw, partitionTimestamp, srcDataNewPartitionSize);
                    this.txWriter.setPartitionParquetFormat(partitionTimestamp, parquetFileSize);
                } else {
                    this.txWriter.updatePartitionSizeAndTxnByRawIndex(partitionIndexRaw, srcDataNewPartitionSize);
                    this.partitionRemoveCandidates.add(partitionTimestamp, srcNameTxn);
                }
                this.txWriter.bumpPartitionTableVersion();
                continue;
            }
            if (partitionTimestamp != this.lastPartitionTimestamp) {
                this.txWriter.bumpPartitionTableVersion();
            }
            this.txWriter.updatePartitionSizeByRawIndex(partitionIndexRaw, partitionTimestamp, srcDataNewPartitionSize);
        }
        if (partitionsRemoved) {
            this.o3ConsumePartitionUpdateSink_processSplitPartitionRemoval();
            if (this.txWriter.getPartitionCount() > 0) {
                try {
                    if (firstPartitionRemoved) {
                        long firstPartitionTimestamp = this.txWriter.getPartitionTimestampByIndex(0);
                        long partitionSize = this.txWriter.getPartitionSize(0);
                        TableUtils.setPathForNativePartition(this.path, this.partitionBy, firstPartitionTimestamp, this.txWriter.getPartitionNameTxn(0));
                        this.readPartitionMinMaxTimestamps(firstPartitionTimestamp, this.path, this.metadata.getColumnName(this.metadata.getTimestampIndex()), -1L, partitionSize);
                        this.txWriter.minTimestamp = this.attachMinTimestamp;
                    }
                    if (lastPartitionRemoved) {
                        int lastPartitionIndex = this.txWriter.getPartitionCount() - 1;
                        long lastPartitionTimestamp = this.txWriter.getPartitionTimestampByIndex(lastPartitionIndex);
                        long partitionSize = this.txWriter.getPartitionSize(lastPartitionIndex);
                        TableUtils.setPathForNativePartition(this.path.trimTo(this.pathSize), this.partitionBy, lastPartitionTimestamp, this.txWriter.getPartitionNameTxn(lastPartitionIndex));
                        this.readPartitionMinMaxTimestamps(lastPartitionTimestamp, this.path, this.metadata.getColumnName(this.metadata.getTimestampIndex()), -1L, partitionSize);
                        this.txWriter.maxTimestamp = this.attachMaxTimestamp;
                    }
                }
                finally {
                    this.path.trimTo(this.pathSize);
                }
                this.txWriter.finishPartitionSizeUpdate(this.txWriter.getMinTimestamp(), this.txWriter.getMaxTimestamp());
                assert (this.partitionTimestampHi != Long.MIN_VALUE);
            } else {
                LOG.info().$("replace commit truncated the table [table=").$(this.tableToken).$();
                this.freeColumns(false);
                this.releaseIndexerWriters();
                this.partitionTimestampHi = Long.MIN_VALUE;
                this.lastPartitionTimestamp = Long.MIN_VALUE;
                this.rowAction = 0;
                this.txWriter.resetTimestamp();
                this.columnVersionWriter.truncate();
                this.txWriter.truncate(this.columnVersionWriter.getVersion(), this.denseSymbolMapWriters);
            }
            this.txWriter.bumpPartitionTableVersion();
        } else {
            this.txWriter.transientRowCount = commitTransientRowCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3ConsumePartitionUpdateSink_findNewSplitPartitionSizeTimestamp(Path partitionPath, long partitionTimestamp, long partitionSize) {
        int pathSize = partitionPath.size();
        try {
            CharSequence tsColumnName = this.metadata.getColumnName(this.metadata.getTimestampIndex());
            long fd = TableUtils.openRO(this.ff, TableUtils.dFile(partitionPath, tsColumnName, -1L), LOG);
            try {
                long mapSize = partitionSize * 8L;
                long addr = TableUtils.mapRO(this.ff, fd, mapSize, 12);
                try {
                    long row;
                    long lastTs = Unsafe.getUnsafe().getLong(addr + (partitionSize - 1L) * 8L);
                    long currentTs = lastTs - 1L;
                    for (row = partitionSize - 2L; row >= 0L && (currentTs = Unsafe.getUnsafe().getLong(addr + row * 8L)) == lastTs; --row) {
                    }
                    this.attachMinTimestamp = row + 1L;
                    this.attachMaxTimestamp = row > -1L ? currentTs + 1L : partitionTimestamp;
                }
                finally {
                    this.ff.munmap(addr, mapSize, 12);
                }
            }
            finally {
                this.ff.close(fd);
            }
        }
        finally {
            partitionPath.trimTo(pathSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3ConsumePartitionUpdateSink_processSplitPartitionRemoval() {
        for (int i = this.txWriter.getPartitionCount() - 1; i > 0; --i) {
            long partitionSize = this.txWriter.getPartitionSize(i);
            if (partitionSize != 0L) continue;
            long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(i);
            long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
            long prevPartitionTimestamp = this.txWriter.getPartitionTimestampByIndex(i - 1);
            long prevPartitionSize = this.txWriter.getPartitionSize(i - 1);
            long prevPartitionTxn = this.txWriter.getPartitionNameTxn(i - 1);
            if (this.txWriter.getPartitionFloor(partitionTimestamp) != this.txWriter.getPartitionFloor(prevPartitionTimestamp) || prevPartitionSize == 0L || prevPartitionTxn == this.txWriter.txn) {
                this.partitionRemoveCandidates.add(partitionTimestamp, partitionNameTxn);
                this.txWriter.removeAttachedPartitions(partitionTimestamp);
                continue;
            }
            try {
                long prevPartitionNameTxn = this.setStateForTimestamp(this.path, prevPartitionTimestamp);
                this.o3ConsumePartitionUpdateSink_findNewSplitPartitionSizeTimestamp(this.path, prevPartitionTimestamp, prevPartitionSize);
                long newPrevPartitionSize = this.attachMinTimestamp;
                long newSplitPartitionTimestamp = this.attachMaxTimestamp;
                assert (newSplitPartitionTimestamp < partitionTimestamp || newPrevPartitionSize == 0L && newSplitPartitionTimestamp == partitionTimestamp);
                LOG.info().$("splitting last line of the partition [table=").$(this.tableToken).$(", partition=").$ts(prevPartitionTimestamp).$(", oldSize=").$(prevPartitionSize).$(", newSize=").$(newPrevPartitionSize).$(", splitPartition=").$ts(newSplitPartitionTimestamp).$(", splitPartitionNameTxn=").$(this.txWriter.txn).$(", deletedSplitPartition=").$ts(partitionTimestamp).$();
                int insertPartitionIndex = i;
                FrameFactory frameFactory = this.engine.getFrameFactory();
                try (Frame sourceFrame = frameFactory.openRO(this.path, prevPartitionTimestamp, this.metadata, this.columnVersionWriter, prevPartitionSize);){
                    if (newPrevPartitionSize == 0L) {
                        this.partitionRemoveCandidates.add(prevPartitionTimestamp, prevPartitionNameTxn);
                        insertPartitionIndex = this.txWriter.removeAttachedPartitions(prevPartitionTimestamp);
                    } else {
                        this.txWriter.updatePartitionSizeByTimestamp(prevPartitionTimestamp, newPrevPartitionSize);
                    }
                    this.txWriter.insertPartition(insertPartitionIndex, newSplitPartitionTimestamp, prevPartitionSize - newPrevPartitionSize, this.txWriter.txn);
                    this.setStateForTimestamp(this.other, newSplitPartitionTimestamp);
                    this.ff.mkdir(this.other.$(), this.configuration.getMkDirMode());
                    try (Frame targetFrame = frameFactory.createRW(this.other, newSplitPartitionTimestamp, this.metadata, this.columnVersionWriter, 0L);){
                        FrameAlgebra.append(targetFrame, sourceFrame, newPrevPartitionSize, prevPartitionSize, this.configuration.getCommitMode());
                    }
                }
                this.addPhysicallyWrittenRows(prevPartitionSize - newPrevPartitionSize);
                this.partitionRemoveCandidates.add(partitionTimestamp, partitionNameTxn);
                this.txWriter.removeAttachedPartitions(partitionTimestamp);
                continue;
            }
            finally {
                this.path.trimTo(this.pathSize);
                this.other.trimTo(this.pathSize);
            }
        }
    }

    private void o3ConsumePartitionUpdateSink_trimPartitionColumnTops(long partitionTimestamp, long newPartitionSize) {
        int columnCount = this.metadata.getColumnCount();
        for (int column = 0; column < columnCount; ++column) {
            long colTop = this.getColumnTop(partitionTimestamp, column, -1L);
            if (colTop <= newPartitionSize) continue;
            this.columnVersionWriter.upsertColumnTop(partitionTimestamp, column, newPartitionSize);
        }
    }

    private void o3ConsumePartitionUpdates() {
        MCSequence partitionSubSeq = this.messageBus.getO3PartitionSubSeq();
        RingQueue<O3PartitionTask> partitionQueue = this.messageBus.getO3PartitionQueue();
        MCSequence openColumnSubSeq = this.messageBus.getO3OpenColumnSubSeq();
        RingQueue<O3OpenColumnTask> openColumnQueue = this.messageBus.getO3OpenColumnQueue();
        MCSequence copySubSeq = this.messageBus.getO3CopySubSeq();
        RingQueue<O3CopyTask> copyQueue = this.messageBus.getO3CopyQueue();
        do {
            long cursor;
            if ((cursor = partitionSubSeq.next()) > -1L) {
                O3PartitionTask partitionTask = partitionQueue.get(cursor);
                if (partitionTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                    partitionSubSeq.done(cursor);
                    this.o3ClockDownPartitionUpdateCount();
                    this.o3CountDownDoneLatch();
                    continue;
                }
                this.o3ProcessPartitionSafe(partitionSubSeq, cursor, partitionTask);
                continue;
            }
            cursor = openColumnSubSeq.next();
            if (cursor > -1L) {
                O3OpenColumnTask openColumnTask = openColumnQueue.get(cursor);
                if (openColumnTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                    O3CopyJob.closeColumnIdle(openColumnTask.getColumnCounter(), openColumnTask.getTimestampMergeIndexAddr(), openColumnTask.getTimestampMergeIndexSize(), openColumnTask.getSrcTimestampFd(), openColumnTask.getSrcTimestampAddr(), openColumnTask.getSrcTimestampSize(), this);
                    openColumnSubSeq.done(cursor);
                    continue;
                }
                this.o3OpenColumnSafe(openColumnSubSeq, cursor, openColumnTask);
                continue;
            }
            cursor = copySubSeq.next();
            if (cursor <= -1L) continue;
            O3CopyTask copyTask = copyQueue.get(cursor);
            if (copyTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                O3CopyJob.unmapAndClose(copyTask.getColumnCounter(), copyTask.getPartCounter(), copyTask.getTimestampMergeIndexAddr(), copyTask.getTimestampMergeIndexSize(), copyTask.getSrcDataFixFd(), copyTask.getSrcDataFixAddr(), copyTask.getSrcDataFixSize(), copyTask.getSrcDataVarFd(), copyTask.getSrcDataVarAddr(), copyTask.getSrcDataVarSize(), copyTask.getDstFixFd(), copyTask.getDstFixAddr(), copyTask.getDstFixSize(), copyTask.getDstVarFd(), copyTask.getDstVarAddr(), copyTask.getDstVarSize(), copyTask.getSrcTimestampFd(), copyTask.getSrcTimestampAddr(), copyTask.getSrcTimestampSize(), copyTask.getDstKFd(), copyTask.getDstVFd(), this);
                copySubSeq.done(cursor);
                continue;
            }
            this.o3CopySafe(cursor);
        } while (this.o3PartitionUpdRemaining.get() > 0L);
    }

    private void o3CopySafe(long cursor) {
        O3CopyTask task = this.messageBus.getO3CopyQueue().get(cursor);
        try {
            O3CopyJob.copy(task, cursor, this.messageBus.getO3CopySubSeq());
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    private long o3MoveUncommitted() {
        long committedRowCount = this.txWriter.unsafeCommittedFixedRowCount() + this.txWriter.unsafeCommittedTransientRowCount();
        long rowsAdded = this.txWriter.getRowCount() - committedRowCount;
        long transientRowCount = this.txWriter.getTransientRowCount();
        long transientRowsAdded = Math.min(transientRowCount, rowsAdded);
        if (transientRowsAdded > 0L) {
            LOG.debug().$("o3 move uncommitted [table=").$safe(this.tableToken.getTableName()).$(", transientRowsAdded=").$(transientRowsAdded).I$();
            long committedTransientRowCount = transientRowCount - transientRowsAdded;
            this.dispatchColumnTasks(committedTransientRowCount, -1L, transientRowsAdded, -1L, -1L, this.cthO3MoveUncommittedRef);
            this.txWriter.resetToLastPartition(committedTransientRowCount);
            return transientRowsAdded;
        }
        return 0L;
    }

    private void o3OpenColumnSafe(Sequence openColumnSubSeq, long cursor, O3OpenColumnTask openColumnTask) {
        try {
            O3OpenColumnJob.openColumn(openColumnTask, cursor, openColumnSubSeq);
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    private void o3OpenColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            int columnType = this.metadata.getColumnType(i);
            if (columnType <= 0) continue;
            MemoryARW dataMem = this.o3MemColumns1.getQuick(TableWriter.getPrimaryColumnIndex(i));
            MemoryARW auxMem = this.o3MemColumns1.getQuick(TableWriter.getSecondaryColumnIndex(i));
            dataMem.jumpTo(0L);
            if (!ColumnType.isVarSize(columnType)) continue;
            auxMem.jumpTo(0L);
            ColumnType.getDriver(columnType).configureAuxMemO3RSS(auxMem);
        }
        this.activeColumns = this.o3MemColumns1;
        this.activeNullSetters = this.o3NullSetters1;
        LOG.debug().$("switched partition to memory").$();
    }

    private void o3ProcessPartitionSafe(Sequence partitionSubSeq, long cursor, O3PartitionTask partitionTask) {
        try {
            O3PartitionJob.processPartition(partitionTask, cursor, partitionSubSeq);
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    private void o3SetAppendOffset(int columnIndex, int columnType, long o3RowCount) {
        if (columnIndex != this.metadata.getTimestampIndex()) {
            long size;
            MemoryARW o3DataMem = this.o3MemColumns1.get(TableWriter.getPrimaryColumnIndex(columnIndex));
            MemoryARW o3IndexMem = this.o3MemColumns1.get(TableWriter.getSecondaryColumnIndex(columnIndex));
            if (o3IndexMem == null) {
                size = o3RowCount << ColumnType.pow2SizeOf(columnType);
            } else {
                ColumnTypeDriver driver = ColumnType.getDriver(columnType);
                size = o3RowCount > 0L ? driver.getDataVectorSizeAt(o3IndexMem.addressOf(0L), o3RowCount - 1L) : 0L;
                o3IndexMem.jumpTo(driver.getAuxVectorSize(o3RowCount));
            }
            o3DataMem.jumpTo(size);
        } else {
            this.o3TimestampMem.jumpTo(o3RowCount * 16L);
        }
    }

    private void o3TimestampSetter(long timestamp) {
        this.o3TimestampMem.putLong128(timestamp, this.getO3RowCount0());
        this.o3CommitBatchTimestampMin = Math.min(this.o3CommitBatchTimestampMin, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openColumnFiles(CharSequence name, long columnNameTxn, int columnIndex, int pathTrimToLen) {
        MemoryMA mem1 = this.getPrimaryColumn(columnIndex);
        MemoryMA mem2 = this.getSecondaryColumn(columnIndex);
        try {
            mem1.of(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), this.dataAppendPageSize, -1L, 12, this.configuration.getWriterFileOpenOpts(), Files.POSIX_MADV_RANDOM);
            if (mem2 != null) {
                mem2.of(this.ff, TableUtils.iFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), this.dataAppendPageSize, -1L, 12, this.configuration.getWriterFileOpenOpts(), Files.POSIX_MADV_RANDOM);
            }
        }
        finally {
            this.path.trimTo(pathTrimToLen);
        }
    }

    private void openLastPartitionAndSetAppendPosition(long ts) {
        this.openPartition(ts, this.txWriter.getTransientRowCount() + (long)this.txWriter.getLagRowCount());
        this.setAppendPosition(this.txWriter.getTransientRowCount() + (long)this.txWriter.getLagRowCount(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewColumnFiles(CharSequence name, int columnType, boolean indexFlag, int indexValueBlockCapacity) {
        try {
            long partitionTimestamp = this.txWriter.getLastPartitionTimestamp();
            this.setStateForTimestamp(this.path, partitionTimestamp);
            int plen = this.path.size();
            int columnIndex = this.columnCount - 1;
            long columnNameTxn = this.getTxn();
            if (indexFlag) {
                this.createIndexFiles(name, columnNameTxn, indexValueBlockCapacity, plen, true);
            }
            this.openColumnFiles(name, columnNameTxn, columnIndex, plen);
            if (this.txWriter.getTransientRowCount() > 0L) {
                this.columnVersionWriter.upsert(this.txWriter.getLastPartitionTimestamp(), columnIndex, columnNameTxn, this.txWriter.getTransientRowCount());
            }
            if (indexFlag) {
                ColumnIndexer indexer = this.indexers.getQuick(columnIndex);
                assert (indexer != null);
                this.indexers.getQuick(columnIndex).configureFollowerAndWriter(this.path.trimTo(plen), name, columnNameTxn, this.getPrimaryColumn(columnIndex), this.txWriter.getTransientRowCount());
            }
            if (ColumnType.isVarSize(columnType)) {
                ColumnType.getDriver(columnType).configureAuxMemMA(this.getSecondaryColumn(this.columnCount - 1));
            }
            LOG.info().$("ADDED column '").$safe(name).$('[').$(ColumnType.nameOf(columnType)).$("], columnName txn ").$(columnNameTxn).$(" to ").$substr(this.pathRootSize, this.path).$(" with columnTop ").$(this.txWriter.getTransientRowCount()).$();
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
    }

    private void openPartition(long timestamp, long rowCount) {
        try {
            timestamp = this.txWriter.getPartitionTimestampByTimestamp(timestamp);
            this.lastOpenPartitionTxnName = this.setStateForTimestamp(this.path, timestamp);
            this.partitionTimestampHi = this.txWriter.getNextPartitionTimestamp(timestamp) - 1L;
            int plen = this.path.size();
            if (this.ff.mkdirs(this.path.slash(), this.mkDirMode) != 0) {
                throw CairoException.critical(this.ff.errno()).put("cannot create directory: ").put(this.path);
            }
            assert (this.columnCount > 0);
            this.lastOpenPartitionTs = timestamp;
            this.lastOpenPartitionIsReadOnly = this.partitionBy != 3 && this.txWriter.isPartitionReadOnlyByPartitionTimestamp(this.lastOpenPartitionTs);
            for (int i = 0; i < this.columnCount; ++i) {
                ColumnIndexer indexer;
                if (this.metadata.getColumnType(i) <= 0) continue;
                CharSequence name = this.metadata.getColumnName(i);
                long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(this.lastOpenPartitionTs, i);
                ColumnIndexer columnIndexer = indexer = this.metadata.isColumnIndexed(i) ? this.indexers.getQuick(i) : null;
                if (indexer != null) {
                    this.createIndexFiles(name, columnNameTxn, this.metadata.getIndexValueBlockCapacity(i), plen, rowCount < 1L);
                }
                this.openColumnFiles(name, columnNameTxn, i, plen);
                if (indexer == null) continue;
                long columnTop = this.columnVersionWriter.getColumnTopQuick(this.lastOpenPartitionTs, i);
                indexer.configureFollowerAndWriter(this.path, name, columnNameTxn, this.getPrimaryColumn(i), columnTop);
            }
            this.populateDenseIndexerList();
            LOG.info().$("switched partition [path=").$substr(this.pathRootSize, this.path).$(", rowCount=").$(rowCount).I$();
        }
        catch (Throwable e) {
            this.distressed = true;
            throw e;
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long openTodoMem() {
        this.path.concat("_todo_");
        try {
            if (this.ff.exists(this.path.$())) {
                long fileLen = this.ff.length(this.path.$());
                if (fileLen < 32L) {
                    throw CairoException.critical(0).put("corrupt ").put(this.path);
                }
                this.todoMem.smallFile(this.ff, this.path.$(), 12);
                this.todoTxn = this.todoMem.getLong(0L);
                if (this.todoMem.getLong(24L) != this.todoTxn) {
                    this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
                    this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
                    Unsafe.getUnsafe().storeFence();
                    this.todoMem.putLong(24L, this.todoTxn);
                    long l = 0L;
                    return l;
                }
                long l = this.todoMem.getLong(32L);
                return l;
            }
            TableUtils.resetTodoLog(this.ff, this.path, this.pathSize, this.todoMem);
            this.todoTxn = 0L;
            long l = 0L;
            return l;
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
    }

    private void performRecovery() {
        this.rollbackIndexes();
        this.rollbackSymbolTables(false);
        this.performRecovery = false;
    }

    private void populateDenseIndexerList() {
        this.denseIndexers.clear();
        int n = this.indexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.indexers.getQuick(i);
            if (indexer == null) continue;
            this.denseIndexers.add(indexer);
        }
        this.indexCount = this.denseIndexers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAsyncWriterCommand(AsyncWriterCommand asyncWriterCommand, TableWriterTask cmd, long cursor, Sequence sequence, boolean contextAllowsAnyStructureChanges) {
        int cmdType = cmd.getType();
        long correlationId = cmd.getInstance();
        long tableId = cmd.getTableId();
        int errorCode = 0;
        CharSequence errorMsg = null;
        long affectedRowsCount = 0L;
        try {
            this.publishTableWriterEvent(cmdType, tableId, correlationId, 0, null, 0L, 64);
            LOG.info().$("received async cmd [type=").$(cmdType).$(", table=").$(this.tableToken).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId).$(", cursor=").$(cursor).I$();
            asyncWriterCommand = asyncWriterCommand.deserialize(cmd);
            affectedRowsCount = asyncWriterCommand.apply(this, contextAllowsAnyStructureChanges);
        }
        catch (TableReferenceOutOfDateException ex) {
            LOG.info().$("cannot complete async cmd, reader is out of date [type=").$(cmdType).$(", table=").$(this.tableToken).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId).I$();
            errorCode = -1;
            errorMsg = ex.getMessage();
        }
        catch (AlterTableContextException ex) {
            LOG.info().$("cannot complete async cmd, table structure change is not allowed [type=").$(cmdType).$(", tableName=").$(this.tableToken).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId).I$();
            errorCode = -2;
            errorMsg = "async cmd cannot change table structure while writer is busy";
        }
        catch (CairoException ex) {
            errorCode = -3;
            errorMsg = ex.getFlyweightMessage();
        }
        catch (Throwable ex) {
            LOG.error().$("error on processing async cmd [type=").$(cmdType).$(", tableName=").$safe(this.tableToken.getTableName()).$(", ex=").$(ex).I$();
            errorCode = -4;
            errorMsg = ex.getMessage();
        }
        finally {
            sequence.done(cursor);
        }
        this.publishTableWriterEvent(cmdType, tableId, correlationId, errorCode, errorMsg, affectedRowsCount, 65);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommandQueue(boolean contextAllowsAnyStructureChanges) {
        if (!this.processingQueue) {
            try {
                long cursor;
                this.processingQueue = true;
                while ((cursor = this.commandSubSeq.next()) != -1L) {
                    if (cursor > -1L) {
                        TableWriterTask cmd = this.commandQueue.get(cursor);
                        this.processCommandQueue(cmd, this.commandSubSeq, cursor, contextAllowsAnyStructureChanges);
                        continue;
                    }
                    Os.pause();
                }
            }
            finally {
                this.processingQueue = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processO3Block(long o3LagRowCount, int timestampIndex, long sortedTimestampsAddr, long srcOooMax, long o3TimestampMin, long o3TimestampMax, boolean flattenTimestamp, long rowLo, TableWriterPressureControl pressureControl) {
        boolean bl;
        this.o3ErrorCount.set(0);
        this.o3oomObserved = false;
        this.lastErrno = 0;
        this.partitionRemoveCandidates.clear();
        this.o3ColumnCounters.clear();
        this.o3BasketPool.clear();
        this.commitRowCount = srcOooMax;
        long maxTimestamp = this.txWriter.getMaxTimestamp();
        long transientRowCount = this.txWriter.transientRowCount;
        this.o3DoneLatch.reset();
        this.o3PartitionUpdRemaining.set(0L);
        boolean success = true;
        int latchCount = 0;
        long srcOoo = rowLo;
        int pCount = 0;
        int partitionParallelism = pressureControl.getMemoryPressureRegulationValue();
        long replaceMaxTimestamp = Long.MIN_VALUE;
        long partitionTimestamp = o3TimestampMin;
        long minO3PartitionTimestamp = this.txWriter.getPartitionTimestampByTimestamp(o3TimestampMin);
        long maxO3PartitionTimestamp = this.txWriter.getPartitionTimestampByTimestamp(o3TimestampMax);
        try {
            this.resizePartitionUpdateSink();
            int inflightPartitions = 0;
            while (srcOoo < srcOooMax || this.isCommitReplaceMode() && partitionTimestamp <= o3TimestampMax) {
                block42: {
                    pressureControl.updateInflightPartitions(++inflightPartitions);
                    try {
                        long o3TimestampHi;
                        long o3TimestampLo;
                        long dedupColSinkAddr;
                        long srcNameTxn;
                        long srcDataMax;
                        long o3Timestamp;
                        long srcOooLo;
                        block41: {
                            block44: {
                                long o3ts;
                                block45: {
                                    block43: {
                                        srcOooLo = srcOoo;
                                        if (this.isCommitReplaceMode()) break block43;
                                        o3Timestamp = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOoo);
                                        break block41;
                                    }
                                    if (srcOoo >= srcOooMax) break block44;
                                    o3ts = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOoo);
                                    if (o3ts >= partitionTimestamp) break block45;
                                    o3Timestamp = o3ts;
                                    break block41;
                                }
                                long o3PartitionTs = this.txWriter.getPartitionTimestampByTimestamp(o3ts);
                                if (o3PartitionTs == partitionTimestamp) {
                                    o3Timestamp = o3ts;
                                    break block41;
                                } else if (this.txWriter.isInsideExistingPartition(partitionTimestamp)) {
                                    o3Timestamp = partitionTimestamp;
                                    break block41;
                                } else {
                                    partitionTimestamp = this.txWriter.getNextExistingPartitionTimestamp(partitionTimestamp);
                                    continue;
                                }
                            }
                            if (this.txWriter.isInsideExistingPartition(partitionTimestamp)) {
                                o3Timestamp = partitionTimestamp;
                            } else {
                                partitionTimestamp = this.txWriter.getNextExistingPartitionTimestamp(partitionTimestamp);
                                continue;
                            }
                        }
                        partitionTimestamp = this.txWriter.getPartitionTimestampByTimestamp(o3Timestamp);
                        assert (o3Timestamp >= o3TimestampMin);
                        long srcOooTimestampCeil = this.txWriter.getNextPartitionTimestamp(o3Timestamp) - 1L;
                        long srcOooHi = srcOooTimestampCeil < o3TimestampMax ? Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, srcOooTimestampCeil, srcOooLo, srcOooMax - 1L, 1) : srcOooMax - 1L;
                        boolean last = partitionTimestamp == this.lastPartitionTimestamp;
                        srcOoo = srcOooHi + 1L;
                        int partitionIndexRaw = this.txWriter.findAttachedPartitionRawIndexByLoTimestamp(partitionTimestamp);
                        if (partitionIndexRaw > -1) {
                            srcDataMax = last ? transientRowCount : this.getPartitionSizeByRawIndex(partitionIndexRaw);
                            srcNameTxn = this.getPartitionNameTxnByRawIndex(partitionIndexRaw);
                        } else {
                            srcDataMax = 0L;
                            srcNameTxn = this.txWriter.getTxn() - 1L;
                        }
                        boolean append = last && (srcDataMax == 0L || this.isCommitDedupMode() && o3Timestamp > maxTimestamp || !this.isCommitDedupMode() && o3Timestamp >= maxTimestamp) && (!this.isCommitReplaceMode() || o3TimestampMin > this.txWriter.getMaxTimestamp());
                        long srcOooBatchRowSize = srcOooHi - srcOooLo + 1L;
                        long newPartitionSize = srcDataMax + srcOooBatchRowSize;
                        boolean partitionIsReadOnly = partitionIndexRaw > -1 && this.txWriter.isPartitionReadOnlyByRawIndex(partitionIndexRaw);
                        boolean isParquet = partitionIndexRaw > -1 && this.txWriter.isPartitionParquetByRawIndex(partitionIndexRaw);
                        LOG.info().$("o3 partition task [table=").$safe(this.tableToken.getTableName()).$(", partitionTs=").$ts(partitionTimestamp).$(", partitionIndex=").$(partitionIndexRaw).$(", last=").$(last).$(", append=").$(append).$(", ro=").$(partitionIsReadOnly).$(", srcOooLo=").$(srcOooLo).$(", srcOooHi=").$(srcOooHi).$(", srcOooMax=").$(srcOooMax).$(", o3RowCount=").$(this.o3RowCount).$(", o3LagRowCount=").$(o3LagRowCount).$(", srcDataMax=").$(srcDataMax).$(", o3Ts=").$ts(o3Timestamp).$(", newSize=").$(newPartitionSize).$(", maxTs=").$ts(maxTimestamp).$(", pCount=").$(++pCount).$(", flattenTs=").$(flattenTimestamp).$(", memUsed=").$size(Unsafe.getMemUsed()).$(", rssMemUsed=").$size(Unsafe.getRssMemUsed()).I$();
                        if (partitionIsReadOnly) {
                            LOG.critical().$("o3 ignoring write on read-only partition [table=").$safe(this.tableToken.getTableName()).$(", timestamp=").$ts(partitionTimestamp).$(", numRows=").$(srcOooBatchRowSize).$();
                            continue;
                        }
                        O3Basket o3Basket = this.o3BasketPool.next();
                        o3Basket.checkCapacity(this.configuration, this.columnCount, this.indexCount);
                        AtomicInteger columnCounter = this.o3ColumnCounters.next();
                        if (this.isCommitReplaceMode() && srcOooLo > srcOooHi && (srcDataMax == 0L || append)) {
                            partitionTimestamp = this.txWriter.getNextExistingPartitionTimestamp(partitionTimestamp);
                            pressureControl.updateInflightPartitions(--inflightPartitions);
                            continue;
                        }
                        long partitionUpdateSinkAddr = this.o3PartitionUpdateSink.allocateBlock();
                        this.o3PartitionUpdRemaining.incrementAndGet();
                        ++latchCount;
                        Vect.memset(partitionUpdateSinkAddr + 64L, (long)this.metadata.getColumnCount() * 8L, -1);
                        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr, partitionTimestamp);
                        Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr + 48L, partitionTimestamp);
                        if (this.isCommitReplaceMode() && partitionTimestamp >= this.lastPartitionTimestamp && o3TimestampMax >= this.txWriter.getMaxTimestamp() && srcOooLo < srcOooMax) {
                            replaceMaxTimestamp = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOooMax - 1L);
                        }
                        if (append) {
                            try {
                                this.setAppendPosition(srcDataMax, false);
                            }
                            catch (Throwable e) {
                                this.o3BumpErrorCount(CairoException.isCairoOomError(e));
                                this.o3ClockDownPartitionUpdateCount();
                                this.o3CountDownDoneLatch();
                                throw e;
                            }
                            columnCounter.set(TableUtils.compressColumnCount(this.metadata));
                            Path pathToPartition = Path.getThreadLocal(this.path);
                            TableUtils.setPathForNativePartition(pathToPartition, this.partitionBy, this.txWriter.getPartitionTimestampByTimestamp(o3TimestampMin), srcNameTxn);
                            int plen = pathToPartition.size();
                            int columnsPublished = 0;
                            long minTimestamp = this.isCommitReplaceMode() ? this.txWriter.getMinTimestamp() : o3TimestampMin;
                            for (int i = 0; i < this.columnCount; ++i) {
                                MemoryMA dstVarMem;
                                MemoryMA dstFixMem;
                                long srcOooVarAddr;
                                long srcOooFixAddr;
                                int columnType = this.metadata.getColumnType(i);
                                if (columnType < 0) continue;
                                int colOffset = TableWriter.getPrimaryColumnIndex(i);
                                boolean notTheTimestamp = i != timestampIndex;
                                CharSequence columnName = this.metadata.getColumnName(i);
                                int indexBlockCapacity = this.metadata.isColumnIndexed(i) ? this.metadata.getIndexValueBlockCapacity(i) : -1;
                                BitmapIndexWriter indexWriter = indexBlockCapacity > -1 ? this.getBitmapIndexWriter(i) : null;
                                MemoryR oooMem1 = this.o3Columns.getQuick(colOffset);
                                MemoryR oooMem2 = this.o3Columns.getQuick(colOffset + 1);
                                MemoryMA mem1 = this.columns.getQuick(colOffset);
                                MemoryMA mem2 = this.columns.getQuick(colOffset + 1);
                                long srcDataTop = this.getColumnTop(i);
                                if (!ColumnType.isVarSize(columnType)) {
                                    srcOooFixAddr = notTheTimestamp ? oooMem1.addressOf(0L) : sortedTimestampsAddr;
                                    srcOooVarAddr = 0L;
                                    dstFixMem = mem1;
                                    dstVarMem = null;
                                } else {
                                    srcOooFixAddr = oooMem2.addressOf(0L);
                                    srcOooVarAddr = oooMem1.addressOf(0L);
                                    dstFixMem = mem2;
                                    dstVarMem = mem1;
                                }
                                ++columnsPublished;
                                try {
                                    O3OpenColumnJob.appendLastPartition(pathToPartition, plen, columnName, columnCounter, notTheTimestamp ? columnType : ColumnType.setDesignatedTimestampBit(columnType, true), srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, minTimestamp, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, dstFixMem, dstVarMem, newPartitionSize, srcDataMax, 0L, this, indexWriter, this.getColumnNameTxn(partitionTimestamp, i), partitionUpdateSinkAddr);
                                    continue;
                                }
                                catch (Throwable e) {
                                    if (columnCounter.addAndGet(columnsPublished - this.columnCount) == 0) {
                                        this.o3ClockDownPartitionUpdateCount();
                                        this.o3CountDownDoneLatch();
                                    }
                                    throw e;
                                }
                            }
                            this.addPhysicallyWrittenRows(srcOooBatchRowSize);
                            break block42;
                        }
                        if (flattenTimestamp && this.o3RowCount > 0L) {
                            Vect.flattenIndex(sortedTimestampsAddr, this.o3RowCount);
                            flattenTimestamp = false;
                        }
                        long l = dedupColSinkAddr = this.dedupColumnCommitAddresses != null ? this.dedupColumnCommitAddresses.allocateBlock() : 0L;
                        if (this.isCommitReplaceMode()) {
                            if (isParquet) {
                                this.o3PartitionUpdRemaining.decrementAndGet();
                                --latchCount;
                                pressureControl.updateInflightPartitions(--inflightPartitions);
                                throw CairoException.critical(0).put("commit replace mode is not supported for Parquet partitions [table=").put(this.getTableToken().getTableName()).put(", partition=").ts(partitionTimestamp).put(']');
                            }
                            o3TimestampLo = partitionTimestamp == minO3PartitionTimestamp ? o3TimestampMin : partitionTimestamp;
                            o3TimestampHi = partitionTimestamp == maxO3PartitionTimestamp ? o3TimestampMax : this.txWriter.getNextPartitionTimestamp(partitionTimestamp) - 1L;
                        } else {
                            o3TimestampLo = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOooLo);
                            o3TimestampHi = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOooHi);
                        }
                        this.o3CommitPartitionAsync(columnCounter, maxTimestamp, sortedTimestampsAddr, srcOooLo, srcOooHi, srcOooMax, o3TimestampMin, partitionTimestamp, srcDataMax, last, srcNameTxn, o3Basket, newPartitionSize, srcDataMax, partitionUpdateSinkAddr, dedupColSinkAddr, isParquet, o3TimestampLo, o3TimestampHi);
                    }
                    catch (CairoError | CairoException e) {
                        LOG.error().$((Sinkable)((Object)e)).$();
                        success = false;
                        throw e;
                    }
                }
                if (inflightPartitions % partitionParallelism == 0) {
                    this.o3ConsumePartitionUpdates();
                    this.o3DoneLatch.await(latchCount);
                    inflightPartitions = 0;
                }
                partitionTimestamp = this.txWriter.getNextExistingPartitionTimestamp(partitionTimestamp);
            }
            this.partitionTimestampHi = Math.max(this.partitionTimestampHi, this.txWriter.getNextPartitionTimestamp(o3TimestampMax) - 1L);
            if (!this.isCommitReplaceMode()) {
                this.txWriter.updateMaxTimestamp(Math.max(this.txWriter.getMaxTimestamp(), o3TimestampMax));
            } else if (replaceMaxTimestamp != Long.MIN_VALUE) {
                this.txWriter.updateMaxTimestamp(replaceMaxTimestamp);
            }
            LOG.debug().$("o3 expecting updates [table=").$safe(this.tableToken.getTableName()).$(", partitionsPublished=").$(pCount).I$();
            this.o3ConsumePartitionUpdates();
            if (this.o3ErrorCount.get() == 0 && success) {
                this.o3ConsumePartitionUpdateSink();
            }
            this.o3DoneLatch.await(latchCount);
            bl = !success || this.o3ErrorCount.get() > 0;
        }
        catch (Throwable th) {
            try {
                LOG.error().$("failed to commit data block [table=").$(this.tableToken).$(", error=").$(th).I$();
                throw th;
            }
            catch (Throwable throwable) {
                LOG.debug().$("o3 expecting updates [table=").$safe(this.tableToken.getTableName()).$(", partitionsPublished=").$(pCount).I$();
                this.o3ConsumePartitionUpdates();
                if (this.o3ErrorCount.get() == 0 && success) {
                    this.o3ConsumePartitionUpdateSink();
                }
                this.o3DoneLatch.await(latchCount);
                boolean bl2 = this.o3InError = !success || this.o3ErrorCount.get() > 0;
                if (success && this.o3ErrorCount.get() > 0) {
                    throw CairoException.critical(0).put("bulk update failed and will be rolled back").setOutOfMemory(this.o3oomObserved);
                }
                throw throwable;
            }
        }
        this.o3InError = bl;
        if (success && this.o3ErrorCount.get() > 0) {
            throw CairoException.critical(0).put("bulk update failed and will be rolled back").setOutOfMemory(this.o3oomObserved);
        }
        if (o3LagRowCount > 0L && !this.metadata.isWalEnabled()) {
            LOG.info().$("shifting lag rows up [table=").$safe(this.tableToken.getTableName()).$(", lagCount=").$(o3LagRowCount).I$();
            this.dispatchColumnTasks(o3LagRowCount, -1L, srcOooMax, 0L, 0L, this.cthO3ShiftColumnInLagToTopRef);
        }
    }

    private void processPartitionRemoveCandidates() {
        try {
            int n = this.partitionRemoveCandidates.size();
            if (n > 0) {
                this.processPartitionRemoveCandidates0(n);
            }
        }
        finally {
            this.partitionRemoveCandidates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPartitionRemoveCandidates0(int n) {
        boolean anyReadersBeforeCommittedTxn = this.checkScoreboardHasReadersBeforeLastCommittedTxn();
        boolean scheduleAsyncPurge = false;
        long lastCommittedTxn = this.getTxn();
        for (int i = 0; i < n; i += 2) {
            try {
                long timestamp = this.partitionRemoveCandidates.getQuick(i);
                long txn = this.partitionRemoveCandidates.get(i + 1);
                if (!anyReadersBeforeCommittedTxn || txn >= lastCommittedTxn) {
                    TableUtils.setPathForNativePartition(this.other, this.partitionBy, timestamp, txn);
                    this.other.$();
                    this.engine.getPartitionOverwriteControl().notifyPartitionMutates(this.tableToken, timestamp, txn, 0L);
                    if (this.ff.unlinkOrRemove(this.other, LOG)) continue;
                    LOG.info().$("could not purge partition version, async purge will be scheduled [path=").$substr(this.pathRootSize, this.other).$(", errno=").$(this.ff.errno()).I$();
                    scheduleAsyncPurge = true;
                    continue;
                }
                scheduleAsyncPurge = true;
                continue;
            }
            finally {
                this.other.trimTo(this.pathSize);
            }
        }
        if (scheduleAsyncPurge) {
            if (TableUtils.schedulePurgeO3Partitions(this.messageBus, this.tableToken, this.partitionBy)) {
                LOG.debug().$("scheduled to purge partitions [table=").$safe(this.tableToken.getTableName()).I$();
            } else {
                LOG.error().$("could not queue for purge, queue is full [table=").$safe(this.tableToken.getTableName()).I$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean processWalCommit(Path walPath, boolean ordered, long rowLo, long rowHi, long o3TimestampMin, long o3TimestampMax, @Nullable SymbolMapDiffCursor mapDiffCursor, long commitToTimestamp, long walIdSegmentId, boolean isLastSegmentUsage, TableWriterPressureControl pressureControl) {
        boolean bl;
        long totalUncommitted;
        long commitRowCount;
        long o3Lo;
        long o3Hi;
        long walLagRowCount;
        long initialPartitionTimestampHi;
        boolean success;
        int walRootPathLen;
        int timestampIndex;
        int initialSize;
        block29: {
            initialSize = this.segmentFileCache.getWalMappedColumns().size();
            timestampIndex = this.metadata.getTimestampIndex();
            walRootPathLen = walPath.size();
            long maxTimestamp = this.txWriter.getMaxTimestamp();
            if (this.isLastPartitionClosed()) {
                if (this.isEmptyTable()) {
                    this.openPartition(o3TimestampMin, 0L);
                    this.txWriter.setMaxTimestamp(o3TimestampMin);
                    this.txWriter.updatePartitionSizeByTimestamp(o3TimestampMin, 0L, this.txWriter.getTxn() - 1L);
                } else {
                    throw CairoException.critical(0).put("system error, cannot resolve WAL table last partition [path=").put(this.path).put(']');
                }
            }
            assert (maxTimestamp == Long.MIN_VALUE || this.txWriter.getPartitionTimestampByTimestamp(this.partitionTimestampHi) == this.txWriter.getPartitionTimestampByTimestamp(this.txWriter.maxTimestamp));
            this.lastPartitionTimestamp = this.txWriter.getPartitionTimestampByTimestamp(this.partitionTimestampHi);
            success = true;
            boolean forceFullCommit = commitToTimestamp == Long.MAX_VALUE;
            long maxLagRows = this.getWalMaxLagRows();
            long walLagMaxTimestampBefore = this.txWriter.getLagMaxTimestamp();
            this.segmentFileCache.mmapSegments(this.metadata, walPath, walIdSegmentId, rowLo, rowHi);
            this.o3Columns = this.segmentFileCache.getWalMappedColumns();
            long newMinLagTimestamp = Math.min(o3TimestampMin, this.txWriter.getLagMinTimestamp());
            initialPartitionTimestampHi = this.partitionTimestampHi;
            walLagRowCount = this.txWriter.getLagRowCount();
            o3Hi = rowHi;
            o3Lo = rowLo;
            commitRowCount = rowHi - rowLo;
            totalUncommitted = walLagRowCount + commitRowCount;
            long newMaxLagTimestamp = Math.max(o3TimestampMax, this.txWriter.getLagMaxTimestamp());
            boolean needFullCommit = forceFullCommit || totalUncommitted > maxLagRows || commitToTimestamp >= newMaxLagTimestamp && totalUncommitted > (long)this.getMetaMaxUncommittedRows() || this.configuration.getWalMaxLagTxnCount() > 0 && this.txWriter.getLagTxnCount() >= this.configuration.getWalMaxLagTxnCount() || this.configuration.getMicrosecondClock().getTicks() - this.lastWalCommitTimestampMicros > this.configuration.getCommitLatency();
            boolean canFastCommit = this.indexers.size() == 0 && this.applyFromWalLagToLastPartitionPossible(commitToTimestamp, this.txWriter.getLagRowCount(), this.txWriter.isLagOrdered(), this.txWriter.getMaxTimestamp(), this.txWriter.getLagMinTimestamp(), this.txWriter.getLagMaxTimestamp());
            boolean lagOrderedNew = !this.isCommitDedupMode() && this.txWriter.isLagOrdered() && ordered && walLagMaxTimestampBefore <= o3TimestampMin;
            boolean canFastCommitNew = this.applyFromWalLagToLastPartitionPossible(commitToTimestamp, totalUncommitted, lagOrderedNew, this.txWriter.getMaxTimestamp(), newMinLagTimestamp, newMaxLagTimestamp);
            if (!needFullCommit && canFastCommit && !canFastCommitNew && this.txWriter.getLagMaxTimestamp() <= o3TimestampMin) {
                this.applyFromWalLagToLastPartition(commitToTimestamp, false);
                walLagRowCount = this.txWriter.getLagRowCount();
                totalUncommitted = commitRowCount;
                newMaxLagTimestamp = Math.max(o3TimestampMax, this.txWriter.getLagMaxTimestamp());
                boolean bl2 = needFullCommit = totalUncommitted > maxLagRows || commitToTimestamp >= newMaxLagTimestamp && totalUncommitted > (long)this.getMetaMaxUncommittedRows() || this.configuration.getWalMaxLagTxnCount() > 0 && this.txWriter.getLagTxnCount() > this.configuration.getWalMaxLagTxnCount();
            }
            if (needFullCommit && !canFastCommitNew) break block29;
            LOG.debug().$("all WAL rows copied to LAG [table=").$(this.tableToken).I$();
            this.o3Columns = this.remapWalSymbols(mapDiffCursor, rowLo, rowHi, walPath);
            this.dispatchColumnTasks(o3Hi - o3Lo, -1L, o3Lo, walLagRowCount, 1L, this.cthAppendWalColumnToLastPartition);
            this.addPhysicallyWrittenRows(commitRowCount);
            this.txWriter.setLagRowCount((int)(walLagRowCount += commitRowCount));
            this.txWriter.setLagOrdered(lagOrderedNew);
            this.txWriter.setLagMinTimestamp(newMinLagTimestamp);
            this.txWriter.setLagMaxTimestamp(Math.max(o3TimestampMax, this.txWriter.getLagMaxTimestamp()));
            this.txWriter.setLagTxnCount(this.txWriter.getLagTxnCount() + 1);
            if (canFastCommitNew) {
                this.applyFromWalLagToLastPartition(commitToTimestamp, false);
            }
            boolean bl3 = forceFullCommit;
            this.finishO3Append(walLagRowCount);
            this.o3Columns = this.o3MemColumns1;
            if (this.memColumnShifted) {
                this.clearMemColumnShifts();
            }
            walPath.trimTo(walRootPathLen);
            this.segmentFileCache.closeWalFiles(isLastSegmentUsage || !success, walIdSegmentId, initialSize);
            return bl3;
        }
        try {
            block31: {
                boolean copiedToMemory;
                if (this.applyFromWalLagToLastPartition(Math.min(o3TimestampMin, commitToTimestamp), true) != Long.MIN_VALUE) {
                    walLagRowCount = this.txWriter.getLagRowCount();
                    totalUncommitted = walLagRowCount + commitRowCount;
                }
                this.txWriter.setLagMinTimestamp(Math.min(o3TimestampMin, this.txWriter.getLagMinTimestamp()));
                this.txWriter.setLagMaxTimestamp(Math.max(o3TimestampMax, this.txWriter.getLagMaxTimestamp()));
                boolean needsOrdering = !ordered || walLagRowCount > 0L;
                boolean needsDedup = this.isCommitDedupMode();
                long timestampAddr = 0L;
                MemoryCR walTimestampColumn = this.segmentFileCache.getWalMappedColumns().getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
                this.o3Columns = this.remapWalSymbols(mapDiffCursor, rowLo, rowHi, walPath);
                if (needsOrdering || needsDedup) {
                    block30: {
                        if (needsOrdering) {
                            LOG.debug().$("sorting WAL [table=").$(this.tableToken).$(", ordered=").$(ordered).$(", lagRowCount=").$(walLagRowCount).$(", walRowLo=").$(rowLo).$(", walRowHi=").$(rowHi).I$();
                            long timestampMemorySize = totalUncommitted << 4;
                            this.o3TimestampMem.jumpTo(timestampMemorySize);
                            this.o3TimestampMemCpy.jumpTo(timestampMemorySize);
                            MemoryMA timestampColumn = this.columns.get(TableWriter.getPrimaryColumnIndex(timestampIndex));
                            long tsLagOffset = this.txWriter.getTransientRowCount() << 3;
                            long tsLagSize = walLagRowCount << 3;
                            long mappedTimestampIndexAddr = walTimestampColumn.addressOf(rowLo << 4);
                            timestampAddr = this.o3TimestampMem.getAddress();
                            long tsLagBufferAddr = this.mapAppendColumnBuffer(timestampColumn, tsLagOffset, tsLagSize, false);
                            try {
                                long rowCount = Vect.radixSortABLongIndexAsc(Math.abs(tsLagBufferAddr), walLagRowCount, mappedTimestampIndexAddr, commitRowCount, timestampAddr, this.o3TimestampMemCpy.addressOf(0L), this.txWriter.getLagMinTimestamp(), this.txWriter.getLagMaxTimestamp());
                                assert (rowCount == totalUncommitted) : "radix sort error, result: " + rowCount + " expected " + totalUncommitted;
                                break block30;
                            }
                            finally {
                                this.mapAppendColumnBufferRelease(tsLagBufferAddr, tsLagOffset, tsLagSize);
                            }
                        }
                        timestampAddr = walTimestampColumn.addressOf(rowLo * 16L);
                    }
                    if (needsDedup) {
                        this.o3TimestampMemCpy.jumpTo(totalUncommitted * 16L);
                        this.o3TimestampMem.jumpTo(totalUncommitted * 16L);
                        long dedupTimestampAddr = this.o3TimestampMem.getAddress();
                        long deduplicatedRowCount = this.deduplicateSortedIndex(totalUncommitted, timestampAddr, dedupTimestampAddr, this.o3TimestampMemCpy.addressOf(0L), walLagRowCount);
                        if (deduplicatedRowCount > 0L) {
                            needsOrdering = true;
                            timestampAddr = dedupTimestampAddr;
                            totalUncommitted = deduplicatedRowCount;
                        }
                    }
                }
                if (needsOrdering) {
                    this.dispatchColumnTasks(timestampAddr, totalUncommitted, walLagRowCount, rowLo, rowHi, this.cthMergeWalColumnWithLag);
                    this.swapO3ColumnsExcept(timestampIndex);
                    o3Hi = totalUncommitted;
                    o3Lo = 0L;
                    walLagRowCount = 0L;
                    this.o3Columns = this.o3MemColumns1;
                    copiedToMemory = true;
                } else {
                    this.segmentFileCache.mmapWalColsEager();
                    timestampAddr = walTimestampColumn.addressOf(0L);
                    copiedToMemory = false;
                }
                walLagRowCount = 0L;
                this.processWalCommitFinishApply(walLagRowCount, timestampAddr, o3Lo, o3Hi, pressureControl, copiedToMemory, initialPartitionTimestampHi);
                break block31;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    this.finishO3Append(walLagRowCount);
                    this.o3Columns = this.o3MemColumns1;
                }
            }
            bl = true;
            if (this.memColumnShifted) {
                this.clearMemColumnShifts();
            }
            walPath.trimTo(walRootPathLen);
        }
        catch (Throwable th) {
            try {
                success = false;
                throw th;
            }
            catch (Throwable throwable) {
                if (this.memColumnShifted) {
                    this.clearMemColumnShifts();
                }
                walPath.trimTo(walRootPathLen);
                this.segmentFileCache.closeWalFiles(isLastSegmentUsage || !success, walIdSegmentId, initialSize);
                throw throwable;
            }
        }
        this.segmentFileCache.closeWalFiles(isLastSegmentUsage || !success, walIdSegmentId, initialSize);
        return bl;
    }

    private boolean processWalCommit(Path walPath, long seqTxn, TableWriterPressureControl pressureControl, long commitToTimestamp) {
        int walId = this.walTxnDetails.getWalId(seqTxn);
        long txnMinTs = this.walTxnDetails.getMinTimestamp(seqTxn);
        long txnMaxTs = this.walTxnDetails.getMaxTimestamp(seqTxn);
        long rowLo = this.walTxnDetails.getSegmentRowLo(seqTxn);
        long rowHi = this.walTxnDetails.getSegmentRowHi(seqTxn);
        boolean inOrder = this.walTxnDetails.getTxnInOrder(seqTxn);
        byte dedupMode = this.walTxnDetails.getDedupMode(seqTxn);
        long replaceRangeTsLo = this.walTxnDetails.getReplaceRangeTsLow(seqTxn);
        long replaceRangeTsHi = this.walTxnDetails.getReplaceRangeTsHi(seqTxn);
        LogRecord logLine = LOG.info();
        logLine.$("processing WAL [path=").$substr(this.pathRootSize, walPath).$(", roLo=").$(rowLo).$(", roHi=").$(rowHi).$(", seqTxn=").$(seqTxn).$(", tsMin=").$ts(txnMinTs).$(", tsMax=").$ts(txnMaxTs).$(", commitToTs=").$ts(commitToTimestamp);
        if (replaceRangeTsLo < replaceRangeTsHi) {
            logLine.$(", replaceRangeTsLo=").$ts(replaceRangeTsLo).$(", replaceRangeTsHi=").$ts(replaceRangeTsHi);
        }
        logLine.I$();
        int segmentId = this.walTxnDetails.getSegmentId(seqTxn);
        boolean isLastSegmentUsage = this.walTxnDetails.isLastSegmentUsage(seqTxn);
        SymbolMapDiffCursor mapDiffCursor = this.walTxnDetails.getWalSymbolDiffCursor(seqTxn);
        long walIdSegmentId = Numbers.encodeLowHighInts(segmentId, walId);
        this.walRowsProcessed = rowHi - rowLo;
        if (dedupMode == 3) {
            this.processWalCommitDedupReplace(walPath, inOrder, rowLo, rowHi, txnMinTs, txnMaxTs, mapDiffCursor, walIdSegmentId, isLastSegmentUsage, pressureControl, replaceRangeTsLo, replaceRangeTsHi);
            assert (this.txWriter.getMinTimestamp() < replaceRangeTsLo || this.txWriter.getMinTimestamp() >= replaceRangeTsHi || this.txWriter.getMinTimestamp() == txnMinTs);
            assert (this.txWriter.getMaxTimestamp() < replaceRangeTsLo || this.txWriter.getMaxTimestamp() >= replaceRangeTsHi || this.txWriter.getMaxTimestamp() == txnMaxTs);
            return true;
        }
        return this.processWalCommit(walPath, inOrder, rowLo, rowHi, txnMinTs, txnMaxTs, mapDiffCursor, commitToTimestamp, walIdSegmentId, isLastSegmentUsage, pressureControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processWalCommitBlock(long startSeqTxn, int blockTransactionCount, TableWriterPressureControl pressureControl) {
        this.segmentCopyInfo.clear();
        this.walTxnDetails.prepareCopySegments(startSeqTxn, blockTransactionCount, this.segmentCopyInfo, this.denseSymbolMapWriters.size() > 0);
        if (this.isLastPartitionClosed() && this.isEmptyTable()) {
            this.populateDenseIndexerList();
        }
        LOG.info().$("processing WAL transaction block [table=").$(this.tableToken).$(", seqTxn=").$(startSeqTxn).$("..").$(startSeqTxn + (long)blockTransactionCount - 1L).$(", rows=").$(this.segmentCopyInfo.getTotalRows()).$(", segments=").$(this.segmentCopyInfo.getSegmentCount()).$(", minTimestamp=").$ts(this.segmentCopyInfo.getMinTimestamp()).$(", maxTimestamp=").$ts(this.segmentCopyInfo.getMaxTimestamp()).I$();
        this.walRowsProcessed = this.segmentCopyInfo.getTotalRows();
        if (this.segmentCopyInfo.hasSegmentGaps()) {
            LOG.info().$("some segments have gaps in committed rows [table=").$(this.tableToken).I$();
            throw CairoException.txnApplyBlockError(this.tableToken);
        }
        this.segmentFileCache.mmapWalColumns(this.segmentCopyInfo, this.metadata, this.path);
        try {
            boolean copiedToMemory;
            long timestampAddr;
            long o3LoHi;
            long o3Lo;
            if (!this.isCommitDedupMode() && this.segmentCopyInfo.getAllTxnDataInOrder() && this.segmentCopyInfo.getSegmentCount() == 1) {
                LOG.info().$("all data in order, single segment, processing optimised [table=").$(this.tableToken).I$();
                if (this.denseSymbolMapWriters.size() > 0) {
                    this.segmentFileCache.mmapWalColsEager();
                    this.o3Columns = this.processWalCommitBlock_remapSymbols();
                } else {
                    this.segmentFileCache.mmapWalColsEager();
                    this.o3Columns = this.segmentFileCache.getWalMappedColumns();
                }
                o3Lo = this.segmentCopyInfo.getRowLo(0);
                o3LoHi = o3Lo + this.segmentCopyInfo.getTotalRows();
                MemoryCR tsColumn = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(this.metadata.getTimestampIndex()));
                timestampAddr = tsColumn.addressOf(0L);
                this.txWriter.setLagMinTimestamp(this.segmentCopyInfo.getMinTimestamp());
                this.txWriter.setLagMaxTimestamp(this.segmentCopyInfo.getMaxTimestamp());
                copiedToMemory = false;
            } else {
                o3Lo = 0L;
                o3LoHi = this.processWalCommitBlock_sortWalSegmentTimestamps();
                timestampAddr = this.o3TimestampMem.getAddress();
                copiedToMemory = true;
            }
            try {
                this.lastPartitionTimestamp = this.txWriter.getLastPartitionTimestamp();
                this.processWalCommitFinishApply(0L, timestampAddr, o3Lo, o3LoHi, pressureControl, copiedToMemory, this.partitionTimestampHi);
            }
            finally {
                this.finishO3Append(0L);
                this.o3Columns = this.o3MemColumns1;
            }
            int n = blockTransactionCount;
            return n;
        }
        finally {
            if (this.memColumnShifted) {
                this.clearMemColumnShifts();
            }
            this.segmentFileCache.closeWalFiles(this.segmentCopyInfo, this.metadata.getColumnCount());
            if (this.tempDirectMemList != null) {
                this.tempDirectMemList.resetCapacity();
            }
        }
    }

    private ObjList<MemoryCR> processWalCommitBlock_remapSymbols() {
        long columnAddressCount = 2L * (long)this.metadata.getColumnCount();
        DirectLongList columnSegmentAddressBuffer = this.getTempDirectLongList(columnAddressCount);
        columnSegmentAddressBuffer.setPos(columnAddressCount);
        this.processWalCommitBlock_sortWalSegmentTimestamps_dispatchColumnSortTasks(0L, this.segmentCopyInfo.getTotalRows(), columnSegmentAddressBuffer.getAddress(), 1L, this.segmentCopyInfo.getRowLo(0), true, false, this.cthMapSymbols);
        this.o3ColumnOverrides.clear();
        this.o3ColumnOverrides.addAll(this.segmentFileCache.getWalMappedColumns());
        long columnSegmentAddressesBase = columnSegmentAddressBuffer.getAddress();
        int tsColIndex = this.metadata.getTimestampIndex();
        int n = this.metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int columnType = this.metadata.getColumnType(i);
            if (i == tsColIndex || columnType <= 0) continue;
            if (ColumnType.isSymbol(columnType) && Unsafe.getUnsafe().getLong(columnSegmentAddressesBase) == -1L) {
                int primaryColumnIndex = TableWriter.getPrimaryColumnIndex(i);
                MemoryCARW remappedColumn = this.o3MemColumns2.getQuick(primaryColumnIndex);
                assert (remappedColumn.size() >= this.segmentCopyInfo.getTotalRows() << ColumnType.pow2SizeOf(columnType));
                this.o3ColumnOverrides.set(primaryColumnIndex, remappedColumn);
                LOG.info().$("using remapped column buffer [table=").$(this.tableToken).$(", name=").$safe(this.metadata.getColumnName(i)).$(", index=").$(i).I$();
            }
            columnSegmentAddressesBase += 8L;
            if (!ColumnType.isVarSize(columnType)) continue;
            columnSegmentAddressesBase += 8L;
        }
        columnSegmentAddressBuffer.resetCapacity();
        return this.o3ColumnOverrides;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long processWalCommitBlock_sortWalSegmentTimestamps() {
        int timestampIndex = this.metadata.getTimestampIndex();
        int walColumnCountPerSegment = this.metadata.getColumnCount() * 2;
        long totalSegmentAddresses = this.segmentCopyInfo.getSegmentCount();
        long totalColumnAddressSize = totalSegmentAddresses * (long)walColumnCountPerSegment;
        DirectLongList tsAddresses = this.getTempDirectLongList(totalColumnAddressSize);
        tsAddresses.setPos(totalColumnAddressSize);
        try {
            this.segmentFileCache.createAddressBuffersPrimary(timestampIndex, this.metadata.getColumnCount(), this.segmentCopyInfo.getSegmentCount(), tsAddresses.getAddress());
            long totalRows = this.segmentCopyInfo.getTotalRows();
            this.o3TimestampMem.jumpTo(totalRows * 8L * 3L + 8L);
            this.o3TimestampMemCpy.jumpTo(totalRows * 8L * 3L + 8L);
            long timestampAddr = this.o3TimestampMem.getAddress();
            boolean needsDedup = this.isDeduplicationEnabled();
            long minTs = this.segmentCopyInfo.getMinTimestamp();
            long maxTs = this.segmentCopyInfo.getMaxTimestamp();
            LOG.debug().$("sorting [table=").$safe(this.tableToken.getTableName()).$(", rows=").$(this.segmentCopyInfo.getTotalRows()).$(", segments=").$(this.segmentCopyInfo.getSegmentCount()).$(", minTs=").$ts(minTs).$(", maxTs=").$ts(maxTs).I$();
            long indexFormat = Vect.radixSortManySegmentsIndexAsc(timestampAddr, this.o3TimestampMemCpy.addressOf(0L), tsAddresses.getAddress(), (int)tsAddresses.size(), this.segmentCopyInfo.getTxnInfoAddress(), this.segmentCopyInfo.getTxnCount(), this.segmentCopyInfo.getMaxTxRowCount(), 0L, 0L, minTs, maxTs, totalRows, needsDedup ? (byte)1 : 2);
            tsAddresses.set(0L, 0L);
            if (!Vect.isIndexSuccess(indexFormat)) {
                LOG.info().$("transaction sort error, will switch to 1 commit [table=").$(this.tableToken).$(", totalRows=").$(totalRows).$(", indexFormat=").$(indexFormat).I$();
                throw CairoException.txnApplyBlockError(this.tableToken);
            }
            if (this.isDeduplicationEnabled()) {
                if (this.denseSymbolMapWriters.size() > 0 && this.dedupColumnCommitAddresses.getColumnCount() > 0) {
                    this.processWalCommitBlock_sortWalSegmentTimestamps_dispatchColumnSortTasks(timestampAddr, totalRows, tsAddresses.getAddress(), totalSegmentAddresses, 0L, true, true, this.cthMapSymbols);
                }
                if (!Vect.isIndexSuccess(indexFormat = this.processWalCommitBlock_sortWalSegmentTimestamps_deduplicateSortedIndexFromManyAddresses(indexFormat, timestampAddr, this.o3TimestampMemCpy.addressOf(0L), tsAddresses.getAddress()))) {
                    LOG.critical().$("WAL dedup sorted index failed will switch to 1 commit [table=").$(this.tableToken).$(", totalRows=").$(totalRows).$(", indexFormat=").$(indexFormat).I$();
                    throw CairoException.txnApplyBlockError(this.tableToken);
                }
                long dedupedRowCount = Vect.readIndexResultRowCount(indexFormat);
                LOG.info().$("WAL dedup sorted commit index [table=").$(this.tableToken).$(", totalRows=").$(totalRows).$(", dups=").$(totalRows - dedupedRowCount).I$();
                timestampAddr = this.swapTimestampInMemCols(timestampIndex);
                totalRows = dedupedRowCount;
            }
            LOG.debug().$("shuffling [table=").$(this.tableToken).$(", columCount=").$(this.metadata.getColumnCount() - 1).$(", rows=").$(totalRows).$(", indexFormat=").$(indexFormat).I$();
            this.processWalCommitBlock_sortWalSegmentTimestamps_dispatchColumnSortTasks(timestampAddr, totalRows, tsAddresses.getAddress(), totalSegmentAddresses, indexFormat, false, false, this.cthMergeWalColumnManySegments);
            assert (this.o3MemColumns1.get(TableWriter.getPrimaryColumnIndex(timestampIndex)) == this.o3TimestampMem);
            assert (this.o3MemColumns2.get(TableWriter.getPrimaryColumnIndex(timestampIndex)) == this.o3TimestampMemCpy);
            this.o3Columns = this.o3MemColumns1;
            this.activeColumns = this.o3MemColumns1;
            this.txWriter.setLagMinTimestamp(minTs);
            this.txWriter.setLagMaxTimestamp(maxTs);
            long l = totalRows;
            return l;
        }
        finally {
            tsAddresses.resetCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long processWalCommitBlock_sortWalSegmentTimestamps_deduplicateSortedIndexFromManyAddresses(long indexFormat, long srcIndexSrcAddr, long outIndexAddr, long columnAddressBufferPrimary) {
        int dedupKeyIndex = 0;
        long dedupCommitAddr = 0L;
        try {
            if (this.dedupColumnCommitAddresses.getColumnCount() > 0) {
                dedupCommitAddr = this.dedupColumnCommitAddresses.allocateBlock();
                int columnCount = this.metadata.getColumnCount();
                int bytesPerColumn = this.segmentCopyInfo.getSegmentCount() * 8;
                for (int i = 0; i < columnCount; ++i) {
                    int columnType = this.metadata.getColumnType(i);
                    if (i == this.metadata.getTimestampIndex() || columnType <= 0) continue;
                    if (this.metadata.isDedupKey(i)) {
                        long dataAddresses;
                        int valueSizeBytes;
                        int n = valueSizeBytes = ColumnType.isVarSize(columnType) ? -1 : ColumnType.sizeOf(columnType);
                        if (!ColumnType.isSymbol(columnType) || Unsafe.getUnsafe().getLong(columnAddressBufferPrimary) == 0L) {
                            this.segmentFileCache.createAddressBuffersPrimary(i, columnCount, this.segmentCopyInfo.getSegmentCount(), columnAddressBufferPrimary);
                            dataAddresses = columnAddressBufferPrimary;
                        } else {
                            dataAddresses = this.o3MemColumns2.get(TableWriter.getPrimaryColumnIndex(i)).addressOf(0L);
                            valueSizeBytes = -1;
                        }
                        long addr = DedupColumnCommitAddresses.setColValues(dedupCommitAddr, dedupKeyIndex++, columnType, valueSizeBytes, 0L);
                        if (!ColumnType.isVarSize(columnType)) {
                            DedupColumnCommitAddresses.setColAddressValues(addr, dataAddresses);
                        } else {
                            long columnAddressBufferSecondary = columnAddressBufferPrimary + (long)bytesPerColumn;
                            ColumnTypeDriver driver = ColumnType.getDriver(columnType);
                            this.segmentFileCache.createAddressBuffersPrimary(i, columnCount, this.segmentCopyInfo.getSegmentCount(), columnAddressBufferPrimary);
                            this.segmentFileCache.createAddressBuffersSecondary(i, columnCount, this.segmentCopyInfo, columnAddressBufferSecondary, driver);
                            DedupColumnCommitAddresses.setColAddressValues(addr, columnAddressBufferSecondary, columnAddressBufferPrimary, 0L);
                            DedupColumnCommitAddresses.setO3DataAddressValues(addr, 0L, 0L, 0L);
                        }
                    }
                    columnAddressBufferPrimary += (long)bytesPerColumn;
                    if (!ColumnType.isVarSize(columnType)) continue;
                    columnAddressBufferPrimary += (long)bytesPerColumn;
                }
                assert (dedupKeyIndex <= this.dedupColumnCommitAddresses.getColumnCount());
            }
            long l = Vect.dedupSortedTimestampIndexManyAddresses(indexFormat, srcIndexSrcAddr, outIndexAddr, dedupKeyIndex, DedupColumnCommitAddresses.getAddress(dedupCommitAddr));
            return l;
        }
        finally {
            this.dedupColumnCommitAddresses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWalCommitBlock_sortWalSegmentTimestamps_dispatchColumnSortTasks(long timestampAddr, long totalRows, long columnAddressesBuffer, long totalSegmentAddresses, long indexFormatOrSymbolRowsOffset, boolean symbolColumnsOnly, boolean dedupColumnOnly, ColumnTaskHandler taskHandler) {
        long timestampColumnIndex = this.metadata.getTimestampIndex();
        MPSequence pubSeq = this.messageBus.getColumnTaskPubSeq();
        RingQueue<ColumnTask> queue = this.messageBus.getColumnTaskQueue();
        this.o3DoneLatch.reset();
        this.o3ErrorCount.set(0);
        this.lastErrno = 0;
        int queuedCount = 0;
        long totalSegmentAddressesBytes = totalSegmentAddresses * 8L;
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            int columnType = this.metadata.getColumnType(columnIndex);
            if ((long)columnIndex == timestampColumnIndex || columnType <= 0) continue;
            long mappedAddrBuffPrimary = columnAddressesBuffer;
            columnAddressesBuffer += totalSegmentAddressesBytes;
            if (ColumnType.isVarSize(columnType)) {
                columnAddressesBuffer += totalSegmentAddressesBytes;
            }
            if (symbolColumnsOnly && !ColumnType.isSymbol(columnType) || dedupColumnOnly && !this.metadata.isDedupKey(columnIndex)) continue;
            long cursor = pubSeq.next();
            if (cursor > -1L) {
                try {
                    ColumnTask task = queue.get(cursor);
                    task.of(this.o3DoneLatch, columnIndex, columnType, timestampColumnIndex, timestampAddr, mappedAddrBuffPrimary, totalRows, indexFormatOrSymbolRowsOffset, totalSegmentAddressesBytes, taskHandler);
                    continue;
                }
                finally {
                    ++queuedCount;
                    pubSeq.done(cursor);
                }
            }
            taskHandler.run(columnIndex, columnType, timestampColumnIndex, timestampAddr, mappedAddrBuffPrimary, totalRows, indexFormatOrSymbolRowsOffset, totalSegmentAddressesBytes);
        }
        this.consumeColumnTasks(queue, queuedCount);
    }

    private void processWalCommitBlock_sortWalSegmentTimestamps_dispatchColumnSortTasks_mapSymbols(int columnIndex, int columnType, long timestampColumnIndex, long mergeIndex, long mappedAddrBuffPrimary, long totalRows, long rowsOffset, long totalSegmentAddressesBytes) {
        try {
            assert (ColumnType.isSymbol(columnType));
            int shl = ColumnType.pow2SizeOf(columnType);
            MapWriter mapWriter = this.symbolMapWriters.get(columnIndex);
            MemoryCARW symbolMapMem = this.o3MemColumns1.get(TableWriter.getPrimaryColumnIndex(columnIndex));
            symbolMapMem.jumpTo(0L);
            boolean needsRemapping = this.walTxnDetails.buildTxnSymbolMap(this.segmentCopyInfo, columnIndex, mapWriter, symbolMapMem);
            if (needsRemapping) {
                long txnCount = this.segmentCopyInfo.getTxnCount();
                this.segmentFileCache.createAddressBuffersPrimary(columnIndex, this.metadata.getColumnCount(), this.segmentCopyInfo.getSegmentCount(), mappedAddrBuffPrimary);
                MemoryCARW destinationColumn = this.o3MemColumns2.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                destinationColumn.jumpTo(rowsOffset + totalRows << shl);
                LOG.debug().$("remapping WAL symbols [table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(this.metadata.getColumnName(columnIndex)).$(", rows=").$(totalRows).$(", txnCount=").$(txnCount).$(", offset=").$(rowsOffset).I$();
                long rowCount = Vect.remapSymbolColumnFromManyAddresses(mappedAddrBuffPrimary, destinationColumn.getAddress(), this.segmentCopyInfo.getTxnInfoAddress(), txnCount, symbolMapMem.getAddress());
                destinationColumn.shiftAddressRight(rowsOffset << shl);
                this.memColumnShifted |= rowsOffset << shl != 0L;
                if (rowCount != totalRows) {
                    this.throwApplyBlockColumnShuffleFailed(columnIndex, columnType, totalRows, rowCount);
                }
                Unsafe.getUnsafe().putLong(mappedAddrBuffPrimary, -1L);
            } else {
                Unsafe.getUnsafe().putLong(mappedAddrBuffPrimary, 0L);
                LOG.debug().$("no new symbols, no remapping needed [table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(this.metadata.getColumnName(columnIndex)).$(", rows=").$(totalRows).I$();
            }
        }
        catch (Throwable th) {
            this.handleColumnTaskException("could not copy remap WAL symbols", columnIndex, columnType, totalRows, mergeIndex, rowsOffset, totalSegmentAddressesBytes, th);
        }
    }

    private void processWalCommitBlock_sortWalSegmentTimestamps_dispatchColumnSortTasks_mergeShuffleWalColumnManySegments(int columnIndex, int columnType, long timestampColumnIndex, long mergeIndexAddress, long mappedAddrBuffPrimary, long totalRows, long mergeIndexFormat, long totalSegmentAddressesBytes) {
        try {
            boolean pointersNotCreated;
            boolean varSize = ColumnType.isVarSize(columnType);
            int shl = ColumnType.pow2SizeOf(columnType);
            long firstPointer = Unsafe.getUnsafe().getLong(mappedAddrBuffPrimary);
            boolean bl = pointersNotCreated = firstPointer == 0L;
            if (pointersNotCreated) {
                this.segmentFileCache.createAddressBuffersPrimary(columnIndex, this.metadata.getColumnCount(), this.segmentCopyInfo.getSegmentCount(), mappedAddrBuffPrimary);
            } else assert (this.isDeduplicationEnabled() && this.metadata.isDedupKey(columnIndex));
            if (!varSize) {
                if (!ColumnType.isSymbol(columnType)) {
                    MemoryCARW destinationColumn = this.o3MemColumns1.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                    destinationColumn.jumpTo(totalRows << shl);
                    long rowCount = Vect.mergeShuffleFixedColumnFromManyAddresses(1 << shl, mergeIndexFormat, mappedAddrBuffPrimary, destinationColumn.getAddress(), mergeIndexAddress, this.segmentCopyInfo.getSegmentsAddress(), this.segmentCopyInfo.getSegmentCount());
                    if (rowCount != totalRows) {
                        this.throwApplyBlockColumnShuffleFailed(columnIndex, columnType, totalRows, rowCount);
                    }
                } else {
                    MemoryCARW destinationColumn = this.o3MemColumns1.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                    destinationColumn.jumpTo(totalRows << shl);
                    if (firstPointer == -1L) {
                        assert (this.isDeduplicationEnabled() && this.metadata.isDedupKey(columnIndex));
                        long rowCount = Vect.shuffleSymbolColumnByReverseIndex(mergeIndexFormat, this.o3MemColumns2.get(TableWriter.getPrimaryColumnIndex(columnIndex)).getAddress(), destinationColumn.getAddress(), mergeIndexAddress);
                        if (rowCount != totalRows) {
                            this.throwApplyBlockColumnShuffleFailed(columnIndex, columnType, totalRows, rowCount);
                        }
                    } else {
                        long rowCount;
                        boolean needsRemapping = !this.metadata.isDedupKey(columnIndex) || !this.isDeduplicationEnabled();
                        MapWriter mapWriter = this.symbolMapWriters.get(columnIndex);
                        long txnCount = this.segmentCopyInfo.getTxnCount();
                        MemoryCARW symbolMapMem = this.o3MemColumns2.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                        symbolMapMem.jumpTo(0L);
                        if (needsRemapping) {
                            needsRemapping = this.walTxnDetails.buildTxnSymbolMap(this.segmentCopyInfo, columnIndex, mapWriter, symbolMapMem);
                        }
                        if ((rowCount = needsRemapping ? Vect.mergeShuffleSymbolColumnFromManyAddresses(mergeIndexFormat, mappedAddrBuffPrimary, destinationColumn.getAddress(), mergeIndexAddress, this.segmentCopyInfo.getTxnInfoAddress(), txnCount, symbolMapMem.getAddress(), symbolMapMem.getAppendOffset()) : Vect.mergeShuffleFixedColumnFromManyAddresses(1 << shl, mergeIndexFormat, mappedAddrBuffPrimary, destinationColumn.getAddress(), mergeIndexAddress, this.segmentCopyInfo.getSegmentsAddress(), this.segmentCopyInfo.getSegmentCount())) != totalRows) {
                            this.throwApplyBlockColumnShuffleFailed(columnIndex, columnType, totalRows, rowCount);
                        }
                    }
                }
            } else {
                long mappedAddrBuffSecondary = mappedAddrBuffPrimary + totalSegmentAddressesBytes;
                MemoryCARW destinationColumnSecondary = this.o3MemColumns1.get(TableWriter.getSecondaryColumnIndex(columnIndex));
                ColumnTypeDriver driver = ColumnType.getDriver(columnType);
                long totalVarSize = this.segmentFileCache.createAddressBuffersSecondary(columnIndex, this.metadata.getColumnCount(), this.segmentCopyInfo, mappedAddrBuffSecondary, driver);
                destinationColumnSecondary.jumpTo(driver.getAuxVectorSize(totalRows));
                MemoryCARW destinationColumnPrimary = this.o3MemColumns1.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                destinationColumnPrimary.jumpTo(totalVarSize);
                long rowCount = driver.mergeShuffleColumnFromManyAddresses(mergeIndexFormat, mappedAddrBuffPrimary, mappedAddrBuffSecondary, destinationColumnPrimary.getAddress(), destinationColumnSecondary.getAddress(), mergeIndexAddress, 0L, totalVarSize);
                if (rowCount != totalRows) {
                    this.throwApplyBlockColumnShuffleFailed(columnIndex, columnType, totalRows, rowCount);
                }
            }
        }
        catch (Throwable th) {
            this.handleColumnTaskException("could not copy shuffle WAL segment columns", columnIndex, columnType, totalRows, mergeIndexAddress, mergeIndexFormat, totalSegmentAddressesBytes, th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWalCommitDedupReplace(Path walPath, boolean ordered, long rowLo, long rowHi, long o3TimestampMin, long o3TimestampMax, @Nullable SymbolMapDiffCursor mapDiffCursor, long walIdSegmentId, boolean isLastSegmentUsage, TableWriterPressureControl pressureControl, long replaceRangeTsLow, long replaceRangeTsHiExcl) {
        assert (this.txWriter.getLagRowCount() == 0);
        assert (replaceRangeTsHiExcl <= replaceRangeTsLow || replaceRangeTsLow <= o3TimestampMin);
        assert (replaceRangeTsHiExcl <= replaceRangeTsLow || replaceRangeTsHiExcl > o3TimestampMax);
        long replaceRangeTsHi = replaceRangeTsHiExcl - 1L;
        int initialSize = this.segmentFileCache.getWalMappedColumns().size();
        int timestampIndex = this.metadata.getTimestampIndex();
        int walRootPathLen = walPath.size();
        boolean success = true;
        this.lastPartitionTimestamp = this.txWriter.getLastPartitionTimestamp();
        if (this.isLastPartitionClosed() && this.isEmptyTable()) {
            this.populateDenseIndexerList();
        }
        try {
            this.dedupMode = (byte)3;
            if (rowLo < rowHi) {
                this.segmentFileCache.mmapSegments(this.metadata, walPath, walIdSegmentId, rowLo, rowHi);
                this.o3Columns = this.segmentFileCache.getWalMappedColumns();
                try {
                    MemoryCR walTimestampColumn = this.segmentFileCache.getWalMappedColumns().getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
                    this.o3Columns = this.remapWalSymbols(mapDiffCursor, rowLo, rowHi, walPath);
                    if (ordered) {
                        long timestampAddr = walTimestampColumn.addressOf(0L);
                        this.txWriter.setLagMinTimestamp(replaceRangeTsLow);
                        this.txWriter.setLagMaxTimestamp(replaceRangeTsHi);
                        this.segmentFileCache.mmapWalColsEager();
                        this.processWalCommitFinishApply(0L, timestampAddr, rowLo, rowHi, pressureControl, false, this.partitionTimestampHi);
                    }
                    LOG.debug().$("sorting WAL [table=").$(this.tableToken).$(", ordered=false").$(", walRowLo=").$(rowLo).$(", walRowHi=").$(rowHi).I$();
                    long totalUncommitted = rowHi - rowLo;
                    long timestampMemorySize = totalUncommitted << 4;
                    this.o3TimestampMem.jumpTo(timestampMemorySize);
                    this.o3TimestampMemCpy.jumpTo(timestampMemorySize);
                    long mappedTimestampIndexAddr = walTimestampColumn.addressOf(rowLo << 4);
                    long timestampAddr = this.o3TimestampMem.getAddress();
                    long rowCount = Vect.radixSortABLongIndexAsc(0L, 0L, mappedTimestampIndexAddr, totalUncommitted, timestampAddr, this.o3TimestampMemCpy.addressOf(0L), o3TimestampMin, o3TimestampMax);
                    assert (rowCount == totalUncommitted) : "radix sort error, result: " + rowCount + " expected " + totalUncommitted;
                    this.dispatchColumnTasks(timestampAddr, totalUncommitted, 0L, rowLo, rowHi, this.cthMergeWalColumnWithLag);
                    this.swapO3ColumnsExcept(timestampIndex);
                    this.o3Columns = this.o3MemColumns1;
                    this.txWriter.setLagMinTimestamp(replaceRangeTsLow);
                    this.txWriter.setLagMaxTimestamp(replaceRangeTsHi);
                    this.processWalCommitFinishApply(0L, timestampAddr, 0L, totalUncommitted, pressureControl, true, this.partitionTimestampHi);
                }
                finally {
                    this.finishO3Append(0L);
                    this.o3Columns = this.o3MemColumns1;
                }
            } else {
                try {
                    this.txWriter.setLagMinTimestamp(replaceRangeTsLow);
                    this.txWriter.setLagMaxTimestamp(replaceRangeTsHi);
                    this.processWalCommitFinishApply(0L, 0L, 0L, 0L, pressureControl, true, this.partitionTimestampHi);
                }
                finally {
                    this.finishO3Append(0L);
                }
            }
            this.dedupMode = 0;
            if (this.memColumnShifted) {
                this.clearMemColumnShifts();
            }
            walPath.trimTo(walRootPathLen);
        }
        catch (Throwable th) {
            try {
                success = false;
                throw th;
            }
            catch (Throwable throwable) {
                this.dedupMode = 0;
                if (this.memColumnShifted) {
                    this.clearMemColumnShifts();
                }
                walPath.trimTo(walRootPathLen);
                if (rowLo < rowHi) {
                    this.segmentFileCache.closeWalFiles(isLastSegmentUsage || !success, walIdSegmentId, initialSize);
                }
                throw throwable;
            }
        }
        if (rowLo < rowHi) {
            this.segmentFileCache.closeWalFiles(isLastSegmentUsage || !success, walIdSegmentId, initialSize);
        }
    }

    private void processWalCommitFinishApply(long walLagRowCount, long timestampAddr, long o3Lo, long o3Hi, TableWriterPressureControl pressureControl, boolean copiedToMemory, long initialPartitionTimestampHi) {
        long commitMinTimestamp = this.txWriter.getLagMinTimestamp();
        long commitMaxTimestamp = this.txWriter.getLagMaxTimestamp();
        this.txWriter.setLagMinTimestamp(Long.MAX_VALUE);
        this.txWriter.setLagMaxTimestamp(Long.MIN_VALUE);
        this.o3RowCount = o3Hi - o3Lo + walLagRowCount;
        if (o3Hi > o3Lo || this.isCommitReplaceMode()) {
            if (this.txWriter.getRowCount() == 0L && this.txWriter.getPartitionCount() == 1 && this.txWriter.getPartitionSize(0) == 0L) {
                this.txWriter.setMaxTimestamp(Long.MIN_VALUE);
                this.lastPartitionTimestamp = Long.MIN_VALUE;
                this.closeActivePartition(false);
                this.partitionTimestampHi = Long.MIN_VALUE;
                long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(0);
                long partitionNameTxn = this.txWriter.getPartitionNameTxnByRawIndex(0);
                this.txWriter.removeAttachedPartitions(partitionTimestamp);
                this.safeDeletePartitionDir(partitionTimestamp, partitionNameTxn);
            }
            this.processO3Block(walLagRowCount, this.metadata.getTimestampIndex(), timestampAddr, o3Hi, commitMinTimestamp, commitMaxTimestamp, copiedToMemory, o3Lo, pressureControl);
            this.finishO3Commit(initialPartitionTimestampHi);
        }
        this.txWriter.setLagOrdered(true);
        this.txWriter.setLagRowCount((int)walLagRowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishTableWriterEvent(int cmdType, long tableId, long correlationId, int errorCode, CharSequence errorMsg, long affectedRowsCount, int eventType) {
        long pubCursor;
        do {
            if ((pubCursor = this.messageBus.getTableWriterEventPubSeq().next()) != -2L) continue;
            Os.pause();
        } while (pubCursor < -1L);
        if (pubCursor > -1L) {
            try {
                TableWriterTask event = this.messageBus.getTableWriterEventQueue().get(pubCursor);
                event.of(eventType, tableId, this.tableToken);
                event.putInt(errorCode);
                if (errorCode != 0) {
                    event.putStr(errorMsg);
                } else {
                    event.putLong(affectedRowsCount);
                }
                event.setInstance(correlationId);
            }
            finally {
                this.messageBus.getTableWriterEventPubSeq().done(pubCursor);
            }
            if (eventType == 65) {
                LogRecord lg = LOG.info().$("published async command complete event [type=").$(cmdType).$(", table=").$(this.tableToken).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId);
                if (errorCode != 0) {
                    lg.$(",errorCode=").$(errorCode).$(",errorMsg=").$(errorMsg);
                }
                lg.I$();
            }
        } else {
            LOG.error().$("could not publish sync command complete event [type=").$(cmdType).$(", table=").$(this.tableToken).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId).I$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readMinTimestamp() {
        this.other.of(this.path).trimTo(this.pathSize);
        long timestamp = this.txWriter.getPartitionTimestampByIndex(1);
        boolean isParquet = this.txWriter.isPartitionParquet(1);
        try {
            this.setStateForTimestamp(this.other, timestamp);
            long l = isParquet ? this.readMinTimestampParquet(this.other) : this.readMinTimestampNative(this.other, timestamp);
            return l;
        }
        finally {
            this.other.trimTo(this.pathSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readMinTimestampNative(Path partitionPath, long partitionTimestamp) {
        if (this.ff.exists(TableUtils.dFile(partitionPath, this.metadata.getColumnName(this.metadata.getTimestampIndex()), -1L))) {
            long fd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
            try {
                long l = TableUtils.readLongOrFail(this.ff, fd, 0L, this.tempMem16b, partitionPath.$());
                return l;
            }
            finally {
                this.ff.close(fd);
            }
        }
        LOG.error().$("cannot read next partition min timestamp on attempt to drop the partition, next partition does not exist [path=").$(this.other).I$();
        return partitionTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readMinTimestampParquet(Path partitionPath) {
        long parquetAddr = 0L;
        long parquetSize = 0L;
        try {
            parquetSize = this.txWriter.getPartitionParquetFileSize(1);
            parquetAddr = TableUtils.mapRO(this.ff, partitionPath.concat("data.parquet").$(), LOG, parquetSize, 17);
            this.parquetDecoder.of(parquetAddr, parquetSize, 56);
            int timestampIndex = this.metadata.getTimestampIndex();
            this.parquetColumnIdsAndTypes.clear();
            this.parquetColumnIdsAndTypes.add(timestampIndex);
            this.parquetColumnIdsAndTypes.add(8);
            this.parquetDecoder.readRowGroupStats(this.parquetStatBuffers, this.parquetColumnIdsAndTypes, 0);
            long l = this.parquetStatBuffers.getMinValueLong(0);
            return l;
        }
        finally {
            this.ff.munmap(parquetAddr, parquetSize, 17);
            Misc.free(this.parquetDecoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNativeMinMaxTimestamps(Path partitionPath, CharSequence columnName, long partitionSize) {
        long fd = TableUtils.openRO(this.ff, TableUtils.dFile(partitionPath, columnName, -1L), LOG);
        try {
            this.attachMinTimestamp = this.ff.readNonNegativeLong(fd, 0L);
            this.attachMaxTimestamp = this.ff.readNonNegativeLong(fd, (partitionSize - 1L) * (long)ColumnType.sizeOf(8));
        }
        finally {
            this.ff.close(fd);
        }
    }

    /*
     * Exception decompiling
     */
    private long readNativeSizeMinMaxTimestamps(long partitionTimestamp, Path path, CharSequence columnName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readParquetMinMaxTimestamps(Path filePath, long parquetSize) {
        assert (parquetSize > 0L);
        long parquetAddr = 0L;
        try {
            parquetAddr = TableUtils.mapRO(this.ff, filePath.$(), LOG, parquetSize, 17);
            this.parquetDecoder.of(parquetAddr, parquetSize, 56);
            int timestampIndex = this.metadata.getTimestampIndex();
            this.parquetColumnIdsAndTypes.clear();
            this.parquetColumnIdsAndTypes.add(timestampIndex);
            this.parquetColumnIdsAndTypes.add(8);
            this.parquetDecoder.readRowGroupStats(this.parquetStatBuffers, this.parquetColumnIdsAndTypes, 0);
            this.attachMinTimestamp = this.parquetStatBuffers.getMinValueLong(0);
            int rowGroupCount = this.parquetDecoder.metadata().rowGroupCount();
            this.parquetDecoder.readRowGroupStats(this.parquetStatBuffers, this.parquetColumnIdsAndTypes, rowGroupCount - 1);
            this.attachMaxTimestamp = this.parquetStatBuffers.getMaxValueLong(0);
            long l = this.parquetDecoder.metadata().rowCount();
            return l;
        }
        finally {
            this.ff.munmap(parquetAddr, parquetSize, 17);
            Misc.free(this.parquetDecoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPartitionMinMaxTimestamps(long partitionTimestamp, Path path, CharSequence columnName, long parquetSize, long partitionSize) {
        int partitionLen = path.size();
        try {
            if (this.ff.exists(path.concat("data.parquet").$())) {
                this.readParquetMinMaxTimestamps(path, parquetSize);
            } else {
                path.trimTo(partitionLen);
                this.readNativeMinMaxTimestamps(path, columnName, partitionSize);
            }
        }
        finally {
            path.trimTo(partitionLen);
        }
        if (this.attachMinTimestamp < 0L || this.attachMaxTimestamp < 0L) {
            throw CairoException.critical(this.ff.errno()).put("cannot read min, max timestamp from the [path=").put(path).put(", partitionSizeRows=").put(partitionSize).put(", errno=").put(this.ff.errno()).put(']');
        }
        if (this.txWriter.getPartitionTimestampByTimestamp(this.attachMinTimestamp) != partitionTimestamp || this.txWriter.getPartitionTimestampByTimestamp(this.attachMaxTimestamp) != partitionTimestamp) {
            throw CairoException.critical(0).put("invalid timestamp data in detached partition, data does not match partition directory name [path=").put(path).put(", minTimestamp=").ts(this.attachMinTimestamp).put(", maxTimestamp=").ts(this.attachMaxTimestamp).put(']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readPartitionSizeMinMaxTimestamps(long partitionTimestamp, Path path, CharSequence columnName, long parquetSize) {
        int partitionLen = path.size();
        try {
            if (this.ff.exists(path.concat("data.parquet").$())) {
                long l = this.readParquetMinMaxTimestamps(path, parquetSize);
                return l;
            }
            path.trimTo(partitionLen);
            long l = this.readNativeSizeMinMaxTimestamps(partitionTimestamp, path, columnName);
            return l;
        }
        finally {
            path.trimTo(partitionLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readTimestampRaw(long transientRowCount) {
        long offset = (transientRowCount - 1L) * 8L;
        long addr = this.mapAppendColumnBuffer(this.getPrimaryColumn(this.metadata.getTimestampIndex()), offset, 8L, false);
        try {
            long l = Unsafe.getUnsafe().getLong(Math.abs(addr));
            return l;
        }
        finally {
            this.mapAppendColumnBufferRelease(addr, offset, 8L);
        }
    }

    private int readTodo() {
        long todoCount;
        try {
            todoCount = this.openTodoMem();
        }
        catch (CairoException ex) {
            if (ex.errnoFileCannotRead()) {
                throw CairoException.tableDoesNotExist(this.tableToken.getTableName());
            }
            throw ex;
        }
        int todo = todoCount > 0L ? (int)this.todoMem.getLong(40L) : -1;
        return todo;
    }

    private void rebuildAttachedPartitionColumnIndex(long partitionTimestamp, long partitionSize, CharSequence columnName) {
        if (this.attachIndexBuilder == null) {
            this.attachIndexBuilder = new IndexBuilder(this.configuration);
            this.attachIndexBuilder.of(Utf8String.EMPTY);
        }
        this.attachIndexBuilder.reindexColumn(this.ff, this.attachColumnVersionReader, this.metadata, this.metadata.getColumnIndex(columnName), -1L, partitionTimestamp, this.partitionBy, partitionSize);
    }

    private boolean reconcileOptimisticPartitions() {
        int maxTimestampPartitionIndex;
        if (this.txWriter.getPartitionTimestampByIndex(this.txWriter.getPartitionCount() - 1) > this.txWriter.getMaxTimestamp() && (maxTimestampPartitionIndex = this.txWriter.getPartitionIndex(this.txWriter.getMaxTimestamp())) < this.getPartitionCount() - 1) {
            int n = this.getPartitionCount();
            for (int i = maxTimestampPartitionIndex + 1; i < n; ++i) {
                long timestamp = this.txWriter.getPartitionTimestampByIndex(i);
                long partitionTxn = this.txWriter.getPartitionNameTxn(i);
                this.partitionRemoveCandidates.add(timestamp, partitionTxn);
            }
            this.txWriter.reconcileOptimisticPartitions();
            return true;
        }
        return false;
    }

    private void recoverFromMetaRenameFailure() {
        TableWriter.openMetaFile(this.ff, this.path, this.pathSize, this.ddlMem, this.metadata);
    }

    private void recoverFromSwapRenameFailure() {
        this.recoverFromTodoWriteFailure();
        this.clearTodoLog();
    }

    private void recoverFromSymbolMapWriterFailure(CharSequence columnName) {
        this.removeSymbolMapFilesQuiet(columnName, this.getTxn());
        this.removeMetaFile();
        this.recoverFromSwapRenameFailure();
    }

    private void recoverFromTodoWriteFailure() {
        this.restoreMetaFrom("_meta.prev", this.metaPrevIndex);
        TableWriter.openMetaFile(this.ff, this.path, this.pathSize, this.ddlMem, this.metadata);
        this.columnCount = this.metadata.getColumnCount();
    }

    private void recoverOpenColumnFailure() {
        this.removeMetaFile();
        this.recoverFromSwapRenameFailure();
        this.distressed = true;
    }

    private void releaseIndexerWriters() {
        int n = this.denseIndexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            if (indexer == null) continue;
            indexer.releaseIndexWriter();
        }
        this.denseIndexers.clear();
    }

    private void releaseLock(boolean distressed) {
        if (this.lockFd != -1L) {
            if (distressed) {
                this.ff.close(this.lockFd);
                return;
            }
            try {
                TableWriter.closeRemove(this.ff, this.lockFd, TableUtils.lockName(this.path));
            }
            finally {
                this.path.trimTo(this.pathSize);
            }
        }
    }

    private ReadOnlyObjList<? extends MemoryCR> remapWalSymbols(@Nullable SymbolMapDiffCursor symbolMapDiffCursor, long rowLo, long rowHi, Path walPath) {
        this.o3ColumnOverrides.clear();
        if (symbolMapDiffCursor != null) {
            SymbolMapDiff symbolMapDiff;
            while ((symbolMapDiff = symbolMapDiffCursor.nextSymbolMapDiff()) != null) {
                int columnIndex = symbolMapDiff.getColumnIndex();
                int columnType = this.metadata.getColumnType(columnIndex);
                if (columnType == -12) {
                    symbolMapDiff.drain();
                    continue;
                }
                if (!ColumnType.isSymbol(columnType)) {
                    throw CairoException.critical(0).put("WAL column and table writer column types don't match [columnIndex=").put(columnIndex).put(", walPath=").put(walPath).put(']');
                }
                boolean identical = this.createWalSymbolMapping(symbolMapDiff, columnIndex, this.symbolRewriteMap);
                if (identical) continue;
                int primaryColumnIndex = TableWriter.getPrimaryColumnIndex(columnIndex);
                MemoryCR o3SymbolColumn = this.o3Columns.getQuick(primaryColumnIndex);
                if (this.o3ColumnOverrides.size() == 0) {
                    this.o3ColumnOverrides.addAll(this.o3Columns);
                }
                MemoryCARW symbolColumnDest = this.o3MemColumns1.get(primaryColumnIndex);
                symbolColumnDest.shiftAddressRight(0L);
                symbolColumnDest.jumpTo(rowHi - rowLo << 2);
                this.o3ColumnOverrides.setQuick(primaryColumnIndex, symbolColumnDest);
                int cleanSymbolCount = symbolMapDiff.getCleanSymbolCount();
                for (long rowId = rowLo; rowId < rowHi; ++rowId) {
                    int symKey = o3SymbolColumn.getInt(rowId << 2);
                    assert (symKey >= 0 || symKey == Integer.MIN_VALUE);
                    if (symKey >= cleanSymbolCount) {
                        int newKey = this.symbolRewriteMap.getQuick(symKey - cleanSymbolCount);
                        if (newKey < 0) {
                            throw CairoException.critical(0).put("WAL symbol key not mapped [columnIndex=").put(columnIndex).put(", columnKey=").put(symKey).put(", walPath=").put(walPath).put(", walRowId=").put(rowId).put(']');
                        }
                        symKey = newKey;
                    }
                    symbolColumnDest.putInt(rowId - rowLo << 2, symKey);
                }
                symbolColumnDest.shiftAddressRight(rowLo << 2);
                this.memColumnShifted |= rowLo != 0L;
            }
        }
        if (this.o3ColumnOverrides.size() == 0) {
            return this.o3Columns;
        }
        return this.o3ColumnOverrides;
    }

    private void removeColumnFiles(int columnIndex, String columnName, int columnType, boolean isIndexed) {
        PurgingOperator purgingOperator = this.getPurgingOperator();
        long defaultNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(columnIndex);
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            int i = this.txWriter.getPartitionCount() - 1;
            while ((long)i > -1L) {
                long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(i);
                if (!this.txWriter.isPartitionReadOnlyByPartitionTimestamp(partitionTimestamp)) {
                    long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
                    long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
                    purgingOperator.add(columnIndex, columnName, columnType, isIndexed, columnNameTxn, partitionTimestamp, partitionNameTxn);
                }
                --i;
            }
        } else {
            purgingOperator.add(columnIndex, columnName, columnType, isIndexed, defaultNameTxn, this.txWriter.getLastPartitionTimestamp(), -1L);
        }
        if (ColumnType.isSymbol(columnType)) {
            purgingOperator.add(columnIndex, columnName, columnType, isIndexed, defaultNameTxn, -9223372036854775807L, -1L);
        }
    }

    private void removeColumnFilesInPartition(CharSequence columnName, int columnIndex, long partitionTimestamp) {
        if (!this.txWriter.isPartitionReadOnlyByPartitionTimestamp(partitionTimestamp)) {
            TableUtils.setPathForNativePartition(this.path, this.partitionBy, partitionTimestamp, -1L);
            int plen = this.path.size();
            long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
            TableWriter.removeFileOrLog(this.ff, TableUtils.dFile(this.path, columnName, columnNameTxn));
            TableWriter.removeFileOrLog(this.ff, TableUtils.iFile(this.path.trimTo(plen), columnName, columnNameTxn));
            TableWriter.removeFileOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn));
            TableWriter.removeFileOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn));
            this.path.trimTo(this.pathSize);
        } else {
            LOG.critical().$("o3 ignoring removal of column in read-only partition [table=").$safe(this.tableToken.getTableName()).$(", column=").$safe(columnName).$(", timestamp=").$ts(partitionTimestamp).$();
        }
    }

    private void removeIndexFilesInPartition(CharSequence columnName, int columnIndex, long partitionTimestamp, long partitionNameTxn) {
        TableUtils.setPathForNativePartition(this.path, this.partitionBy, partitionTimestamp, partitionNameTxn);
        int plen = this.path.size();
        long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
        TableWriter.removeFileOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn));
        TableWriter.removeFileOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn));
        this.path.trimTo(this.pathSize);
    }

    private void removeMetaFile() {
        try {
            this.path.concat("_meta");
            if (!this.ff.removeQuiet(this.path.$())) {
                this.other.concat("_meta").put('.').put(this.configuration.getMicrosecondClock().getTicks());
                if (this.ff.rename(this.path.$(), this.other.$()) != 0) {
                    LOG.error().$("could not rename [from=").$(this.path).$(", to=").$(this.other).I$();
                    throw CairoException.critical(this.ff.errno()).put("Recovery failed. Could not rename: ").put(this.path);
                }
            }
        }
        finally {
            this.path.trimTo(this.pathSize);
            this.other.trimTo(this.pathSize);
        }
    }

    private void removeNonAttachedPartitions() {
        LOG.debug().$("purging non attached partitions [path=").$substr(this.pathRootSize, this.path.$()).I$();
        try {
            this.ff.iterateDir(this.path.$(), this.removePartitionDirsNotAttached);
            this.processPartitionRemoveCandidates();
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
    }

    private void removePartitionDirsNotAttached(long pUtf8NameZ, int type) {
        int checkedType = this.ff.typeDirOrSoftLinkDirNoDots(this.path, this.pathSize, pUtf8NameZ, type, this.utf8Sink);
        if (!(checkedType == 0 || CairoKeywords.isDetachedDirMarker(pUtf8NameZ) || CairoKeywords.isWal(pUtf8NameZ) || CairoKeywords.isTxnSeq(pUtf8NameZ) || CairoKeywords.isSeq(pUtf8NameZ) || Utf8s.endsWithAscii((Utf8Sequence)this.utf8Sink, this.configuration.getAttachPartitionSuffix()))) {
            try {
                long txn;
                int txnSep = Utf8s.indexOfAscii(this.utf8Sink, '.');
                if (txnSep < 0) {
                    txnSep = this.utf8Sink.size();
                    txn = -1L;
                } else {
                    txn = Numbers.parseLong(this.utf8Sink, txnSep + 1, this.utf8Sink.size());
                }
                long dirTimestamp = this.partitionDirFmt.parse(this.utf8Sink.asAsciiCharSequence(), 0, txnSep, DateFormatUtils.EN_LOCALE);
                if (txn != this.txWriter.getPartitionNameTxnByPartitionTimestamp(dirTimestamp, -2L)) {
                    this.partitionRemoveCandidates.add(dirTimestamp, txn);
                }
            }
            catch (NumericException ignore) {
                this.path.trimTo(this.pathSize);
                this.path.concat(pUtf8NameZ).$();
                LOG.error().$("invalid partition directory inside table folder: ").$(this.path).$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSymbolMapFilesQuiet(CharSequence name, long columnNameTxn) {
        try {
            TableWriter.removeFileOrLog(this.ff, TableUtils.offsetFileName(this.path.trimTo(this.pathSize), name, columnNameTxn));
            TableWriter.removeFileOrLog(this.ff, TableUtils.charFileName(this.path.trimTo(this.pathSize), name, columnNameTxn));
            TableWriter.removeFileOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.pathSize), name, columnNameTxn));
            TableWriter.removeFileOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.pathSize), name, columnNameTxn));
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
    }

    private void removeSymbolMapWriter(int index) {
        MapWriter writer = this.symbolMapWriters.getAndSetQuick(index, NullMapWriter.INSTANCE);
        if (writer != null && writer != NullMapWriter.INSTANCE) {
            for (int symColIndex = this.denseSymbolMapWriters.remove(writer); symColIndex < this.denseSymbolMapWriters.size(); ++symColIndex) {
                MapWriter w = this.denseSymbolMapWriters.getQuick(symColIndex);
                w.setSymbolIndexInTxWriter(symColIndex);
            }
            Misc.freeIfCloseable(writer);
        }
    }

    private int rename(int retries) {
        try {
            int index = 0;
            this.other.concat("_meta.prev").$();
            this.path.concat("_meta").$();
            int l = this.other.size();
            do {
                if (index > 0) {
                    this.other.trimTo(l);
                    this.other.put('.').put(index);
                }
                if (!this.ff.removeQuiet(this.other.$())) {
                    LOG.info().$("could not remove target of rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).I$();
                    ++index;
                    continue;
                }
                if (this.ff.rename(this.path.$(), this.other.$()) != 0) {
                    LOG.info().$("could not rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).I$();
                    ++index;
                    continue;
                }
                int n = index;
                return n;
            } while (index < retries);
            throw CairoException.critical(0).put("could not rename ").put(this.path).put(". Max number of attempts reached [").put(index).put("]. Last target was: ").put(this.other);
        }
        finally {
            this.path.trimTo(this.pathSize);
            this.other.trimTo(this.pathSize);
        }
    }

    private void renameMetaToMetaPrev() {
        try {
            this.metaPrevIndex = this.rename(this.fileOperationRetryCount);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_META_RENAME_FAILURE, e);
        }
    }

    private void renameSwapMetaToMeta() {
        try {
            this.restoreMetaFrom("_meta.swp", this.metaSwapIndex);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_SWAP_RENAME_FAILURE, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long repairDataGaps(long timestamp) {
        if (this.txWriter.getMaxTimestamp() != Long.MIN_VALUE && PartitionBy.isPartitioned(this.partitionBy)) {
            long expectedSize;
            long fixedRowCount = 0L;
            long lastTimestamp = -1L;
            long transientRowCount = this.txWriter.getTransientRowCount();
            long maxTimestamp = this.txWriter.getMaxTimestamp();
            try {
                long tsLimit = this.txWriter.getPartitionTimestampByTimestamp(this.txWriter.getMaxTimestamp());
                long ts = this.txWriter.getPartitionTimestampByTimestamp(this.txWriter.getMinTimestamp());
                while (ts < tsLimit) {
                    this.path.trimTo(this.pathSize);
                    this.setStateForTimestamp(this.path, ts);
                    int p = this.path.size();
                    long partitionSize = this.txWriter.getPartitionRowCountByTimestamp(ts);
                    if (partitionSize >= 0L && this.ff.exists(this.path.$())) {
                        fixedRowCount += partitionSize;
                        lastTimestamp = ts;
                    } else {
                        Path other = Path.getThreadLocal2(this.path.trimTo(p));
                        TableUtils.oldPartitionName(other, this.getTxn());
                        if (this.ff.exists(other.$())) {
                            if (this.ff.rename(other.$(), this.path.$()) != 0) {
                                LOG.error().$("could not rename [from=").$(other).$(", to=").$(this.path).I$();
                                throw new CairoError("could not restore directory, see log for details");
                            }
                            LOG.info().$("restored [path=").$substr(this.pathRootSize, this.path).I$();
                        } else {
                            LOG.debug().$("missing partition [name=").$(this.path.trimTo(p).$()).I$();
                        }
                    }
                    ts = this.txWriter.getNextPartitionTimestamp(ts);
                }
                if (lastTimestamp > -1L) {
                    this.path.trimTo(this.pathSize);
                    this.setStateForTimestamp(this.path, tsLimit);
                    if (!this.ff.exists(this.path.$())) {
                        Path other = Path.getThreadLocal2(this.path);
                        TableUtils.oldPartitionName(other, this.getTxn());
                        if (this.ff.exists(other.$())) {
                            if (this.ff.rename(other.$(), this.path.$()) != 0) {
                                LOG.error().$("could not rename [from=").$(other).$(", to=").$(this.path).I$();
                                throw new CairoError("could not restore directory, see log for details");
                            }
                            LOG.info().$("restored [path=").$substr(this.pathRootSize, this.path).I$();
                        } else {
                            LOG.error().$("last partition does not exist [name=").$(this.path).I$();
                            this.path.trimTo(this.pathSize);
                            this.setStateForTimestamp(this.path, lastTimestamp);
                            int p = this.path.size();
                            transientRowCount = this.txWriter.getPartitionRowCountByTimestamp(lastTimestamp);
                            TableUtils.dFile(this.path.trimTo(p), this.metadata.getColumnName(this.metadata.getTimestampIndex()), -1L);
                            maxTimestamp = TableUtils.readLongAtOffset(this.ff, this.path.$(), this.tempMem16b, (transientRowCount - 1L) * 8L);
                            fixedRowCount -= transientRowCount;
                            this.txWriter.removeAttachedPartitions(this.txWriter.getMaxTimestamp());
                            LOG.info().$("updated active partition [name=").$(this.path.trimTo(p).$()).$(", maxTimestamp=").$ts(maxTimestamp).$(", transientRowCount=").$(transientRowCount).$(", fixedRowCount=").$(this.txWriter.getFixedRowCount()).I$();
                        }
                    }
                }
            }
            finally {
                this.path.trimTo(this.pathSize);
            }
            if ((expectedSize = this.txWriter.unsafeReadFixedRowCount()) != fixedRowCount || maxTimestamp != this.txWriter.getMaxTimestamp()) {
                LOG.info().$("actual table size has been adjusted [name=`").$safe(this.tableToken.getTableName()).$('`').$(", expectedFixedSize=").$(expectedSize).$(", actualFixedSize=").$(fixedRowCount).I$();
                this.txWriter.reset(fixedRowCount, transientRowCount, maxTimestamp, this.denseSymbolMapWriters);
                return maxTimestamp;
            }
        }
        return timestamp;
    }

    private void repairMetaRename(int index) {
        try {
            this.path.concat("_meta.prev");
            if (index > 0) {
                this.path.put('.').put(index);
            }
            if (this.ff.exists(this.path.$())) {
                LOG.info().$("Repairing metadata from: ").$substr(this.pathRootSize, this.path).$();
                this.ff.remove(this.other.concat("_meta").$());
                if (this.ff.rename(this.path.$(), this.other.$()) != 0) {
                    throw CairoException.critical(this.ff.errno()).put("Repair failed. Cannot rename ").put(this.path).put(" -> ").put(this.other);
                }
            }
        }
        finally {
            this.path.trimTo(this.pathSize);
            this.other.trimTo(this.pathSize);
        }
        this.clearTodoLog();
    }

    private void repairTruncate() {
        LOG.info().$("repairing abnormally terminated truncate on ").$substr(this.pathRootSize, this.path).$();
        this.scheduleRemoveAllPartitions();
        this.txWriter.truncate(this.columnVersionWriter.getVersion(), this.denseSymbolMapWriters);
        this.clearTodoLog();
        this.processPartitionRemoveCandidates();
    }

    private void resizePartitionUpdateSink() {
        if (this.o3PartitionUpdateSink == null) {
            this.o3PartitionUpdateSink = new PagedDirectLongList(45);
        }
        this.o3PartitionUpdateSink.clear();
        this.o3PartitionUpdateSink.setBlockSize(8 + this.metadata.getColumnCount());
    }

    private void restoreMetaFrom(CharSequence fromBase, int fromIndex) {
        try {
            this.path.concat(fromBase);
            if (fromIndex > 0) {
                this.path.put('.').put(fromIndex);
            }
            this.path.$();
            TableUtils.renameOrFail(this.ff, this.path.$(), this.other.concat("_meta").$());
        }
        finally {
            this.path.trimTo(this.pathSize);
            this.other.trimTo(this.pathSize);
        }
    }

    private void rewriteAndSwapMetadata(TableWriterMetadata metadata) {
        this.metaSwapIndex = this.rewriteMetadata(metadata);
        this.validateSwapMeta();
        this.renameMetaToMetaPrev();
        this.writeRestoreMetaTodo();
        this.renameSwapMetaToMeta();
    }

    private int rewriteMetadata(TableWriterMetadata metadata) {
        try {
            int columnCount = metadata.getColumnCount();
            int index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.pathSize, this.configuration.getMaxSwapFileCount());
            this.ddlMem.putInt(metadata.getColumnCount());
            this.ddlMem.putInt(metadata.getPartitionBy());
            this.ddlMem.putInt(metadata.getTimestampIndex());
            this.ddlMem.putInt(426);
            this.ddlMem.putInt(metadata.getTableId());
            this.ddlMem.putInt(metadata.getMaxUncommittedRows());
            this.ddlMem.putLong(metadata.getO3MaxLag());
            int version = this.txWriter.getMetadataVersion() + 1;
            metadata.setMetadataVersion(version);
            this.ddlMem.putLong(metadata.getMetadataVersion());
            this.ddlMem.putBool(metadata.isWalEnabled());
            this.ddlMem.putInt(TableUtils.calculateMetaFormatMinorVersionField(version, columnCount));
            this.ddlMem.putInt(metadata.getTtlHoursOrMonths());
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                int columnType = metadata.getColumnType(i);
                this.ddlMem.putInt(columnType);
                long flags = 0L;
                if (metadata.isIndexed(i)) {
                    flags |= 1L;
                }
                if (metadata.isDedupKey(i)) {
                    flags |= 8L;
                }
                if (metadata.getSymbolCacheFlag(i)) {
                    flags |= 4L;
                }
                this.ddlMem.putLong(flags);
                this.ddlMem.putInt(metadata.getIndexBlockCapacity(i));
                this.ddlMem.putInt(metadata.getSymbolCapacity(i));
                this.ddlMem.skip(4L);
                int replaceColumnIndex = metadata.getReplacingColumnIndex(i);
                this.ddlMem.putInt(replaceColumnIndex > -1 ? replaceColumnIndex + 1 : 0);
                this.ddlMem.skip(4L);
            }
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            this.ddlMem.jumpTo(nameOffset);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = metadata.getColumnName(i);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)Vm.getStorageLength(columnName);
            }
            this.ddlMem.sync(false);
            int n = index;
            return n;
        }
        catch (Throwable th) {
            LOG.critical().$("could not write to metadata file, rolling back DDL [path=").$(this.path).$(']').$();
            try {
                TableWriter.openMetaFile(this.ff, this.path, this.pathSize, this.ddlMem, metadata);
            }
            catch (Throwable th2) {
                LOG.critical().$("could not revert metadata, writer distressed [path=").$(this.path).$(']').$();
                this.throwDistressException(th2);
            }
            throw th;
        }
        finally {
            this.ddlMem.close(true, (byte)1);
        }
    }

    private void rollbackIndexes() {
        long maxRow = this.txWriter.getTransientRowCount() - 1L;
        int n = this.denseIndexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            long fd = indexer.getFd();
            if (fd <= -1L) continue;
            LOG.info().$("recovering index [fd=").$(fd).I$();
            indexer.rollback(maxRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackRemoveIndexFiles(CharSequence columnName, int columnIndex) {
        try {
            int i = this.txWriter.getPartitionCount() - 1;
            while ((long)i > -1L) {
                long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(i);
                long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
                this.removeIndexFilesInPartition(columnName, columnIndex, partitionTimestamp, partitionNameTxn);
                --i;
            }
            if (!PartitionBy.isPartitioned(this.partitionBy)) {
                this.removeColumnFilesInPartition(columnName, columnIndex, this.txWriter.getLastPartitionTimestamp());
            }
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
    }

    private void rollbackSymbolTables(boolean quiet) {
        int expectedMapWriters = this.txWriter.unsafeReadSymbolColumnCount();
        for (int i = 0; i < expectedMapWriters; ++i) {
            try {
                this.denseSymbolMapWriters.get(i).rollback(this.txWriter.unsafeReadSymbolWriterIndexOffset(i));
                continue;
            }
            catch (Throwable th) {
                if (quiet) {
                    this.distressed = true;
                    CharSequence columnName = this.metadata.getColumnName(i);
                    LOG.error().$("could not rollback symbol table [table=").$(this.tableToken).$(", columnName=").$safe(columnName).$(", exception=").$(th).I$();
                    continue;
                }
                throw th;
            }
        }
    }

    private void rowAppend(ObjList<Runnable> activeNullSetters) {
        if ((this.masterRef & 1L) != 0L) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.rowValueIsNotNull.getQuick(i) >= this.masterRef) continue;
                activeNullSetters.getQuick(i).run();
            }
            ++this.masterRef;
        }
    }

    private void runFragile(FragileCode fragile, CairoException e) {
        try {
            fragile.run();
        }
        catch (CairoException e2) {
            LOG.error().$("DOUBLE ERROR: 1st: {").$(e).$('}').$();
            this.throwDistressException(e2);
        }
        throw e;
    }

    private void safeDeletePartitionDir(long timestamp, long partitionNameTxn) {
        this.partitionRemoveCandidates.clear();
        this.partitionRemoveCandidates.add(timestamp, partitionNameTxn);
        this.processPartitionRemoveCandidates();
    }

    private void scheduleRemoveAllPartitions() {
        int i = this.txWriter.getPartitionCount() - 1;
        while ((long)i > -1L) {
            long timestamp = this.txWriter.getPartitionTimestampByIndex(i);
            long partitionTxn = this.txWriter.getPartitionNameTxn(i);
            this.partitionRemoveCandidates.add(timestamp, partitionTxn);
            --i;
        }
    }

    private void setAppendPosition(long rowCount, boolean doubleAllocate) {
        this.engine.getPartitionOverwriteControl().notifyPartitionMutates(this.tableToken, this.lastOpenPartitionTs, this.lastOpenPartitionTxnName, rowCount);
        long recordLength = 0L;
        for (int i = 0; i < this.columnCount; ++i) {
            recordLength += this.setColumnAppendPosition(i, rowCount, doubleAllocate);
        }
        this.avgRecordSize = rowCount > 0L ? recordLength / rowCount : Math.max(this.avgRecordSize, recordLength);
    }

    private long setColumnAppendPosition(int columnIndex, long size, boolean doubleAllocate) {
        long dataSizeBytes = 0L;
        try {
            MemoryMA dataMem = this.getPrimaryColumn(columnIndex);
            MemoryMA auxMem = this.getSecondaryColumn(columnIndex);
            int columnType = this.metadata.getColumnType(columnIndex);
            if (columnType > 0) {
                long pos = size - this.getColumnTop(columnIndex);
                if (ColumnType.isVarSize(columnType)) {
                    ColumnTypeDriver driver = ColumnType.getDriver(columnType);
                    dataSizeBytes = driver.setAppendPosition(pos, auxMem, dataMem) - driver.getMinAuxVectorSize();
                } else {
                    dataSizeBytes = pos << ColumnType.pow2SizeOf(columnType);
                    if (doubleAllocate) {
                        dataMem.allocate(dataSizeBytes);
                    }
                    dataMem.jumpTo(dataSizeBytes);
                }
            }
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        return dataSizeBytes;
    }

    private void setO3AppendPosition(long position) {
        for (int i = 0; i < this.columnCount; ++i) {
            int columnType = this.metadata.getColumnType(i);
            if (columnType <= 0) continue;
            this.o3SetAppendOffset(i, columnType, position);
        }
    }

    private void setRowValueNotNull(int columnIndex) {
        assert (this.rowValueIsNotNull.getQuick(columnIndex) != this.masterRef);
        this.rowValueIsNotNull.setQuick(columnIndex, this.masterRef);
    }

    private long setStateForTimestamp(Path path, long timestamp) {
        long partitionTxnName = PartitionBy.isPartitioned(this.partitionBy) ? this.txWriter.getTxn() - 1L : -1L;
        partitionTxnName = this.txWriter.getPartitionNameTxnByPartitionTimestamp(timestamp, partitionTxnName);
        TableUtils.setPathForNativePartition(path, this.partitionBy, timestamp, partitionTxnName);
        return partitionTxnName;
    }

    private void shrinkO3Mem() {
        int i;
        int n = this.o3MemColumns1.size();
        for (i = 0; i < n; ++i) {
            MemoryCARW o3mem = this.o3MemColumns1.getQuick(i);
            if (o3mem == null) continue;
            o3mem.truncate();
        }
        n = this.o3MemColumns2.size();
        for (i = 0; i < n; ++i) {
            MemoryCARW o3mem2 = this.o3MemColumns2.getQuick(i);
            if (o3mem2 == null) continue;
            o3mem2.truncate();
        }
    }

    private void squashPartitionForce(int partitionIndex) {
        int lastLogicalPartitionIndex = partitionIndex;
        long lastLogicalPartitionTimestamp = this.txWriter.getPartitionTimestampByIndex(partitionIndex);
        if (lastLogicalPartitionTimestamp != this.txWriter.getLogicalPartitionTimestamp(lastLogicalPartitionTimestamp)) {
            lastLogicalPartitionTimestamp = this.txWriter.getLogicalPartitionTimestamp(lastLogicalPartitionTimestamp);
            this.txWriter.insertPartition(partitionIndex, lastLogicalPartitionTimestamp, 0L, this.txWriter.txn);
            this.setStateForTimestamp(this.other, lastLogicalPartitionTimestamp);
            if (this.ff.mkdir(this.other.$(), this.configuration.getMkDirMode()) != 0) {
                throw CairoException.critical(this.ff.errno()).put("could not create directory [path='").put(this.other).put("']");
            }
            ++partitionIndex;
        }
        while (partitionIndex < this.txWriter.getPartitionCount()) {
            long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(partitionIndex);
            long logicalPartitionTimestamp = this.txWriter.getLogicalPartitionTimestamp(partitionTimestamp);
            if (logicalPartitionTimestamp != lastLogicalPartitionTimestamp) {
                if (partitionIndex > lastLogicalPartitionIndex + 1) {
                    this.squashSplitPartitions(lastLogicalPartitionIndex, partitionIndex, 1, true);
                }
                return;
            }
            ++partitionIndex;
        }
        if (partitionIndex > lastLogicalPartitionIndex + 1) {
            this.squashSplitPartitions(lastLogicalPartitionIndex, partitionIndex, 1, true);
        }
    }

    private void squashPartitionRange(int maxLastSubPartitionCount, int partitionIndexLo, int partitionIndexHi) {
        if (partitionIndexHi > partitionIndexLo) {
            int optimalPartitionCount;
            int subpartitions = partitionIndexHi - partitionIndexLo;
            int n = optimalPartitionCount = partitionIndexHi == this.txWriter.getPartitionCount() ? maxLastSubPartitionCount : 1;
            if (subpartitions > Math.max(1, optimalPartitionCount)) {
                this.squashSplitPartitions(partitionIndexLo, partitionIndexHi, optimalPartitionCount, false);
            } else if (subpartitions == 1 && partitionIndexLo >= 0 && partitionIndexLo < this.txWriter.getPartitionCount() && this.minSplitPartitionTimestamp == this.txWriter.getPartitionTimestampByIndex(partitionIndexLo)) {
                this.minSplitPartitionTimestamp = this.getPartitionTimestampOrMax(partitionIndexLo + 1);
            }
        }
    }

    private void squashSplitPartitions(long timestampMin, long timestampMax, int maxLastSubPartitionCount) {
        if (timestampMin > this.txWriter.getMaxTimestamp() || this.txWriter.getPartitionCount() < 2) {
            return;
        }
        long logicalPartitionTimestamp = this.txWriter.getLogicalPartitionTimestamp(timestampMin);
        int partitionIndexLo = this.squashSplitPartitions_findPartitionIndexAtOrGreaterTimestamp(logicalPartitionTimestamp);
        boolean splitsKept = false;
        if (partitionIndexLo < this.txWriter.getPartitionCount()) {
            int partitionIndex;
            int partitionIndexHi = Math.min(this.squashSplitPartitions_findPartitionIndexAtOrGreaterTimestamp(timestampMax) + 1, this.txWriter.getPartitionCount());
            for (partitionIndex = partitionIndexLo + 1; partitionIndex < partitionIndexHi; ++partitionIndex) {
                long nextPartitionTimestamp = this.txWriter.getPartitionTimestampByIndex(partitionIndex);
                long nextPartitionLogicalTimestamp = this.txWriter.getLogicalPartitionTimestamp(nextPartitionTimestamp);
                if (nextPartitionLogicalTimestamp == logicalPartitionTimestamp) continue;
                int splitCount = partitionIndex - partitionIndexLo;
                if (splitCount > 1) {
                    int partitionCount = this.txWriter.getPartitionCount();
                    this.squashPartitionRange(maxLastSubPartitionCount, partitionIndexLo, partitionIndex);
                    int partitionReduction = partitionCount - this.txWriter.getPartitionCount();
                    splitsKept = partitionReduction < splitCount - 1;
                    logicalPartitionTimestamp = nextPartitionTimestamp;
                    partitionIndexLo = partitionIndex = this.squashSplitPartitions_findPartitionIndexAtOrGreaterTimestamp(nextPartitionTimestamp);
                    partitionIndexHi = Math.min(this.squashSplitPartitions_findPartitionIndexAtOrGreaterTimestamp(timestampMax) + 1, this.txWriter.getPartitionCount());
                } else {
                    partitionIndexLo = partitionIndex;
                    logicalPartitionTimestamp = nextPartitionLogicalTimestamp;
                }
                if (splitsKept || timestampMin != this.minSplitPartitionTimestamp) continue;
                this.minSplitPartitionTimestamp = nextPartitionTimestamp;
            }
            if (partitionIndex - partitionIndexLo > 1) {
                this.squashPartitionRange(maxLastSubPartitionCount, partitionIndexLo, partitionIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void squashSplitPartitions(int partitionIndexLo, int partitionIndexHi, int optimalPartitionCount, boolean force) {
        int targetPartitionIndex;
        if (partitionIndexHi <= partitionIndexLo + Math.max(1, optimalPartitionCount)) {
            return;
        }
        if (this.checkpointStatus.partitionsLocked()) {
            LOG.info().$("cannot squash partition [table=").$safe(this.tableToken.getTableName()).$("], checkpoint in progress").$();
            return;
        }
        assert (partitionIndexHi >= 0 && partitionIndexHi <= this.txWriter.getPartitionCount() && partitionIndexLo >= 0);
        long targetPartition = Long.MIN_VALUE;
        boolean copyTargetFrame = false;
        int n = partitionIndexHi - 1;
        for (targetPartitionIndex = partitionIndexLo; targetPartitionIndex < n; ++targetPartitionIndex) {
            boolean canOverwrite = this.canSquashOverwritePartitionTail(targetPartitionIndex);
            if (!canOverwrite && !force) continue;
            targetPartition = this.txWriter.getPartitionTimestampByIndex(targetPartitionIndex);
            copyTargetFrame = !canOverwrite;
            break;
        }
        if (targetPartition == Long.MIN_VALUE) {
            return;
        }
        boolean lastPartitionSquashed = false;
        int squashCount = Math.min(partitionIndexHi - targetPartitionIndex - 1, partitionIndexHi - partitionIndexLo - optimalPartitionCount);
        if (squashCount <= 0) {
            return;
        }
        long targetPartitionNameTxn = this.txWriter.getPartitionNameTxnByPartitionTimestamp(targetPartition);
        TableUtils.setPathForNativePartition(this.path, this.partitionBy, targetPartition, targetPartitionNameTxn);
        long originalSize = this.txWriter.getPartitionRowCountByTimestamp(targetPartition);
        boolean rw = !copyTargetFrame;
        Frame targetFrame = null;
        FrameFactory frameFactory = this.engine.getFrameFactory();
        Frame firstPartitionFrame = frameFactory.open(rw, this.path, targetPartition, this.metadata, this.columnVersionWriter, originalSize);
        try {
            if (copyTargetFrame) {
                try {
                    TableUtils.setPathForNativePartition(this.other, this.partitionBy, targetPartition, this.txWriter.txn);
                    TableUtils.createDirsOrFail(this.ff, this.other.slash(), this.configuration.getMkDirMode());
                    LOG.info().$("copying partition to force squash [from=").$substr(this.pathRootSize, this.path).$(", to=").$(this.other).I$();
                    targetFrame = frameFactory.openRW(this.other, targetPartition, this.metadata, this.columnVersionWriter, 0L);
                    FrameAlgebra.append(targetFrame, firstPartitionFrame, this.configuration.getCommitMode());
                    this.addPhysicallyWrittenRows(firstPartitionFrame.getRowCount());
                    this.txWriter.updatePartitionSizeAndTxnByRawIndex(targetPartitionIndex * 4, originalSize);
                    this.partitionRemoveCandidates.add(targetPartition, targetPartitionNameTxn);
                    targetPartitionNameTxn = this.txWriter.txn;
                }
                finally {
                    Misc.free(firstPartitionFrame);
                }
            } else {
                targetFrame = firstPartitionFrame;
            }
            this.engine.getPartitionOverwriteControl().notifyPartitionMutates(this.tableToken, targetPartition, targetPartitionNameTxn, targetFrame.getRowCount());
            for (int i = 0; i < squashCount; ++i) {
                long sourcePartition = this.txWriter.getPartitionTimestampByIndex(targetPartitionIndex + 1);
                this.other.trimTo(this.pathSize);
                long sourceNameTxn = this.txWriter.getPartitionNameTxnByPartitionTimestamp(sourcePartition);
                TableUtils.setPathForNativePartition(this.other, this.partitionBy, sourcePartition, sourceNameTxn);
                long partitionRowCount = this.txWriter.getPartitionRowCountByTimestamp(sourcePartition);
                boolean bl = lastPartitionSquashed = targetPartitionIndex + 2 == this.txWriter.getPartitionCount();
                if (lastPartitionSquashed) {
                    this.closeActivePartition(false);
                    partitionRowCount = this.txWriter.getTransientRowCount() + (long)this.txWriter.getLagRowCount();
                }
                assert (partitionRowCount > 0L);
                LOG.info().$("squashing partitions [table=").$(this.tableToken).$(", target=").$(this.formatPartitionForTimestamp(targetPartition, targetPartitionNameTxn)).$(", targetSize=").$(targetFrame.getRowCount()).$(", source=").$(this.formatPartitionForTimestamp(sourcePartition, sourceNameTxn)).$(", sourceSize=").$(partitionRowCount).I$();
                try (Frame sourceFrame = frameFactory.openRO(this.other, sourcePartition, this.metadata, this.columnVersionWriter, partitionRowCount);){
                    FrameAlgebra.append(targetFrame, sourceFrame, this.configuration.getCommitMode());
                    this.addPhysicallyWrittenRows(sourceFrame.getRowCount());
                }
                catch (Throwable th) {
                    LOG.critical().$("partition squashing failed [table=").$(this.tableToken).$(", error=").$(th).I$();
                    throw th;
                }
                this.txWriter.removeAttachedPartitions(sourcePartition);
                this.columnVersionWriter.squashPartition(targetPartition, sourcePartition);
                this.partitionRemoveCandidates.add(sourcePartition, sourceNameTxn);
                if (sourcePartition != this.minSplitPartitionTimestamp) continue;
                this.minSplitPartitionTimestamp = this.getPartitionTimestampOrMax(targetPartitionIndex + 1);
            }
            this.txWriter.updatePartitionSizeByTimestamp(targetPartition, targetFrame.getRowCount());
            if (lastPartitionSquashed) {
                long newTransientRowCount = targetFrame.getRowCount() - (long)this.txWriter.getLagRowCount();
                assert (newTransientRowCount >= 0L);
                this.txWriter.fixedRowCount += this.txWriter.getTransientRowCount() - newTransientRowCount;
                assert (this.txWriter.fixedRowCount >= 0L);
                this.txWriter.transientRowCount = newTransientRowCount;
            }
        }
        finally {
            Misc.free(targetFrame);
            this.path.trimTo(this.pathSize);
            this.other.trimTo(this.pathSize);
        }
        if (lastPartitionSquashed) {
            this.openLastPartition();
        }
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.commit(this.denseSymbolMapWriters);
    }

    private int squashSplitPartitions_findPartitionIndexAtOrGreaterTimestamp(long timestampMax) {
        int partitionIndex = this.txWriter.findAttachedPartitionIndexByLoTimestamp(timestampMax);
        if (partitionIndex < 0) {
            return -partitionIndex - 1;
        }
        return partitionIndex;
    }

    private void swapO3ColumnsExcept(int timestampIndex) {
        ObjList<MemoryCARW> temp = this.o3MemColumns1;
        this.o3MemColumns1 = this.o3MemColumns2;
        this.o3MemColumns2 = temp;
        int timestampMemoryIndex = TableWriter.getPrimaryColumnIndex(timestampIndex);
        this.o3MemColumns2.setQuick(timestampMemoryIndex, this.o3MemColumns1.getAndSetQuick(timestampMemoryIndex, this.o3MemColumns2.getQuick(timestampMemoryIndex)));
        this.o3Columns = this.o3MemColumns1;
        this.activeColumns = this.o3MemColumns1;
        ObjList<Runnable> tempNullSetters = this.o3NullSetters1;
        this.o3NullSetters1 = this.o3NullSetters2;
        this.o3NullSetters2 = tempNullSetters;
        this.activeNullSetters = this.o3NullSetters1;
    }

    private long swapTimestampInMemCols(int timestampIndex) {
        MemoryCARW tsMem1 = this.o3MemColumns1.get(TableWriter.getPrimaryColumnIndex(timestampIndex));
        MemoryCARW tsMem2 = this.o3MemColumns2.get(TableWriter.getPrimaryColumnIndex(timestampIndex));
        this.o3MemColumns1.set(TableWriter.getPrimaryColumnIndex(timestampIndex), tsMem2);
        this.o3TimestampMem = tsMem2;
        this.o3MemColumns2.set(TableWriter.getPrimaryColumnIndex(timestampIndex), tsMem1);
        this.o3TimestampMemCpy = tsMem1;
        long timestampAddr = this.o3TimestampMem.getAddress();
        return timestampAddr;
    }

    private void switchPartition(long timestamp) {
        this.updateIndexes();
        this.txWriter.switchPartitions(timestamp);
        this.openPartition(timestamp, 0L);
        this.setAppendPosition(0L, false);
    }

    private void syncColumns() {
        int commitMode = this.configuration.getCommitMode();
        if (commitMode != 2) {
            int i;
            boolean async = commitMode == 0;
            this.syncColumns0(async);
            int n = this.denseIndexers.size();
            for (i = 0; i < n; ++i) {
                this.denseIndexers.getQuick(i).sync(async);
            }
            n = this.denseSymbolMapWriters.size();
            for (i = 0; i < n; ++i) {
                this.denseSymbolMapWriters.getQuick(i).sync(async);
            }
        }
    }

    private void syncColumns0(boolean async) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.columns.getQuick(i * 2).sync(async);
            MemoryMA m2 = this.columns.getQuick(i * 2 + 1);
            if (m2 == null) continue;
            m2.sync(async);
        }
    }

    private void throwApplyBlockColumnShuffleFailed(int columnIndex, int columnType, long totalRows, long rowCount) {
        LOG.error().$("wal block apply failed [table=").$(this.tableToken).$(", column=").$safe(this.metadata.getColumnName(columnIndex)).$(", columnType=").$(ColumnType.nameOf(columnType)).$(", expectedResult=").$(totalRows).$(", actualResult=").$(rowCount).I$();
        if (this.configuration.getDebugWalApplyBlockFailureNoRetry()) {
            throw new IllegalStateException("apply block failed");
        }
        throw CairoException.txnApplyBlockError(this.tableToken);
    }

    private void throwDistressException(Throwable cause) {
        try {
            Sinkable sinkable = (Sinkable)((Object)cause);
            LOG.critical().$("writer error [table=").$(this.tableToken).$(", e=").$(sinkable).I$();
        }
        catch (Throwable th) {
            LOG.critical().$("writer error [table=").$(this.tableToken).$(", e=").$(cause).I$();
        }
        this.distressed = true;
        throw new CairoError(cause);
    }

    private void truncate(boolean keepSymbolTables) {
        this.rollback();
        if (!keepSymbolTables) {
            int n = this.denseSymbolMapWriters.size();
            for (int i = 0; i < n; ++i) {
                this.denseSymbolMapWriters.getQuick(i).truncate();
            }
        }
        if (this.size() == 0L) {
            return;
        }
        this.todoMem.putLong(0L, ++this.todoTxn);
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
        this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(24L, this.todoTxn);
        this.todoMem.putLong(32L, 1L);
        this.todoMem.putLong(40L, 1L);
        this.todoMem.jumpTo(48L);
        if (this.partitionBy != 3) {
            this.freeColumns(false);
            this.releaseIndexerWriters();
            this.scheduleRemoveAllPartitions();
            this.rowAction = 0;
        } else {
            this.truncateColumns();
        }
        this.txWriter.resetTimestamp();
        this.columnVersionWriter.truncate();
        this.txWriter.truncate(this.columnVersionWriter.getVersion(), this.denseSymbolMapWriters);
        try {
            this.clearTodoLog();
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        this.minSplitPartitionTimestamp = Long.MAX_VALUE;
        this.processPartitionRemoveCandidates();
        LOG.info().$("truncated [name=").$safe(this.tableToken.getTableName()).I$();
        try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
            metadataRW.hydrateTable(this.metadata);
        }
    }

    private void truncateColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            int columnType = this.metadata.getColumnType(i);
            if (columnType < 0) continue;
            this.getPrimaryColumn(i).truncate();
            if (!ColumnType.isVarSize(columnType)) continue;
            MemoryMA auxMem = this.getSecondaryColumn(i);
            auxMem.truncate();
            ColumnType.getDriver(columnType).configureAuxMemMA(auxMem);
        }
    }

    private void updateIndexes() {
        if (this.indexCount == 0 || this.avoidIndexOnCommit) {
            this.avoidIndexOnCommit = false;
            return;
        }
        this.updateIndexesSlow();
    }

    private void updateIndexesParallel(long lo, long hi) {
        int i;
        this.indexSequences.clear();
        this.indexLatch.setCount(this.indexCount);
        int nParallelIndexes = this.indexCount - 1;
        MPSequence indexPubSequence = this.messageBus.getIndexerPubSequence();
        RingQueue<ColumnIndexerTask> indexerQueue = this.messageBus.getIndexerQueue();
        LOG.info().$("parallel indexing [table=").$safe(this.tableToken.getTableName()).$(", indexCount=").$(this.indexCount).$(", rowCount=").$(hi - lo).I$();
        int serialIndexCount = 0;
        block0: for (i = 0; i < nParallelIndexes; ++i) {
            long cursor = indexPubSequence.next();
            if (cursor == -1L) {
                TableWriter.indexAndCountDown(this.denseIndexers.getQuick(i), lo, hi, this.indexLatch);
                ++serialIndexCount;
                continue;
            }
            if (cursor == -2L) {
                do {
                    Os.pause();
                    cursor = indexPubSequence.next();
                    if (cursor != -1L) continue;
                    TableWriter.indexAndCountDown(this.denseIndexers.getQuick(i), lo, hi, this.indexLatch);
                    ++serialIndexCount;
                    continue block0;
                } while (cursor < 0L);
            }
            ColumnIndexerTask queueItem = indexerQueue.get(cursor);
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            long sequence = indexer.getSequence();
            queueItem.indexer = indexer;
            queueItem.lo = lo;
            queueItem.hi = hi;
            queueItem.countDownLatch = this.indexLatch;
            queueItem.sequence = sequence;
            this.indexSequences.add(sequence);
            indexPubSequence.done(cursor);
        }
        TableWriter.indexAndCountDown(this.denseIndexers.getQuick(this.indexCount - 1), lo, hi, this.indexLatch);
        ++serialIndexCount;
        if (!this.indexLatch.await(this.configuration.getWorkStealTimeoutNanos())) {
            for (i = 0; i < nParallelIndexes; ++i) {
                ColumnIndexer indexer = this.denseIndexers.getQuick(i);
                if (!indexer.tryLock(this.indexSequences.getQuick(i))) continue;
                TableWriter.indexAndCountDown(indexer, lo, hi, this.indexLatch);
                ++serialIndexCount;
            }
            this.indexLatch.await();
        }
        boolean distressed = false;
        for (int i2 = 0; i2 < this.indexCount; ++i2) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i2);
            distressed |= indexer.isDistressed();
        }
        if (distressed) {
            this.throwDistressException(null);
        }
        LOG.info().$("parallel indexing done [serialCount=").$(serialIndexCount).I$();
    }

    private void updateIndexesSerially(long lo, long hi) {
        LOG.debug().$("serial indexing [table=").$safe(this.tableToken.getTableName()).$(", indexCount=").$(this.indexCount).$(", rowCount=").$(hi - lo).I$();
        int n = this.denseIndexers.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.denseIndexers.getQuick(i).refreshSourceAndIndex(lo, hi);
                continue;
            }
            catch (CairoException e) {
                this.throwDistressException(e);
            }
        }
        LOG.debug().$("serial indexing done [table=").$safe(this.tableToken.getTableName()).I$();
    }

    private void updateIndexesSlow() {
        long lo;
        long hi = this.txWriter.getTransientRowCount();
        long l = lo = this.txWriter.getAppendedPartitionCount() == 1 ? hi - this.txWriter.getLastTxSize() : 0L;
        if (this.indexCount > 1 && this.parallelIndexerEnabled && hi - lo > (long)this.configuration.getParallelIndexThreshold()) {
            this.updateIndexesParallel(lo, hi);
        } else {
            this.updateIndexesSerially(lo, hi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMatViewDefinition(MatViewDefinition newDefinition) {
        if (this.blockFileWriter == null) {
            this.blockFileWriter = new BlockFileWriter(this.ff, this.configuration.getCommitMode());
        }
        try (BlockFileWriter definitionWriter = this.blockFileWriter;){
            definitionWriter.of(this.path.concat("_mv").$());
            MatViewDefinition.append(newDefinition, definitionWriter);
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
        this.engine.getMatViewGraph().updateViewDefinition(this.tableToken, newDefinition);
        this.engine.getMatViewStateStore().updateViewDefinition(this.tableToken, newDefinition);
    }

    private void updateMaxTimestamp(long timestamp) {
        this.txWriter.updateMaxTimestamp(timestamp);
        this.timestampSetter.accept(timestamp);
    }

    private void updateO3ColumnTops() {
        int columnCount = this.metadata.getColumnCount();
        long blockIndex = -1L;
        while ((blockIndex = this.o3PartitionUpdateSink.nextBlockIndex(blockIndex)) > -1L) {
            long blockAddress = this.o3PartitionUpdateSink.getBlockAddress(blockIndex);
            long partitionTimestamp = Unsafe.getUnsafe().getLong(blockAddress);
            long o3SplitPartitionSize = Unsafe.getUnsafe().getLong(blockAddress + 40L);
            long dataPartitionTimestamp = Unsafe.getUnsafe().getLong(blockAddress + 48L);
            if (o3SplitPartitionSize > 0L) {
                this.columnVersionWriter.copyColumnVersions(dataPartitionTimestamp, partitionTimestamp);
            }
            if (partitionTimestamp <= -1L) continue;
            blockAddress += 64L;
            for (int column = 0; column < columnCount; ++column) {
                long colTop = Unsafe.getUnsafe().getLong(blockAddress);
                blockAddress += 8L;
                if (colTop > -1L) {
                    this.columnVersionWriter.upsertColumnTop(partitionTimestamp, column, colTop);
                    continue;
                }
                if (o3SplitPartitionSize <= 0L) continue;
                this.columnVersionWriter.removeColumnTop(partitionTimestamp, column);
            }
        }
    }

    private void validateSwapMeta() {
        try {
            try {
                long len;
                this.path.concat("_meta.swp");
                if (this.metaSwapIndex > 0) {
                    this.path.put('.').put(this.metaSwapIndex);
                }
                if ((len = this.ff.length(this.path.$())) < 1L) {
                    throw CairoException.critical(this.ff.errno()).put("cannot swap metadata file, invalid size: ").put(this.path);
                }
                this.ddlMem.of(this.ff, this.path.$(), this.ff.getPageSize(), len, 12, 0, Files.POSIX_MADV_RANDOM);
                this.validationMap.clear();
                TableUtils.validateMeta(this.ddlMem, this.validationMap, 426);
            }
            finally {
                this.ddlMem.close(false);
                this.path.trimTo(this.pathSize);
            }
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_META_RENAME_FAILURE, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex(@NotNull CharSequence columnName, int indexValueBlockSize, int columnIndex, SymbolColumnIndexer indexer) {
        long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(this.txWriter.getLastPartitionTimestamp(), columnIndex);
        try {
            try {
                if (PartitionBy.isPartitioned(this.partitionBy)) {
                    this.indexHistoricPartitions(indexer, columnName, indexValueBlockSize, columnIndex);
                    long timestamp = this.txWriter.getLastPartitionTimestamp();
                    if (timestamp != Long.MIN_VALUE) {
                        this.path.trimTo(this.pathSize);
                        this.setStateForTimestamp(this.path, timestamp);
                        this.indexLastPartition(indexer, columnName, columnNameTxn, columnIndex, indexValueBlockSize);
                    }
                } else {
                    this.setStateForTimestamp(this.path, 0L);
                    this.indexLastPartition(indexer, columnName, columnNameTxn, columnIndex, indexValueBlockSize);
                }
            }
            finally {
                this.path.trimTo(this.pathSize);
            }
        }
        catch (Throwable th) {
            Misc.free(indexer);
            LOG.error().$("rolling back index created so far [path=").$substr(this.pathRootSize, this.path).I$();
            this.rollbackRemoveIndexFiles(columnName, columnIndex);
            throw th;
        }
    }

    private void writeMetadataToDisk() {
        this.rewriteAndSwapMetadata(this.metadata);
        this.clearTodoAndCommitMeta();
        try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
            metadataRW.hydrateTable(this.metadata);
        }
    }

    private void writeRestoreMetaTodo() {
        try {
            this.todoMem.putLong(0L, ++this.todoTxn);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
            this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(32L, 1L);
            this.todoMem.putLong(40L, 2L);
            this.todoMem.putLong(48L, this.metaPrevIndex);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(24L, this.todoTxn);
            this.todoMem.jumpTo(56L);
            this.todoMem.sync(false);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_TODO_WRITE_FAILURE, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void indexAndCountDown(ColumnIndexer indexer, long lo, long hi, SOCountDownLatch latch) {
        try {
            indexer.refreshSourceAndIndex(lo, hi);
        }
        catch (CairoException e) {
            indexer.distress();
            LOG.critical().$("index error [fd=").$(indexer.getFd()).$("]{").$(e).$('}').$();
        }
        finally {
            latch.countDown();
        }
    }

    boolean allowMixedIO() {
        return this.mixedIOFlag;
    }

    boolean checkDedupCommitIdenticalToPartition(long partitionTimestamp, long partitionNameTxn, long partitionRowCount, long partitionLo, long partitionHi, long commitLo, long commitHi, long mergeIndexAddr, long mergeIndexRows) {
        TableMetadata metadata = this.getMetadata();
        FrameFactory frameFactory = this.engine.getFrameFactory();
        try (Frame partitionFrame = frameFactory.openRO(this.path, partitionTimestamp, partitionNameTxn, this.partitionBy, metadata, this.columnVersionWriter, partitionRowCount);
             Frame commitFrame = this.engine.getFrameFactory().openROFromMemoryColumns(this.o3Columns, this.metadata, this.commitRowCount);){
            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                if (metadata.isDedupKey(i) || FrameAlgebra.isColumnReplaceIdentical(i, partitionFrame, partitionLo, partitionHi + 1L, commitFrame, commitLo, commitHi + 1L, mergeIndexAddr, mergeIndexRows)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean checkReplaceCommitIdenticalToPartition(long partitionTimestamp, long partitionNameTxn, long partitionRowCount, long partitionLo, long partitionHi, long commitLo, long commitHi) {
        TableMetadata metadata = this.getMetadata();
        FrameFactory frameFactory = this.engine.getFrameFactory();
        try (Frame partitionFrame = frameFactory.openRO(this.path, partitionTimestamp, partitionNameTxn, this.partitionBy, metadata, this.columnVersionWriter, partitionRowCount);
             Frame commitFrame = this.engine.getFrameFactory().openROFromMemoryColumns(this.o3Columns, this.metadata, this.commitRowCount);){
            int i = 0;
            while (i < metadata.getColumnCount()) {
                if (i != metadata.getTimestampIndex()) {
                    if (!FrameAlgebra.isColumnReplaceIdentical(i, partitionFrame, partitionLo, partitionHi + 1L, commitFrame, commitLo, commitHi + 1L, 0L, commitHi + 1L - commitLo)) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (!FrameAlgebra.isDesignatedTimestampColumnReplaceIdentical(i, partitionFrame, partitionLo, partitionHi + 1L, commitFrame, commitLo, commitHi + 1L)) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            return true;
        }
    }

    void closeActivePartition(long size) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.setColumnAppendPosition(i, size, false);
            Misc.free(this.getPrimaryColumn(i));
            Misc.free(this.getSecondaryColumn(i));
        }
        this.releaseIndexerWriters();
    }

    BitmapIndexWriter getBitmapIndexWriter(int columnIndex) {
        return this.indexers.getQuick(columnIndex).getWriter();
    }

    long getColumnTop(int columnIndex) {
        assert (this.lastOpenPartitionTs != Long.MIN_VALUE);
        return this.columnVersionWriter.getColumnTopQuick(this.lastOpenPartitionTs, columnIndex);
    }

    ColumnVersionReader getColumnVersionReader() {
        return this.columnVersionWriter;
    }

    CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    Sequence getO3CopyPubSeq() {
        return this.messageBus.getO3CopyPubSeq();
    }

    RingQueue<O3CopyTask> getO3CopyQueue() {
        return this.messageBus.getO3CopyQueue();
    }

    Sequence getO3OpenColumnPubSeq() {
        return this.messageBus.getO3OpenColumnPubSeq();
    }

    RingQueue<O3OpenColumnTask> getO3OpenColumnQueue() {
        return this.messageBus.getO3OpenColumnQueue();
    }

    long getPartitionNameTxnByRawIndex(int index) {
        return this.txWriter.getPartitionNameTxnByRawIndex(index);
    }

    long getPartitionSizeByRawIndex(int index) {
        return this.txWriter.getPartitionSizeByRawIndex(index);
    }

    TxReader getTxReader() {
        return this.txWriter;
    }

    void o3ClockDownPartitionUpdateCount() {
        this.o3PartitionUpdRemaining.decrementAndGet();
    }

    void o3CountDownDoneLatch() {
        this.o3DoneLatch.countDown();
    }

    void purgeUnusedPartitions() {
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            this.removeNonAttachedPartitions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rowCancel() {
        if ((this.masterRef & 1L) == 0L) {
            return;
        }
        if (this.hasO3()) {
            long o3RowCount = this.getO3RowCount0();
            if (o3RowCount > 0L) {
                --this.masterRef;
                this.setO3AppendPosition(o3RowCount);
            } else {
                this.setO3AppendPosition(0L);
                --this.masterRef;
                this.clearO3();
            }
            this.rowValueIsNotNull.fill(0, this.columnCount, this.masterRef);
            return;
        }
        long dirtyMaxTimestamp = this.txWriter.getMaxTimestamp();
        long dirtyTransientRowCount = this.txWriter.getTransientRowCount();
        long rollbackToMaxTimestamp = this.txWriter.cancelToMaxTimestamp();
        long rollbackToTransientRowCount = this.txWriter.cancelToTransientRowCount();
        if (dirtyTransientRowCount == 1L) {
            if (PartitionBy.isPartitioned(this.partitionBy)) {
                this.closeActivePartition(false);
                if (this.removeDirOnCancelRow) {
                    try {
                        this.setStateForTimestamp(this.path, this.txWriter.getPartitionTimestampByTimestamp(dirtyMaxTimestamp));
                        if (!this.ff.rmdir(this.path)) {
                            throw CairoException.critical(this.ff.errno()).put("could not remove directory: ").put(this.path);
                        }
                        this.removeDirOnCancelRow = false;
                    }
                    finally {
                        this.path.trimTo(this.pathSize);
                    }
                }
                if (rollbackToMaxTimestamp > Long.MIN_VALUE) {
                    try {
                        this.txWriter.setMaxTimestamp(rollbackToMaxTimestamp);
                        this.openPartition(rollbackToMaxTimestamp, rollbackToTransientRowCount);
                        this.setAppendPosition(rollbackToTransientRowCount, false);
                    }
                    catch (Throwable e) {
                        this.freeColumns(false);
                        throw e;
                    }
                } else {
                    this.txWriter.removeAllPartitions();
                    this.rowAction = 0;
                }
                this.removeDirOnCancelRow = true;
                this.txWriter.cancelRow();
            } else {
                this.txWriter.cancelRow();
                this.truncateColumns();
            }
        } else {
            boolean rowChanged;
            this.txWriter.cancelRow();
            boolean bl = rowChanged = this.metadata.getTimestampIndex() >= 0;
            if (!rowChanged) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.rowValueIsNotNull.getQuick(i) != this.masterRef) continue;
                    rowChanged = true;
                    break;
                }
            }
            if (rowChanged) {
                this.setAppendPosition(dirtyTransientRowCount - 1L, false);
            }
        }
        this.rowValueIsNotNull.fill(0, this.columnCount, --this.masterRef);
        if (this.txWriter.transientRowCount > 0L) {
            --this.txWriter.transientRowCount;
        }
    }

    @FunctionalInterface
    private static interface FragileCode {
        public void run();
    }

    private class RowImpl
    implements Row {
        private RowImpl() {
        }

        @Override
        public void append() {
            TableWriter.this.rowAppend(TableWriter.this.activeNullSetters);
        }

        @Override
        public void cancel() {
            TableWriter.this.rowCancel();
        }

        @Override
        public void putArray(int columnIndex, @NotNull ArrayView array) {
            ArrayTypeDriver.appendValue(this.getSecondaryColumn(columnIndex), this.getPrimaryColumn(columnIndex), array);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBin(int columnIndex, long address, long len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(address, len));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBin(int columnIndex, BinarySequence sequence) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(sequence));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBool(int columnIndex, boolean value) {
            this.getPrimaryColumn(columnIndex).putBool(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putByte(int columnIndex, byte value) {
            this.getPrimaryColumn(columnIndex).putByte(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putChar(int columnIndex, char value) {
            this.getPrimaryColumn(columnIndex).putChar(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putDate(int columnIndex, long value) {
            this.putLong(columnIndex, value);
        }

        @Override
        public void putDouble(int columnIndex, double value) {
            this.getPrimaryColumn(columnIndex).putDouble(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putFloat(int columnIndex, float value) {
            this.getPrimaryColumn(columnIndex).putFloat(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putGeoHash(int columnIndex, long value) {
            int type = TableWriter.this.metadata.getColumnType(columnIndex);
            WriterRowUtils.putGeoHash(columnIndex, value, type, this);
        }

        @Override
        public void putGeoHashDeg(int columnIndex, double lat, double lon) {
            int type = TableWriter.this.metadata.getColumnType(columnIndex);
            WriterRowUtils.putGeoHash(columnIndex, GeoHashes.fromCoordinatesDegUnsafe(lat, lon, ColumnType.getGeoHashBits(type)), type, this);
        }

        @Override
        public void putGeoStr(int columnIndex, CharSequence hash) {
            int type = TableWriter.this.metadata.getColumnType(columnIndex);
            WriterRowUtils.putGeoStr(columnIndex, hash, type, this);
        }

        @Override
        public void putGeoVarchar(int columnIndex, Utf8Sequence hash) {
            int type = TableWriter.this.metadata.getColumnType(columnIndex);
            WriterRowUtils.putGeoVarchar(columnIndex, hash, type, this);
        }

        @Override
        public void putIPv4(int columnIndex, int value) {
            this.putInt(columnIndex, value);
        }

        @Override
        public void putInt(int columnIndex, int value) {
            this.getPrimaryColumn(columnIndex).putInt(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong(int columnIndex, long value) {
            this.getPrimaryColumn(columnIndex).putLong(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong128(int columnIndex, long lo, long hi) {
            MemoryA primaryColumn = this.getPrimaryColumn(columnIndex);
            primaryColumn.putLong(lo);
            primaryColumn.putLong(hi);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, long l0, long l1, long l2, long l3) {
            this.getPrimaryColumn(columnIndex).putLong256(l0, l1, l2, l3);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, Long256 value) {
            this.getPrimaryColumn(columnIndex).putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, CharSequence hexString) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, @NotNull CharSequence hexString, int start, int end) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString, start, end);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256Utf8(int columnIndex, DirectUtf8Sequence hexString) {
            this.getPrimaryColumn(columnIndex).putLong256Utf8(hexString);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putShort(int columnIndex, short value) {
            this.getPrimaryColumn(columnIndex).putShort(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, char value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value, int pos, int len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value, pos, len));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStrUtf8(int columnIndex, DirectUtf8Sequence value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStrUtf8(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSym(int columnIndex, CharSequence value) {
            this.getPrimaryColumn(columnIndex).putInt(TableWriter.this.symbolMapWriters.getQuick(columnIndex).put(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSym(int columnIndex, char value) {
            this.getPrimaryColumn(columnIndex).putInt(TableWriter.this.symbolMapWriters.getQuick(columnIndex).put(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSymIndex(int columnIndex, int key) {
            this.putInt(columnIndex, key);
        }

        @Override
        public void putSymUtf8(int columnIndex, DirectUtf8Sequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putTimestamp(int columnIndex, long value) {
            this.putLong(columnIndex, value);
        }

        @Override
        public void putUuid(int columnIndex, CharSequence uuidStr) {
            SqlUtil.implicitCastStrAsUuid(uuidStr, TableWriter.this.uuid);
            this.putLong128(columnIndex, TableWriter.this.uuid.getLo(), TableWriter.this.uuid.getHi());
        }

        @Override
        public void putUuidUtf8(int columnIndex, Utf8Sequence uuidStr) {
            SqlUtil.implicitCastStrAsUuid(uuidStr, TableWriter.this.uuid);
            this.putLong128(columnIndex, TableWriter.this.uuid.getLo(), TableWriter.this.uuid.getHi());
        }

        @Override
        public void putVarchar(int columnIndex, char value) {
            TableWriter.this.utf8Sink.clear();
            TableWriter.this.utf8Sink.put(value);
            VarcharTypeDriver.appendValue(this.getSecondaryColumn(columnIndex), this.getPrimaryColumn(columnIndex), TableWriter.this.utf8Sink);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putVarchar(int columnIndex, Utf8Sequence value) {
            VarcharTypeDriver.appendValue(this.getSecondaryColumn(columnIndex), this.getPrimaryColumn(columnIndex), value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        private MemoryA getPrimaryColumn(int columnIndex) {
            return TableWriter.this.activeColumns.getQuick(TableWriter.getPrimaryColumnIndex(columnIndex));
        }

        private MemoryA getSecondaryColumn(int columnIndex) {
            return TableWriter.this.activeColumns.getQuick(TableWriter.getSecondaryColumnIndex(columnIndex));
        }
    }

    public static interface Row {
        public void append();

        public void cancel();

        public void putArray(int var1, @NotNull ArrayView var2);

        public void putBin(int var1, long var2, long var4);

        public void putBin(int var1, BinarySequence var2);

        public void putBool(int var1, boolean var2);

        public void putByte(int var1, byte var2);

        public void putChar(int var1, char var2);

        public void putDate(int var1, long var2);

        public void putDouble(int var1, double var2);

        public void putFloat(int var1, float var2);

        public void putGeoHash(int var1, long var2);

        public void putGeoHashDeg(int var1, double var2, double var4);

        public void putGeoStr(int var1, CharSequence var2);

        public void putGeoVarchar(int var1, Utf8Sequence var2);

        public void putIPv4(int var1, int var2);

        public void putInt(int var1, int var2);

        public void putLong(int var1, long var2);

        public void putLong128(int var1, long var2, long var4);

        public void putLong256(int var1, long var2, long var4, long var6, long var8);

        public void putLong256(int var1, Long256 var2);

        public void putLong256(int var1, CharSequence var2);

        public void putLong256(int var1, @NotNull CharSequence var2, int var3, int var4);

        public void putLong256Utf8(int var1, DirectUtf8Sequence var2);

        public void putShort(int var1, short var2);

        public void putStr(int var1, CharSequence var2);

        public void putStr(int var1, char var2);

        public void putStr(int var1, CharSequence var2, int var3, int var4);

        public void putStrUtf8(int var1, DirectUtf8Sequence var2);

        public void putSym(int var1, CharSequence var2);

        public void putSym(int var1, char var2);

        public void putSymIndex(int var1, int var2);

        public void putSymUtf8(int var1, DirectUtf8Sequence var2);

        public void putTimestamp(int var1, long var2);

        public void putUuid(int var1, CharSequence var2);

        public void putUuidUtf8(int var1, Utf8Sequence var2);

        public void putVarchar(int var1, char var2);

        public void putVarchar(int var1, Utf8Sequence var2);
    }

    @FunctionalInterface
    public static interface ColumnTaskHandler {
        public void run(int var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13);
    }

    @FunctionalInterface
    public static interface ExtensionListener {
        public void onTableExtended(long var1);
    }

    private static class NoOpRow
    implements Row {
        private NoOpRow() {
        }

        @Override
        public void append() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void putArray(int columnIndex, @NotNull ArrayView array) {
        }

        @Override
        public void putBin(int columnIndex, long address, long len) {
        }

        @Override
        public void putBin(int columnIndex, BinarySequence sequence) {
        }

        @Override
        public void putBool(int columnIndex, boolean value) {
        }

        @Override
        public void putByte(int columnIndex, byte value) {
        }

        @Override
        public void putChar(int columnIndex, char value) {
        }

        @Override
        public void putDate(int columnIndex, long value) {
        }

        @Override
        public void putDouble(int columnIndex, double value) {
        }

        @Override
        public void putFloat(int columnIndex, float value) {
        }

        @Override
        public void putGeoHash(int columnIndex, long value) {
        }

        @Override
        public void putGeoHashDeg(int index, double lat, double lon) {
        }

        @Override
        public void putGeoStr(int columnIndex, CharSequence value) {
        }

        @Override
        public void putGeoVarchar(int columnIndex, Utf8Sequence value) {
        }

        @Override
        public void putIPv4(int columnIndex, int value) {
        }

        @Override
        public void putInt(int columnIndex, int value) {
        }

        @Override
        public void putLong(int columnIndex, long value) {
        }

        @Override
        public void putLong128(int columnIndex, long lo, long hi) {
        }

        @Override
        public void putLong256(int columnIndex, long l0, long l1, long l2, long l3) {
        }

        @Override
        public void putLong256(int columnIndex, Long256 value) {
        }

        @Override
        public void putLong256(int columnIndex, CharSequence hexString) {
        }

        @Override
        public void putLong256(int columnIndex, @NotNull CharSequence hexString, int start, int end) {
        }

        @Override
        public void putLong256Utf8(int columnIndex, DirectUtf8Sequence hexString) {
        }

        @Override
        public void putShort(int columnIndex, short value) {
        }

        @Override
        public void putStr(int columnIndex, CharSequence value) {
        }

        @Override
        public void putStr(int columnIndex, char value) {
        }

        @Override
        public void putStr(int columnIndex, CharSequence value, int pos, int len) {
        }

        @Override
        public void putStrUtf8(int columnIndex, DirectUtf8Sequence value) {
        }

        @Override
        public void putSym(int columnIndex, CharSequence value) {
        }

        @Override
        public void putSym(int columnIndex, char value) {
        }

        @Override
        public void putSymIndex(int columnIndex, int key) {
        }

        @Override
        public void putSymUtf8(int columnIndex, DirectUtf8Sequence value) {
        }

        @Override
        public void putTimestamp(int columnIndex, long value) {
        }

        @Override
        public void putUuid(int columnIndex, CharSequence uuid) {
        }

        @Override
        public void putUuidUtf8(int columnIndex, Utf8Sequence uuid) {
        }

        @Override
        public void putVarchar(int columnIndex, char value) {
        }

        @Override
        public void putVarchar(int columnIndex, Utf8Sequence value) {
        }
    }
}

