/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.Metrics;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ErrorTag;
import io.questdb.cairo.wal.TableWriterPressureControl;
import io.questdb.cairo.wal.seq.TableWriterPressureControlImpl;
import io.questdb.std.Unsafe;

public class SeqTxnTracker {
    public static final long UNINITIALIZED_TXN = -1L;
    private static final long SEQ_TXN_OFFSET = Unsafe.getFieldOffset(SeqTxnTracker.class, "seqTxn");
    private static final long SUSPENDED_STATE_OFFSET = Unsafe.getFieldOffset(SeqTxnTracker.class, "suspendedState");
    private static final long WRITER_TXN_OFFSET = Unsafe.getFieldOffset(SeqTxnTracker.class, "writerTxn");
    private final Metrics metrics;
    private final TableWriterPressureControlImpl pressureControl;
    private volatile long dirtyWriterTxn;
    private boolean dropped;
    private volatile String errorMessage = "";
    private volatile ErrorTag errorTag = ErrorTag.NONE;
    private volatile long seqTxn = -1L;
    private volatile int suspendedState = 0;
    private volatile long writerTxn = -1L;

    public SeqTxnTracker(CairoConfiguration configuration) {
        this.pressureControl = new TableWriterPressureControlImpl(configuration);
        this.metrics = configuration.getMetrics();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ErrorTag getErrorTag() {
        return this.errorTag;
    }

    public long getLagTxnCount() {
        return Math.max(0L, this.dirtyWriterTxn - this.writerTxn);
    }

    public TableWriterPressureControl getMemPressureControl() {
        return this.pressureControl;
    }

    public long getSeqTxn() {
        return this.seqTxn;
    }

    public long getWriterTxn() {
        return this.writerTxn;
    }

    public boolean initTxns(long newWriterTxn, long newSeqTxn, boolean isSuspended) {
        if (Unsafe.cas((Object)this, SUSPENDED_STATE_OFFSET, 0, isSuspended ? -1 : 1) && isSuspended) {
            this.metrics.tableWriterMetrics().incSuspendedTables();
        }
        long stxn = this.seqTxn;
        while (stxn < newSeqTxn && !Unsafe.cas((Object)this, SEQ_TXN_OFFSET, stxn, newSeqTxn)) {
            stxn = this.seqTxn;
        }
        this.metrics.walMetrics().addSeqTxn(newSeqTxn - Math.max(0L, stxn));
        long wtxn = this.writerTxn;
        while (newWriterTxn > wtxn && !Unsafe.cas((Object)this, WRITER_TXN_OFFSET, wtxn, newWriterTxn)) {
            wtxn = this.writerTxn;
        }
        this.metrics.walMetrics().addWriterTxn(newWriterTxn - Math.max(0L, wtxn));
        return this.seqTxn > 0L && this.seqTxn > this.writerTxn;
    }

    public boolean isInitialised() {
        return this.writerTxn != -1L;
    }

    public boolean isSuspended() {
        return this.suspendedState < 0;
    }

    public boolean notifyOnCheck(long newSeqTxn) {
        long stxn = this.seqTxn;
        while (newSeqTxn > stxn && !Unsafe.cas((Object)this, SEQ_TXN_OFFSET, stxn, newSeqTxn)) {
            stxn = this.seqTxn;
        }
        return this.writerTxn < this.seqTxn && this.suspendedState > 0 && this.pressureControl.isReadyToProcess();
    }

    public boolean notifyOnCommit(long newSeqTxn) {
        long stxn = this.seqTxn;
        while (newSeqTxn > stxn) {
            if (Unsafe.cas((Object)this, SEQ_TXN_OFFSET, stxn, newSeqTxn)) {
                this.metrics.walMetrics().addSeqTxn(newSeqTxn - stxn);
                break;
            }
            stxn = this.seqTxn;
        }
        return (stxn < 1L || this.writerTxn == newSeqTxn - 1L) && this.suspendedState >= 0;
    }

    public synchronized void notifyOnDrop() {
        if (this.dropped) {
            return;
        }
        this.dropped = true;
        this.metrics.walMetrics().addSeqTxn(-this.seqTxn);
        this.metrics.walMetrics().addWriterTxn(-this.writerTxn);
    }

    public void setSuspended(ErrorTag errorTag, String errorMessage) {
        this.errorTag = errorTag;
        this.errorMessage = errorMessage;
        this.suspendedState = -1;
        this.metrics.tableWriterMetrics().incSuspendedTables();
    }

    public void setUnsuspended() {
        this.suspendedState = 1;
        this.errorTag = ErrorTag.NONE;
        this.errorMessage = "";
        this.metrics.tableWriterMetrics().decSuspendedTables();
    }

    public synchronized boolean updateWriterTxns(long writerTxn, long dirtyWriterTxn) {
        if (this.dropped) {
            return false;
        }
        long prevWriterTxn = this.writerTxn;
        long prevDirtyWriterTxn = this.dirtyWriterTxn;
        this.writerTxn = writerTxn;
        this.dirtyWriterTxn = dirtyWriterTxn;
        if (writerTxn > prevWriterTxn) {
            this.suspendedState = 1;
            this.metrics.walMetrics().addWriterTxn(writerTxn - prevWriterTxn);
        } else if (dirtyWriterTxn > prevDirtyWriterTxn) {
            this.suspendedState = 1;
        }
        return writerTxn < this.seqTxn;
    }
}

