/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.array;

import io.questdb.cutlass.line.array.AbstractArray;
import io.questdb.std.Unsafe;

public class DoubleArray
extends AbstractArray {
    public DoubleArray(int ... shape) {
        super(shape, (short)10);
    }

    public DoubleArray append(double value) {
        this.ensureLegalAppendPosition();
        this.memA.putDouble(value);
        return this;
    }

    public DoubleArray set(double value, int ... coords) {
        assert (!this.closed);
        this.array.putDouble(this.toFlatOffset(coords), value);
        return this;
    }

    public DoubleArray setAll(double value) {
        long ptr = this.array.ptr();
        int size = this.array.getFlatViewLength();
        for (int i = 0; i < size; ++i) {
            Unsafe.getUnsafe().putDouble(ptr, value);
            ptr += 8L;
        }
        return this;
    }
}

