/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.wal.MetadataService;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.DirectUtf8SymbolLookup;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.cutlass.line.tcp.SymbolCache;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BitSet;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Pool;
import io.questdb.std.Utf8StringIntHashMap;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableUpdateDetails
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TableUpdateDetails.class);
    private static final DirectUtf8SymbolLookup NOT_FOUND_LOOKUP = value -> -2;
    private final long commitInterval;
    private final boolean commitOnClose;
    private final DefaultColumnTypes defaultColumnTypes;
    private final long defaultMaxUncommittedRows;
    private final CairoEngine engine;
    private final ThreadLocalDetails[] localDetailsArray;
    private final MillisecondClock millisecondClock;
    private final SecurityContext ownSecurityContext;
    private final Utf8String tableNameUtf8;
    private final TableToken tableToken;
    private final int timestampIndex;
    private final long writerTickRowsCountMod;
    protected TableWriterAPI writerAPI;
    private boolean assignedToJob = false;
    private long eventsProcessedSinceReshuffle = 0L;
    private boolean isDropped;
    private long lastMeasurementMillis = Long.MAX_VALUE;
    private long latestKnownMetadataVersion;
    private MetadataService metadataService;
    private int networkIOOwnerCount = 0;
    private long nextCommitTime;
    private volatile boolean writerInError;
    private int writerThreadId;

    public TableUpdateDetails(LineTcpReceiverConfiguration configuration, CairoEngine engine, @Nullable SecurityContext ownSecurityContext, TableWriterAPI writer, int writerThreadId, NetworkIOJob[] netIoJobs, DefaultColumnTypes defaultColumnTypes, Utf8String tableNameUtf8) {
        this.writerThreadId = writerThreadId;
        this.engine = engine;
        this.ownSecurityContext = ownSecurityContext;
        this.defaultColumnTypes = defaultColumnTypes;
        CairoConfiguration cairoConfiguration = engine.getConfiguration();
        this.millisecondClock = cairoConfiguration.getMillisecondClock();
        this.writerTickRowsCountMod = cairoConfiguration.getWriterTickRowsCountMod();
        this.defaultMaxUncommittedRows = cairoConfiguration.getMaxUncommittedRows();
        this.writerAPI = writer;
        this.timestampIndex = writer.getMetadata().getTimestampIndex();
        this.tableToken = writer.getTableToken();
        this.metadataService = writer.supportsMultipleWriters() ? null : (MetadataService)((Object)writer);
        this.commitInterval = configuration.getCommitInterval();
        this.nextCommitTime = this.millisecondClock.getTicks() + this.commitInterval;
        int n = netIoJobs.length;
        this.localDetailsArray = new ThreadLocalDetails[n];
        for (int i = 0; i < n; ++i) {
            this.localDetailsArray[i] = new ThreadLocalDetails(netIoJobs[i].getSymbolCachePool());
        }
        this.tableNameUtf8 = tableNameUtf8;
        this.commitOnClose = true;
    }

    protected TableUpdateDetails(CairoEngine engine, @Nullable SecurityContext ownSecurityContext, TableWriterAPI writer, int writerThreadId, DefaultColumnTypes defaultColumnTypes, Utf8String tableNameUtf8, Pool<SymbolCache> symbolCachePool, long commitInterval, boolean commitOnClose, long maxUncommittedRows) {
        this.writerThreadId = writerThreadId;
        this.engine = engine;
        this.ownSecurityContext = ownSecurityContext;
        this.defaultColumnTypes = defaultColumnTypes;
        this.commitOnClose = commitOnClose;
        CairoConfiguration cairoConfiguration = engine.getConfiguration();
        this.millisecondClock = cairoConfiguration.getMillisecondClock();
        this.writerTickRowsCountMod = cairoConfiguration.getWriterTickRowsCountMod();
        this.defaultMaxUncommittedRows = maxUncommittedRows;
        this.writerAPI = writer;
        this.timestampIndex = writer.getMetadata().getTimestampIndex();
        this.tableToken = writer.getTableToken();
        this.metadataService = writer.supportsMultipleWriters() ? null : (MetadataService)((Object)writer);
        this.commitInterval = commitInterval;
        this.nextCommitTime = this.millisecondClock.getTicks() + this.commitInterval;
        this.localDetailsArray = new ThreadLocalDetails[]{new ThreadLocalDetails(symbolCachePool)};
        this.tableNameUtf8 = tableNameUtf8;
    }

    public void addReference(int workerId) {
        if (!this.isWal()) {
            ++this.networkIOOwnerCount;
            LOG.info().$("network IO thread using table [workerId=").$(workerId).$(", tableName=").$(this.tableToken).$(", nNetworkIoWorkers=").$(this.networkIOOwnerCount).I$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        TableUpdateDetails tableUpdateDetails = this;
        synchronized (tableUpdateDetails) {
            this.closeNoLock();
        }
    }

    public void closeLocals() {
        for (int n = 0; n < this.localDetailsArray.length; ++n) {
            LOG.info().$("closing table parsers [tableName=").$(this.tableToken).$(']').$();
            this.localDetailsArray[n] = Misc.free(this.localDetailsArray[n]);
        }
    }

    public void closeNoLock() {
        if (this.writerThreadId != Integer.MIN_VALUE) {
            LOG.info().$("closing table writer [tableName=").$(this.tableToken).$(']').$();
            this.closeLocals();
            if (this.writerAPI != null) {
                try {
                    if (this.commitOnClose) {
                        this.authorizeCommit();
                        this.writerAPI.commit();
                    }
                }
                catch (CairoException ex) {
                    if (!ex.isTableDropped()) {
                        LOG.error().$("cannot commit writer transaction, rolling back before releasing it [table=").$(this.tableToken).$(",ex=").$(ex).I$();
                    }
                }
                catch (Throwable ex) {
                    LOG.error().$("cannot commit writer transaction, rolling back before releasing it [table=").$(this.tableToken).$(",ex=").$(ex).I$();
                }
                finally {
                    this.writerAPI = Misc.free(this.writerAPI);
                    this.metadataService = null;
                }
            }
            this.writerThreadId = Integer.MIN_VALUE;
        }
    }

    public void commit(boolean withLag) throws CommitFailedException {
        if (this.writerAPI.getUncommittedRowCount() > 0L) {
            try {
                this.authorizeCommit();
                if (withLag) {
                    this.writerAPI.ic();
                } else {
                    this.writerAPI.commit();
                }
            }
            catch (CairoException ex) {
                if (!ex.isTableDropped()) {
                    this.handleCommitException(ex);
                }
                throw CommitFailedException.instance(ex, ex.isTableDropped());
            }
            catch (Throwable ex) {
                this.handleCommitException(ex);
                throw CommitFailedException.instance(ex, false);
            }
        }
        if (this.isWal() && this.tableToken != this.engine.getTableTokenIfExists(this.tableToken.getTableName())) {
            this.setWriterInError();
        }
    }

    public long getEventsProcessedSinceReshuffle() {
        return this.eventsProcessedSinceReshuffle;
    }

    public long getLastMeasurementMillis() {
        return this.lastMeasurementMillis;
    }

    public MillisecondClock getMillisecondClock() {
        return this.millisecondClock;
    }

    public int getNetworkIOOwnerCount() {
        return this.networkIOOwnerCount;
    }

    public String getTableNameUtf16() {
        return this.tableToken.getTableName();
    }

    public Utf8String getTableNameUtf8() {
        return this.tableNameUtf8;
    }

    public TableToken getTableToken() {
        return this.tableToken;
    }

    public int getWriterThreadId() {
        return this.writerThreadId;
    }

    public void incrementEventsProcessedSinceReshuffle() {
        ++this.eventsProcessedSinceReshuffle;
    }

    public boolean isAssignedToJob() {
        return this.assignedToJob;
    }

    public boolean isDropped() {
        return this.isDropped;
    }

    public boolean isWal() {
        return this.tableToken.isWal();
    }

    public boolean isWriterInError() {
        return this.writerInError;
    }

    public void removeReference(int workerId) {
        if (!this.isWal()) {
            --this.networkIOOwnerCount;
            this.localDetailsArray[workerId].clear();
            LOG.info().$("network IO thread released table [workerId=").$(workerId).$(", tableName=").$(this.tableToken).$(", nNetworkIoWorkers=").$(this.networkIOOwnerCount).I$();
        }
    }

    public void rollback() {
        this.writerAPI.rollback();
    }

    public void setAssignedToJob(boolean assignedToJob) {
        this.assignedToJob = assignedToJob;
    }

    public void setIsDropped() {
        this.isDropped = true;
    }

    public void setWriterInError() {
        this.writerInError = true;
    }

    public void tick() {
        if (this.metadataService != null) {
            this.metadataService.tick();
        }
    }

    private void authorizeCommit() {
        if (this.ownSecurityContext != null) {
            this.ownSecurityContext.authorizeInsert(this.tableToken);
        }
    }

    private long getMetaMaxUncommittedRows() {
        if (this.metadataService != null) {
            return this.metadataService.getMetaMaxUncommittedRows();
        }
        return this.defaultMaxUncommittedRows;
    }

    private void handleCommitException(Throwable ex) {
        this.setWriterInError();
        LOG.error().$("could not commit [table=").$(this.tableToken).$(", e=").$(ex).I$();
        try {
            this.writerAPI.rollback();
        }
        catch (Throwable th) {
            LOG.error().$("could not perform emergency rollback [table=").$(this.tableToken).$(", e=").$(th).I$();
        }
    }

    long commitIfIntervalElapsed(long wallClockMillis) throws CommitFailedException {
        if (wallClockMillis < this.nextCommitTime) {
            return this.nextCommitTime;
        }
        if (this.writerAPI != null) {
            long start = this.millisecondClock.getTicks();
            boolean withLag = wallClockMillis - this.lastMeasurementMillis < this.commitInterval;
            LOG.debug().$("time-based commit ").$(withLag ? "with lag " : "").$("[rows=").$(this.writerAPI.getUncommittedRowCount()).$(", table=").$(this.tableToken).I$();
            this.commit(withLag);
            this.nextCommitTime += this.commitInterval + this.millisecondClock.getTicks() - start;
        }
        return this.nextCommitTime;
    }

    void commitIfMaxUncommittedRowsCountReached() throws CommitFailedException {
        long rowsSinceCommit = this.writerAPI.getUncommittedRowCount();
        if (rowsSinceCommit < this.getMetaMaxUncommittedRows()) {
            if ((rowsSinceCommit & this.writerTickRowsCountMod) == 0L) {
                this.tick();
            }
            return;
        }
        this.nextCommitTime = this.millisecondClock.getTicks() + this.commitInterval;
        LOG.debug().$("max-uncommitted-rows commit with lag [rows=").$(this.writerAPI.getUncommittedRowCount()).$(", table=").$(this.tableToken).I$();
        try {
            this.commit(true);
        }
        catch (CommitFailedException ex) {
            throw ex;
        }
        catch (Throwable th) {
            LOG.error().$("could not commit line protocol measurement [tableName=").$(this.writerAPI.getTableToken()).$(", message=").$safe(th.getMessage()).$(th).I$();
            this.writerAPI.rollback();
            throw CommitFailedException.instance(th, false);
        }
        this.tick();
    }

    ThreadLocalDetails getThreadLocalDetails(int workerId) {
        this.lastMeasurementMillis = this.millisecondClock.getTicks();
        return this.localDetailsArray[workerId];
    }

    int getTimestampIndex() {
        return this.timestampIndex;
    }

    TableWriterAPI getWriter() {
        return this.writerAPI;
    }

    void releaseWriter(boolean commit) {
        if (this.writerAPI != null) {
            try {
                if (commit) {
                    LOG.debug().$("release commit [table=").$(this.tableToken).I$();
                    this.authorizeCommit();
                    this.writerAPI.commit();
                }
            }
            catch (Throwable ex) {
                LOG.error().$("writer commit failed, force closing it [table=").$(this.tableToken).$(",ex=").$(ex).I$();
            }
            finally {
                this.writerAPI = Misc.free(this.writerAPI);
                this.metadataService = null;
            }
        }
    }

    public class ThreadLocalDetails
    implements Closeable {
        static final int COLUMN_NOT_FOUND = -1;
        static final int DUPLICATED_COLUMN = -2;
        private final LowerCaseCharSequenceHashSet addedColsUtf16 = new LowerCaseCharSequenceHashSet();
        private final Utf8StringIntHashMap columnIndexByNameUtf8 = new Utf8StringIntHashMap();
        private final IntList columnIndices = new IntList();
        private final Utf8StringIntHashMap columnTypeByNameUtf8 = new Utf8StringIntHashMap();
        private final IntList columnTypeMeta = new IntList();
        private final IntList columnTypes = new IntList();
        private final Path path = new Path();
        private final BitSet processedCols = new BitSet();
        private final ObjList<SymbolCache> symbolCacheByColumnIndex = new ObjList();
        private final Pool<SymbolCache> symbolCachePool;
        private final StringSink tempSink = new StringSink();
        private boolean clean = true;
        private String colNameUtf16;
        private Utf8String colNameUtf8;
        private GenericRecordMetadata latestKnownMetadata;
        private String symbolNameTemp;
        private TxReader txReader;

        ThreadLocalDetails(Pool<SymbolCache> symbolCachePool) {
            this.symbolCachePool = symbolCachePool;
            this.columnTypeMeta.add(0);
        }

        public void addColumn(String columnNameUtf16, int columnWriterIndex, int columnType) {
            if (this.latestKnownMetadata != null) {
                this.latestKnownMetadata.add(new TableColumnMetadata(columnNameUtf16, columnType, false, 0, false, null, columnWriterIndex, false));
                ++TableUpdateDetails.this.latestKnownMetadataVersion;
            }
        }

        @Override
        public void close() {
            Misc.freeObjList(this.symbolCacheByColumnIndex);
            Misc.free(this.path);
            this.txReader = Misc.free(this.txReader);
        }

        private DirectUtf8SymbolLookup addSymbolCache(int colWriterIndex) {
            try (TableReader reader = TableUpdateDetails.this.engine.getReader(TableUpdateDetails.this.tableToken);){
                int symIndex = this.resolveSymbolIndexAndName(reader.getMetadata(), colWriterIndex);
                if (this.symbolNameTemp == null || symIndex < 0) {
                    DirectUtf8SymbolLookup directUtf8SymbolLookup = NOT_FOUND_LOOKUP;
                    return directUtf8SymbolLookup;
                }
                CairoConfiguration cairoConfiguration = TableUpdateDetails.this.engine.getConfiguration();
                this.path.of(cairoConfiguration.getDbRoot()).concat(TableUpdateDetails.this.tableToken);
                SymbolCache symCache = this.symbolCachePool.pop();
                if (this.clean) {
                    if (this.txReader == null) {
                        this.txReader = new TxReader(cairoConfiguration.getFilesFacade());
                    }
                    int pathLen = this.path.size();
                    this.txReader.ofRO(this.path.concat("_txn").$(), reader.getPartitionedBy());
                    this.path.trimTo(pathLen);
                    this.clean = false;
                }
                long columnNameTxn = reader.getColumnVersionReader().getDefaultColumnNameTxn(colWriterIndex);
                assert (symIndex <= colWriterIndex);
                symCache.of(cairoConfiguration, TableUpdateDetails.this.writerAPI, colWriterIndex, this.path, this.symbolNameTemp, symIndex, this.txReader, columnNameTxn);
                this.symbolCacheByColumnIndex.extendAndSet(colWriterIndex, symCache);
                SymbolCache symbolCache = symCache;
                return symbolCache;
            }
        }

        private GenericRecordMetadata deepCopyOfDense(TableRecordMetadata that) {
            GenericRecordMetadata metadata = new GenericRecordMetadata();
            int n = that.getColumnCount();
            for (int i = 0; i < n; ++i) {
                int columnType = that.getColumnType(i);
                if (columnType <= 0) continue;
                metadata.add(new TableColumnMetadata(that.getColumnName(i), that.getColumnType(i), that.isColumnIndexed(i), that.getIndexValueBlockCapacity(i), that.isSymbolTableStatic(i), that.getMetadata(i), that.getWriterIndex(i), that.isDedupKey(i)));
            }
            metadata.setTimestampIndex(that.getTimestampIndex());
            return metadata;
        }

        private int getColumnIndex0(DirectUtf8Sequence colNameUtf8, @NotNull TableRecordMetadata metadata) {
            CharSequence colNameUtf16 = this.utf8ToUtf16(colNameUtf8);
            int index = this.addedColsUtf16.keyIndex(colNameUtf16);
            if (index > -1) {
                int colIndex = metadata.getColumnIndexQuiet(colNameUtf16);
                int colWriterIndex = colIndex < 0 ? colIndex : metadata.getWriterIndex(colIndex);
                Utf8String onHeapColNameUtf8 = Utf8String.newInstance(colNameUtf8);
                if (colWriterIndex > -1) {
                    this.columnIndexByNameUtf8.put(onHeapColNameUtf8, colWriterIndex);
                    if (this.processedCols.getAndSet(colWriterIndex)) {
                        return -2;
                    }
                    return colWriterIndex;
                }
                this.colNameUtf16 = Chars.toString(colNameUtf16);
                this.colNameUtf8 = onHeapColNameUtf8;
                this.addedColsUtf16.addAt(index, this.colNameUtf16);
                return -1;
            }
            return -2;
        }

        private int getColumnWriterIndex(CharSequence colNameUtf16) {
            assert (this.latestKnownMetadata != null);
            int colIndex = this.latestKnownMetadata.getColumnIndexQuiet(colNameUtf16);
            if (colIndex < 0) {
                return colIndex;
            }
            int writerColIndex = this.latestKnownMetadata.getWriterIndex(colIndex);
            this.updateColumnTypeCache(colIndex, writerColIndex, this.latestKnownMetadata);
            return writerColIndex;
        }

        private int resolveSymbolIndexAndName(TableRecordMetadata metadata, int colWriterIndex) {
            this.symbolNameTemp = null;
            int symIndex = -1;
            int n = metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (metadata.getWriterIndex(i) == colWriterIndex) {
                    if (!ColumnType.isSymbol(metadata.getColumnType(i))) {
                        return -1;
                    }
                    ++symIndex;
                    this.symbolNameTemp = metadata.getColumnName(i);
                    break;
                }
                if (!ColumnType.isSymbol(metadata.getColumnType(i))) continue;
                ++symIndex;
            }
            return symIndex;
        }

        private void updateColumnTypeCache(int colIndex, int writerColIndex, GenericRecordMetadata metadata) {
            int colType = metadata.getColumnType(colIndex);
            int geoHashBits = ColumnType.getGeoHashBits(colType);
            this.columnTypes.extendAndSet(writerColIndex, colType);
            this.columnTypeMeta.extendAndSet(writerColIndex + 1, geoHashBits == 0 ? 0 : Numbers.encodeLowHighShorts((short)geoHashBits, ColumnType.tagOf(colType)));
        }

        void addColumnType(int columnWriterIndex, int colType) {
            this.columnIndices.add(columnWriterIndex);
            this.columnTypes.add(colType);
        }

        void clear() {
            this.columnIndexByNameUtf8.clear();
            this.columnTypeByNameUtf8.clear();
            int sz = this.symbolCacheByColumnIndex.size();
            for (int n = 0; n < sz; ++n) {
                SymbolCache symCache = this.symbolCacheByColumnIndex.getQuick(n);
                if (symCache == null) continue;
                symCache.close();
                this.symbolCachePool.push(symCache);
            }
            this.symbolCacheByColumnIndex.clear();
            this.columnTypes.clear();
            this.columnIndices.clear();
            this.columnTypeMeta.clear();
            this.columnTypeMeta.add(0);
            if (this.txReader != null) {
                this.txReader.clear();
            }
            this.clean = true;
        }

        void clearColumnTypes() {
            this.columnTypes.clear();
            this.columnIndices.clear();
        }

        void clearProcessedColumns() {
            this.processedCols.clear();
            if (this.addedColsUtf16.size() > 0) {
                this.addedColsUtf16.clear();
            }
        }

        String getColNameUtf16() {
            assert (this.colNameUtf16 != null);
            return this.colNameUtf16;
        }

        Utf8String getColNameUtf8() {
            assert (this.colNameUtf8 != null);
            return this.colNameUtf8;
        }

        int getColumnIndex(int colIndex) {
            return this.columnIndices.getQuick(colIndex);
        }

        int getColumnType(int colIndex) {
            return this.columnTypes.getQuick(colIndex);
        }

        int getColumnType(Utf8String colName, LineTcpParser.ProtoEntity entity) {
            int colType = this.columnTypeByNameUtf8.get(colName);
            if (colType < 0) {
                colType = TableUpdateDetails.this.defaultColumnTypes.DEFAULT_COLUMN_TYPES[entity.getType()];
                if (colType == 27) {
                    colType = entity.getArray().getType();
                }
                this.columnTypeByNameUtf8.put(colName, colType);
            }
            return colType;
        }

        int getColumnTypeMeta(int colIndex) {
            return this.columnTypeMeta.getQuick(colIndex + 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int getColumnWriterIndex(DirectUtf8Sequence colNameUtf8) {
            int colWriterIndex = this.columnIndexByNameUtf8.get(colNameUtf8);
            if (colWriterIndex < 0) {
                CharSequence colNameUtf16 = this.utf8ToUtf16(colNameUtf8);
                int index = this.addedColsUtf16.keyIndex(colNameUtf16);
                if (index <= -1) return -2;
                colWriterIndex = this.getColumnWriterIndex(colNameUtf16);
                Utf8String onHeapColNameUtf8 = Utf8String.newInstance(colNameUtf8);
                if (colWriterIndex > -1) {
                    this.columnIndexByNameUtf8.put(onHeapColNameUtf8, colWriterIndex);
                } else {
                    this.colNameUtf16 = Chars.toString(colNameUtf16);
                    this.colNameUtf8 = onHeapColNameUtf8;
                    this.addedColsUtf16.addAt(index, this.colNameUtf16);
                    return -1;
                }
            }
            if (!this.processedCols.getAndSet(colWriterIndex)) return colWriterIndex;
            return -2;
        }

        int getColumnWriterIndex(DirectUtf8Sequence colNameUtf8, @NotNull TableRecordMetadata metadata) {
            int colWriterIndex = this.columnIndexByNameUtf8.get(colNameUtf8);
            if (colWriterIndex < 0) {
                return this.getColumnIndex0(colNameUtf8, metadata);
            }
            if (this.processedCols.getAndSet(colWriterIndex)) {
                return -2;
            }
            return colWriterIndex;
        }

        long getMetadataVersion() {
            if (this.latestKnownMetadata != null) {
                return TableUpdateDetails.this.latestKnownMetadataVersion;
            }
            return -1L;
        }

        DirectUtf8SymbolLookup getSymbolLookup(int columnIndex) {
            if (columnIndex > -1) {
                SymbolCache symCache = this.symbolCacheByColumnIndex.getQuiet(columnIndex);
                if (symCache != null) {
                    return symCache;
                }
                return this.addSymbolCache(columnIndex);
            }
            return NOT_FOUND_LOOKUP;
        }

        void removeFromCaches(DirectUtf8Sequence colNameUtf8) {
            this.columnIndexByNameUtf8.remove(colNameUtf8);
            this.addedColsUtf16.remove(this.utf8ToUtf16(colNameUtf8));
        }

        void resetStateIfNecessary() {
            block12: {
                this.clearProcessedColumns();
                if (this.latestKnownMetadata != null && TableUpdateDetails.this.latestKnownMetadataVersion != TableUpdateDetails.this.writerAPI.getMetadataVersion()) {
                    this.clear();
                    this.latestKnownMetadata = null;
                }
                if (this.latestKnownMetadata == null) {
                    try {
                        if (TableUpdateDetails.this.isWal()) {
                            this.latestKnownMetadata = this.deepCopyOfDense(TableUpdateDetails.this.writerAPI.getMetadata());
                            TableUpdateDetails.this.latestKnownMetadataVersion = TableUpdateDetails.this.writerAPI.getMetadataVersion();
                            break block12;
                        }
                        try (TableRecordMetadata meta = TableUpdateDetails.this.engine.getLegacyMetadata(TableUpdateDetails.this.tableToken);){
                            this.latestKnownMetadata = this.deepCopyOfDense(meta);
                            TableUpdateDetails.this.latestKnownMetadataVersion = meta.getMetadataVersion();
                        }
                    }
                    catch (CairoException | TableReferenceOutOfDateException ex) {
                        if (TableUpdateDetails.this.isWal()) {
                            LOG.critical().$("could not write to WAL [ex=").$(ex).I$();
                            TableUpdateDetails.this.setWriterInError();
                        }
                        throw ex;
                    }
                }
            }
        }

        CharSequence utf8ToUtf16(DirectUtf8Sequence colNameUtf8) {
            return Utf8s.directUtf8ToUtf16(colNameUtf8, this.tempSink);
        }
    }
}

